/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.ast.CommentNode;
import org.jruby.nb.nb.nb.ast.InvisibleNode;
import org.jruby.nb.nb.nb.ast.NodeType;
import org.jruby.nb.nb.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.nb.nb.evaluator.Instruction;
import org.jruby.nb.nb.nb.exceptions.JumpException;
import org.jruby.nb.nb.nb.lexer.yacc.IDESourcePosition;
import org.jruby.nb.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.nb.lexer.yacc.ISourcePositionHolder;
import org.jruby.nb.nb.nb.runtime.Block;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node
implements ISourcePositionHolder {
    public static final ISourcePosition INVALID_POSITION = new ISourcePosition(){

        @Override
        public String getFile() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getStartLine() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getEndLine() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void adjustStartOffset(int n) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getStartOffset() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getEndOffset() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public ISourcePosition union(ISourcePosition iSourcePosition) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Collection<CommentNode> getComments() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void setComments(Collection<CommentNode> collection) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    };
    static final List<Node> EMPTY_LIST = new ArrayList<Node>();
    public static final List<CommentNode> EMPTY_COMMENT_LIST = new ArrayList<CommentNode>();
    public final NodeType nodeId;
    private ISourcePosition position;

    public Node(ISourcePosition iSourcePosition, NodeType nodeType) {
        assert (iSourcePosition != null);
        this.position = iSourcePosition;
        this.nodeId = nodeType;
    }

    @Override
    public ISourcePosition getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(ISourcePosition iSourcePosition) {
        this.position = iSourcePosition;
    }

    public abstract Instruction accept(NodeVisitor var1);

    public abstract List<Node> childNodes();

    protected static List<Node> createList(Node ... nodeArray) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : nodeArray) {
            if (node == null) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    public String toString() {
        return this.getNodeName() + "[]";
    }

    protected String getNodeName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        String string2 = string.substring(n + 1);
        return string2;
    }

    public void addComment(CommentNode commentNode) {
        Collection<CommentNode> collection = this.position.getComments();
        if (collection == null) {
            collection = new ArrayList<CommentNode>();
            this.position.setComments(collection);
        }
        collection.add(commentNode);
    }

    public void addComments(Collection<CommentNode> collection) {
        Collection<CommentNode> collection2 = this.position.getComments();
        if (collection2 == EMPTY_COMMENT_LIST) {
            collection2 = new ArrayList<CommentNode>();
            this.position.setComments(collection2);
        }
        collection2.addAll(collection);
    }

    public Collection<CommentNode> getComments() {
        return this.position.getComments();
    }

    public boolean hasComments() {
        return this.getComments() != EMPTY_COMMENT_LIST;
    }

    public ISourcePosition getPositionIncludingComments() {
        if (!this.hasComments()) {
            return this.position;
        }
        String string = this.position.getFile();
        int n = this.position.getStartOffset();
        int n2 = this.position.getEndOffset();
        int n3 = this.position.getStartLine();
        int n4 = this.position.getEndLine();
        IDESourcePosition iDESourcePosition = new IDESourcePosition(string, n3, n4, n, n2);
        for (CommentNode commentNode : this.getComments()) {
            iDESourcePosition = IDESourcePosition.combinePosition(iDESourcePosition, commentNode.getPosition());
        }
        return iDESourcePosition;
    }

    public boolean isInvisible() {
        return this instanceof InvisibleNode;
    }

    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        throw new RuntimeException(this.getClass().getSimpleName() + " should not be directly interpreted");
    }

    public IRubyObject assign(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block, boolean bl) {
        throw new RuntimeException("Invalid node encountered in interpreter: \"" + this.getClass().getName() + "\", please report this at www.jruby.org");
    }

    public String definition(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        try {
            this.interpret(ruby, threadContext, iRubyObject, block);
            return "expression";
        }
        catch (JumpException jumpException) {
            return null;
        }
    }
}

