/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.ast;

import java.util.List;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.ast.Node;
import org.jruby.nb.nb.nb.ast.NodeType;
import org.jruby.nb.nb.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.nb.nb.evaluator.Instruction;
import org.jruby.nb.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.nb.runtime.Block;
import org.jruby.nb.nb.nb.runtime.DynamicScope;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlipNode
extends Node {
    private final Node beginNode;
    private final Node endNode;
    private final boolean exclusive;
    private final int location;

    public FlipNode(ISourcePosition iSourcePosition, Node node, Node node2, boolean bl, int n) {
        super(iSourcePosition, NodeType.FLIPNODE);
        assert (node != null) : "beginNode is not null";
        assert (node2 != null) : "endNode is not null";
        this.beginNode = node;
        this.endNode = node2;
        this.exclusive = bl;
        this.location = n;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitFlipNode(this);
    }

    public Node getBeginNode() {
        return this.beginNode;
    }

    public Node getEndNode() {
        return this.endNode;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public int getDepth() {
        return this.location >> 16;
    }

    public int getIndex() {
        return this.location & 0xFFFF;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.beginNode, this.endNode);
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        DynamicScope dynamicScope = threadContext.getCurrentScope();
        IRubyObject iRubyObject2 = ruby.getNil();
        int n = this.getIndex();
        DynamicScope dynamicScope2 = dynamicScope.getFlipScope();
        dynamicScope2.growIfNeeded();
        IRubyObject iRubyObject3 = dynamicScope2.getValueDepthZeroOrNil(n, iRubyObject2);
        if (this.exclusive) {
            if (iRubyObject3 == null || !iRubyObject3.isTrue()) {
                iRubyObject3 = this.beginNode.interpret(ruby, threadContext, iRubyObject, block).isTrue() ? ruby.getTrue() : ruby.getFalse();
                dynamicScope2.setValueDepthZero(iRubyObject3, n);
                return iRubyObject3;
            }
            if (this.endNode.interpret(ruby, threadContext, iRubyObject, block).isTrue()) {
                dynamicScope2.setValueDepthZero(ruby.getFalse(), n);
            }
            return ruby.getTrue();
        }
        if (iRubyObject3 == null || !iRubyObject3.isTrue()) {
            if (this.beginNode.interpret(ruby, threadContext, iRubyObject, block).isTrue()) {
                dynamicScope2.setValueDepthZero(this.endNode.interpret(ruby, threadContext, iRubyObject, block).isTrue() ? ruby.getFalse() : ruby.getTrue(), n);
                return ruby.getTrue();
            }
            return ruby.getFalse();
        }
        if (this.endNode.interpret(ruby, threadContext, iRubyObject, block).isTrue()) {
            dynamicScope2.setValueDepthZero(ruby.getFalse(), n);
        }
        return ruby.getTrue();
    }
}

