/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.ast;

import java.util.List;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyArray;
import org.jruby.nb.nb.nb.RubyClass;
import org.jruby.nb.nb.nb.ast.ArrayNode;
import org.jruby.nb.nb.nb.ast.AttrAssignOneArgNode;
import org.jruby.nb.nb.nb.ast.AttrAssignThreeArgNode;
import org.jruby.nb.nb.nb.ast.AttrAssignTwoArgNode;
import org.jruby.nb.nb.nb.ast.IArgumentNode;
import org.jruby.nb.nb.nb.ast.Node;
import org.jruby.nb.nb.nb.ast.NodeType;
import org.jruby.nb.nb.nb.ast.types.INameNode;
import org.jruby.nb.nb.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.nb.nb.evaluator.ASTInterpreter;
import org.jruby.nb.nb.nb.evaluator.Instruction;
import org.jruby.nb.nb.nb.exceptions.JumpException;
import org.jruby.nb.nb.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.nb.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.nb.runtime.Block;
import org.jruby.nb.nb.nb.runtime.CallSite;
import org.jruby.nb.nb.nb.runtime.CallType;
import org.jruby.nb.nb.nb.runtime.MethodIndex;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttrAssignNode
extends Node
implements INameNode,
IArgumentNode {
    protected final Node receiverNode;
    private String name;
    private Node argsNode;
    public CallSite variableCallAdapter;
    public CallSite normalCallAdapter;

    public AttrAssignNode(ISourcePosition iSourcePosition, Node node, String string, Node node2) {
        super(iSourcePosition, NodeType.ATTRASSIGNNODE);
        assert (node != null) : "receiverNode is not null";
        this.receiverNode = node;
        this.name = string;
        this.setArgsInternal(node2);
        this.normalCallAdapter = MethodIndex.getCallSite(string);
        this.variableCallAdapter = MethodIndex.getVariableCallSite(string);
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitAttrAssignNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    @Override
    public Node getArgsNode() {
        return this.argsNode;
    }

    protected Node newAttrAssignNode(ArrayNode arrayNode) {
        int n = arrayNode.size();
        switch (n) {
            case 1: {
                return new AttrAssignOneArgNode(this.getPosition(), this.receiverNode, this.name, arrayNode);
            }
            case 2: {
                return new AttrAssignTwoArgNode(this.getPosition(), this.receiverNode, this.name, arrayNode);
            }
            case 3: {
                return new AttrAssignThreeArgNode(this.getPosition(), this.receiverNode, this.name, arrayNode);
            }
        }
        return new AttrAssignNode(this.getPosition(), this.receiverNode, this.name, arrayNode);
    }

    protected Node newMutatedAttrAssignNode(ArrayNode arrayNode) {
        int n = arrayNode.size();
        switch (n) {
            case 1: {
                if (!(this instanceof AttrAssignOneArgNode)) {
                    return new AttrAssignOneArgNode(this.getPosition(), this.receiverNode, this.name, arrayNode);
                }
                return this;
            }
            case 2: {
                if (!(this instanceof AttrAssignTwoArgNode)) {
                    return new AttrAssignTwoArgNode(this.getPosition(), this.receiverNode, this.name, arrayNode);
                }
                return this;
            }
            case 3: {
                if (!(this instanceof AttrAssignThreeArgNode)) {
                    return new AttrAssignThreeArgNode(this.getPosition(), this.receiverNode, this.name, arrayNode);
                }
                return this;
            }
        }
        return new AttrAssignNode(this.getPosition(), this.receiverNode, this.name, arrayNode);
    }

    @Override
    public Node setArgsNode(Node node) {
        if (this.argsNode == null && node instanceof ArrayNode) {
            return this.newAttrAssignNode((ArrayNode)node);
        }
        if (this.argsNode == node) {
            return this.newMutatedAttrAssignNode((ArrayNode)node);
        }
        this.setArgsInternal(node);
        return this;
    }

    private void setArgsInternal(Node node) {
        this.argsNode = node;
        if (node instanceof ArrayNode) {
            ((ArrayNode)node).setLightweight(true);
        }
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.argsNode);
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        IRubyObject iRubyObject2 = this.receiverNode.interpret(ruby, threadContext, iRubyObject, block);
        IRubyObject[] iRubyObjectArray = ASTInterpreter.setupArgs(ruby, threadContext, this.argsNode, iRubyObject, block);
        assert (iRubyObject2.getMetaClass() != null) : iRubyObject2.getClass().getName();
        if (iRubyObject2 == iRubyObject) {
            this.variableCallAdapter.call(threadContext, iRubyObject2, iRubyObjectArray);
        } else {
            this.normalCallAdapter.call(threadContext, iRubyObject2, iRubyObjectArray);
        }
        return iRubyObjectArray[iRubyObjectArray.length - 1];
    }

    @Override
    public IRubyObject assign(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block, boolean bl) {
        IRubyObject iRubyObject3 = this.receiverNode.interpret(ruby, threadContext, iRubyObject, block);
        if (iRubyObject3 == iRubyObject) {
            return this.selfAssign(ruby, threadContext, iRubyObject, iRubyObject2, block, bl);
        }
        return this.otherAssign(ruby, threadContext, iRubyObject, iRubyObject2, block, bl);
    }

    private IRubyObject selfAssign(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block, boolean bl) {
        IRubyObject iRubyObject3 = this.receiverNode.interpret(ruby, threadContext, iRubyObject, block);
        if (this.argsNode == null) {
            RuntimeHelpers.invoke(threadContext, iRubyObject3, this.name, iRubyObject2, Block.NULL_BLOCK);
        } else {
            RubyArray rubyArray = (RubyArray)this.argsNode.interpret(ruby, threadContext, iRubyObject, block);
            rubyArray.append(iRubyObject2);
            RuntimeHelpers.invoke(threadContext, iRubyObject3, this.name, rubyArray.toJavaArray(), Block.NULL_BLOCK);
        }
        return ruby.getNil();
    }

    private IRubyObject otherAssign(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block, boolean bl) {
        IRubyObject iRubyObject3 = this.receiverNode.interpret(ruby, threadContext, iRubyObject, block);
        if (this.argsNode == null) {
            RuntimeHelpers.invoke(threadContext, iRubyObject3, this.name, iRubyObject2, CallType.NORMAL, Block.NULL_BLOCK);
        } else {
            RubyArray rubyArray = (RubyArray)this.argsNode.interpret(ruby, threadContext, iRubyObject, block);
            rubyArray.append(iRubyObject2);
            RuntimeHelpers.invoke(threadContext, iRubyObject3, this.name, rubyArray.toJavaArray(), CallType.NORMAL, Block.NULL_BLOCK);
        }
        return ruby.getNil();
    }

    @Override
    public String definition(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        if (this.receiverNode.definition(ruby, threadContext, iRubyObject, block) != null) {
            try {
                IRubyObject iRubyObject2 = this.receiverNode.interpret(ruby, threadContext, iRubyObject, block);
                RubyClass rubyClass = iRubyObject2.getMetaClass();
                DynamicMethod dynamicMethod = rubyClass.searchMethod(this.name);
                Visibility visibility = dynamicMethod.getVisibility();
                if (visibility != Visibility.PRIVATE && (visibility != Visibility.PROTECTED || rubyClass.getRealClass().isInstance(iRubyObject)) && rubyClass.isMethodBound(this.name, false)) {
                    return ASTInterpreter.getArgumentDefinition(ruby, threadContext, this.argsNode, "assignment", iRubyObject, block);
                }
            }
            catch (JumpException jumpException) {
                // empty catch block
            }
        }
        return null;
    }
}

