/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb;

import java.nio.channels.Selector;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyArray;
import org.jruby.nb.nb.nb.RubyBoolean;
import org.jruby.nb.nb.nb.RubyClass;
import org.jruby.nb.nb.nb.RubyException;
import org.jruby.nb.nb.nb.RubyFixnum;
import org.jruby.nb.nb.nb.RubyIO;
import org.jruby.nb.nb.nb.RubyInstanceConfig;
import org.jruby.nb.nb.nb.RubyModule;
import org.jruby.nb.nb.nb.RubyNumeric;
import org.jruby.nb.nb.nb.RubyObject;
import org.jruby.nb.nb.nb.RubyString;
import org.jruby.nb.nb.nb.RubySymbol;
import org.jruby.nb.nb.nb.RubySystemExit;
import org.jruby.nb.nb.nb.RubyThreadGroup;
import org.jruby.nb.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.nb.common.IRubyWarnings;
import org.jruby.nb.nb.nb.exceptions.RaiseException;
import org.jruby.nb.nb.nb.exceptions.ThreadKill;
import org.jruby.nb.nb.nb.internal.runtime.FutureThread;
import org.jruby.nb.nb.nb.internal.runtime.NativeThread;
import org.jruby.nb.nb.nb.internal.runtime.RubyRunnable;
import org.jruby.nb.nb.nb.internal.runtime.ThreadLike;
import org.jruby.nb.nb.nb.internal.runtime.ThreadService;
import org.jruby.nb.nb.nb.runtime.Block;
import org.jruby.nb.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.nb.runtime.ObjectMarshal;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Thread"})
public class RubyThread
extends RubyObject {
    private ThreadLike threadImpl;
    private RubyFixnum priority;
    private transient Map<IRubyObject, IRubyObject> threadLocalVariables;
    private boolean abortOnException;
    private IRubyObject finalResult;
    private RaiseException exitingException;
    private IRubyObject receivedException;
    private RubyThreadGroup threadGroup;
    private final ThreadService threadService;
    private volatile boolean isStopped = false;
    private volatile boolean isDead = false;
    public Object stopLock = new Object();
    private volatile boolean killed = false;
    public Object killLock = new Object();
    public final ReentrantLock lock = new ReentrantLock();
    private static final boolean DEBUG = false;
    private Selector currentSelector;

    protected RubyThread(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
        this.threadService = ruby.getThreadService();
        this.finalResult = ruby.getNil();
    }

    public void dispose() {
        this.threadGroup.remove(this);
    }

    public static RubyClass createThreadClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("Thread", ruby.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        ruby.setThread(rubyClass);
        rubyClass.defineAnnotatedMethods(RubyThread.class);
        RubyThread rubyThread = new RubyThread(ruby, rubyClass);
        rubyThread.threadImpl = new NativeThread(rubyThread, Thread.currentThread());
        ruby.getThreadService().setMainThread(Thread.currentThread(), rubyThread);
        ruby.getDefaultThreadGroup().addDirectly(rubyThread);
        rubyClass.setMarshal(ObjectMarshal.NOT_MARSHALABLE_MARSHAL);
        return rubyClass;
    }

    @JRubyMethod(name={"new", "fork"}, rest=true, frame=true, meta=true)
    public static IRubyObject newInstance(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        return RubyThread.startThread(iRubyObject, iRubyObjectArray, true, block);
    }

    @JRubyMethod(name={"start"}, rest=true, frame=true, meta=true)
    public static RubyThread start(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        return RubyThread.startThread(iRubyObject, iRubyObjectArray, false, block);
    }

    public static RubyThread adopt(IRubyObject iRubyObject, Thread thread) {
        return RubyThread.adoptThread(iRubyObject, thread, Block.NULL_BLOCK);
    }

    private static RubyThread adoptThread(IRubyObject iRubyObject, Thread thread, Block block) {
        Ruby ruby = iRubyObject.getRuntime();
        RubyThread rubyThread = new RubyThread(ruby, (RubyClass)iRubyObject);
        rubyThread.threadImpl = new NativeThread(rubyThread, thread);
        ThreadContext threadContext = ruby.getThreadService().registerNewThread(rubyThread);
        threadContext.preAdoptThread();
        ruby.getDefaultThreadGroup().addDirectly(rubyThread);
        return rubyThread;
    }

    @JRubyMethod(name={"initialize"}, rest=true, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] iRubyObjectArray, Block block) {
        Ruby ruby = this.getRuntime();
        if (!block.isGiven()) {
            throw ruby.newThreadError("must be called with a block");
        }
        RubyRunnable rubyRunnable = new RubyRunnable(this, iRubyObjectArray, block);
        if (RubyInstanceConfig.POOLING_ENABLED) {
            this.threadImpl = new FutureThread(this, rubyRunnable);
        } else {
            Thread thread = new Thread(rubyRunnable);
            thread.setDaemon(true);
            this.threadImpl = new NativeThread(this, thread);
        }
        ruby.getDefaultThreadGroup().addDirectly(this);
        this.threadImpl.start();
        Thread.yield();
        return this;
    }

    private static RubyThread startThread(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, boolean bl, Block block) {
        RubyThread rubyThread = new RubyThread(iRubyObject.getRuntime(), (RubyClass)iRubyObject);
        if (bl) {
            rubyThread.callInit(iRubyObjectArray, block);
        } else {
            rubyThread.initialize(iRubyObjectArray, block);
        }
        return rubyThread;
    }

    private void ensureNotCurrent() {
        if (this == this.getRuntime().getCurrentContext().getThread()) {
            throw new RuntimeException("internal thread method called from another thread");
        }
    }

    public synchronized void cleanTerminate(IRubyObject iRubyObject) {
        this.finalResult = iRubyObject;
        this.isStopped = true;
        this.isDead = true;
    }

    public void pollThreadEvents() {
        this.pollThreadEvents(this.getRuntime().getCurrentContext());
    }

    public void pollThreadEvents(ThreadContext threadContext) {
        this.threadService.waitForCritical();
        if (this.killed) {
            this.throwThreadKill();
        }
        if (this.receivedException != null) {
            this.receivedAnException(threadContext);
        }
    }

    private void throwThreadKill() {
        throw new ThreadKill();
    }

    @JRubyMethod(name={"abort_on_exception"}, meta=true)
    public static RubyBoolean abort_on_exception_x(IRubyObject iRubyObject) {
        Ruby ruby = iRubyObject.getRuntime();
        return ruby.isGlobalAbortOnExceptionEnabled() ? ruby.getTrue() : ruby.getFalse();
    }

    @JRubyMethod(name={"abort_on_exception="}, required=1, meta=true)
    public static IRubyObject abort_on_exception_set_x(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        iRubyObject.getRuntime().setGlobalAbortOnExceptionEnabled(iRubyObject2.isTrue());
        return iRubyObject2;
    }

    @JRubyMethod(name={"current"}, meta=true)
    public static RubyThread current(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().getCurrentContext().getThread();
    }

    @JRubyMethod(name={"main"}, meta=true)
    public static RubyThread main(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().getThreadService().getMainThread();
    }

    @JRubyMethod(name={"pass"}, meta=true)
    public static IRubyObject pass(IRubyObject iRubyObject) {
        Ruby ruby = iRubyObject.getRuntime();
        ThreadService threadService = ruby.getThreadService();
        boolean bl = threadService.getCritical();
        threadService.setCritical(false);
        Thread.yield();
        threadService.setCritical(bl);
        return iRubyObject.getRuntime().getNil();
    }

    @JRubyMethod(name={"list"}, meta=true)
    public static RubyArray list(IRubyObject iRubyObject) {
        IRubyObject[] iRubyObjectArray = iRubyObject.getRuntime().getThreadService().getActiveRubyThreads();
        return iRubyObject.getRuntime().newArrayNoCopy(iRubyObjectArray);
    }

    private IRubyObject getSymbolKey(IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubySymbol) {
            return iRubyObject;
        }
        if (iRubyObject instanceof RubyString) {
            return this.getRuntime().newSymbol(iRubyObject.asJavaString());
        }
        if (iRubyObject instanceof RubyFixnum) {
            this.getRuntime().getWarnings().warn(IRubyWarnings.ID.FIXNUMS_NOT_SYMBOLS, "Do not use Fixnums as Symbols", new Object[0]);
            throw this.getRuntime().newArgumentError(iRubyObject + " is not a symbol");
        }
        throw this.getRuntime().newTypeError(iRubyObject + " is not a symbol");
    }

    private synchronized Map<IRubyObject, IRubyObject> getThreadLocals() {
        if (this.threadLocalVariables == null) {
            this.threadLocalVariables = new HashMap<IRubyObject, IRubyObject>();
        }
        return this.threadLocalVariables;
    }

    @JRubyMethod(name={"[]"}, required=1)
    public IRubyObject op_aref(IRubyObject iRubyObject) {
        IRubyObject iRubyObject2 = this.getThreadLocals().get(this.getSymbolKey(iRubyObject));
        if (iRubyObject2 != null) {
            return iRubyObject2;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"[]="}, required=2)
    public IRubyObject op_aset(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        iRubyObject = this.getSymbolKey(iRubyObject);
        this.getThreadLocals().put(iRubyObject, iRubyObject2);
        return iRubyObject2;
    }

    @JRubyMethod(name={"abort_on_exception"})
    public RubyBoolean abort_on_exception() {
        return this.abortOnException ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"abort_on_exception="}, required=1)
    public IRubyObject abort_on_exception_set(IRubyObject iRubyObject) {
        this.abortOnException = iRubyObject.isTrue();
        return iRubyObject;
    }

    @JRubyMethod(name={"alive?"})
    public RubyBoolean alive_p() {
        return !this.isDead && this.threadImpl.isAlive() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"join"}, optional=1, backtrace=true)
    public IRubyObject join(IRubyObject[] iRubyObjectArray) {
        block16: {
            long l = Long.MAX_VALUE;
            if (iRubyObjectArray.length > 0) {
                if (iRubyObjectArray.length > 1) {
                    throw this.getRuntime().newArgumentError(iRubyObjectArray.length, 1);
                }
                l = (long)(1000.0 * iRubyObjectArray[0].convertToFloat().getValue());
                if (l <= 0L) {
                    if (this.threadImpl.isAlive()) {
                        return this.getRuntime().getNil();
                    }
                    return this;
                }
            }
            if (this.isCurrent()) {
                throw this.getRuntime().newThreadError("thread tried to join itself");
            }
            try {
                Object object;
                if (this.threadService.getCritical()) {
                    object = this.stopLock;
                    synchronized (object) {
                        this.stopLock.notify();
                    }
                }
                object = this.getRuntime().getCurrentContext().getThread();
                long l2 = Math.min(l, 200L);
                long l3 = System.currentTimeMillis();
                do {
                    ((RubyThread)object).pollThreadEvents();
                    this.threadImpl.join(l2);
                } while (this.threadImpl.isAlive() && System.currentTimeMillis() - l3 <= l);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                assert (false) : interruptedException;
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
                if ($assertionsDisabled) break block16;
                throw new AssertionError((Object)executionException);
            }
        }
        if (this.exitingException != null) {
            throw this.exitingException;
        }
        if (this.threadImpl.isAlive()) {
            return this.getRuntime().getNil();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"value"})
    public IRubyObject value() {
        this.join(new IRubyObject[0]);
        RubyThread rubyThread = this;
        synchronized (rubyThread) {
            return this.finalResult;
        }
    }

    @JRubyMethod(name={"group"})
    public IRubyObject group() {
        if (this.threadGroup == null) {
            return this.getRuntime().getNil();
        }
        return this.threadGroup;
    }

    void setThreadGroup(RubyThreadGroup rubyThreadGroup) {
        this.threadGroup = rubyThreadGroup;
    }

    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getMetaClass().getRealClass().getName();
        stringBuilder.append("#<").append(string).append(":0x");
        stringBuilder.append(Integer.toHexString(System.identityHashCode(this)));
        if (this.threadImpl.isAlive()) {
            if (this.isStopped) {
                stringBuilder.append(this.getRuntime().newString(" sleep"));
            } else if (this.killed) {
                stringBuilder.append(this.getRuntime().newString(" aborting"));
            } else {
                stringBuilder.append(this.getRuntime().newString(" run"));
            }
        } else {
            stringBuilder.append(" dead");
        }
        stringBuilder.append(">");
        return this.getRuntime().newString(stringBuilder.toString());
    }

    @JRubyMethod(name={"key?"}, required=1)
    public RubyBoolean key_p(IRubyObject iRubyObject) {
        iRubyObject = this.getSymbolKey(iRubyObject);
        return this.getRuntime().newBoolean(this.getThreadLocals().containsKey(iRubyObject));
    }

    @JRubyMethod(name={"keys"})
    public RubyArray keys() {
        IRubyObject[] iRubyObjectArray = new IRubyObject[this.getThreadLocals().size()];
        return RubyArray.newArrayNoCopy(this.getRuntime(), this.getThreadLocals().keySet().toArray(iRubyObjectArray));
    }

    @JRubyMethod(name={"critical="}, required=1, meta=true)
    public static IRubyObject critical_set(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        iRubyObject.getRuntime().getThreadService().setCritical(iRubyObject2.isTrue());
        return iRubyObject2;
    }

    @JRubyMethod(name={"critical"}, meta=true)
    public static IRubyObject critical(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().newBoolean(iRubyObject.getRuntime().getThreadService().getCritical());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"stop"}, meta=true)
    public static IRubyObject stop(IRubyObject iRubyObject) {
        Object object;
        RubyThread rubyThread = iRubyObject.getRuntime().getThreadService().getCurrentContext().getThread();
        Object object2 = object = rubyThread.stopLock;
        synchronized (object2) {
            rubyThread.pollThreadEvents();
            try {
                rubyThread.isStopped = true;
                iRubyObject.getRuntime().getThreadService().setCritical(false);
                object.wait();
            }
            catch (InterruptedException interruptedException) {
                rubyThread.pollThreadEvents();
            }
            rubyThread.isStopped = false;
        }
        return iRubyObject.getRuntime().getNil();
    }

    @JRubyMethod(name={"kill"}, required=1, frame=true, meta=true)
    public static IRubyObject kill(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        if (!(iRubyObject2 instanceof RubyThread)) {
            throw iRubyObject.getRuntime().newTypeError(iRubyObject2, iRubyObject.getRuntime().getThread());
        }
        return ((RubyThread)iRubyObject2).kill();
    }

    @JRubyMethod(name={"exit"}, frame=true, meta=true)
    public static IRubyObject s_exit(IRubyObject iRubyObject, Block block) {
        RubyThread rubyThread = iRubyObject.getRuntime().getThreadService().getCurrentContext().getThread();
        rubyThread.killed = true;
        iRubyObject.getRuntime().getThreadService().setCritical(false);
        throw new ThreadKill();
    }

    @JRubyMethod(name={"stop?"})
    public RubyBoolean stop_p() {
        return this.getRuntime().newBoolean(this.isStopped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"wakeup"})
    public RubyThread wakeup() {
        Object object = this.stopLock;
        synchronized (object) {
            this.stopLock.notifyAll();
        }
        return this;
    }

    @JRubyMethod(name={"priority"})
    public RubyFixnum priority() {
        return this.priority;
    }

    @JRubyMethod(name={"priority="}, required=1)
    public IRubyObject priority_set(IRubyObject iRubyObject) {
        int n = RubyNumeric.fix2int(iRubyObject);
        if (n < 1) {
            n = 1;
        } else if (n > 10) {
            n = 10;
        }
        this.priority = RubyFixnum.newFixnum(this.getRuntime(), n);
        if (this.threadImpl.isAlive()) {
            this.threadImpl.setPriority(n);
        }
        return this.priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"raise"}, optional=2, frame=true)
    public IRubyObject raise(IRubyObject[] iRubyObjectArray, Block block) {
        this.ensureNotCurrent();
        Ruby ruby = this.getRuntime();
        RubyThread rubyThread = this.getRuntime().getCurrentContext().getThread();
        try {
            while (!rubyThread.lock.tryLock() || !this.lock.tryLock()) {
                if (!rubyThread.lock.isHeldByCurrentThread()) continue;
                rubyThread.lock.unlock();
            }
            rubyThread.pollThreadEvents();
            this.receivedException = this.prepareRaiseException(ruby, iRubyObjectArray, block);
            Object object = this.stopLock;
            synchronized (object) {
                this.stopLock.notify();
            }
            this.interrupt();
            Object var8_7 = null;
            if (rubyThread.lock.isHeldByCurrentThread()) {
                rubyThread.lock.unlock();
            }
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (rubyThread.lock.isHeldByCurrentThread()) {
                rubyThread.lock.unlock();
            }
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
            throw throwable;
        }
        return this;
    }

    private IRubyObject prepareRaiseException(Ruby ruby, IRubyObject[] iRubyObjectArray, Block block) {
        IRubyObject iRubyObject;
        if (iRubyObjectArray.length == 0) {
            IRubyObject iRubyObject2 = ruby.getGlobalVariables().get("$!");
            if (iRubyObject2.isNil()) {
                return new RaiseException(ruby, ruby.getRuntimeError(), "", false).getException();
            }
            return iRubyObject2;
        }
        ThreadContext threadContext = this.getRuntime().getCurrentContext();
        if (iRubyObjectArray.length == 1) {
            if (iRubyObjectArray[0] instanceof RubyString) {
                return ruby.getRuntimeError().newInstance(threadContext, iRubyObjectArray, block);
            }
            if (!iRubyObjectArray[0].respondsTo("exception")) {
                return ruby.newTypeError("exception class/object expected").getException();
            }
            iRubyObject = iRubyObjectArray[0].callMethod(threadContext, "exception");
        } else {
            if (!iRubyObjectArray[0].respondsTo("exception")) {
                return ruby.newTypeError("exception class/object expected").getException();
            }
            iRubyObject = iRubyObjectArray[0].callMethod(threadContext, "exception", iRubyObjectArray[1]);
        }
        if (!ruby.getException().isInstance(iRubyObject)) {
            return ruby.newTypeError("exception object expected").getException();
        }
        if (iRubyObjectArray.length == 3) {
            ((RubyException)iRubyObject).set_backtrace(iRubyObjectArray[2]);
        }
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"run"})
    public IRubyObject run() {
        Object object = this.stopLock;
        synchronized (object) {
            if (this.isStopped) {
                this.isStopped = false;
                this.stopLock.notifyAll();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sleep(long l) throws InterruptedException {
        assert (this == this.getRuntime().getCurrentContext().getThread());
        Object object = this.stopLock;
        synchronized (object) {
            this.pollThreadEvents();
            try {
                this.isStopped = true;
                this.stopLock.wait(l);
                Object var5_3 = null;
                this.isStopped = false;
                this.pollThreadEvents();
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                this.isStopped = false;
                this.pollThreadEvents();
                throw throwable;
            }
        }
    }

    @JRubyMethod(name={"status"})
    public IRubyObject status() {
        if (this.threadImpl.isAlive()) {
            if (this.isStopped || this.currentSelector != null && this.currentSelector.isOpen()) {
                return this.getRuntime().newString("sleep");
            }
            if (this.killed) {
                return this.getRuntime().newString("aborting");
            }
            return this.getRuntime().newString("run");
        }
        if (this.exitingException != null) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().getFalse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"kill", "exit", "terminate"})
    public IRubyObject kill() {
        RubyThread rubyThread = this.getRuntime().getCurrentContext().getThread();
        if (rubyThread == this) {
            this.throwThreadKill();
        }
        try {
            while (!rubyThread.lock.tryLock() || !this.lock.tryLock()) {
                if (!rubyThread.lock.isHeldByCurrentThread()) continue;
                rubyThread.lock.unlock();
            }
            rubyThread.pollThreadEvents();
            this.killed = true;
            Object object = this.stopLock;
            synchronized (object) {
                this.stopLock.notify();
            }
            this.interrupt();
            Object var5_6 = null;
            if (rubyThread.lock.isHeldByCurrentThread()) {
                rubyThread.lock.unlock();
            }
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (rubyThread.lock.isHeldByCurrentThread()) {
                rubyThread.lock.unlock();
            }
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
            throw throwable;
        }
        try {
            this.threadImpl.join();
        }
        catch (InterruptedException interruptedException) {
            rubyThread.pollThreadEvents();
        }
        catch (ExecutionException executionException) {
            rubyThread.pollThreadEvents();
        }
        return this;
    }

    @JRubyMethod(name={"kill!", "exit!", "terminate!"})
    public IRubyObject kill_bang() {
        throw this.getRuntime().newNotImplementedError("Thread#kill!, exit!, and terminate! are not safe and not supported");
    }

    @JRubyMethod(name={"safe_level"})
    public IRubyObject safe_level() {
        throw this.getRuntime().newNotImplementedError("Thread-specific SAFE levels are not supported");
    }

    private boolean isCurrent() {
        return this.threadImpl.isCurrent();
    }

    public void exceptionRaised(RaiseException raiseException) {
        assert (this.isCurrent());
        RubyException rubyException = raiseException.getException();
        Ruby ruby = rubyException.getRuntime();
        if (ruby.getSystemExit().isInstance(rubyException)) {
            this.threadService.getMainThread().raise(new IRubyObject[]{rubyException}, Block.NULL_BLOCK);
        } else {
            if (this.abortOnException(ruby)) {
                ruby.printError(rubyException);
                RubySystemExit rubySystemExit = RubySystemExit.newInstance(ruby, 1);
                rubySystemExit.message = rubyException.message;
                rubySystemExit.set_backtrace(rubyException.backtrace());
                this.threadService.getMainThread().raise(new IRubyObject[]{rubySystemExit}, Block.NULL_BLOCK);
                return;
            }
            if (ruby.getDebug().isTrue()) {
                ruby.printError(raiseException.getException());
            }
        }
        this.exitingException = raiseException;
    }

    private boolean abortOnException(Ruby ruby) {
        return ruby.isGlobalAbortOnExceptionEnabled() || this.abortOnException;
    }

    public static RubyThread mainThread(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().getThreadService().getMainThread();
    }

    @Deprecated
    public boolean selectForAccept(RubyIO rubyIO) {
        return this.select(rubyIO, 16);
    }

    /*
     * Exception decompiling
     */
    public boolean select(RubyIO var1_1, int var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void interrupt() {
        if (this.currentSelector != null) {
            this.currentSelector.wakeup();
        }
    }

    public void beforeBlockingCall() {
        this.isStopped = true;
    }

    public void afterBlockingCall() {
        this.isStopped = false;
    }

    private void receivedAnException(ThreadContext threadContext) {
        IRubyObject iRubyObject = this.receivedException;
        this.receivedException = null;
        RubyModule rubyModule = this.getRuntime().getKernel();
        rubyModule.callMethod(threadContext, "raise", iRubyObject);
    }
}

