/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb;

import java.io.IOException;
import java.util.List;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyBoolean;
import org.jruby.nb.nb.nb.RubyClass;
import org.jruby.nb.nb.nb.RubyComparable;
import org.jruby.nb.nb.nb.RubyFixnum;
import org.jruby.nb.nb.nb.RubyModule;
import org.jruby.nb.nb.nb.RubyNumeric;
import org.jruby.nb.nb.nb.RubyObject;
import org.jruby.nb.nb.nb.RubyString;
import org.jruby.nb.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.nb.exceptions.RaiseException;
import org.jruby.nb.nb.nb.runtime.Arity;
import org.jruby.nb.nb.nb.runtime.Block;
import org.jruby.nb.nb.nb.runtime.BlockCallback;
import org.jruby.nb.nb.nb.runtime.CallBlock;
import org.jruby.nb.nb.nb.runtime.MethodIndex;
import org.jruby.nb.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.nb.runtime.ObjectMarshal;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.nb.runtime.builtin.Variable;
import org.jruby.nb.nb.nb.runtime.component.VariableEntry;
import org.jruby.nb.nb.nb.runtime.marshal.MarshalStream;
import org.jruby.nb.nb.nb.runtime.marshal.UnmarshalStream;

@JRubyClass(name={"Range"}, include={"Enumerable"})
public class RubyRange
extends RubyObject {
    private IRubyObject begin;
    private IRubyObject end;
    private boolean isExclusive;
    private static final ObjectAllocator RANGE_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyRange(ruby, rubyClass);
        }
    };
    private static byte[] DOTDOTDOT = "...".getBytes();
    private static byte[] DOTDOT = "..".getBytes();
    private static final ObjectMarshal RANGE_MARSHAL = new ObjectMarshal(){

        public void marshalTo(Ruby ruby, Object object, RubyClass rubyClass, MarshalStream marshalStream) throws IOException {
            RubyRange rubyRange = (RubyRange)object;
            marshalStream.registerLinkTarget(rubyRange);
            List<Variable<IRubyObject>> list = rubyRange.getVariableList();
            list.add(new VariableEntry<IRubyObject>("begin", rubyRange.begin));
            list.add(new VariableEntry<IRubyObject>("end", rubyRange.end));
            list.add(new VariableEntry<RubyBoolean>("excl", rubyRange.isExclusive ? ruby.getTrue() : ruby.getFalse()));
            marshalStream.dumpVariables(list);
        }

        public Object unmarshalFrom(Ruby ruby, RubyClass rubyClass, UnmarshalStream unmarshalStream) throws IOException {
            RubyRange rubyRange = (RubyRange)rubyClass.allocate();
            unmarshalStream.registerLinkTarget(rubyRange);
            unmarshalStream.defaultVariablesUnmarshal(rubyRange);
            rubyRange.begin = rubyRange.removeInternalVariable("begin");
            rubyRange.end = rubyRange.removeInternalVariable("end");
            rubyRange.isExclusive = rubyRange.removeInternalVariable("excl").isTrue();
            return rubyRange;
        }
    };

    public static RubyClass createRangeClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("Range", ruby.getObject(), RANGE_ALLOCATOR);
        ruby.setRange(rubyClass);
        rubyClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject iRubyObject, RubyModule rubyModule) {
                return iRubyObject instanceof RubyRange;
            }
        };
        rubyClass.setMarshal(RANGE_MARSHAL);
        rubyClass.includeModule(ruby.getEnumerable());
        rubyClass.defineAnnotatedMethods(RubyRange.class);
        return rubyClass;
    }

    private RubyRange(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
        this.begin = this.end = ruby.getNil();
    }

    public static RubyRange newRange(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, boolean bl) {
        RubyRange rubyRange = new RubyRange(ruby, ruby.getRange());
        rubyRange.init(threadContext, iRubyObject, iRubyObject2, bl);
        return rubyRange;
    }

    public static RubyRange newExclusiveRange(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyRange rubyRange = new RubyRange(ruby, ruby.getRange());
        rubyRange.init(threadContext, iRubyObject, iRubyObject2, true);
        return rubyRange;
    }

    public static RubyRange newInclusiveRange(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyRange rubyRange = new RubyRange(ruby, ruby.getRange());
        rubyRange.init(threadContext, iRubyObject, iRubyObject2, false);
        return rubyRange;
    }

    protected void copySpecialInstanceVariables(IRubyObject iRubyObject) {
        RubyRange rubyRange = (RubyRange)iRubyObject;
        rubyRange.begin = this.begin;
        rubyRange.end = this.end;
        rubyRange.isExclusive = this.isExclusive;
    }

    final long[] begLen(long l, int n) {
        long l2 = RubyNumeric.num2long(this.begin);
        long l3 = RubyNumeric.num2long(this.end);
        if (l2 < 0L && (l2 += l) < 0L) {
            if (n != 0) {
                throw this.getRuntime().newRangeError(l2 + ".." + (this.isExclusive ? "." : "") + l3 + " out of range");
            }
            return null;
        }
        if (n == 0 || n == 2) {
            if (l2 > l) {
                if (n != 0) {
                    throw this.getRuntime().newRangeError(l2 + ".." + (this.isExclusive ? "." : "") + l3 + " out of range");
                }
                return null;
            }
            if (l3 > l) {
                l3 = l;
            }
        }
        if (l3 < 0L) {
            l3 += l;
        }
        if (!this.isExclusive) {
            ++l3;
        }
        if ((l = l3 - l2) < 0L) {
            l = 0L;
        }
        return new long[]{l2, l};
    }

    private void init(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, boolean bl) {
        if (!(iRubyObject instanceof RubyFixnum) || !(iRubyObject2 instanceof RubyFixnum)) {
            try {
                IRubyObject iRubyObject3 = iRubyObject.callMethod(threadContext, MethodIndex.OP_SPACESHIP, "<=>", iRubyObject2);
                if (iRubyObject3.isNil()) {
                    throw this.getRuntime().newArgumentError("bad value for range");
                }
            }
            catch (RaiseException raiseException) {
                throw this.getRuntime().newArgumentError("bad value for range");
            }
        }
        this.begin = iRubyObject;
        this.end = iRubyObject2;
        this.isExclusive = bl;
    }

    @JRubyMethod(name={"initialize"}, required=2, optional=1, frame=true)
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        this.init(threadContext, iRubyObjectArray[0], iRubyObjectArray[1], iRubyObjectArray.length > 2 && iRubyObjectArray[2].isTrue());
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"first", "begin"})
    public IRubyObject first() {
        return this.begin;
    }

    @JRubyMethod(name={"last", "end"})
    public IRubyObject last() {
        return this.end;
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash(ThreadContext threadContext) {
        long l;
        long l2 = l = this.isExclusive ? 1L : 0L;
        long l3 = this.begin.callMethod(threadContext, MethodIndex.HASH, "hash").convertToInteger().getLongValue();
        l ^= l3 << 1;
        l3 = this.end.callMethod(threadContext, MethodIndex.HASH, "hash").convertToInteger().getLongValue();
        l ^= l3 << 9;
        return this.getRuntime().newFixnum(l ^= l2 << 24);
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext threadContext) {
        RubyString rubyString = RubyRange.inspect(threadContext, this.begin).strDup(threadContext.getRuntime());
        RubyString rubyString2 = RubyRange.inspect(threadContext, this.end);
        rubyString.cat(this.isExclusive ? DOTDOTDOT : DOTDOT);
        rubyString.concat(rubyString2);
        rubyString.infectBy(rubyString2);
        return rubyString;
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s(ThreadContext threadContext) {
        RubyString rubyString = RubyString.objAsString(threadContext, this.begin).strDup(threadContext.getRuntime());
        RubyString rubyString2 = RubyString.objAsString(threadContext, this.end);
        rubyString.cat(this.isExclusive ? DOTDOTDOT : DOTDOT);
        rubyString.concat(rubyString2);
        rubyString.infectBy(rubyString2);
        return rubyString;
    }

    @JRubyMethod(name={"exclude_end?"})
    public RubyBoolean exclude_end_p() {
        return this.getRuntime().newBoolean(this.isExclusive);
    }

    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this == iRubyObject) {
            return this.getRuntime().getTrue();
        }
        if (!(iRubyObject instanceof RubyRange)) {
            return this.getRuntime().getFalse();
        }
        RubyRange rubyRange = (RubyRange)iRubyObject;
        if (RubyRange.equalInternal(threadContext, this.begin, rubyRange.begin) && RubyRange.equalInternal(threadContext, this.end, rubyRange.end) && this.isExclusive == rubyRange.isExclusive) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this == iRubyObject) {
            return this.getRuntime().getTrue();
        }
        if (!(iRubyObject instanceof RubyRange)) {
            return this.getRuntime().getFalse();
        }
        RubyRange rubyRange = (RubyRange)iRubyObject;
        if (RubyRange.eqlInternal(threadContext, this.begin, rubyRange.begin) && RubyRange.eqlInternal(threadContext, this.end, rubyRange.end) && this.isExclusive == rubyRange.isExclusive) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    private IRubyObject rangeLt(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        IRubyObject iRubyObject3 = iRubyObject.callMethod(threadContext, MethodIndex.OP_SPACESHIP, "<=>", iRubyObject2);
        if (iRubyObject3.isNil()) {
            return null;
        }
        return RubyComparable.cmpint(threadContext, iRubyObject3, iRubyObject, iRubyObject2) < 0 ? this.getRuntime().getTrue() : null;
    }

    private IRubyObject rangeLe(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        IRubyObject iRubyObject3 = iRubyObject.callMethod(threadContext, MethodIndex.OP_SPACESHIP, "<=>", iRubyObject2);
        if (iRubyObject3.isNil()) {
            return null;
        }
        int n = RubyComparable.cmpint(threadContext, iRubyObject3, iRubyObject, iRubyObject2);
        if (n == 0) {
            return RubyFixnum.zero(this.getRuntime());
        }
        return n < 0 ? this.getRuntime().getTrue() : null;
    }

    private void rangeEach(ThreadContext threadContext, RangeCallBack rangeCallBack) {
        IRubyObject iRubyObject = this.begin;
        if (this.isExclusive) {
            while (this.rangeLt(threadContext, iRubyObject, this.end) != null) {
                rangeCallBack.call(threadContext, iRubyObject);
                iRubyObject = iRubyObject.callMethod(threadContext, "succ");
            }
        } else {
            IRubyObject iRubyObject2;
            while ((iRubyObject2 = this.rangeLe(threadContext, iRubyObject, this.end)) != null && iRubyObject2.isTrue()) {
                rangeCallBack.call(threadContext, iRubyObject);
                if (iRubyObject2 != RubyFixnum.zero(this.getRuntime())) {
                    iRubyObject = iRubyObject.callMethod(threadContext, "succ");
                    continue;
                }
                break;
            }
        }
    }

    @JRubyMethod(name={"each"}, frame=true)
    public IRubyObject each(ThreadContext threadContext, final Block block) {
        Ruby ruby = threadContext.getRuntime();
        if (this.begin instanceof RubyFixnum && this.end instanceof RubyFixnum) {
            long l = ((RubyFixnum)this.end).getLongValue();
            if (!this.isExclusive) {
                ++l;
            }
            for (long i = ((RubyFixnum)this.begin).getLongValue(); i < l; ++i) {
                block.yield(threadContext, RubyFixnum.newFixnum(ruby, i));
            }
        } else if (this.begin instanceof RubyString) {
            ((RubyString)this.begin).upto(threadContext, this.end, this.isExclusive, block);
        } else {
            if (!this.begin.respondsTo("succ")) {
                throw this.getRuntime().newTypeError("can't iterate from " + this.begin.getMetaClass().getName());
            }
            this.rangeEach(threadContext, new RangeCallBack(){

                void call(ThreadContext threadContext, IRubyObject iRubyObject) {
                    block.yield(threadContext, iRubyObject);
                }
            });
        }
        return this;
    }

    @JRubyMethod(name={"step"}, optional=1, frame=true)
    public IRubyObject step(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        Ruby ruby = threadContext.getRuntime();
        IRubyObject iRubyObject = iRubyObjectArray.length == 0 ? RubyFixnum.one(ruby) : iRubyObjectArray[0];
        long l = RubyNumeric.num2long(iRubyObject);
        if (l < 0L) {
            throw ruby.newArgumentError("step can't be negative");
        }
        if (this.begin instanceof RubyFixnum && this.end instanceof RubyFixnum) {
            if (l == 0L) {
                throw ruby.newArgumentError("step can't be 0");
            }
            long l2 = ((RubyFixnum)this.end).getLongValue();
            if (!this.isExclusive) {
                ++l2;
            }
            for (long i = ((RubyFixnum)this.begin).getLongValue(); i < l2; i += l) {
                block.yield(threadContext, RubyFixnum.newFixnum(ruby, i));
            }
        } else {
            IRubyObject iRubyObject2 = this.begin.checkStringType();
            if (!iRubyObject2.isNil()) {
                if (l == 0L) {
                    throw ruby.newArgumentError("step can't be 0");
                }
                StepBlockCallBack stepBlockCallBack = new StepBlockCallBack(block, RubyFixnum.one(ruby), iRubyObject);
                Block block2 = CallBlock.newCallClosure(this, ruby.getRange(), Arity.singleArgument(), stepBlockCallBack, threadContext);
                ((RubyString)iRubyObject2).upto(threadContext, this.end, this.isExclusive, block2);
            } else if (this.begin instanceof RubyNumeric) {
                int n;
                String string;
                if (RubyRange.equalInternal(threadContext, iRubyObject, RubyFixnum.zero(ruby))) {
                    throw ruby.newArgumentError("step can't be 0");
                }
                if (this.isExclusive) {
                    string = "<";
                    n = MethodIndex.OP_LT;
                } else {
                    string = "<=";
                    n = MethodIndex.OP_LE;
                }
                IRubyObject iRubyObject3 = this.begin;
                while (iRubyObject3.callMethod(threadContext, n, string, this.end).isTrue()) {
                    block.yield(threadContext, iRubyObject3);
                    iRubyObject3 = iRubyObject3.callMethod(threadContext, MethodIndex.OP_PLUS, "+", iRubyObject);
                }
            } else {
                if (l == 0L) {
                    throw ruby.newArgumentError("step can't be 0");
                }
                if (!this.begin.respondsTo("succ")) {
                    throw ruby.newTypeError("can't iterate from " + this.begin.getMetaClass().getName());
                }
                this.rangeEach(threadContext, new StepBlockCallBack(block, RubyFixnum.one(ruby), iRubyObject));
            }
        }
        return this;
    }

    @JRubyMethod(name={"include?", "member?", "==="}, required=1)
    public RubyBoolean include_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this.rangeLe(threadContext, this.begin, iRubyObject) != null && (this.isExclusive ? this.rangeLt(threadContext, iRubyObject, this.end) != null : this.rangeLe(threadContext, iRubyObject, this.end) != null)) {
            return threadContext.getRuntime().getTrue();
        }
        return threadContext.getRuntime().getFalse();
    }

    private static final class StepBlockCallBack
    extends RangeCallBack
    implements BlockCallback {
        final Block block;
        IRubyObject iter;
        final IRubyObject step;

        StepBlockCallBack(Block block, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            this.block = block;
            this.iter = iRubyObject;
            this.step = iRubyObject2;
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
            this.call(threadContext, iRubyObjectArray[0]);
            return threadContext.getRuntime().getNil();
        }

        void call(ThreadContext threadContext, IRubyObject iRubyObject) {
            this.iter = this.iter instanceof RubyFixnum ? RubyFixnum.newFixnum(threadContext.getRuntime(), ((RubyFixnum)this.iter).getLongValue() - 1L) : this.iter.callMethod(threadContext, MethodIndex.OP_MINUS, "-", RubyFixnum.one(threadContext.getRuntime()));
            if (this.iter == RubyFixnum.zero(threadContext.getRuntime())) {
                this.block.yield(threadContext, iRubyObject);
                this.iter = this.step;
            }
        }
    }

    private static abstract class RangeCallBack {
        private RangeCallBack() {
        }

        abstract void call(ThreadContext var1, IRubyObject var2);
    }
}

