/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb;

import java.util.HashMap;
import java.util.Map;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyArgsFile;
import org.jruby.nb.nb.nb.RubyArray;
import org.jruby.nb.nb.nb.RubyBoolean;
import org.jruby.nb.nb.nb.RubyFixnum;
import org.jruby.nb.nb.nb.RubyHash;
import org.jruby.nb.nb.nb.RubyIO;
import org.jruby.nb.nb.nb.RubyNumeric;
import org.jruby.nb.nb.nb.RubyRegexp;
import org.jruby.nb.nb.nb.RubyString;
import org.jruby.nb.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.nb.common.IRubyWarnings;
import org.jruby.nb.nb.nb.environment.OSEnvironment;
import org.jruby.nb.nb.nb.environment.OSEnvironmentReaderExcepton;
import org.jruby.nb.nb.nb.internal.runtime.ValueAccessor;
import org.jruby.nb.nb.nb.javasupport.JavaUtil;
import org.jruby.nb.nb.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.nb.nb.runtime.Block;
import org.jruby.nb.nb.nb.runtime.Constants;
import org.jruby.nb.nb.nb.runtime.GlobalVariable;
import org.jruby.nb.nb.nb.runtime.ReadonlyGlobalVariable;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.nb.util.KCode;
import org.jruby.nb.nb.nb.util.io.STDIO;

public class RubyGlobal {
    public static void createGlobals(ThreadContext threadContext, Ruby ruby) {
        ruby.defineGlobalConstant("TOPLEVEL_BINDING", ruby.newBinding());
        ruby.defineGlobalConstant("TRUE", ruby.getTrue());
        ruby.defineGlobalConstant("FALSE", ruby.getFalse());
        ruby.defineGlobalConstant("NIL", ruby.getNil());
        RubyArray rubyArray = ruby.newArray();
        String[] stringArray = ruby.getInstanceConfig().getArgv();
        for (int i = 0; i < stringArray.length; ++i) {
            rubyArray.append(RubyString.newString(ruby, stringArray[i].getBytes()));
        }
        ruby.defineGlobalConstant("ARGV", rubyArray);
        ruby.getGlobalVariables().defineReadonly("$*", new ValueAccessor(rubyArray));
        ValueAccessor valueAccessor = new ValueAccessor(ruby.newString(ruby.getInstanceConfig().displayedFileName()));
        ruby.getGlobalVariables().define("$PROGRAM_NAME", valueAccessor);
        ruby.getGlobalVariables().define("$0", valueAccessor);
        IRubyObject iRubyObject = ruby.newString(Constants.RUBY_VERSION).freeze(threadContext);
        IRubyObject iRubyObject2 = ruby.newString(Constants.COMPILE_DATE).freeze(threadContext);
        IRubyObject iRubyObject3 = ruby.newString("java").freeze(threadContext);
        IRubyObject iRubyObject4 = ruby.newString("jruby").freeze(threadContext);
        ruby.defineGlobalConstant("RUBY_VERSION", iRubyObject);
        ruby.defineGlobalConstant("RUBY_PATCHLEVEL", ruby.newString(Constants.RUBY_PATCHLEVEL).freeze(threadContext));
        ruby.defineGlobalConstant("RUBY_RELEASE_DATE", iRubyObject2);
        ruby.defineGlobalConstant("RUBY_PLATFORM", iRubyObject3);
        ruby.defineGlobalConstant("RUBY_ENGINE", iRubyObject4);
        ruby.defineGlobalConstant("VERSION", iRubyObject);
        ruby.defineGlobalConstant("RELEASE_DATE", iRubyObject2);
        ruby.defineGlobalConstant("PLATFORM", iRubyObject3);
        IRubyObject iRubyObject5 = ruby.newString(Constants.VERSION).freeze(threadContext);
        ruby.defineGlobalConstant("JRUBY_VERSION", iRubyObject5);
        KCodeGlobalVariable kCodeGlobalVariable = new KCodeGlobalVariable(ruby, "$KCODE", ruby.newString("NONE"));
        ruby.defineVariable(kCodeGlobalVariable);
        ruby.defineVariable(new GlobalVariable.Copy(ruby, "$-K", kCodeGlobalVariable));
        IRubyObject iRubyObject6 = ruby.newString(ruby.getInstanceConfig().getRecordSeparator()).freeze(threadContext);
        StringGlobalVariable stringGlobalVariable = new StringGlobalVariable(ruby, "$/", iRubyObject6);
        ruby.defineVariable(stringGlobalVariable);
        ruby.setRecordSeparatorVar(stringGlobalVariable);
        ruby.getGlobalVariables().setDefaultSeparator(iRubyObject6);
        ruby.defineVariable(new StringGlobalVariable(ruby, "$\\", ruby.getNil()));
        ruby.defineVariable(new StringGlobalVariable(ruby, "$,", ruby.getNil()));
        ruby.defineVariable(new LineNumberGlobalVariable(ruby, "$.", RubyFixnum.one(ruby)));
        ruby.defineVariable(new LastlineGlobalVariable(ruby, "$_"));
        ruby.defineVariable(new LastExitStatusVariable(ruby, "$?"));
        ruby.defineVariable(new ErrorInfoGlobalVariable(ruby, "$!", ruby.getNil()));
        ruby.defineVariable(new NonEffectiveGlobalVariable(ruby, "$=", ruby.getFalse()));
        if (ruby.getInstanceConfig().getInputFieldSeparator() == null) {
            ruby.defineVariable(new GlobalVariable(ruby, "$;", ruby.getNil()));
        } else {
            ruby.defineVariable(new GlobalVariable(ruby, "$;", RubyRegexp.newRegexp(ruby, ruby.getInstanceConfig().getInputFieldSeparator(), 0)));
        }
        Boolean bl = ruby.getInstanceConfig().getVerbose();
        IRubyObject iRubyObject7 = null;
        iRubyObject7 = bl == null ? ruby.getNil() : (bl == Boolean.TRUE ? ruby.getTrue() : ruby.getFalse());
        ruby.defineVariable(new VerboseGlobalVariable(ruby, "$VERBOSE", iRubyObject7));
        RubyBoolean rubyBoolean = ruby.newBoolean(ruby.getInstanceConfig().isDebug());
        ruby.defineVariable(new DebugGlobalVariable(ruby, "$DEBUG", rubyBoolean));
        ruby.defineVariable(new DebugGlobalVariable(ruby, "$-d", rubyBoolean));
        ruby.defineVariable(new SafeGlobalVariable(ruby, "$SAFE"));
        ruby.defineVariable(new BacktraceGlobalVariable(ruby, "$@"));
        RubyIO rubyIO = new RubyIO(ruby, STDIO.IN);
        RubyIO rubyIO2 = new RubyIO(ruby, STDIO.OUT);
        RubyIO rubyIO3 = new RubyIO(ruby, STDIO.ERR);
        ruby.defineVariable(new InputGlobalVariable(ruby, "$stdin", rubyIO));
        ruby.defineVariable(new OutputGlobalVariable(ruby, "$stdout", rubyIO2));
        ruby.getGlobalVariables().alias("$>", "$stdout");
        ruby.getGlobalVariables().alias("$defout", "$stdout");
        ruby.defineVariable(new OutputGlobalVariable(ruby, "$stderr", rubyIO3));
        ruby.getGlobalVariables().alias("$deferr", "$stderr");
        ruby.defineGlobalConstant("STDIN", rubyIO);
        ruby.defineGlobalConstant("STDOUT", rubyIO2);
        ruby.defineGlobalConstant("STDERR", rubyIO3);
        ruby.defineVariable(new LoadedFeatures(ruby, "$\""));
        ruby.defineVariable(new LoadedFeatures(ruby, "$LOADED_FEATURES"));
        ruby.defineVariable(new LoadPath(ruby, "$:"));
        ruby.defineVariable(new LoadPath(ruby, "$-I"));
        ruby.defineVariable(new LoadPath(ruby, "$LOAD_PATH"));
        ruby.defineVariable(new MatchMatchGlobalVariable(ruby, "$&"));
        ruby.defineVariable(new PreMatchGlobalVariable(ruby, "$`"));
        ruby.defineVariable(new PostMatchGlobalVariable(ruby, "$'"));
        ruby.defineVariable(new LastMatchGlobalVariable(ruby, "$+"));
        ruby.defineVariable(new BackRefGlobalVariable(ruby, "$~"));
        ruby.getGlobalVariables().defineReadonly("$$", new ValueAccessor(ruby.newFixnum(ruby.getPosix().getpid())));
        RubyGlobal.defineGlobalEnvConstants(ruby);
        if (ruby.getGlobalVariables().get("$*").isNil()) {
            ruby.getGlobalVariables().defineReadonly("$*", new ValueAccessor(ruby.newArray()));
        }
        ruby.getGlobalVariables().defineReadonly("$-p", new ValueAccessor(ruby.getInstanceConfig().isAssumePrinting() ? ruby.getTrue() : ruby.getNil()));
        ruby.getGlobalVariables().defineReadonly("$-n", new ValueAccessor(ruby.getInstanceConfig().isAssumeLoop() ? ruby.getTrue() : ruby.getNil()));
        ruby.getGlobalVariables().defineReadonly("$-a", new ValueAccessor(ruby.getInstanceConfig().isSplit() ? ruby.getTrue() : ruby.getNil()));
        ruby.getGlobalVariables().defineReadonly("$-l", new ValueAccessor(ruby.getInstanceConfig().isProcessLineEnds() ? ruby.getTrue() : ruby.getNil()));
        RubyArgsFile.initArgsFile(ruby);
    }

    private static void defineGlobalEnvConstants(Ruby ruby) {
        HashMap hashMap = null;
        OSEnvironment oSEnvironment = new OSEnvironment();
        try {
            hashMap = oSEnvironment.getEnvironmentVariableMap(ruby);
        }
        catch (OSEnvironmentReaderExcepton oSEnvironmentReaderExcepton) {
            ruby.getWarnings().warn(IRubyWarnings.ID.MISCELLANEOUS, oSEnvironmentReaderExcepton.getMessage(), new Object[0]);
        }
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        StringOnlyRubyHash stringOnlyRubyHash = new StringOnlyRubyHash(ruby, hashMap, ruby.getNil());
        stringOnlyRubyHash.getSingletonClass().defineAnnotatedMethods(StringOnlyRubyHash.class);
        ruby.defineGlobalConstant("ENV", stringOnlyRubyHash);
        Map map = oSEnvironment.getSystemPropertiesMap(ruby);
        ruby.defineGlobalConstant("ENV_JAVA", new StringOnlyRubyHash(ruby, map, ruby.getNil()));
    }

    private static class LoadedFeatures
    extends ReadonlyGlobalVariable {
        public LoadedFeatures(Ruby ruby, String string) {
            super(ruby, string, null);
        }

        public IRubyObject get() {
            return this.runtime.getLoadService().getLoadedFeatures();
        }
    }

    private static class LoadPath
    extends ReadonlyGlobalVariable {
        public LoadPath(Ruby ruby, String string) {
            super(ruby, string, null);
        }

        public IRubyObject get() {
            return this.runtime.getLoadService().getLoadPath();
        }
    }

    private static class OutputGlobalVariable
    extends GlobalVariable {
        public OutputGlobalVariable(Ruby ruby, String string, IRubyObject iRubyObject) {
            super(ruby, string, iRubyObject);
        }

        public IRubyObject set(IRubyObject iRubyObject) {
            if (iRubyObject == this.get()) {
                return iRubyObject;
            }
            if (iRubyObject instanceof RubyIO) {
                RubyIO rubyIO = (RubyIO)iRubyObject;
                rubyIO.getHandler().setSync(true);
            }
            if (!iRubyObject.respondsTo("write")) {
                throw this.runtime.newTypeError(this.name() + " must have write method, " + iRubyObject.getType().getName() + " given");
            }
            return super.set(iRubyObject);
        }
    }

    private static class InputGlobalVariable
    extends GlobalVariable {
        public InputGlobalVariable(Ruby ruby, String string, IRubyObject iRubyObject) {
            super(ruby, string, iRubyObject);
        }

        public IRubyObject set(IRubyObject iRubyObject) {
            if (iRubyObject == this.get()) {
                return iRubyObject;
            }
            return super.set(iRubyObject);
        }
    }

    private static class LastlineGlobalVariable
    extends GlobalVariable {
        public LastlineGlobalVariable(Ruby ruby, String string) {
            super(ruby, string, null);
        }

        public IRubyObject get() {
            return RuntimeHelpers.getLastLine(this.runtime, this.runtime.getCurrentContext());
        }

        public IRubyObject set(IRubyObject iRubyObject) {
            RuntimeHelpers.setLastLine(this.runtime, this.runtime.getCurrentContext(), iRubyObject);
            return iRubyObject;
        }
    }

    private static class BacktraceGlobalVariable
    extends GlobalVariable {
        public BacktraceGlobalVariable(Ruby ruby, String string) {
            super(ruby, string, null);
        }

        public IRubyObject get() {
            IRubyObject iRubyObject;
            IRubyObject iRubyObject2 = this.runtime.getGlobalVariables().get("$!");
            IRubyObject iRubyObject3 = iRubyObject = iRubyObject2.isNil() ? this.runtime.getNil() : iRubyObject2.callMethod(iRubyObject2.getRuntime().getCurrentContext(), "backtrace");
            if (!(iRubyObject instanceof RubyArray)) {
                iRubyObject = this.runtime.getNil();
            }
            return iRubyObject;
        }

        public IRubyObject set(IRubyObject iRubyObject) {
            if (this.runtime.getGlobalVariables().get("$!").isNil()) {
                throw this.runtime.newArgumentError("$! not set.");
            }
            this.runtime.getGlobalVariables().get("$!").callMethod(iRubyObject.getRuntime().getCurrentContext(), "set_backtrace", iRubyObject);
            return iRubyObject;
        }
    }

    private static class DebugGlobalVariable
    extends GlobalVariable {
        public DebugGlobalVariable(Ruby ruby, String string, IRubyObject iRubyObject) {
            super(ruby, string, iRubyObject);
            this.set(iRubyObject);
        }

        public IRubyObject get() {
            return this.runtime.getDebug();
        }

        public IRubyObject set(IRubyObject iRubyObject) {
            if (iRubyObject.isNil()) {
                this.runtime.setDebug(iRubyObject);
            } else {
                this.runtime.setDebug(this.runtime.newBoolean(iRubyObject.isTrue()));
            }
            return iRubyObject;
        }
    }

    private static class VerboseGlobalVariable
    extends GlobalVariable {
        public VerboseGlobalVariable(Ruby ruby, String string, IRubyObject iRubyObject) {
            super(ruby, string, iRubyObject);
            this.set(iRubyObject);
        }

        public IRubyObject get() {
            return this.runtime.getVerbose();
        }

        public IRubyObject set(IRubyObject iRubyObject) {
            if (iRubyObject.isNil()) {
                this.runtime.setVerbose(iRubyObject);
            } else {
                this.runtime.setVerbose(this.runtime.newBoolean(iRubyObject.isTrue()));
            }
            return iRubyObject;
        }
    }

    private static class SafeGlobalVariable
    extends GlobalVariable {
        public SafeGlobalVariable(Ruby ruby, String string) {
            super(ruby, string, null);
        }

        public IRubyObject get() {
            return this.runtime.newFixnum(this.runtime.getSafeLevel());
        }

        public IRubyObject set(IRubyObject iRubyObject) {
            this.runtime.getWarnings().warn(IRubyWarnings.ID.SAFE_NOT_SUPPORTED, "SAFE levels are not supported in JRuby", new Object[0]);
            return RubyFixnum.newFixnum(this.runtime, this.runtime.getSafeLevel());
        }
    }

    public static class KCodeGlobalVariable
    extends GlobalVariable {
        public KCodeGlobalVariable(Ruby ruby, String string, IRubyObject iRubyObject) {
            super(ruby, string, iRubyObject);
        }

        public IRubyObject get() {
            return this.runtime.getKCode().kcode(this.runtime);
        }

        public IRubyObject set(IRubyObject iRubyObject) {
            this.runtime.setKCode(KCode.create(this.runtime, iRubyObject.convertToString().toString()));
            return iRubyObject;
        }
    }

    public static class StringGlobalVariable
    extends GlobalVariable {
        public StringGlobalVariable(Ruby ruby, String string, IRubyObject iRubyObject) {
            super(ruby, string, iRubyObject);
        }

        public IRubyObject set(IRubyObject iRubyObject) {
            if (!iRubyObject.isNil() && !(iRubyObject instanceof RubyString)) {
                throw this.runtime.newTypeError("value of " + this.name() + " must be a String");
            }
            return super.set(iRubyObject);
        }
    }

    private static class ErrorInfoGlobalVariable
    extends GlobalVariable {
        public ErrorInfoGlobalVariable(Ruby ruby, String string, IRubyObject iRubyObject) {
            super(ruby, string, null);
            this.set(iRubyObject);
        }

        public IRubyObject set(IRubyObject iRubyObject) {
            if (!(iRubyObject.isNil() || this.runtime.getException().isInstance(iRubyObject) || JavaUtil.isJavaObject(iRubyObject) && JavaUtil.unwrapJavaObject(iRubyObject) instanceof Exception)) {
                throw this.runtime.newTypeError("assigning non-exception to $!");
            }
            return this.runtime.getCurrentContext().setErrorInfo(iRubyObject);
        }

        public IRubyObject get() {
            return this.runtime.getCurrentContext().getErrorInfo();
        }
    }

    private static class LineNumberGlobalVariable
    extends GlobalVariable {
        public LineNumberGlobalVariable(Ruby ruby, String string, RubyFixnum rubyFixnum) {
            super(ruby, string, rubyFixnum);
        }

        public IRubyObject set(IRubyObject iRubyObject) {
            RubyArgsFile.setCurrentLineNumber(this.runtime.getGlobalVariables().get("$<"), RubyNumeric.fix2int(iRubyObject));
            return super.set(iRubyObject);
        }
    }

    private static class BackRefGlobalVariable
    extends GlobalVariable {
        public BackRefGlobalVariable(Ruby ruby, String string) {
            super(ruby, string, ruby.getNil());
        }

        public IRubyObject get() {
            return RuntimeHelpers.getBackref(this.runtime, this.runtime.getCurrentContext());
        }

        public IRubyObject set(IRubyObject iRubyObject) {
            RuntimeHelpers.setBackref(this.runtime, this.runtime.getCurrentContext(), iRubyObject);
            return iRubyObject;
        }
    }

    private static class LastMatchGlobalVariable
    extends GlobalVariable {
        public LastMatchGlobalVariable(Ruby ruby, String string) {
            super(ruby, string, ruby.getNil());
        }

        public IRubyObject get() {
            return RubyRegexp.match_last(this.runtime.getCurrentContext().getCurrentFrame().getBackRef());
        }
    }

    private static class PostMatchGlobalVariable
    extends GlobalVariable {
        public PostMatchGlobalVariable(Ruby ruby, String string) {
            super(ruby, string, ruby.getNil());
        }

        public IRubyObject get() {
            return RubyRegexp.match_post(this.runtime.getCurrentContext().getCurrentFrame().getBackRef());
        }
    }

    private static class PreMatchGlobalVariable
    extends GlobalVariable {
        public PreMatchGlobalVariable(Ruby ruby, String string) {
            super(ruby, string, ruby.getNil());
        }

        public IRubyObject get() {
            return RubyRegexp.match_pre(this.runtime.getCurrentContext().getCurrentFrame().getBackRef());
        }
    }

    private static class MatchMatchGlobalVariable
    extends GlobalVariable {
        public MatchMatchGlobalVariable(Ruby ruby, String string) {
            super(ruby, string, ruby.getNil());
        }

        public IRubyObject get() {
            return RubyRegexp.last_match(this.runtime.getCurrentContext().getCurrentFrame().getBackRef());
        }
    }

    private static class LastExitStatusVariable
    extends GlobalVariable {
        public LastExitStatusVariable(Ruby ruby, String string) {
            super(ruby, string, ruby.getNil());
        }

        public IRubyObject get() {
            IRubyObject iRubyObject = this.runtime.getCurrentContext().getLastExitStatus();
            return iRubyObject == null ? this.runtime.getNil() : iRubyObject;
        }

        public IRubyObject set(IRubyObject iRubyObject) {
            this.runtime.getCurrentContext().setLastExitStatus(iRubyObject);
            return iRubyObject;
        }
    }

    private static class NonEffectiveGlobalVariable
    extends GlobalVariable {
        public NonEffectiveGlobalVariable(Ruby ruby, String string, IRubyObject iRubyObject) {
            super(ruby, string, iRubyObject);
        }

        public IRubyObject set(IRubyObject iRubyObject) {
            this.runtime.getWarnings().warn(IRubyWarnings.ID.INEFFECTIVE_GLOBAL, "warning: variable " + this.name + " is no longer effective; ignored", this.name);
            return iRubyObject;
        }

        public IRubyObject get() {
            this.runtime.getWarnings().warn(IRubyWarnings.ID.INEFFECTIVE_GLOBAL, "warning: variable " + this.name + " is no longer effective", this.name);
            return this.runtime.getFalse();
        }
    }

    public static class StringOnlyRubyHash
    extends RubyHash {
        public StringOnlyRubyHash(Ruby ruby, Map map, IRubyObject iRubyObject) {
            super(ruby, map, iRubyObject);
        }

        public RubyHash to_hash() {
            Ruby ruby = this.getRuntime();
            RubyHash rubyHash = RubyHash.newHash(ruby);
            rubyHash.replace(ruby.getCurrentContext(), this);
            return rubyHash;
        }

        public IRubyObject op_aref(ThreadContext threadContext, IRubyObject iRubyObject) {
            return super.op_aref(threadContext, iRubyObject.convertToString());
        }

        public IRubyObject op_aset(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            if (!iRubyObject.respondsTo("to_str")) {
                throw this.getRuntime().newTypeError("can't convert " + iRubyObject.getMetaClass() + " into String");
            }
            if (!iRubyObject2.respondsTo("to_str") && !iRubyObject2.isNil()) {
                throw this.getRuntime().newTypeError("can't convert " + iRubyObject2.getMetaClass() + " into String");
            }
            if (iRubyObject2.isNil()) {
                return super.delete(threadContext, iRubyObject, Block.NULL_BLOCK);
            }
            return super.op_aset(threadContext, RuntimeHelpers.invoke(threadContext, iRubyObject, "to_str"), iRubyObject2.isNil() ? this.getRuntime().getNil() : RuntimeHelpers.invoke(threadContext, iRubyObject2, "to_str"));
        }

        @JRubyMethod
        public IRubyObject to_s() {
            return this.getRuntime().newString("ENV");
        }
    }
}

