/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import org.jruby.nb.nb.nb.JRubyService;
import org.jruby.nb.nb.nb.Main;

public class JRubyServer
extends JRubyService {
    private JRubyService.Configuration conf;
    private boolean stillStarting = true;

    private JRubyServer(String[] stringArray) throws Exception {
        this.conf = new JRubyService.Configuration(stringArray[0]);
        if (this.conf.isDebug()) {
            System.err.println("Starting server with port " + this.conf.getPort() + " and key " + this.conf.getKey());
        }
        ServerSocket serverSocket = new ServerSocket();
        serverSocket.bind(new InetSocketAddress(InetAddress.getLocalHost(), this.conf.getPort()));
        while (true) {
            Thread thread = new Thread(new Handler(serverSocket.accept()));
            thread.setDaemon(true);
            thread.start();
        }
    }

    protected static String[] intoCommandArguments(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        int n = -1;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(i) == ' ' && !bl && n != -1) {
                arrayList.add(string.substring(n, i));
                n = -1;
                continue;
            }
            if (string.charAt(i) == ' ') continue;
            if (string.charAt(i) == '\'' && !bl) {
                bl = true;
                n = i + 1;
                continue;
            }
            if (string.charAt(i) == '\'') {
                bl = false;
                arrayList.add(string.substring(n, i));
                n = -1;
                continue;
            }
            if (n != -1) continue;
            n = i;
        }
        if (n != -1) {
            arrayList.add(string.substring(n));
        }
        return arrayList.toArray(new String[0]);
    }

    public static void main(String[] stringArray) throws Exception {
        new JRubyServer(stringArray);
    }

    private class Handler
    implements Runnable {
        private Socket socket;

        public Handler(Socket socket) {
            this.socket = socket;
        }

        public void run() {
            try {
                String[] stringArray;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                String string = bufferedReader.readLine();
                bufferedReader.close();
                this.socket.close();
                this.socket = null;
                if (JRubyServer.this.conf.isDebug()) {
                    System.err.println("Got command: " + string);
                }
                if ((stringArray = string.split(" ", 3))[1].equals(JRubyServer.this.conf.getKey())) {
                    if (stringArray[0].equals("TERM")) {
                        if (JRubyServer.this.conf.isDebug()) {
                            System.err.println("Terminating hard");
                        }
                        System.exit(0);
                    } else if (stringArray[0].equals("NO_MORE")) {
                        if (JRubyServer.this.conf.isDebug()) {
                            System.err.println("Accepting no more START");
                        }
                        JRubyServer.this.stillStarting = false;
                    } else if (stringArray[0].equals("START")) {
                        if (JRubyServer.this.stillStarting) {
                            if (JRubyServer.this.conf.isDebug()) {
                                System.err.println("Doing START on command " + stringArray[2]);
                            }
                            new Main().run(JRubyServer.intoCommandArguments(stringArray[2].trim()));
                        } else if (JRubyServer.this.conf.isDebug()) {
                            System.err.println("Not doing START anymore, invalid command");
                        }
                    } else if (JRubyServer.this.conf.isDebug()) {
                        System.err.println("Unrecognized command");
                    }
                } else if (JRubyServer.this.conf.isDebug()) {
                    System.err.println("Invalid key");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

