/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.libraries;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.ext.posix.util.Platform;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyHash;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.anno.JRubyModule;
import org.jruby.nb.nb.runtime.Constants;
import org.jruby.nb.nb.runtime.load.Library;
import org.jruby.nb.nb.util.NormalizedFile;

@JRubyModule(name={"Config"})
public class RbConfigLibrary
implements Library {
    private static final String RUBY_DARWIN = "darwin";
    private static final String RUBY_LINUX = "linux";
    private static final String RUBY_WIN32 = "mswin32";
    private static final String RUBY_SOLARIS = "solaris";
    private static final String RUBY_FREEBSD = "freebsd";
    private static final String RUBY_AIX = "aix";
    public static final Map<String, String> RUBY_OS_NAMES = new HashMap<String, String>();

    public static String getOSName() {
        String string = Platform.getOSName();
        String string2 = RUBY_OS_NAMES.get(string);
        return string2 == null ? string : string2;
    }

    public void load(Ruby ruby, boolean bl) {
        Object object;
        Object object2;
        RubyModule rubyModule = ruby.defineModule("Config");
        rubyModule.defineAnnotatedMethods(RbConfigLibrary.class);
        RubyHash rubyHash = RubyHash.newHash(ruby);
        rubyModule.defineConstant("CONFIG", rubyHash);
        ruby.getObject().defineConstant("RbConfig", rubyModule);
        String[] stringArray = Constants.RUBY_VERSION.split("\\.");
        RbConfigLibrary.setConfig(rubyHash, "MAJOR", stringArray[0]);
        RbConfigLibrary.setConfig(rubyHash, "MINOR", stringArray[1]);
        RbConfigLibrary.setConfig(rubyHash, "TEENY", stringArray[2]);
        RbConfigLibrary.setConfig(rubyHash, "ruby_version", stringArray[0] + '.' + stringArray[1]);
        RbConfigLibrary.setConfig(rubyHash, "arch", "universal-java" + System.getProperty("java.specification.version"));
        String string = Ruby.isSecurityRestricted() ? "SECURITY RESTRICTED" : ruby.getJRubyHome();
        RbConfigLibrary.setConfig(rubyHash, "bindir", new NormalizedFile(string, "bin").getPath());
        RbConfigLibrary.setConfig(rubyHash, "RUBY_INSTALL_NAME", RbConfigLibrary.jrubyScript());
        RbConfigLibrary.setConfig(rubyHash, "ruby_install_name", RbConfigLibrary.jrubyScript());
        RbConfigLibrary.setConfig(rubyHash, "SHELL", RbConfigLibrary.jrubyShell());
        RbConfigLibrary.setConfig(rubyHash, "prefix", string);
        RbConfigLibrary.setConfig(rubyHash, "exec_prefix", string);
        RbConfigLibrary.setConfig(rubyHash, "host_os", RbConfigLibrary.getOSName());
        RbConfigLibrary.setConfig(rubyHash, "host_vendor", System.getProperty("java.vendor"));
        RbConfigLibrary.setConfig(rubyHash, "host_cpu", Platform.ARCH);
        RbConfigLibrary.setConfig(rubyHash, "target_os", RbConfigLibrary.getOSName());
        RbConfigLibrary.setConfig(rubyHash, "target_cpu", Platform.ARCH);
        String string2 = "jruby.jar";
        URL uRL = Ruby.getClassLoader().getResource("/org/jruby/nb/nb/jruby.properties");
        if (uRL != null) {
            object2 = Pattern.compile("jar:file:.*?([a-zA-Z0-9.\\-]+\\.jar)!/org/jruby/nb/nb/jruby.properties");
            object = ((Pattern)object2).matcher(uRL.toString());
            ((Matcher)object).find();
            if (((Matcher)object).matches()) {
                string2 = ((Matcher)object).group(1);
            }
        }
        RbConfigLibrary.setConfig(rubyHash, "LIBRUBY", string2);
        RbConfigLibrary.setConfig(rubyHash, "LIBRUBY_SO", string2);
        RbConfigLibrary.setConfig(rubyHash, "build", Constants.BUILD);
        RbConfigLibrary.setConfig(rubyHash, "target", Constants.TARGET);
        object2 = System.getProperty("jruby.lib");
        if (object2 == null) {
            object2 = new NormalizedFile(string, "lib").getPath();
        } else {
            try {
                object2 = new NormalizedFile((String)object2).getCanonicalPath();
            }
            catch (IOException iOException) {
                object2 = new NormalizedFile((String)object2).getAbsolutePath();
            }
        }
        object = new NormalizedFile((String)object2, "ruby/1.8").getPath();
        String string3 = new NormalizedFile((String)object2, "ruby/site_ruby").getPath();
        String string4 = new NormalizedFile((String)object2, "ruby/site_ruby/1.8").getPath();
        String string5 = new NormalizedFile((String)object2, "ruby/site_ruby/1.8/java").getPath();
        String string6 = new NormalizedFile((String)object2, "ruby/1.8/java").getPath();
        RbConfigLibrary.setConfig(rubyHash, "libdir", (String)object2);
        RbConfigLibrary.setConfig(rubyHash, "rubylibdir", (String)object);
        RbConfigLibrary.setConfig(rubyHash, "sitedir", string3);
        RbConfigLibrary.setConfig(rubyHash, "sitelibdir", string4);
        RbConfigLibrary.setConfig(rubyHash, "sitearchdir", string5);
        RbConfigLibrary.setConfig(rubyHash, "archdir", string6);
        RbConfigLibrary.setConfig(rubyHash, "topdir", string6);
        RbConfigLibrary.setConfig(rubyHash, "configure_args", "");
        RbConfigLibrary.setConfig(rubyHash, "datadir", new NormalizedFile(string, "share").getPath());
        RbConfigLibrary.setConfig(rubyHash, "mandir", new NormalizedFile(string, "man").getPath());
        RbConfigLibrary.setConfig(rubyHash, "sysconfdir", new NormalizedFile(string, "etc").getPath());
        RbConfigLibrary.setConfig(rubyHash, "localstatedir", new NormalizedFile(string, "var").getPath());
        RbConfigLibrary.setConfig(rubyHash, "DLEXT", "jar");
        if (Platform.IS_WINDOWS) {
            RbConfigLibrary.setConfig(rubyHash, "EXEEXT", ".exe");
        } else {
            RbConfigLibrary.setConfig(rubyHash, "EXEEXT", "");
        }
        RubyHash rubyHash2 = RubyHash.newHash(ruby);
        RbConfigLibrary.setConfig(rubyHash2, "libdir", (String)object2);
        RbConfigLibrary.setConfig(rubyHash2, "arch", "java");
        RbConfigLibrary.setConfig(rubyHash2, "rubylibdir", (String)object);
        RbConfigLibrary.setConfig(rubyHash2, "sitedir", string3);
        RbConfigLibrary.setConfig(rubyHash2, "sitelibdir", string4);
        RbConfigLibrary.setConfig(rubyHash2, "sitearch", "java");
        RbConfigLibrary.setConfig(rubyHash2, "sitearchdir", string5);
        RbConfigLibrary.setConfig(rubyHash2, "archdir", string6);
        RbConfigLibrary.setConfig(rubyHash2, "topdir", string6);
        RbConfigLibrary.setConfig(rubyHash2, "configure_args", "");
        RbConfigLibrary.setConfig(rubyHash2, "datadir", new NormalizedFile(string, "share").getPath());
        RbConfigLibrary.setConfig(rubyHash2, "mandir", new NormalizedFile(string, "man").getPath());
        RbConfigLibrary.setConfig(rubyHash2, "sysconfdir", new NormalizedFile(string, "etc").getPath());
        RbConfigLibrary.setConfig(rubyHash2, "localstatedir", new NormalizedFile(string, "var").getPath());
        RbConfigLibrary.setupMakefileConfig(rubyModule, rubyHash2);
    }

    private static void setupMakefileConfig(RubyModule rubyModule, RubyHash rubyHash) {
        String string;
        Ruby ruby = rubyModule.getRuntime();
        String string2 = " -fno-omit-frame-pointer -fno-strict-aliasing -DNDEBUG ";
        String string3 = " -O2 " + string2;
        String string4 = " -W -Werror -Wall -Wno-unused -Wno-parentheses ";
        String string5 = "";
        String string6 = " -I\"$(JDK_HOME)/include\" -I\"$(JDK_HOME)/include/$(OS)\" -I\"$(BUILD_DIR)\" ";
        String string7 = "";
        String string8 = string = "";
        String string9 = " -arch i386 -arch ppc -arch x86_64 ";
        string7 = string7 + string9;
        string7 = string7 + " -isysroot /Developer/SDKs/MacOSX10.4u.sdk -DTARGET_RT_MAC_CFM=0 ";
        string7 = string7 + " -arch i386 -arch ppc -arch x86_64 ";
        string8 = string8 + " -arch i386 -arch ppc -arch x86_64 -bundle -framework JavaVM -Wl,-syslibroot,$(SDKROOT) -mmacosx-version-min=10.4 -undefined dynamic_lookup ";
        String string10 = "a";
        String string11 = "o";
        RbConfigLibrary.setConfig(rubyHash, "configure_args", "");
        RbConfigLibrary.setConfig(rubyHash, "CFLAGS", string7);
        RbConfigLibrary.setConfig(rubyHash, "CPPFLAGS", "");
        RbConfigLibrary.setConfig(rubyHash, "ARCH_FLAG", "");
        RbConfigLibrary.setConfig(rubyHash, "LDFLAGS", string8);
        RbConfigLibrary.setConfig(rubyHash, "DLDFLAGS", "");
        RbConfigLibrary.setConfig(rubyHash, "LIBEXT", string10);
        RbConfigLibrary.setConfig(rubyHash, "OBJEXT", string11);
        RbConfigLibrary.setConfig(rubyHash, "LIBRUBYARG_STATIC", "");
        RbConfigLibrary.setConfig(rubyHash, "LIBRUBYARG_SHARED", "");
        RbConfigLibrary.setConfig(rubyHash, "LIBS", "");
        RbConfigLibrary.setConfig(rubyHash, "DLDLIBS", "");
        RbConfigLibrary.setConfig(rubyHash, "ENABLED_SHARED", "");
        RbConfigLibrary.setConfig(rubyHash, "LIBRUBY", "");
        RbConfigLibrary.setConfig(rubyHash, "LIBRUBY_A", "");
        RbConfigLibrary.setConfig(rubyHash, "LIBRUBYARG", "");
        RbConfigLibrary.setConfig(rubyHash, "prefix", "");
        RbConfigLibrary.setConfig(rubyHash, "ruby_install_name", RbConfigLibrary.jrubyScript());
        RbConfigLibrary.setConfig(rubyHash, "DLEXT", "bundle");
        RbConfigLibrary.setConfig(rubyHash, "CC", "cc ");
        RbConfigLibrary.setConfig(rubyHash, "LDSHARED", "cc ");
        RbConfigLibrary.setConfig(rubyHash, "OUTFLAG", "-o ");
        RbConfigLibrary.setConfig(rubyHash, "PATH_SEPARATOR", ":");
        RbConfigLibrary.setConfig(rubyHash, "INSTALL", "install -c ");
        RbConfigLibrary.setConfig(rubyHash, "RM", "rm -f");
        RbConfigLibrary.setConfig(rubyHash, "CP", "cp ");
        RbConfigLibrary.setConfig(rubyHash, "MAKEDIRS", "mkdir -p ");
        ruby.getObject().defineConstant("CROSS_COMPILING", ruby.getNil());
        rubyModule.defineConstant("MAKEFILE_CONFIG", rubyHash);
    }

    private static void setConfig(RubyHash rubyHash, String string, String string2) {
        Ruby ruby = rubyHash.getRuntime();
        rubyHash.op_aset(ruby.getCurrentContext(), ruby.newString(string), ruby.newString(string2));
    }

    public static String jrubyScript() {
        return System.getProperty("jruby.script", Platform.IS_WINDOWS ? "jruby.bat" : "jruby").replace('\\', '/');
    }

    public static String jrubyShell() {
        return System.getProperty("jruby.shell", Platform.IS_WINDOWS ? "cmd.exe" : "/bin/sh").replace('\\', '/');
    }

    static {
        RUBY_OS_NAMES.put("Mac OS X", RUBY_DARWIN);
        RUBY_OS_NAMES.put("Darwin", RUBY_DARWIN);
        RUBY_OS_NAMES.put("Linux", RUBY_LINUX);
        RUBY_OS_NAMES.put("Windows 95", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows 98", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows Me", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows NT", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows NT (unknown)", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows XP", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows 2003", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows Vista", RUBY_WIN32);
        RUBY_OS_NAMES.put("Solaris", RUBY_SOLARIS);
        RUBY_OS_NAMES.put("FreeBSD", RUBY_FREEBSD);
        RUBY_OS_NAMES.put("AIX", RUBY_AIX);
    }
}

