/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.lexer.yacc;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jruby.nb.nb.lexer.yacc.IDESourcePositionFactory;
import org.jruby.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.lexer.yacc.ISourcePositionFactory;
import org.jruby.nb.nb.lexer.yacc.InputStreamLexerSource;
import org.jruby.nb.nb.lexer.yacc.SimplePositionFactory;
import org.jruby.nb.nb.parser.ParserConfiguration;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LexerSource {
    private ISourcePositionFactory positionFactory;
    private final String sourceName;
    protected int line = 0;
    protected int offset = 0;
    private List<String> list;
    private StringBuilder lineBuffer;

    protected LexerSource(String string, List<String> list, int n, boolean bl) {
        this.sourceName = string;
        this.line = n;
        this.positionFactory = bl ? new IDESourcePositionFactory(this, n) : new SimplePositionFactory(this, n);
        this.list = list;
        this.lineBuffer = new StringBuilder();
    }

    public String getFilename() {
        return this.sourceName;
    }

    public int getLine() {
        return this.line;
    }

    public int getOffset() {
        return this.offset <= 0 ? 0 : this.offset;
    }

    public ISourcePosition getPosition(ISourcePosition iSourcePosition, boolean bl) {
        return this.positionFactory.getPosition(iSourcePosition, bl);
    }

    public ISourcePosition getPosition() {
        return this.positionFactory.getPosition(null, false);
    }

    public ISourcePositionFactory getPositionFactory() {
        return this.positionFactory;
    }

    public static LexerSource getSource(String string, InputStream inputStream, List<String> list, ParserConfiguration parserConfiguration) {
        return new InputStreamLexerSource(string, inputStream, list, parserConfiguration.getLineNumber(), parserConfiguration.hasExtraPositionInformation());
    }

    protected void captureFeature(int n) {
        if (this.list != null) {
            if (n != -1) {
                this.lineBuffer.append((char)n);
            }
            if (n == 10 || n == -1 && this.lineBuffer.length() > 0) {
                this.list.add(this.lineBuffer.toString());
                this.lineBuffer.setLength(0);
            }
        }
    }

    public abstract boolean matchMarker(ByteList var1, boolean var2, boolean var3) throws IOException;

    public abstract int read() throws IOException;

    public abstract ByteList readUntil(char var1) throws IOException;

    public abstract ByteList readLineBytes() throws IOException;

    public abstract int skipUntil(int var1) throws IOException;

    public abstract void unread(int var1);

    public abstract void unreadMany(CharSequence var1);

    public abstract boolean peek(int var1) throws IOException;

    public abstract boolean lastWasBeginOfLine();

    public abstract boolean wasBeginOfLine();

    public abstract int chompReadAhead();

    public abstract boolean isANewLine();

    public abstract void setIsANewLine(boolean var1);

    public abstract void setOffset(int var1);
}

