/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.javasupport;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyBoolean;
import org.jruby.nb.nb.RubyClass;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.RubyString;
import org.jruby.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.javasupport.Java;
import org.jruby.nb.nb.javasupport.JavaAccessibleObject;
import org.jruby.nb.nb.javasupport.JavaCallable;
import org.jruby.nb.nb.javasupport.JavaClass;
import org.jruby.nb.nb.javasupport.JavaObject;
import org.jruby.nb.nb.javasupport.JavaUtil;
import org.jruby.nb.nb.javasupport.proxy.InternalJavaProxy;
import org.jruby.nb.nb.javasupport.proxy.JavaProxyClass;
import org.jruby.nb.nb.javasupport.proxy.JavaProxyMethod;
import org.jruby.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Java::JavaMethod"})
public class JavaMethod
extends JavaCallable {
    private final Method method;
    private final Class<?>[] parameterTypes;
    private final JavaUtil.JavaConverter returnConverter;

    public Object getValue() {
        return this.method;
    }

    public static RubyClass createJavaMethodClass(Ruby ruby, RubyModule rubyModule) {
        RubyClass rubyClass = rubyModule.defineClassUnder("JavaMethod", ruby.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        JavaAccessibleObject.registerRubyMethods(ruby, rubyClass);
        JavaCallable.registerRubyMethods(ruby, rubyClass);
        rubyClass.defineAnnotatedMethods(JavaMethod.class);
        return rubyClass;
    }

    public JavaMethod(Ruby ruby, Method method) {
        super(ruby, ruby.getJavaSupport().getJavaMethodClass());
        this.method = method;
        this.parameterTypes = method.getParameterTypes();
        if (Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getClass().getModifiers()) && !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            this.accessibleObject().setAccessible(true);
        }
        this.returnConverter = JavaUtil.getJavaConverter(method.getReturnType());
    }

    public static JavaMethod create(Ruby ruby, Method method) {
        return new JavaMethod(ruby, method);
    }

    public static JavaMethod create(Ruby ruby, Class<?> clazz, String string, Class<?>[] classArray) {
        try {
            Method method = clazz.getMethod(string, classArray);
            return JavaMethod.create(ruby, method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw ruby.newNameError("undefined method '" + string + "' for class '" + clazz.getName() + "'", string);
        }
    }

    public static JavaMethod createDeclared(Ruby ruby, Class<?> clazz, String string, Class<?>[] classArray) {
        try {
            return JavaMethod.create(ruby, clazz.getDeclaredMethod(string, classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw ruby.newNameError("undefined method '" + string + "' for class '" + clazz.getName() + "'", string);
        }
    }

    public static JavaMethod getMatchingDeclaredMethod(Ruby ruby, Class<?> clazz, String string, Class<?>[] classArray) {
        try {
            return JavaMethod.create(ruby, clazz.getDeclaredMethod(string, classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            block2: for (Method method : clazz.getDeclaredMethods()) {
                if (!method.getName().equals(string)) continue;
                Class<?>[] classArray2 = method.getParameterTypes();
                if (classArray2.length == 0 && classArray.length == 0) {
                    return JavaMethod.create(ruby, method);
                }
                for (int i = 0; i < classArray.length; ++i) {
                    if (i >= classArray2.length || !classArray2[i].isAssignableFrom(classArray[i])) continue block2;
                }
                return JavaMethod.create(ruby, method);
            }
            return null;
        }
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof JavaMethod && this.method == ((JavaMethod)object).method;
    }

    @Override
    public int hashCode() {
        return this.method.hashCode();
    }

    @Override
    @JRubyMethod
    public RubyString name() {
        return this.getRuntime().newString(this.method.getName());
    }

    @Override
    public int getArity() {
        return this.parameterTypes.length;
    }

    @Override
    @JRubyMethod(name={"public?"})
    public RubyBoolean public_p() {
        return this.getRuntime().newBoolean(Modifier.isPublic(this.method.getModifiers()));
    }

    @JRubyMethod(name={"final?"})
    public RubyBoolean final_p() {
        return this.getRuntime().newBoolean(Modifier.isFinal(this.method.getModifiers()));
    }

    @JRubyMethod(rest=true)
    public IRubyObject invoke(IRubyObject[] iRubyObjectArray) {
        JavaProxyClass javaProxyClass;
        JavaProxyMethod javaProxyMethod;
        if (iRubyObjectArray.length != 1 + this.getArity()) {
            throw this.getRuntime().newArgumentError(iRubyObjectArray.length, 1 + this.getArity());
        }
        Object[] objectArray = new Object[iRubyObjectArray.length - 1];
        this.convertArguments(this.getRuntime(), objectArray, iRubyObjectArray, 1);
        IRubyObject iRubyObject = iRubyObjectArray[0];
        if (iRubyObject.isNil()) {
            return this.invokeWithExceptionHandling(this.method, null, objectArray);
        }
        Object object = JavaUtil.unwrapJavaObject(this.getRuntime(), iRubyObject, "invokee not a java object").getValue();
        if (!this.method.getDeclaringClass().isInstance(object)) {
            throw this.getRuntime().newTypeError("invokee not instance of method's class (got" + object.getClass().getName() + " wanted " + this.method.getDeclaringClass().getName() + ")");
        }
        if (object instanceof InternalJavaProxy && !Modifier.isFinal(this.method.getModifiers()) && (javaProxyMethod = (javaProxyClass = ((InternalJavaProxy)object).___getProxyClass()).getMethod(this.method.getName(), this.parameterTypes)) != null && javaProxyMethod.hasSuperImplementation()) {
            return this.invokeWithExceptionHandling(javaProxyMethod.getSuperMethod(), object, objectArray);
        }
        return this.invokeWithExceptionHandling(this.method, object, objectArray);
    }

    public IRubyObject invoke(IRubyObject iRubyObject, Object[] objectArray) {
        JavaProxyClass javaProxyClass;
        JavaProxyMethod javaProxyMethod;
        if (objectArray.length != this.getArity()) {
            throw this.getRuntime().newArgumentError(objectArray.length, this.getArity());
        }
        if (!(iRubyObject instanceof JavaObject)) {
            throw this.getRuntime().newTypeError("invokee not a java object");
        }
        Object object = ((JavaObject)iRubyObject).getValue();
        if (!this.method.getDeclaringClass().isInstance(object)) {
            throw this.getRuntime().newTypeError("invokee not instance of method's class (got" + object.getClass().getName() + " wanted " + this.method.getDeclaringClass().getName() + ")");
        }
        if (object instanceof InternalJavaProxy && !Modifier.isFinal(this.method.getModifiers()) && (javaProxyMethod = (javaProxyClass = ((InternalJavaProxy)object).___getProxyClass()).getMethod(this.method.getName(), this.parameterTypes)) != null && javaProxyMethod.hasSuperImplementation()) {
            return this.invokeWithExceptionHandling(javaProxyMethod.getSuperMethod(), object, objectArray);
        }
        return this.invokeWithExceptionHandling(this.method, object, objectArray);
    }

    @JRubyMethod(rest=true)
    public IRubyObject invoke_static(IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length != this.getArity()) {
            throw this.getRuntime().newArgumentError(iRubyObjectArray.length, this.getArity());
        }
        Object[] objectArray = new Object[iRubyObjectArray.length];
        System.arraycopy(iRubyObjectArray, 0, objectArray, 0, objectArray.length);
        this.convertArguments(this.getRuntime(), objectArray, iRubyObjectArray, 0);
        return this.invokeWithExceptionHandling(this.method, null, objectArray);
    }

    public IRubyObject invoke_static(Object[] objectArray) {
        if (objectArray.length != this.getArity()) {
            throw this.getRuntime().newArgumentError(objectArray.length, this.getArity());
        }
        return this.invokeWithExceptionHandling(this.method, null, objectArray);
    }

    @JRubyMethod
    public IRubyObject return_type() {
        Class<?> clazz = this.method.getReturnType();
        if (clazz.equals(Void.TYPE)) {
            return this.getRuntime().getNil();
        }
        return JavaClass.get(this.getRuntime(), clazz);
    }

    @JRubyMethod
    public IRubyObject type_parameters() {
        return Java.getInstance(this.getRuntime(), this.method.getTypeParameters());
    }

    private IRubyObject invokeWithExceptionHandling(Method method, Object object, Object[] objectArray) {
        try {
            Object object2 = method.invoke(object, objectArray);
            return this.returnConverter.convert(this.getRuntime(), object2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.getRuntime().newTypeError("for method " + method.getName() + " expected " + this.argument_types().inspect() + "; got: " + this.dumpArgTypes(objectArray) + "; error: " + illegalArgumentException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw this.getRuntime().newTypeError("illegal access on '" + method.getName() + "': " + illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            this.getRuntime().getJavaSupport().handleNativeException(invocationTargetException.getTargetException());
            return this.getRuntime().getNil();
        }
    }

    private String dumpArgTypes(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder("[");
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            if (objectArray[i] == null) {
                stringBuilder.append("null");
                continue;
            }
            stringBuilder.append(objectArray[i].getClass().getName());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private void convertArguments(Ruby ruby, Object[] objectArray, Object[] objectArray2, int n) {
        Class<?>[] classArray = this.parameterTypes;
        int n2 = objectArray.length;
        while (--n2 >= 0) {
            objectArray[n2] = JavaUtil.convertArgument(ruby, objectArray2[n2 + n], classArray[n2]);
        }
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public Class<?>[] getExceptionTypes() {
        return this.method.getExceptionTypes();
    }

    @Override
    public Type[] getGenericParameterTypes() {
        return this.method.getGenericParameterTypes();
    }

    @Override
    public Type[] getGenericExceptionTypes() {
        return this.method.getGenericExceptionTypes();
    }

    @Override
    public Annotation[][] getParameterAnnotations() {
        return this.method.getParameterAnnotations();
    }

    @Override
    public boolean isVarArgs() {
        return this.method.isVarArgs();
    }

    @Override
    protected String nameOnInspection() {
        return "#<" + this.getType().toString() + "/" + this.method.getName() + "(";
    }

    public RubyBoolean static_p() {
        return this.getRuntime().newBoolean(this.isStatic());
    }

    public RubyBoolean bridge_p() {
        return this.getRuntime().newBoolean(this.method.isBridge());
    }

    private boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    @Override
    public int getModifiers() {
        return this.method.getModifiers();
    }

    @Override
    public String toGenericString() {
        return this.method.toGenericString();
    }

    @Override
    protected AccessibleObject accessibleObject() {
        return this.method;
    }
}

