/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.internal.runtime;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyProc;
import org.jruby.nb.nb.common.IRubyWarnings;
import org.jruby.nb.nb.exceptions.RaiseException;
import org.jruby.nb.nb.internal.runtime.GlobalVariable;
import org.jruby.nb.nb.internal.runtime.ReadonlyAccessor;
import org.jruby.nb.nb.internal.runtime.UndefinedAccessor;
import org.jruby.nb.nb.runtime.IAccessor;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalVariables {
    private Ruby runtime;
    private Map<String, GlobalVariable> globalVariables = new ConcurrentHashMap<String, GlobalVariable>();
    private IRubyObject defaultSeparator;

    public GlobalVariables(Ruby ruby) {
        this.runtime = ruby;
    }

    public void define(String string, IAccessor iAccessor) {
        assert (string != null);
        assert (iAccessor != null);
        assert (string.startsWith("$"));
        this.globalVariables.put(string, new GlobalVariable(iAccessor));
    }

    public void defineReadonly(String string, IAccessor iAccessor) {
        assert (string != null);
        assert (iAccessor != null);
        assert (string.startsWith("$"));
        this.globalVariables.put(string, new GlobalVariable(new ReadonlyAccessor(string, iAccessor)));
    }

    public boolean isDefined(String string) {
        assert (string != null);
        assert (string.startsWith("$"));
        GlobalVariable globalVariable = this.globalVariables.get(string);
        return globalVariable != null && !(globalVariable.getAccessor() instanceof UndefinedAccessor);
    }

    public void alias(String string, String string2) {
        assert (string != null);
        assert (string2 != null);
        assert (string.startsWith("$"));
        assert (string2.startsWith("$"));
        if (this.runtime.getSafeLevel() >= 4) {
            throw this.runtime.newSecurityError("Insecure: can't alias global variable");
        }
        GlobalVariable globalVariable = this.createIfNotDefined(string2);
        GlobalVariable globalVariable2 = this.globalVariables.get(string);
        if (globalVariable2 != null && globalVariable != globalVariable2 && globalVariable2.isTracing()) {
            throw new RaiseException(this.runtime, this.runtime.getRuntimeError(), "can't alias in tracer", false);
        }
        this.globalVariables.put(string, globalVariable);
    }

    public IRubyObject get(String string) {
        assert (string != null);
        assert (string.startsWith("$"));
        GlobalVariable globalVariable = this.globalVariables.get(string);
        if (globalVariable != null) {
            return globalVariable.getAccessor().getValue();
        }
        this.runtime.getWarnings().warning(IRubyWarnings.ID.GLOBAL_NOT_INITIALIZED, "global variable `" + string + "' not initialized", string);
        return this.runtime.getNil();
    }

    public IRubyObject set(String string, IRubyObject iRubyObject) {
        assert (string != null);
        assert (string.startsWith("$"));
        if (this.runtime.getSafeLevel() >= 4) {
            throw this.runtime.newSecurityError("Insecure: can't change global variable value");
        }
        GlobalVariable globalVariable = this.createIfNotDefined(string);
        IRubyObject iRubyObject2 = globalVariable.getAccessor().setValue(iRubyObject);
        globalVariable.trace(iRubyObject);
        return iRubyObject2;
    }

    public void setTraceVar(String string, RubyProc rubyProc) {
        assert (string != null);
        assert (string.startsWith("$"));
        GlobalVariable globalVariable = this.createIfNotDefined(string);
        globalVariable.addTrace(rubyProc);
    }

    public boolean untraceVar(String string, IRubyObject iRubyObject) {
        assert (string != null);
        assert (string.startsWith("$"));
        if (this.isDefined(string)) {
            GlobalVariable globalVariable = this.globalVariables.get(string);
            return globalVariable.removeTrace(iRubyObject);
        }
        return false;
    }

    public void untraceVar(String string) {
        assert (string != null);
        assert (string.startsWith("$"));
        if (this.isDefined(string)) {
            GlobalVariable globalVariable = this.globalVariables.get(string);
            globalVariable.removeTraces();
        }
    }

    public Set<String> getNames() {
        return this.globalVariables.keySet();
    }

    private GlobalVariable createIfNotDefined(String string) {
        GlobalVariable globalVariable = this.globalVariables.get(string);
        if (globalVariable == null) {
            globalVariable = GlobalVariable.newUndefined(this.runtime, string);
            this.globalVariables.put(string, globalVariable);
        }
        return globalVariable;
    }

    public IRubyObject getDefaultSeparator() {
        return this.defaultSeparator;
    }

    public void setDefaultSeparator(IRubyObject iRubyObject) {
        this.defaultSeparator = iRubyObject;
    }
}

