/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.ext.ffi.jna;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import org.jruby.nb.nb.ext.ffi.Factory;

public class FileDescriptorByteChannel
implements ByteChannel {
    private static final LibC libc = Factory.getInstance().loadLibrary("c", LibC.class);
    private final int fd;
    private volatile boolean isOpen = true;

    public FileDescriptorByteChannel(int n) {
        this.fd = n;
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        if (!this.isOpen) {
            throw new IOException("Not open");
        }
        int n = libc.read(this.fd, byteBuffer, byteBuffer.remaining());
        if (n > 0) {
            byteBuffer.position(byteBuffer.position() + n);
        }
        return n;
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        if (!this.isOpen) {
            throw new IOException("Not open");
        }
        int n = libc.write(this.fd, byteBuffer, byteBuffer.remaining());
        if (n > 0) {
            byteBuffer.position(byteBuffer.position() + n);
        }
        return n;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void close() throws IOException {
        if (!this.isOpen) {
            throw new IllegalStateException("file already closed");
        }
        this.isOpen = false;
        libc.close(this.fd);
    }

    private static interface LibC {
        public int read(int var1, ByteBuffer var2, int var3);

        public int write(int var1, ByteBuffer var2, int var3);

        public int close(int var1);
    }
}

