/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.ext.ffi;

import java.nio.ByteBuffer;
import org.jruby.nb.nb.RubyNumeric;
import org.jruby.nb.nb.RubyString;
import org.jruby.nb.nb.javasupport.JavaObject;
import org.jruby.nb.nb.javasupport.JavaUtil;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Util {
    private Util() {
    }

    public static final byte int8Value(IRubyObject iRubyObject) {
        long l = Util.longValue(iRubyObject);
        if (l < -128L || l > 127L) {
            throw iRubyObject.getRuntime().newRangeError("Value " + l + " outside char range");
        }
        return (byte)l;
    }

    public static final short uint8Value(IRubyObject iRubyObject) {
        long l = Util.longValue(iRubyObject);
        if (l < 0L || l > 255L) {
            throw iRubyObject.getRuntime().newRangeError("Value " + l + " outside unsigned char range");
        }
        return (short)l;
    }

    public static final short int16Value(IRubyObject iRubyObject) {
        long l = Util.longValue(iRubyObject);
        if (l < -32768L || l > 32767L) {
            throw iRubyObject.getRuntime().newRangeError("Value " + l + " outside short range");
        }
        return (short)l;
    }

    public static final int uint16Value(IRubyObject iRubyObject) {
        long l = Util.longValue(iRubyObject);
        if (l < 0L || l > 65535L) {
            throw iRubyObject.getRuntime().newRangeError("Value " + l + " outside unsigned short range");
        }
        return (int)l;
    }

    public static final int int32Value(IRubyObject iRubyObject) {
        long l = Util.longValue(iRubyObject);
        if (l < Integer.MIN_VALUE || l > 0xFFFFFFFFL) {
            throw iRubyObject.getRuntime().newRangeError("Value " + l + " outside integer range");
        }
        return (int)l;
    }

    public static final long uint32Value(IRubyObject iRubyObject) {
        long l = Util.longValue(iRubyObject);
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw iRubyObject.getRuntime().newRangeError("Value " + l + " outside unsigned integer range");
        }
        return l;
    }

    public static final long int64Value(IRubyObject iRubyObject) {
        return Util.longValue(iRubyObject);
    }

    public static final long uint64Value(IRubyObject iRubyObject) {
        long l = Util.longValue(iRubyObject);
        if (l < 0L) {
            throw iRubyObject.getRuntime().newRangeError("Value " + l + " outside unsigned long long range");
        }
        return l;
    }

    public static final float floatValue(IRubyObject iRubyObject) {
        double d = RubyNumeric.num2dbl(iRubyObject);
        if (d < (double)1.4E-45f || d > 3.4028234663852886E38) {
            throw iRubyObject.getRuntime().newRangeError("Value " + d + " outside float range");
        }
        return (float)d;
    }

    public static final double doubleValue(IRubyObject iRubyObject) {
        return RubyNumeric.num2dbl(iRubyObject);
    }

    public static final long longValue(IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyNumeric) {
            return ((RubyNumeric)iRubyObject).getLongValue();
        }
        if (iRubyObject.isNil()) {
            return 0L;
        }
        if (iRubyObject instanceof RubyString) {
            return Util.longValue((RubyString)iRubyObject);
        }
        throw iRubyObject.getRuntime().newRangeError("Value " + iRubyObject + " is not an integer");
    }

    private static final long longValue(RubyString rubyString) {
        String string = rubyString.asJavaString();
        if (string.length() == 1) {
            return string.charAt(0);
        }
        throw rubyString.getRuntime().newRangeError("Value " + rubyString + " is not an integer");
    }

    public static final <T> T convertParameter(IRubyObject iRubyObject, Class<T> clazz) {
        return clazz.cast(iRubyObject instanceof JavaObject ? ((JavaObject)iRubyObject).getValue() : JavaUtil.convertRubyToJava(iRubyObject, clazz));
    }

    public static final ByteBuffer slice(ByteBuffer byteBuffer, int n) {
        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
        byteBuffer2.position(n);
        return byteBuffer2.slice();
    }
}

