/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.ext.ffi;

import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyArray;
import org.jruby.nb.nb.RubyClass;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.RubyObject;
import org.jruby.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.ext.ffi.Invoker;
import org.jruby.nb.nb.ext.ffi.NativeType;
import org.jruby.nb.nb.ext.ffi.Util;
import org.jruby.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;

@JRubyClass(name={"JRuby::FFI::Provider"}, parent="Object")
public abstract class FFIProvider
extends RubyObject {
    public static final String MODULE_NAME = "JRuby::FFI";
    public static final String CLASS_NAME = "Provider";

    public static RubyClass createProviderClass(Ruby ruby) {
        RubyModule rubyModule = FFIProvider.getModule(ruby);
        RubyClass rubyClass = rubyModule.defineClassUnder(CLASS_NAME, ruby.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        rubyClass.defineAnnotatedMethods(FFIProvider.class);
        rubyClass.defineAnnotatedConstants(FFIProvider.class);
        return rubyClass;
    }

    protected FFIProvider(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    protected FFIProvider(Ruby ruby) {
        super(ruby, FFIProvider.getModule(ruby).fastGetClass(CLASS_NAME));
    }

    public static RubyModule getModule(Ruby ruby) {
        return (RubyModule)ruby.fastGetModule("JRuby").fastGetConstantAt("FFI");
    }

    @JRubyMethod(name={"create_invoker", "createInvoker"}, required=5)
    public IRubyObject createInvoker(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        RubyArray rubyArray = (RubyArray)iRubyObjectArray[3];
        NativeType[] nativeTypeArray = new NativeType[rubyArray.size()];
        for (int i = 0; i < rubyArray.size(); ++i) {
            nativeTypeArray[i] = NativeType.valueOf(Util.int32Value(rubyArray.entry(i)));
        }
        try {
            return this.createInvoker(threadContext.getRuntime(), iRubyObjectArray[0].toString(), iRubyObjectArray[1].toString(), NativeType.valueOf(Util.int32Value(iRubyObjectArray[2])), nativeTypeArray, iRubyObjectArray[4].toString());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return threadContext.getRuntime().getNil();
        }
    }

    @JRubyMethod(name={"error", "last_error"})
    public IRubyObject getLastError(ThreadContext threadContext) {
        return threadContext.getRuntime().newFixnum(this.getLastError());
    }

    @JRubyMethod(name={"error=", "last_error="})
    public IRubyObject getLastError(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.setLastError(Util.int32Value(iRubyObject));
        return threadContext.getRuntime().getNil();
    }

    public abstract Invoker createInvoker(Ruby var1, String var2, String var3, NativeType var4, NativeType[] var5, String var6);

    public abstract int getLastError();

    public abstract void setLastError(int var1);
}

