/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.ext.ffi;

import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyArray;
import org.jruby.nb.nb.RubyClass;
import org.jruby.nb.nb.RubyFixnum;
import org.jruby.nb.nb.RubyFloat;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.RubyObject;
import org.jruby.nb.nb.RubyString;
import org.jruby.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.ext.ffi.AbstractMemoryPointer;
import org.jruby.nb.nb.ext.ffi.FFIProvider;
import org.jruby.nb.nb.ext.ffi.MemoryIO;
import org.jruby.nb.nb.ext.ffi.Platform;
import org.jruby.nb.nb.ext.ffi.Util;
import org.jruby.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"AbstractMemory"}, parent="Object")
public abstract class AbstractMemory
extends RubyObject {
    public static final String ABSTRACT_MEMORY_RUBY_CLASS = "AbstractMemory";
    protected final long offset;
    protected final long size;
    protected final MemoryIO io;

    public static RubyClass createAbstractMemoryClass(Ruby ruby) {
        RubyModule rubyModule = FFIProvider.getModule(ruby);
        RubyClass rubyClass = rubyModule.defineClassUnder(ABSTRACT_MEMORY_RUBY_CLASS, ruby.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        rubyClass.defineAnnotatedMethods(AbstractMemory.class);
        rubyClass.defineAnnotatedConstants(AbstractMemory.class);
        return rubyClass;
    }

    protected AbstractMemory(Ruby ruby, RubyClass rubyClass, MemoryIO memoryIO, long l, long l2) {
        super(ruby, rubyClass);
        this.io = memoryIO;
        this.offset = l;
        this.size = l2;
    }

    protected final MemoryIO getMemoryIO() {
        return this.io;
    }

    protected final long getOffset(IRubyObject iRubyObject) {
        return this.getOffset() + Util.int64Value(iRubyObject);
    }

    protected final long getOffset() {
        return this.offset;
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash(ThreadContext threadContext) {
        return threadContext.getRuntime().newFixnum(this.hashCode());
    }

    @JRubyMethod(name={"to_s"}, optional=1)
    public IRubyObject to_s(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        return RubyString.newString(threadContext.getRuntime(), "AbstractMemory[size=" + this.size + "]");
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbstractMemory)) {
            return false;
        }
        AbstractMemory abstractMemory = (AbstractMemory)object;
        return abstractMemory.getMemoryIO().equals(this.getMemoryIO()) && abstractMemory.offset == this.offset;
    }

    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext threadContext, IRubyObject iRubyObject) {
        return threadContext.getRuntime().newBoolean(this.equals(iRubyObject));
    }

    public final boolean eql(IRubyObject iRubyObject) {
        return this.equals(iRubyObject);
    }

    public int hashCode() {
        return 67 * this.getMemoryIO().hashCode() + (int)(this.offset ^ this.offset >>> 32);
    }

    @JRubyMethod(name={"clear"})
    public IRubyObject clear(ThreadContext threadContext) {
        this.getMemoryIO().setMemory(this.offset, this.size, (byte)0);
        return this;
    }

    @JRubyMethod(name={"total"})
    public IRubyObject total(ThreadContext threadContext) {
        return RubyFixnum.newFixnum(threadContext.getRuntime(), this.size);
    }

    protected static final void checkBounds(ThreadContext threadContext, long l, long l2, long l3) {
        if ((l2 | l3 | l2 + l3 | l - (l2 + l3)) < 0L) {
            throw threadContext.getRuntime().newIndexError("Memory access offset=" + l2 + " size=" + l3 + " is out of bounds");
        }
    }

    protected final void checkBounds(ThreadContext threadContext, long l, long l2) {
        AbstractMemory.checkBounds(threadContext, this.size, l, l2);
    }

    protected final long checkBounds(ThreadContext threadContext, IRubyObject iRubyObject, long l) {
        long l2 = Util.longValue(iRubyObject);
        AbstractMemory.checkBounds(threadContext, this.size, l2, l);
        return this.offset + l2;
    }

    @JRubyMethod(name={"put_int8", "put_char"}, required=2)
    public IRubyObject put_int8(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.checkBounds(threadContext, iRubyObject, 1L);
        this.getMemoryIO().putByte(this.getOffset(iRubyObject), Util.int8Value(iRubyObject2));
        return this;
    }

    @JRubyMethod(name={"get_int8", "get_char"}, required=1)
    public IRubyObject get_int8(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.checkBounds(threadContext, iRubyObject, 1L);
        return RubyFixnum.newFixnum(threadContext.getRuntime(), this.getMemoryIO().getByte(this.getOffset(iRubyObject)));
    }

    @JRubyMethod(name={"put_uint8", "put_uchar"}, required=2)
    public IRubyObject put_uint8(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.checkBounds(threadContext, iRubyObject, 1L);
        this.getMemoryIO().putByte(this.getOffset(iRubyObject), (byte)Util.uint8Value(iRubyObject2));
        return this;
    }

    @JRubyMethod(name={"get_uint8", "get_uchar"}, required=1)
    public IRubyObject get_uint8(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.checkBounds(threadContext, iRubyObject, 1L);
        byte by = this.getMemoryIO().getByte(this.getOffset(iRubyObject));
        return RubyFixnum.newFixnum(threadContext.getRuntime(), by < 0 ? (long)((short)((by & 0x7F) + 128)) : (long)by);
    }

    @JRubyMethod(name={"put_int16", "put_short"}, required=2)
    public IRubyObject put_int16(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.checkBounds(threadContext, iRubyObject, 2L);
        this.getMemoryIO().putShort(this.getOffset(iRubyObject), Util.int16Value(iRubyObject2));
        return this;
    }

    @JRubyMethod(name={"get_int16", "get_short"}, required=1)
    public IRubyObject get_int16(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.checkBounds(threadContext, iRubyObject, 2L);
        return RubyFixnum.newFixnum(threadContext.getRuntime(), this.getMemoryIO().getShort(this.getOffset(iRubyObject)));
    }

    @JRubyMethod(name={"put_uint16", "put_ushort"}, required=2)
    public IRubyObject put_uint16(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.checkBounds(threadContext, iRubyObject, 2L);
        this.getMemoryIO().putShort(this.getOffset(iRubyObject), (short)Util.uint16Value(iRubyObject2));
        return this;
    }

    @JRubyMethod(name={"get_uint16", "get_ushort"}, required=1)
    public IRubyObject get_uint16(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.checkBounds(threadContext, iRubyObject, 2L);
        short s = this.getMemoryIO().getShort(this.getOffset(iRubyObject));
        return RubyFixnum.newFixnum(threadContext.getRuntime(), s < 0 ? (long)((s & Short.MAX_VALUE) + 32768) : (long)s);
    }

    @JRubyMethod(name={"put_int32", "put_int"}, required=2)
    public IRubyObject put_int32(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.checkBounds(threadContext, iRubyObject, 4L);
        this.getMemoryIO().putInt(this.getOffset(iRubyObject), Util.int32Value(iRubyObject2));
        return this;
    }

    @JRubyMethod(name={"get_int32", "get_int"}, required=1)
    public IRubyObject get_int32(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.checkBounds(threadContext, iRubyObject, 4L);
        return RubyFixnum.newFixnum(threadContext.getRuntime(), this.getMemoryIO().getInt(this.getOffset(iRubyObject)));
    }

    @JRubyMethod(name={"put_uint32", "put_uint"}, required=2)
    public IRubyObject put_uint32(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.checkBounds(threadContext, iRubyObject, 4L);
        this.getMemoryIO().putInt(this.getOffset(iRubyObject), (int)Util.uint32Value(iRubyObject2));
        return this;
    }

    @JRubyMethod(name={"get_uint32", "get_uint"}, required=1)
    public IRubyObject get_uint32(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.checkBounds(threadContext, iRubyObject, 4L);
        long l = this.getMemoryIO().getInt(this.getOffset(iRubyObject));
        return RubyFixnum.newFixnum(threadContext.getRuntime(), l < 0L ? (l & Integer.MAX_VALUE) + 0x80000000L : l);
    }

    @JRubyMethod(name={"put_int64", "put_uint64", "put_long_long", "put_ulong_long"}, required=2)
    public IRubyObject put_int64(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.checkBounds(threadContext, iRubyObject, 8L);
        this.getMemoryIO().putLong(this.getOffset(iRubyObject), Util.int64Value(iRubyObject2));
        return this;
    }

    @JRubyMethod(name={"get_int64", "get_uint64", "get_long_long", "get_ulong_long"}, required=1)
    public IRubyObject get_int64(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.checkBounds(threadContext, iRubyObject, 8L);
        return RubyFixnum.newFixnum(threadContext.getRuntime(), this.getMemoryIO().getLong(this.getOffset(iRubyObject)));
    }

    @JRubyMethod(name={"put_long"}, required=2)
    public IRubyObject put_long(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.checkBounds(threadContext, iRubyObject, (long)(Platform.getPlatform().longSize() / 8));
        this.getMemoryIO().putNativeLong(this.getOffset(iRubyObject), Util.longValue(iRubyObject2));
        return this;
    }

    @JRubyMethod(name={"get_long"}, required=1)
    public IRubyObject get_long(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.checkBounds(threadContext, iRubyObject, (long)(Platform.getPlatform().longSize() / 8));
        return RubyFixnum.newFixnum(threadContext.getRuntime(), this.getMemoryIO().getNativeLong(this.getOffset(iRubyObject)));
    }

    @JRubyMethod(name={"put_ulong"}, required=2)
    public IRubyObject put_ulong(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.checkBounds(threadContext, iRubyObject, (long)(Platform.getPlatform().longSize() / 8));
        this.getMemoryIO().putNativeLong(this.getOffset(iRubyObject), Util.longValue(iRubyObject2));
        return this;
    }

    @JRubyMethod(name={"get_ulong"}, required=1)
    public IRubyObject get_ulong(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.checkBounds(threadContext, iRubyObject, (long)(Platform.getPlatform().longSize() / 8));
        long l = this.getMemoryIO().getNativeLong(this.getOffset(iRubyObject));
        return RubyFixnum.newFixnum(threadContext.getRuntime(), l < 0L ? (l & Integer.MAX_VALUE) + 0x80000000L : l);
    }

    @JRubyMethod(name={"put_float32", "put_float"}, required=2)
    public IRubyObject put_float32(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.checkBounds(threadContext, iRubyObject, 4L);
        this.getMemoryIO().putFloat(this.getOffset(iRubyObject), Util.floatValue(iRubyObject2));
        return this;
    }

    @JRubyMethod(name={"get_float32", "get_float"}, required=1)
    public IRubyObject get_float32(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.checkBounds(threadContext, iRubyObject, 4L);
        return RubyFloat.newFloat(threadContext.getRuntime(), this.getMemoryIO().getFloat(this.getOffset(iRubyObject)));
    }

    @JRubyMethod(name={"put_float64", "put_double"}, required=2)
    public IRubyObject put_float64(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.checkBounds(threadContext, iRubyObject, 8L);
        this.getMemoryIO().putDouble(this.getOffset(iRubyObject), Util.doubleValue(iRubyObject2));
        return this;
    }

    @JRubyMethod(name={"get_float64", "get_double"}, required=1)
    public IRubyObject get_float64(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.checkBounds(threadContext, iRubyObject, 8L);
        return RubyFloat.newFloat(threadContext.getRuntime(), this.getMemoryIO().getDouble(this.getOffset(iRubyObject)));
    }

    @JRubyMethod(name={"get_array_of_int8", "get_array_of_char"}, required=2)
    public IRubyObject get_array_of_int8(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        int n = Util.int32Value(iRubyObject2);
        this.checkBounds(threadContext, iRubyObject, (long)(n * 2));
        byte[] byArray = new byte[n];
        this.getMemoryIO().get(this.getOffset(iRubyObject), byArray, 0, byArray.length);
        Ruby ruby = threadContext.getRuntime();
        RubyArray rubyArray = RubyArray.newArray(ruby, byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            rubyArray.add(RubyFixnum.newFixnum(ruby, byArray[i]));
        }
        return rubyArray;
    }

    @JRubyMethod(name={"put_array_of_int8", "put_array_of_char"}, required=2)
    public IRubyObject put_array_of_int8(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyArray rubyArray = (RubyArray)iRubyObject2;
        int n = rubyArray.getLength();
        this.checkBounds(threadContext, iRubyObject, (long)(n * 2));
        byte[] byArray = new byte[n];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = Util.int8Value(rubyArray.entry(i));
        }
        this.getMemoryIO().put(this.getOffset(iRubyObject), byArray, 0, byArray.length);
        return this;
    }

    @JRubyMethod(name={"get_array_of_int16", "get_array_of_short"}, required=2)
    public IRubyObject get_array_of_int16(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        int n = Util.int32Value(iRubyObject2);
        this.checkBounds(threadContext, iRubyObject, (long)(n * 2));
        short[] sArray = new short[n];
        this.getMemoryIO().get(this.getOffset(iRubyObject), sArray, 0, sArray.length);
        Ruby ruby = threadContext.getRuntime();
        RubyArray rubyArray = RubyArray.newArray(ruby, sArray.length);
        for (int i = 0; i < sArray.length; ++i) {
            rubyArray.add(RubyFixnum.newFixnum(ruby, sArray[i]));
        }
        return rubyArray;
    }

    @JRubyMethod(name={"put_array_of_int16", "put_array_of_short"}, required=2)
    public IRubyObject put_array_of_int16(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyArray rubyArray = (RubyArray)iRubyObject2;
        int n = rubyArray.getLength();
        this.checkBounds(threadContext, iRubyObject, (long)(n * 2));
        short[] sArray = new short[n];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = Util.int16Value(rubyArray.entry(i));
        }
        this.getMemoryIO().put(this.getOffset(iRubyObject), sArray, 0, sArray.length);
        return this;
    }

    @JRubyMethod(name={"get_array_of_int32", "get_array_of_int"}, required=2)
    public IRubyObject get_array_of_int32(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        int n = Util.int32Value(iRubyObject2);
        this.checkBounds(threadContext, iRubyObject, (long)(n * 4));
        int[] nArray = new int[n];
        this.getMemoryIO().get(this.getOffset(iRubyObject), nArray, 0, nArray.length);
        Ruby ruby = threadContext.getRuntime();
        RubyArray rubyArray = RubyArray.newArray(ruby, nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            rubyArray.add(RubyFixnum.newFixnum(ruby, nArray[i]));
        }
        return rubyArray;
    }

    @JRubyMethod(name={"put_array_of_int32", "get_array_of_int"}, required=2)
    public IRubyObject put_array_of_int32(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyArray rubyArray = (RubyArray)iRubyObject2;
        int n = rubyArray.getLength();
        this.checkBounds(threadContext, iRubyObject, (long)(n * 4));
        int[] nArray = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = Util.int32Value(rubyArray.entry(i));
        }
        this.getMemoryIO().put(this.getOffset(iRubyObject), nArray, 0, nArray.length);
        return this;
    }

    @JRubyMethod(name={"get_array_of_long"}, required=2)
    public IRubyObject get_array_of_long(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return Platform.getPlatform().longSize() == 32 ? this.get_array_of_int32(threadContext, iRubyObject, iRubyObject2) : this.get_array_of_int64(threadContext, iRubyObject, iRubyObject2);
    }

    @JRubyMethod(name={"put_array_of_long"}, required=2)
    public IRubyObject put_array_of_long(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return Platform.getPlatform().longSize() == 32 ? this.put_array_of_int32(threadContext, iRubyObject, iRubyObject2) : this.put_array_of_int64(threadContext, iRubyObject, iRubyObject2);
    }

    @JRubyMethod(name={"get_array_of_int64"}, required=2)
    public IRubyObject get_array_of_int64(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        int n = Util.int32Value(iRubyObject2);
        this.checkBounds(threadContext, iRubyObject, (long)(n * 4));
        long[] lArray = new long[n];
        this.getMemoryIO().get(this.getOffset(iRubyObject), lArray, 0, lArray.length);
        Ruby ruby = threadContext.getRuntime();
        RubyArray rubyArray = RubyArray.newArray(ruby, lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            rubyArray.add(RubyFixnum.newFixnum(ruby, lArray[i]));
        }
        return rubyArray;
    }

    @JRubyMethod(name={"put_array_of_int64"}, required=2)
    public IRubyObject put_array_of_int64(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyArray rubyArray = (RubyArray)iRubyObject2;
        int n = rubyArray.getLength();
        this.checkBounds(threadContext, iRubyObject, (long)(n * 8));
        long[] lArray = new long[n];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = Util.int64Value(rubyArray.entry(i));
        }
        this.getMemoryIO().put(this.getOffset(iRubyObject), lArray, 0, lArray.length);
        return this;
    }

    @JRubyMethod(name={"get_array_of_float32", "get_array_of_float"}, required=2)
    public IRubyObject get_array_of_float(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        int n = Util.int32Value(iRubyObject2);
        this.checkBounds(threadContext, iRubyObject, (long)(n * 4));
        float[] fArray = new float[n];
        this.getMemoryIO().get(this.getOffset(iRubyObject), fArray, 0, fArray.length);
        Ruby ruby = threadContext.getRuntime();
        RubyArray rubyArray = RubyArray.newArray(ruby, fArray.length);
        for (int i = 0; i < fArray.length; ++i) {
            rubyArray.add(RubyFloat.newFloat(ruby, fArray[i]));
        }
        return rubyArray;
    }

    @JRubyMethod(name={"put_array_of_float32", "put_array_of_float"}, required=2)
    public IRubyObject put_array_of_float(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyArray rubyArray = (RubyArray)iRubyObject2;
        int n = rubyArray.getLength();
        this.checkBounds(threadContext, iRubyObject, (long)(n * 4));
        float[] fArray = new float[n];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = Util.floatValue(rubyArray.entry(i));
        }
        this.getMemoryIO().put(this.getOffset(iRubyObject), fArray, 0, fArray.length);
        return this;
    }

    @JRubyMethod(name={"get_array_of_float64", "get_array_of_double"}, required=2)
    public IRubyObject get_array_of_float64(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        int n = Util.int32Value(iRubyObject2);
        this.checkBounds(threadContext, iRubyObject, (long)(n * 8));
        double[] dArray = new double[n];
        this.getMemoryIO().get(this.getOffset(iRubyObject), dArray, 0, dArray.length);
        Ruby ruby = threadContext.getRuntime();
        RubyArray rubyArray = RubyArray.newArray(ruby, dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            rubyArray.add(RubyFloat.newFloat(ruby, dArray[i]));
        }
        return rubyArray;
    }

    @JRubyMethod(name={"put_array_of_float64", "put_array_of_double"}, required=2)
    public IRubyObject put_array_of_float64(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyArray rubyArray = (RubyArray)iRubyObject2;
        int n = rubyArray.getLength();
        this.checkBounds(threadContext, iRubyObject, (long)(n * 8));
        double[] dArray = new double[n];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Util.doubleValue(rubyArray.entry(i));
        }
        this.getMemoryIO().put(this.getOffset(iRubyObject), dArray, 0, dArray.length);
        return this;
    }

    @JRubyMethod(name={"get_string"}, required=1, optional=1)
    public IRubyObject get_string(ThreadContext threadContext, IRubyObject iRubyObject) {
        long l = this.getOffset(iRubyObject);
        int n = this.getMemoryIO().indexOf(l, (byte)0);
        ByteList byteList = new ByteList(n);
        this.getMemoryIO().get(l, byteList.unsafeBytes(), byteList.begin(), n);
        byteList.length(n);
        return threadContext.getRuntime().newString(byteList);
    }

    @JRubyMethod(name={"get_string"})
    public IRubyObject get_string(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        long l = this.getOffset(iRubyObject);
        int n = Util.int32Value(iRubyObject2);
        int n2 = this.getMemoryIO().indexOf(l, (byte)0, n);
        if (n2 < 0 || n2 > n) {
            n2 = n;
        }
        ByteList byteList = new ByteList(n2);
        this.getMemoryIO().get(l, byteList.unsafeBytes(), byteList.begin(), n2);
        byteList.length(n2);
        return threadContext.getRuntime().newString(byteList);
    }

    @JRubyMethod(name={"put_string"}, required=2, optional=1)
    public IRubyObject put_string(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        long l = this.getOffset(iRubyObjectArray[0]);
        ByteList byteList = iRubyObjectArray[1].convertToString().getByteList();
        int n = byteList.length();
        boolean bl = true;
        if (iRubyObjectArray.length > 2) {
            n = Math.min(Util.int32Value(iRubyObjectArray[2]) - 1, n);
            bl = false;
        }
        this.getMemoryIO().put(l, byteList.unsafeBytes(), byteList.begin(), n);
        if (bl) {
            this.getMemoryIO().putByte(l + (long)byteList.length(), (byte)0);
        }
        return this;
    }

    @JRubyMethod(name={"get_pointer"}, required=1)
    public IRubyObject get_pointer(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.getMemoryPointer(threadContext.getRuntime(), Util.int64Value(iRubyObject));
    }

    protected abstract AbstractMemoryPointer getMemoryPointer(Ruby var1, long var2);
}

