/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.evaluator;

import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyArray;
import org.jruby.nb.nb.RubyBinding;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.RubyProc;
import org.jruby.nb.nb.RubyString;
import org.jruby.nb.nb.ast.ArrayNode;
import org.jruby.nb.nb.ast.BlockPassNode;
import org.jruby.nb.nb.ast.IterNode;
import org.jruby.nb.nb.ast.MultipleAsgnNode;
import org.jruby.nb.nb.ast.Node;
import org.jruby.nb.nb.ast.util.ArgsUtil;
import org.jruby.nb.nb.common.IRubyWarnings;
import org.jruby.nb.nb.evaluator.AssignmentVisitor;
import org.jruby.nb.nb.exceptions.JumpException;
import org.jruby.nb.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.nb.parser.StaticScope;
import org.jruby.nb.nb.runtime.Binding;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.DynamicScope;
import org.jruby.nb.nb.runtime.Frame;
import org.jruby.nb.nb.runtime.InterpretedBlock;
import org.jruby.nb.nb.runtime.MethodIndex;
import org.jruby.nb.nb.runtime.RubyEvent;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.util.TypeConverter;

public class ASTInterpreter {
    @Deprecated
    public static IRubyObject eval(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        assert (iRubyObject != null) : "self during eval must never be null";
        if (node == null) {
            return ruby.getNil();
        }
        try {
            return node.interpret(ruby, threadContext, iRubyObject, block);
        }
        catch (StackOverflowError stackOverflowError) {
            throw ruby.newSystemStackError("stack level too deep");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IRubyObject evalWithBinding(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, String string, int n) {
        assert (!iRubyObject2.isNil());
        Ruby ruby = iRubyObject.getRuntime();
        String string2 = threadContext.getFile();
        int n2 = threadContext.getLine();
        if (!(iRubyObject2 instanceof RubyBinding)) {
            if (!(iRubyObject2 instanceof RubyProc)) throw ruby.newTypeError("wrong argument type " + iRubyObject2.getMetaClass() + " (expected Proc/Binding)");
            iRubyObject2 = ((RubyProc)iRubyObject2).binding();
        }
        Binding binding = ((RubyBinding)iRubyObject2).getBinding();
        DynamicScope dynamicScope = binding.getDynamicScope().getEvalScope();
        if (string == null) {
            string = binding.getFrame().getFile();
        }
        if (n == -1) {
            n = binding.getFrame().getLine();
        }
        dynamicScope.getStaticScope().determineModule();
        Frame frame = threadContext.preEvalWithBinding(binding);
        try {
            IRubyObject iRubyObject3;
            try {
                IRubyObject iRubyObject4 = binding.getSelf();
                RubyString rubyString = iRubyObject.convertToString();
                Node node = ruby.parseEval(rubyString.getByteList(), string, dynamicScope, n);
                iRubyObject3 = node.interpret(ruby, threadContext, iRubyObject4, binding.getFrame().getBlock());
                Object var16_18 = null;
            }
            catch (JumpException.BreakJump breakJump) {
                throw ruby.newLocalJumpError("break", (IRubyObject)breakJump.getValue(), "unexpected break");
            }
            catch (JumpException.RedoJump redoJump) {
                throw ruby.newLocalJumpError("redo", (IRubyObject)redoJump.getValue(), "unexpected redo");
            }
            catch (StackOverflowError stackOverflowError) {
                throw ruby.newSystemStackError("stack level too deep");
            }
            threadContext.postEvalWithBinding(binding, frame);
            threadContext.setFile(string2);
            threadContext.setLine(n2);
            return iRubyObject3;
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            threadContext.postEvalWithBinding(binding, frame);
            threadContext.setFile(string2);
            threadContext.setLine(n2);
            throw throwable;
        }
    }

    public static IRubyObject evalSimple(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, String string, int n) {
        RubyString rubyString = iRubyObject2.convertToString();
        return ASTInterpreter.evalSimple(threadContext, iRubyObject, rubyString, string, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IRubyObject evalSimple(ThreadContext threadContext, IRubyObject iRubyObject, RubyString rubyString, String string, int n) {
        assert (string != null);
        Ruby ruby = rubyString.getRuntime();
        String string2 = threadContext.getFile();
        int n2 = threadContext.getLine();
        RubyString rubyString2 = rubyString.convertToString();
        DynamicScope dynamicScope = threadContext.getCurrentScope().getEvalScope();
        dynamicScope.getStaticScope().determineModule();
        try {
            IRubyObject iRubyObject2;
            try {
                Node node = ruby.parseEval(rubyString2.getByteList(), string, dynamicScope, n);
                iRubyObject2 = node.interpret(ruby, threadContext, iRubyObject, Block.NULL_BLOCK);
                Object var13_14 = null;
            }
            catch (JumpException.BreakJump breakJump) {
                throw ruby.newLocalJumpError("break", (IRubyObject)breakJump.getValue(), "unexpected break");
            }
            catch (StackOverflowError stackOverflowError) {
                throw ruby.newSystemStackError("stack level too deep");
            }
            threadContext.setFile(string2);
            threadContext.setLine(n2);
            return iRubyObject2;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            threadContext.setFile(string2);
            threadContext.setLine(n2);
            throw throwable;
        }
    }

    public static void callTraceFunction(Ruby ruby, ThreadContext threadContext, RubyEvent rubyEvent) {
        String string = threadContext.getFrameName();
        RubyModule rubyModule = threadContext.getFrameKlazz();
        ruby.callEventHooks(threadContext, rubyEvent, threadContext.getFile(), threadContext.getLine(), string, rubyModule);
    }

    public static IRubyObject pollAndReturn(ThreadContext threadContext, IRubyObject iRubyObject) {
        threadContext.pollThreadEvents();
        return iRubyObject;
    }

    public static IRubyObject multipleAsgnArrayNode(Ruby ruby, ThreadContext threadContext, MultipleAsgnNode multipleAsgnNode, ArrayNode arrayNode, IRubyObject iRubyObject, Block block) {
        IRubyObject[] iRubyObjectArray = new IRubyObject[arrayNode.size()];
        for (int i = 0; i < arrayNode.size(); ++i) {
            iRubyObjectArray[i] = arrayNode.get(i).interpret(ruby, threadContext, iRubyObject, block);
        }
        return AssignmentVisitor.multiAssign(ruby, threadContext, iRubyObject, multipleAsgnNode, RubyArray.newArrayNoCopyLight(ruby, iRubyObjectArray), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject evalClassDefinitionBody(Ruby ruby, ThreadContext threadContext, StaticScope staticScope, Node node, RubyModule rubyModule, IRubyObject iRubyObject, Block block) {
        IRubyObject iRubyObject2;
        block7: {
            block5: {
                IRubyObject iRubyObject3;
                block6: {
                    threadContext.preClassEval(staticScope, rubyModule);
                    try {
                        if (ruby.hasEventHooks()) {
                            ASTInterpreter.callTraceFunction(ruby, threadContext, RubyEvent.CLASS);
                        }
                        if (node != null) break block5;
                        iRubyObject3 = ruby.getNil();
                        Object var9_9 = null;
                        if (!ruby.hasEventHooks()) break block6;
                    }
                    catch (Throwable throwable) {
                        Object var9_11 = null;
                        if (ruby.hasEventHooks()) {
                            ASTInterpreter.callTraceFunction(ruby, threadContext, RubyEvent.END);
                        }
                        threadContext.postClassEval();
                        throw throwable;
                    }
                    ASTInterpreter.callTraceFunction(ruby, threadContext, RubyEvent.END);
                }
                threadContext.postClassEval();
                return iRubyObject3;
            }
            iRubyObject2 = node.interpret(ruby, threadContext, rubyModule, block);
            Object var9_10 = null;
            if (!ruby.hasEventHooks()) break block7;
            ASTInterpreter.callTraceFunction(ruby, threadContext, RubyEvent.END);
        }
        threadContext.postClassEval();
        return iRubyObject2;
    }

    public static String getArgumentDefinition(Ruby ruby, ThreadContext threadContext, Node node, String string, IRubyObject iRubyObject, Block block) {
        if (node == null) {
            return string;
        }
        if (node instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)node;
            int n = arrayNode.size();
            for (int i = 0; i < n; ++i) {
                if (arrayNode.get(i).definition(ruby, threadContext, iRubyObject, block) != null) continue;
                return null;
            }
        } else if (node.definition(ruby, threadContext, iRubyObject, block) == null) {
            return null;
        }
        return string;
    }

    public static Block getBlock(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block, Node node) {
        if (node == null) {
            return Block.NULL_BLOCK;
        }
        if (node instanceof IterNode) {
            return ASTInterpreter.getIterNodeBlock(node, threadContext, iRubyObject);
        }
        if (node instanceof BlockPassNode) {
            return ASTInterpreter.getBlockPassBlock(node, ruby, threadContext, iRubyObject, block);
        }
        assert (false) : "Trying to get block from something which cannot deliver";
        return null;
    }

    private static Block getBlockPassBlock(Node node, Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        Node node2 = ((BlockPassNode)node).getBodyNode();
        IRubyObject iRubyObject2 = node2 == null ? ruby.getNil() : node2.interpret(ruby, threadContext, iRubyObject, block);
        return RuntimeHelpers.getBlockFromBlockPassBody(iRubyObject2, block);
    }

    private static Block getIterNodeBlock(Node node, ThreadContext threadContext, IRubyObject iRubyObject) {
        IterNode iterNode = (IterNode)node;
        StaticScope staticScope = iterNode.getScope();
        staticScope.determineModule();
        return InterpretedBlock.newInterpretedClosure(threadContext, iterNode.getBlockBody(), iRubyObject);
    }

    public static RubyModule getClassVariableBase(ThreadContext threadContext, Ruby ruby) {
        StaticScope staticScope = threadContext.getCurrentScope().getStaticScope();
        RubyModule rubyModule = staticScope.getModule();
        if (rubyModule.isSingleton() || rubyModule == ruby.getDummy()) {
            staticScope = staticScope.getPreviousCRefScope();
            rubyModule = staticScope.getModule();
            if (staticScope.getPreviousCRefScope() == null) {
                ruby.getWarnings().warn(IRubyWarnings.ID.CVAR_FROM_TOPLEVEL_SINGLETON_METHOD, "class variable access from toplevel singleton method", new Object[0]);
            }
        }
        return rubyModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String getDefinition(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        try {
            threadContext.setWithinDefined(true);
            String string = node.definition(ruby, threadContext, iRubyObject, block);
            Object var7_6 = null;
            threadContext.setWithinDefined(false);
            return string;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            threadContext.setWithinDefined(false);
            throw throwable;
        }
    }

    public static IRubyObject[] setupArgs(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        if (node == null) {
            return IRubyObject.NULL_ARRAY;
        }
        if (node instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)node;
            String string = threadContext.getFile();
            int n = threadContext.getLine();
            int n2 = arrayNode.size();
            IRubyObject[] iRubyObjectArray = new IRubyObject[n2];
            for (int i = 0; i < n2; ++i) {
                iRubyObjectArray[i] = arrayNode.get(i).interpret(ruby, threadContext, iRubyObject, block);
            }
            threadContext.setFile(string);
            threadContext.setLine(n);
            return iRubyObjectArray;
        }
        return ArgsUtil.convertToJavaArray(node.interpret(ruby, threadContext, iRubyObject, block));
    }

    @Deprecated
    public static IRubyObject aValueSplat(Ruby ruby, IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyArray) || ((RubyArray)iRubyObject).length().getLongValue() == 0L) {
            return ruby.getNil();
        }
        RubyArray rubyArray = (RubyArray)iRubyObject;
        return rubyArray.getLength() == 1 ? rubyArray.first(IRubyObject.NULL_ARRAY) : rubyArray;
    }

    @Deprecated
    public static RubyArray arrayValue(Ruby ruby, IRubyObject iRubyObject) {
        IRubyObject iRubyObject2 = iRubyObject.checkArrayType();
        if (iRubyObject2.isNil()) {
            if (iRubyObject.getMetaClass().searchMethod("to_a").getImplementationClass() != ruby.getKernel()) {
                if (!((iRubyObject = iRubyObject.callMethod(ruby.getCurrentContext(), MethodIndex.TO_A, "to_a")) instanceof RubyArray)) {
                    throw ruby.newTypeError("`to_a' did not return Array");
                }
                return (RubyArray)iRubyObject;
            }
            return ruby.newArray(iRubyObject);
        }
        return (RubyArray)iRubyObject2;
    }

    @Deprecated
    public static IRubyObject aryToAry(Ruby ruby, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyArray) {
            return iRubyObject;
        }
        if (iRubyObject.respondsTo("to_ary")) {
            return TypeConverter.convertToType(iRubyObject, ruby.getArray(), MethodIndex.TO_A, "to_ary", false);
        }
        return ruby.newArray(iRubyObject);
    }

    @Deprecated
    public static RubyArray splatValue(Ruby ruby, IRubyObject iRubyObject) {
        if (iRubyObject.isNil()) {
            return ruby.newArray(iRubyObject);
        }
        return ASTInterpreter.arrayValue(ruby, iRubyObject);
    }

    @Deprecated
    public static RubyArray splatValue(IRubyObject iRubyObject, Ruby ruby) {
        return ASTInterpreter.splatValue(ruby, iRubyObject);
    }

    @Deprecated
    public static IRubyObject aValueSplat(IRubyObject iRubyObject, Ruby ruby) {
        return ASTInterpreter.aValueSplat(ruby, iRubyObject);
    }

    @Deprecated
    public static IRubyObject aryToAry(IRubyObject iRubyObject, Ruby ruby) {
        return ASTInterpreter.aryToAry(ruby, iRubyObject);
    }
}

