/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.compiler.util;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jruby.nb.nb.compiler.impl.SkinnyMethodAdapter;
import org.jruby.nb.nb.util.CodegenUtils;
import org.jruby.nb.nb.util.JRubyClassLoader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.util.ASMifierClassVisitor;

public class HandleFactory {
    private static final boolean DEBUG = false;

    public static Handle createHandle(JRubyClassLoader jRubyClassLoader, Method method, boolean bl) {
        ClassWriter classWriter = bl ? new ASMifierClassVisitor(new PrintWriter(System.out)) : new ClassWriter(1);
        Class<?> clazz = method.getReturnType();
        Class[] classArray = method.getParameterTypes();
        String string = "H" + (method.getName() + CodegenUtils.pretty(clazz, classArray)).hashCode();
        try {
            Class<?> clazz2 = jRubyClassLoader.loadClass(string);
            return (Handle)clazz2.newInstance();
        }
        catch (Exception exception) {
            Class<?> clazz3;
            String string2;
            classWriter.visit(49, 49, string, null, CodegenUtils.p(Handle.class), null);
            switch (classArray.length) {
                case 0: {
                    string2 = CodegenUtils.sig(Object.class, Object.class);
                    break;
                }
                case 1: {
                    string2 = CodegenUtils.sig(Object.class, Object.class, Object.class);
                    break;
                }
                case 2: {
                    string2 = CodegenUtils.sig(Object.class, Object.class, Object.class, Object.class);
                    break;
                }
                case 3: {
                    string2 = CodegenUtils.sig(Object.class, Object.class, Object.class, Object.class, Object.class);
                    break;
                }
                default: {
                    string2 = CodegenUtils.sig(Object.class, Object.class, Object[].class);
                }
            }
            SkinnyMethodAdapter skinnyMethodAdapter = new SkinnyMethodAdapter(classWriter.visitMethod(4113, "invoke", string2, null, null));
            skinnyMethodAdapter.start();
            if (!Modifier.isStatic(method.getModifiers())) {
                skinnyMethodAdapter.aload(1);
                if (method.getDeclaringClass() != Object.class) {
                    skinnyMethodAdapter.checkcast(CodegenUtils.p(method.getDeclaringClass()));
                }
            }
            switch (classArray.length) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    int n;
                    for (n = 0; n < classArray.length; ++n) {
                        HandleFactory.loadUnboxedArgument(skinnyMethodAdapter, n + 2, classArray[n]);
                    }
                    break;
                }
                default: {
                    int n;
                    for (n = 0; n < classArray.length; ++n) {
                        skinnyMethodAdapter.aload(2);
                        skinnyMethodAdapter.pushInt(n);
                        skinnyMethodAdapter.aaload();
                        clazz3 = classArray[n];
                        if (clazz3.isPrimitive()) {
                            Class clazz4 = HandleFactory.getBoxType(clazz3);
                            skinnyMethodAdapter.checkcast(CodegenUtils.p(clazz4));
                            skinnyMethodAdapter.invokevirtual(CodegenUtils.p(clazz4), clazz3.toString() + "Value", CodegenUtils.sig(clazz3, new Class[0]));
                            continue;
                        }
                        if (clazz3 == Object.class) continue;
                        skinnyMethodAdapter.checkcast(CodegenUtils.p(clazz3));
                    }
                }
            }
            if (Modifier.isStatic(method.getModifiers())) {
                skinnyMethodAdapter.invokestatic(CodegenUtils.p(method.getDeclaringClass()), method.getName(), CodegenUtils.sig(clazz, classArray));
            } else if (Modifier.isInterface(method.getDeclaringClass().getModifiers())) {
                skinnyMethodAdapter.invokeinterface(CodegenUtils.p(method.getDeclaringClass()), method.getName(), CodegenUtils.sig(clazz, classArray));
            } else {
                skinnyMethodAdapter.invokevirtual(CodegenUtils.p(method.getDeclaringClass()), method.getName(), CodegenUtils.sig(clazz, classArray));
            }
            if (clazz == Void.TYPE) {
                skinnyMethodAdapter.aload(1);
            } else if (clazz.isPrimitive()) {
                Class clazz5 = HandleFactory.getBoxType(clazz);
                skinnyMethodAdapter.invokestatic(CodegenUtils.p(clazz5), "valueOf", CodegenUtils.sig(clazz5, clazz));
            }
            skinnyMethodAdapter.areturn();
            skinnyMethodAdapter.end();
            skinnyMethodAdapter = new SkinnyMethodAdapter(classWriter.visitMethod(1, "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]), null, null));
            skinnyMethodAdapter.start();
            skinnyMethodAdapter.aload(0);
            skinnyMethodAdapter.invokespecial(CodegenUtils.p(Handle.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
            skinnyMethodAdapter.voidreturn();
            skinnyMethodAdapter.end();
            classWriter.visitEnd();
            if (bl) {
                ((ASMifierClassVisitor)classWriter).print(new PrintWriter(System.out));
                return HandleFactory.createHandle(jRubyClassLoader, method, false);
            }
            byte[] byArray = classWriter.toByteArray();
            clazz3 = (jRubyClassLoader != null ? jRubyClassLoader : new JRubyClassLoader(JRubyClassLoader.class.getClassLoader())).defineClass(string, byArray);
            try {
                return (Handle)clazz3.newInstance();
            }
            catch (Exception exception2) {
                throw new RuntimeException(exception2);
            }
        }
    }

    public static void loadUnboxedArgument(SkinnyMethodAdapter skinnyMethodAdapter, int n, Class clazz) {
        skinnyMethodAdapter.aload(n);
        HandleFactory.unboxAndCast(skinnyMethodAdapter, clazz);
    }

    public static void unboxAndCast(SkinnyMethodAdapter skinnyMethodAdapter, Class clazz) {
        if (clazz.isPrimitive()) {
            Class clazz2 = HandleFactory.getBoxType(clazz);
            skinnyMethodAdapter.checkcast(CodegenUtils.p(clazz2));
            skinnyMethodAdapter.invokevirtual(CodegenUtils.p(clazz2), clazz.toString() + "Value", CodegenUtils.sig(clazz, new Class[0]));
        } else if (clazz != Object.class) {
            skinnyMethodAdapter.checkcast(CodegenUtils.p(clazz));
        }
    }

    public static Handle createHandle(JRubyClassLoader jRubyClassLoader, Method method) {
        return HandleFactory.createHandle(jRubyClassLoader, method, false);
    }

    protected static Class getBoxType(Class clazz) {
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        throw new RuntimeException("Not a native type: " + clazz);
    }

    public static void main(String[] stringArray) {
        try {
            Method method = HandleFactory.class.getMethod("dummy", String.class);
            Handle handle = HandleFactory.createHandle(null, method);
            String string = "java.class.path";
            String string2 = "";
            for (int i = 0; i < 10; ++i) {
                String string3;
                Object object;
                int n;
                System.out.print("handle invocation: ");
                long l = System.currentTimeMillis();
                for (n = 0; n < 50000000; ++n) {
                    object = handle.invoke((Object)null, (Object)string);
                    if (n % 10000000 == 0) {
                        System.out.println(object);
                    }
                    handle.invoke((Object)null, (Object)string2);
                    string3 = string;
                    string = string2;
                    string2 = string3;
                }
                System.out.println(System.currentTimeMillis() - l);
                System.out.print("reflected invocation: ");
                l = System.currentTimeMillis();
                for (n = 0; n < 50000000; ++n) {
                    object = method.invoke(null, string);
                    if (n % 10000000 == 0) {
                        System.out.println(object);
                    }
                    method.invoke(null, string2);
                    string3 = string;
                    string = string2;
                    string2 = string3;
                    if (n % 10000000 != 0) continue;
                    System.out.println(string2);
                }
                System.out.println(System.currentTimeMillis() - l);
                System.out.print("method invocation: ");
                l = System.currentTimeMillis();
                for (n = 0; n < 50000000; ++n) {
                    object = HandleFactory.dummy(string);
                    if (n % 10000000 == 0) {
                        System.out.println(object);
                    }
                    HandleFactory.dummy(string2);
                    string3 = string;
                    string = string2;
                    string2 = string3;
                    if (n % 10000000 != 0) continue;
                    System.out.println(string2);
                }
                System.out.println(System.currentTimeMillis() - l);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public static String dummy(String string) {
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    public static int dummy2() {
        return 1;
    }

    public static Object dummy3(Object object) {
        return object;
    }

    public static class Handle {
        private Error fail() {
            return new AbstractMethodError("invalid call signature for target method");
        }

        public Object invoke(Object object) {
            throw this.fail();
        }

        public Object invoke(Object object, Object object2) {
            throw this.fail();
        }

        public Object invoke(Object object, Object object2, Object object3) {
            throw this.fail();
        }

        public Object invoke(Object object, Object object2, Object object3, Object object4) {
            throw this.fail();
        }

        public Object invoke(Object object, Object ... objectArray) {
            throw this.fail();
        }
    }
}

