/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.ast;

import java.util.List;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.ast.ArrayNode;
import org.jruby.nb.nb.ast.Node;
import org.jruby.nb.nb.ast.NodeType;
import org.jruby.nb.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.nb.evaluator.Instruction;
import org.jruby.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YieldNode
extends Node {
    private final Node argsNode;
    private final boolean checkState;

    public YieldNode(ISourcePosition iSourcePosition, Node node, boolean bl) {
        super(iSourcePosition, NodeType.YIELDNODE);
        this.argsNode = node;
        if (node instanceof ArrayNode) {
            ((ArrayNode)node).setLightweight(true);
        }
        this.checkState = bl;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitYieldNode(this);
    }

    public Node getArgsNode() {
        return this.argsNode;
    }

    public boolean getCheckState() {
        return this.checkState;
    }

    @Override
    public List<Node> childNodes() {
        return YieldNode.createList(this.argsNode);
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        IRubyObject iRubyObject2 = null;
        if (this.argsNode != null) {
            iRubyObject2 = this.argsNode.interpret(ruby, threadContext, iRubyObject, block);
        }
        return threadContext.getCurrentFrame().getBlock().yield(threadContext, iRubyObject2, null, null, this.checkState);
    }

    @Override
    public String definition(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return block.isGiven() ? "yield" : null;
    }
}

