/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.ast;

import java.util.List;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.ast.Node;
import org.jruby.nb.nb.ast.NodeType;
import org.jruby.nb.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.nb.evaluator.Instruction;
import org.jruby.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RescueBodyNode
extends Node {
    private final Node exceptionNodes;
    private final Node bodyNode;
    private final RescueBodyNode optRescueNode;

    public RescueBodyNode(ISourcePosition iSourcePosition, Node node, Node node2, RescueBodyNode rescueBodyNode) {
        super(iSourcePosition, NodeType.RESCUEBODYNODE);
        assert (node2 != null) : "bodyNode is not null";
        this.exceptionNodes = node;
        this.bodyNode = node2;
        this.optRescueNode = rescueBodyNode;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitRescueBodyNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public RescueBodyNode getOptRescueNode() {
        return this.optRescueNode;
    }

    public Node getExceptionNodes() {
        return this.exceptionNodes;
    }

    @Override
    public List<Node> childNodes() {
        if (this.optRescueNode != null) {
            return Node.createList(this.exceptionNodes, this.bodyNode, this.optRescueNode);
        }
        return Node.createList(this.exceptionNodes, this.bodyNode);
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return this.bodyNode.interpret(ruby, threadContext, iRubyObject, block);
    }
}

