/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.ast;

import java.util.List;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.ast.Node;
import org.jruby.nb.nb.ast.NodeType;
import org.jruby.nb.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.nb.evaluator.Instruction;
import org.jruby.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinedNode
extends Node {
    private final Node expressionNode;

    public DefinedNode(ISourcePosition iSourcePosition, Node node) {
        super(iSourcePosition, NodeType.DEFINEDNODE);
        assert (node != null) : "expressionNode is not null";
        this.expressionNode = node;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitDefinedNode(this);
    }

    public Node getExpressionNode() {
        return this.expressionNode;
    }

    @Override
    public List<Node> childNodes() {
        return DefinedNode.createList(this.expressionNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        try {
            threadContext.setWithinDefined(true);
            String string = this.expressionNode.definition(ruby, threadContext, iRubyObject, block);
            IRubyObject iRubyObject2 = string != null ? ruby.newString(string) : ruby.getNil();
            Object var8_7 = null;
            threadContext.setWithinDefined(false);
            return iRubyObject2;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            threadContext.setWithinDefined(false);
            throw throwable;
        }
    }
}

