/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.ast;

import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyRegexp;
import org.jruby.nb.nb.RubyString;
import org.jruby.nb.nb.ast.DStrNode;
import org.jruby.nb.nb.ast.ListNode;
import org.jruby.nb.nb.ast.Node;
import org.jruby.nb.nb.ast.NodeType;
import org.jruby.nb.nb.ast.StrNode;
import org.jruby.nb.nb.ast.types.ILiteralNode;
import org.jruby.nb.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.nb.evaluator.Instruction;
import org.jruby.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class DRegexpNode
extends ListNode
implements ILiteralNode {
    private final int options;
    private final boolean once;
    private RubyRegexp onceRegexp;

    public DRegexpNode(ISourcePosition iSourcePosition) {
        this(iSourcePosition, 0, false);
    }

    public DRegexpNode(ISourcePosition iSourcePosition, DStrNode dStrNode, int n, boolean bl) {
        this(iSourcePosition, n, bl);
        this.addAll(dStrNode);
    }

    public DRegexpNode(ISourcePosition iSourcePosition, int n, boolean bl) {
        super(iSourcePosition, NodeType.DREGEXPNODE);
        this.options = n;
        this.once = bl;
    }

    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitDRegxNode(this);
    }

    public boolean getOnce() {
        return this.once;
    }

    public int getOptions() {
        return this.options;
    }

    public RubyRegexp getOnceRegexp() {
        return this.onceRegexp;
    }

    public void setOnceRegexp(RubyRegexp rubyRegexp) {
        if (this.once && this.onceRegexp == null) {
            this.onceRegexp = rubyRegexp;
        }
    }

    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        RubyRegexp rubyRegexp;
        if (this.once && this.onceRegexp != null) {
            return this.onceRegexp;
        }
        RubyString rubyString = ruby.newString(new ByteList());
        for (int i = 0; i < this.size(); ++i) {
            Node node = this.get(i);
            if (node instanceof StrNode) {
                rubyString.getByteList().append(((StrNode)node).getValue());
                continue;
            }
            rubyString.append(node.interpret(ruby, threadContext, iRubyObject, block));
        }
        try {
            rubyRegexp = RubyRegexp.newRegexp(ruby, rubyString.getByteList(), this.options);
        }
        catch (Exception exception) {
            throw ruby.newRegexpError(exception.getMessage());
        }
        if (this.once) {
            this.setOnceRegexp(rubyRegexp);
        }
        return rubyRegexp;
    }
}

