/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.ast;

import java.util.List;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.ast.BinaryOperatorNode;
import org.jruby.nb.nb.ast.Node;
import org.jruby.nb.nb.ast.NodeType;
import org.jruby.nb.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.nb.evaluator.Instruction;
import org.jruby.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndNode
extends Node
implements BinaryOperatorNode {
    private final Node firstNode;
    private final Node secondNode;

    public AndNode(ISourcePosition iSourcePosition, Node node, Node node2) {
        super(iSourcePosition, NodeType.ANDNODE);
        assert (node != null) : "AndNode.first == null";
        assert (node2 != null) : "AndNode.second == null";
        this.firstNode = node;
        this.secondNode = node2;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitAndNode(this);
    }

    @Override
    public Node getSecondNode() {
        return this.secondNode;
    }

    @Override
    public Node getFirstNode() {
        return this.firstNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.firstNode, this.secondNode);
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        IRubyObject iRubyObject2 = this.firstNode.interpret(ruby, threadContext, iRubyObject, block);
        if (!iRubyObject2.isTrue()) {
            return iRubyObject2;
        }
        return this.secondNode.interpret(ruby, threadContext, iRubyObject, block);
    }
}

