/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.anno;

import java.util.List;
import java.util.Map;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.anno.JavaMethodDescriptor;
import org.jruby.nb.nb.internal.runtime.methods.CallConfiguration;
import org.jruby.nb.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.nb.internal.runtime.methods.JavaMethod;
import org.jruby.nb.nb.runtime.Arity;
import org.jruby.nb.nb.runtime.MethodFactory;
import org.jruby.nb.nb.runtime.Visibility;

public abstract class TypePopulator {
    public static final TypePopulator DEFAULT = new DefaultTypePopulator();

    public void populateMethod(JavaMethod javaMethod, int n, String string, boolean bl, CallConfiguration callConfiguration) {
        javaMethod.setArity(Arity.createArity(n));
        javaMethod.setJavaName(string);
        javaMethod.setSingleton(bl);
        javaMethod.setCallConfig(callConfiguration);
    }

    public DynamicMethod populateModuleMethod(RubyModule rubyModule, JavaMethod javaMethod) {
        DynamicMethod dynamicMethod = javaMethod.dup();
        dynamicMethod.setImplementationClass(rubyModule.getSingletonClass());
        dynamicMethod.setVisibility(Visibility.PUBLIC);
        return dynamicMethod;
    }

    public abstract void populate(RubyModule var1, Class var2);

    public static class DefaultTypePopulator
    extends TypePopulator {
        public void populate(RubyModule rubyModule, Class clazz) {
            MethodFactory methodFactory = MethodFactory.createFactory(rubyModule.getRuntime().getJRubyClassLoader());
            RubyModule.MethodClumper methodClumper = new RubyModule.MethodClumper();
            methodClumper.clump(clazz);
            for (Map.Entry<String, List<JavaMethodDescriptor>> entry : methodClumper.getStaticAnnotatedMethods().entrySet()) {
                rubyModule.defineAnnotatedMethod(entry.getKey(), entry.getValue(), methodFactory);
            }
            for (Map.Entry<String, List<JavaMethodDescriptor>> entry : methodClumper.getAnnotatedMethods().entrySet()) {
                rubyModule.defineAnnotatedMethod(entry.getKey(), entry.getValue(), methodFactory);
            }
            for (Map.Entry<String, List<JavaMethodDescriptor>> entry : methodClumper.getStaticAnnotatedMethods1_8().entrySet()) {
                rubyModule.defineAnnotatedMethod(entry.getKey(), entry.getValue(), methodFactory);
            }
            for (Map.Entry<String, List<JavaMethodDescriptor>> entry : methodClumper.getAnnotatedMethods1_8().entrySet()) {
                rubyModule.defineAnnotatedMethod(entry.getKey(), entry.getValue(), methodFactory);
            }
            for (Map.Entry<String, List<JavaMethodDescriptor>> entry : methodClumper.getStaticAnnotatedMethods1_9().entrySet()) {
                rubyModule.defineAnnotatedMethod(entry.getKey(), entry.getValue(), methodFactory);
            }
            for (Map.Entry<String, List<JavaMethodDescriptor>> entry : methodClumper.getAnnotatedMethods1_9().entrySet()) {
                rubyModule.defineAnnotatedMethod(entry.getKey(), entry.getValue(), methodFactory);
            }
        }
    }
}

