/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb;

import java.util.Iterator;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyFixnum;
import org.jruby.nb.nb.RubyGC;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.RubyNumeric;
import org.jruby.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.anno.JRubyModule;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;

@JRubyModule(name={"ObjectSpace"})
public class RubyObjectSpace {
    public static RubyModule createObjectSpaceModule(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("ObjectSpace");
        ruby.setObjectSpaceModule(rubyModule);
        rubyModule.defineAnnotatedMethods(RubyObjectSpace.class);
        return rubyModule;
    }

    @JRubyMethod(name={"define_finalizer"}, required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject define_finalizer(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        Ruby ruby = iRubyObject.getRuntime();
        IRubyObject iRubyObject2 = null;
        if (iRubyObjectArray.length == 2) {
            iRubyObject2 = iRubyObjectArray[1];
            if (!iRubyObject2.respondsTo("call")) {
                throw ruby.newArgumentError("wrong type argument " + iRubyObject2.getType() + " (should be callable)");
            }
        } else {
            iRubyObject2 = ruby.newProc(Block.Type.PROC, block);
        }
        IRubyObject iRubyObject3 = iRubyObjectArray[0];
        ruby.getObjectSpace().addFinalizer(iRubyObject3, iRubyObject2);
        return ruby.newArray(ruby.newFixnum(ruby.getSafeLevel()), iRubyObject2);
    }

    @JRubyMethod(name={"undefine_finalizer"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject undefine_finalizer(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        iRubyObject.getRuntime().getObjectSpace().removeFinalizers(RubyNumeric.fix2long(iRubyObject2.id()));
        return iRubyObject;
    }

    @JRubyMethod(name={"_id2ref"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject id2ref(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject2.getRuntime();
        if (!(iRubyObject2 instanceof RubyFixnum)) {
            throw iRubyObject.getRuntime().newTypeError(iRubyObject2, iRubyObject.getRuntime().getFixnum());
        }
        RubyFixnum rubyFixnum = (RubyFixnum)iRubyObject2;
        long l = rubyFixnum.getLongValue();
        if (l == 0L) {
            return ruby.getFalse();
        }
        if (l == 2L) {
            return ruby.getTrue();
        }
        if (l == 4L) {
            return ruby.getNil();
        }
        if (l % 2L != 0L) {
            return ruby.newFixnum((l - 1L) / 2L);
        }
        IRubyObject iRubyObject3 = ruby.getObjectSpace().id2ref(l);
        if (iRubyObject3 == null) {
            return ruby.getNil();
        }
        return iRubyObject3;
    }

    @JRubyMethod(name={"each_object"}, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject each_object(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        RubyModule rubyModule;
        if (iRubyObjectArray.length == 0) {
            rubyModule = iRubyObject.getRuntime().getObject();
        } else {
            if (!(iRubyObjectArray[0] instanceof RubyModule)) {
                throw iRubyObject.getRuntime().newTypeError("class or module required");
            }
            rubyModule = (RubyModule)iRubyObjectArray[0];
        }
        Ruby ruby = iRubyObject.getRuntime();
        int n = 0;
        if (rubyModule != ruby.getClassClass()) {
            if (!ruby.isObjectSpaceEnabled()) {
                throw ruby.newRuntimeError("ObjectSpace is disabled; each_object will only work with Class, pass +O to enable");
            }
            Iterator iterator = iRubyObject.getRuntime().getObjectSpace().iterator(rubyModule);
            IRubyObject iRubyObject2 = null;
            while ((iRubyObject2 = (IRubyObject)iterator.next()) != null) {
                ++n;
                block.yield(threadContext, iRubyObject2);
            }
        } else {
            Iterator iterator = ruby.getObject().subclasses(true).iterator();
            while (iterator.hasNext()) {
                ++n;
                block.yield(threadContext, (IRubyObject)iterator.next());
            }
        }
        return iRubyObject.getRuntime().newFixnum(n);
    }

    @JRubyMethod(name={"garbage_collect"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject garbage_collect(IRubyObject iRubyObject) {
        return RubyGC.start(iRubyObject);
    }
}

