/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb;

import java.util.Iterator;
import org.joni.NameEntry;
import org.joni.Regex;
import org.joni.Region;
import org.joni.exception.JOniException;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyArray;
import org.jruby.nb.nb.RubyClass;
import org.jruby.nb.nb.RubyFixnum;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.RubyNumeric;
import org.jruby.nb.nb.RubyObject;
import org.jruby.nb.nb.RubyRegexp;
import org.jruby.nb.nb.RubyString;
import org.jruby.nb.nb.RubySymbol;
import org.jruby.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.runtime.Arity;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"MatchData"})
public class RubyMatchData
extends RubyObject {
    Region regs;
    int begin;
    int end;
    RubyString str;
    Regex pattern;
    public static final int MATCH_BUSY = 64;

    public static RubyClass createMatchDataClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("MatchData", ruby.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        ruby.setMatchData(rubyClass);
        ruby.defineGlobalConstant("MatchingData", rubyClass);
        rubyClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject iRubyObject, RubyModule rubyModule) {
                return iRubyObject instanceof RubyMatchData;
            }
        };
        rubyClass.getMetaClass().undefineMethod("new");
        rubyClass.defineAnnotatedMethods(RubyMatchData.class);
        return rubyClass;
    }

    public RubyMatchData(Ruby ruby) {
        super(ruby, ruby.getMatchData());
    }

    public final void use() {
        this.flags |= 0x40;
    }

    public final boolean used() {
        return (this.flags & 0x40) != 0;
    }

    private RubyArray match_array(Ruby ruby, int n) {
        if (this.regs == null) {
            if (n != 0) {
                return ruby.newEmptyArray();
            }
            if (this.begin == -1) {
                return this.getRuntime().newArray(ruby.getNil());
            }
            RubyString rubyString = this.str.makeShared(ruby, this.begin, this.end - this.begin);
            if (this.isTaint()) {
                rubyString.setTaint(true);
            }
            return this.getRuntime().newArray(rubyString);
        }
        RubyArray rubyArray = this.getRuntime().newArray(this.regs.numRegs - n);
        for (int i = n; i < this.regs.numRegs; ++i) {
            if (this.regs.beg[i] == -1) {
                rubyArray.append(this.getRuntime().getNil());
                continue;
            }
            RubyString rubyString = this.str.makeShared(ruby, this.regs.beg[i], this.regs.end[i] - this.regs.beg[i]);
            if (this.isTaint()) {
                rubyString.setTaint(true);
            }
            rubyArray.append(rubyString);
        }
        return rubyArray;
    }

    public IRubyObject group(long l) {
        return RubyRegexp.nth_match((int)l, this);
    }

    public IRubyObject group(int n) {
        return RubyRegexp.nth_match(n, this);
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        Object object;
        if (this.pattern == null) {
            return this.anyToString();
        }
        RubyString rubyString = this.getRuntime().newString();
        rubyString.cat((byte)35).cat((byte)60);
        rubyString.append(this.getMetaClass().getRealClass().to_s());
        NameEntry[] nameEntryArray = new NameEntry[this.regs == null ? 1 : this.regs.numRegs];
        if (this.pattern.numberOfNames() > 0) {
            Iterator iterator = this.pattern.namedBackrefIterator();
            while (iterator.hasNext()) {
                object = (NameEntry)iterator.next();
                for (int n : object.getBackRefs()) {
                    nameEntryArray[n] = object;
                }
            }
        }
        for (int i = 0; i < nameEntryArray.length; ++i) {
            rubyString.cat((byte)32);
            if (i > 0) {
                object = nameEntryArray[i];
                if (object != null) {
                    rubyString.cat(((NameEntry)object).name, ((NameEntry)object).nameP, ((NameEntry)object).nameEnd - ((NameEntry)object).nameP);
                } else {
                    rubyString.cat((byte)(48 + i));
                }
                rubyString.cat((byte)58);
            }
            if ((object = RubyRegexp.nth_match(i, this)).isNil()) {
                rubyString.cat("nil".getBytes());
                continue;
            }
            rubyString.append(object.inspect());
        }
        return rubyString.cat((byte)62);
    }

    @JRubyMethod(name={"to_a"})
    public RubyArray to_a() {
        return this.match_array(this.getRuntime(), 0);
    }

    @JRubyMethod(name={"values_at"}, required=1, rest=true)
    public IRubyObject values_at(IRubyObject[] iRubyObjectArray) {
        return this.to_a().values_at(iRubyObjectArray);
    }

    @JRubyMethod(name={"select"}, frame=true)
    public IRubyObject select(ThreadContext threadContext, Block block) {
        return block.yield(threadContext, this.to_a());
    }

    @JRubyMethod(name={"captures"})
    public IRubyObject captures(ThreadContext threadContext) {
        return this.match_array(threadContext.getRuntime(), 1);
    }

    private int nameToBackrefNumber(RubyString rubyString) {
        ByteList byteList = rubyString.getByteList();
        try {
            return this.pattern.nameToBackrefNumber(byteList.bytes, byteList.begin, byteList.begin + byteList.realSize, this.regs);
        }
        catch (JOniException jOniException) {
            throw this.getRuntime().newIndexError(jOniException.getMessage());
        }
    }

    final int backrefNumber(IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubySymbol) {
            return this.nameToBackrefNumber((RubyString)((RubySymbol)iRubyObject).id2name());
        }
        if (iRubyObject instanceof RubyString) {
            return this.nameToBackrefNumber((RubyString)iRubyObject);
        }
        return RubyNumeric.num2int(iRubyObject);
    }

    public IRubyObject op_aref(IRubyObject[] iRubyObjectArray) {
        switch (iRubyObjectArray.length) {
            case 1: {
                return this.op_aref(iRubyObjectArray[0]);
            }
            case 2: {
                return this.op_aref(iRubyObjectArray[0], iRubyObjectArray[1]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), iRubyObjectArray.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject op_aref(IRubyObject iRubyObject) {
        IRubyObject iRubyObject2 = this.op_arefCommon(iRubyObject);
        return iRubyObject2 == null ? this.to_a().aref(iRubyObject) : iRubyObject2;
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject op_aref(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        IRubyObject iRubyObject3;
        return !iRubyObject2.isNil() || (iRubyObject3 = this.op_arefCommon(iRubyObject)) == null ? this.to_a().aref(iRubyObject, iRubyObject2) : iRubyObject3;
    }

    private IRubyObject op_arefCommon(IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            int n = RubyNumeric.fix2int(iRubyObject);
            if (n >= 0) {
                return RubyRegexp.nth_match(n, this);
            }
        } else {
            if (iRubyObject instanceof RubySymbol) {
                return RubyRegexp.nth_match(this.nameToBackrefNumber((RubyString)((RubySymbol)iRubyObject).id2name()), this);
            }
            if (iRubyObject instanceof RubyString) {
                return RubyRegexp.nth_match(this.nameToBackrefNumber((RubyString)iRubyObject), this);
            }
        }
        return null;
    }

    @JRubyMethod(name={"size", "length"})
    public IRubyObject size() {
        return this.regs == null ? RubyFixnum.one(this.getRuntime()) : RubyFixnum.newFixnum(this.getRuntime(), this.regs.numRegs);
    }

    @JRubyMethod(name={"begin"}, required=1)
    public IRubyObject begin(IRubyObject iRubyObject) {
        int n = this.backrefNumber(iRubyObject);
        if (this.regs == null) {
            if (n != 0) {
                throw this.getRuntime().newIndexError("index " + n + " out of matches");
            }
            if (this.begin < 0) {
                return this.getRuntime().getNil();
            }
            return RubyFixnum.newFixnum(this.getRuntime(), this.begin);
        }
        if (n < 0 || this.regs.numRegs <= n) {
            throw this.getRuntime().newIndexError("index " + n + " out of matches");
        }
        if (this.regs.beg[n] < 0) {
            return this.getRuntime().getNil();
        }
        return RubyFixnum.newFixnum(this.getRuntime(), this.regs.beg[n]);
    }

    @JRubyMethod(name={"end"}, required=1)
    public IRubyObject end(IRubyObject iRubyObject) {
        int n = this.backrefNumber(iRubyObject);
        if (this.regs == null) {
            if (n != 0) {
                throw this.getRuntime().newIndexError("index " + n + " out of matches");
            }
            if (this.end < 0) {
                return this.getRuntime().getNil();
            }
            return RubyFixnum.newFixnum(this.getRuntime(), this.end);
        }
        if (n < 0 || this.regs.numRegs <= n) {
            throw this.getRuntime().newIndexError("index " + n + " out of matches");
        }
        if (this.regs.end[n] < 0) {
            return this.getRuntime().getNil();
        }
        return RubyFixnum.newFixnum(this.getRuntime(), this.regs.end[n]);
    }

    @JRubyMethod(name={"offset"}, required=1)
    public IRubyObject offset(IRubyObject iRubyObject) {
        int n = this.backrefNumber(iRubyObject);
        Ruby ruby = this.getRuntime();
        if (this.regs == null) {
            if (n != 0) {
                throw this.getRuntime().newIndexError("index " + n + " out of matches");
            }
            if (this.begin < 0) {
                return ruby.newArray(ruby.getNil(), ruby.getNil());
            }
            return ruby.newArray(RubyFixnum.newFixnum(ruby, this.begin), RubyFixnum.newFixnum(ruby, this.end));
        }
        if (n < 0 || this.regs.numRegs <= n) {
            throw ruby.newIndexError("index " + n + " out of matches");
        }
        if (this.regs.beg[n] < 0) {
            return ruby.newArray(ruby.getNil(), ruby.getNil());
        }
        return ruby.newArray(RubyFixnum.newFixnum(ruby, this.regs.beg[n]), RubyFixnum.newFixnum(ruby, this.regs.end[n]));
    }

    @JRubyMethod(name={"pre_match"})
    public IRubyObject pre_match(ThreadContext threadContext) {
        RubyString rubyString;
        if (this.regs == null) {
            if (this.begin == -1) {
                return threadContext.getRuntime().getNil();
            }
            rubyString = this.str.makeShared(threadContext.getRuntime(), 0, this.begin);
        } else {
            if (this.regs.beg[0] == -1) {
                return threadContext.getRuntime().getNil();
            }
            rubyString = this.str.makeShared(threadContext.getRuntime(), 0, this.regs.beg[0]);
        }
        if (this.isTaint()) {
            rubyString.setTaint(true);
        }
        return rubyString;
    }

    @JRubyMethod(name={"post_match"})
    public IRubyObject post_match(ThreadContext threadContext) {
        RubyString rubyString;
        if (this.regs == null) {
            if (this.begin == -1) {
                return threadContext.getRuntime().getNil();
            }
            rubyString = this.str.makeShared(threadContext.getRuntime(), this.end, this.str.getByteList().length() - this.end);
        } else {
            if (this.regs.beg[0] == -1) {
                return threadContext.getRuntime().getNil();
            }
            rubyString = this.str.makeShared(threadContext.getRuntime(), this.regs.end[0], this.str.getByteList().length() - this.regs.end[0]);
        }
        if (this.isTaint()) {
            rubyString.setTaint(true);
        }
        return rubyString;
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        IRubyObject iRubyObject = RubyRegexp.last_match(this);
        if (iRubyObject.isNil()) {
            iRubyObject = RubyString.newEmptyString(this.getRuntime());
        }
        if (this.isTaint()) {
            iRubyObject.setTaint(true);
        }
        return iRubyObject;
    }

    @JRubyMethod(name={"string"})
    public IRubyObject string() {
        return this.str;
    }

    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject iRubyObject) {
        if (this == iRubyObject) {
            return this;
        }
        if (this.getMetaClass() != iRubyObject.getMetaClass()) {
            throw this.getRuntime().newTypeError("wrong argument class");
        }
        RubyMatchData rubyMatchData = (RubyMatchData)iRubyObject;
        this.str = rubyMatchData.str;
        this.regs = rubyMatchData.regs;
        return this;
    }
}

