/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb;

import org.jruby.ext.posix.Group;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.Passwd;
import org.jruby.ext.posix.util.Platform;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.RubyNumeric;
import org.jruby.nb.nb.RubyStruct;
import org.jruby.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.anno.JRubyModule;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;

@JRubyModule(name={"Etc"})
public class RubyEtc {
    public static RubyModule createEtcModule(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("Etc");
        ruby.setEtc(rubyModule);
        rubyModule.defineAnnotatedMethods(RubyEtc.class);
        RubyEtc.definePasswdStruct(ruby);
        RubyEtc.defineGroupStruct(ruby);
        return rubyModule;
    }

    private static void definePasswdStruct(Ruby ruby) {
        IRubyObject[] iRubyObjectArray = new IRubyObject[]{ruby.newString("Passwd"), ruby.newSymbol("name"), ruby.newSymbol("passwd"), ruby.newSymbol("uid"), ruby.newSymbol("gid"), ruby.newSymbol("gecos"), ruby.newSymbol("dir"), ruby.newSymbol("shell"), ruby.newSymbol("change"), ruby.newSymbol("uclass"), ruby.newSymbol("expire")};
        ruby.setPasswdStruct(RubyStruct.newInstance(ruby.getStructClass(), iRubyObjectArray, Block.NULL_BLOCK));
    }

    private static void defineGroupStruct(Ruby ruby) {
        IRubyObject[] iRubyObjectArray = new IRubyObject[]{ruby.newString("Group"), ruby.newSymbol("name"), ruby.newSymbol("passwd"), ruby.newSymbol("gid"), ruby.newSymbol("mem")};
        ruby.setGroupStruct(RubyStruct.newInstance(ruby.getStructClass(), iRubyObjectArray, Block.NULL_BLOCK));
    }

    private static IRubyObject setupPasswd(Ruby ruby, Passwd passwd) {
        IRubyObject[] iRubyObjectArray = new IRubyObject[]{ruby.newString(passwd.getLoginName()), ruby.newString(passwd.getPassword()), ruby.newFixnum(passwd.getUID()), ruby.newFixnum(passwd.getGID()), ruby.newString(passwd.getGECOS()), ruby.newString(passwd.getHome()), ruby.newString(passwd.getShell()), ruby.newFixnum(passwd.getPasswdChangeTime()), ruby.newString(passwd.getAccessClass()), ruby.newFixnum(passwd.getExpire())};
        return RubyStruct.newStruct(ruby.getPasswdStruct(), iRubyObjectArray, Block.NULL_BLOCK);
    }

    private static IRubyObject setupGroup(Ruby ruby, Group group) {
        IRubyObject[] iRubyObjectArray = new IRubyObject[]{ruby.newString(group.getName()), ruby.newString(group.getPassword()), ruby.newFixnum(group.getGID()), RubyEtc.intoStringArray(ruby, group.getMembers())};
        return RubyStruct.newStruct(ruby.getGroupStruct(), iRubyObjectArray, Block.NULL_BLOCK);
    }

    private static IRubyObject intoStringArray(Ruby ruby, String[] stringArray) {
        IRubyObject[] iRubyObjectArray = new IRubyObject[stringArray.length];
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            iRubyObjectArray[i] = ruby.newString(stringArray[i]);
        }
        return ruby.newArrayNoCopy(iRubyObjectArray);
    }

    @JRubyMethod(name={"getpwuid"}, optional=1, module=true)
    public static IRubyObject getpwuid(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        int n;
        Ruby ruby = iRubyObject.getRuntime();
        POSIX pOSIX = ruby.getPosix();
        Passwd passwd = pOSIX.getpwuid(n = iRubyObjectArray.length == 0 ? pOSIX.getuid() : RubyNumeric.fix2int(iRubyObjectArray[0]));
        if (passwd == null) {
            if (Platform.IS_WINDOWS) {
                return iRubyObject.getRuntime().getNil();
            }
            throw ruby.newArgumentError("can't find user for " + n);
        }
        return RubyEtc.setupPasswd(ruby, passwd);
    }

    @JRubyMethod(name={"getpwnam"}, required=1, module=true)
    public static IRubyObject getpwnam(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        String string = iRubyObject2.convertToString().toString();
        Passwd passwd = iRubyObject.getRuntime().getPosix().getpwnam(string);
        if (passwd == null) {
            if (Platform.IS_WINDOWS) {
                return iRubyObject.getRuntime().getNil();
            }
            throw iRubyObject.getRuntime().newArgumentError("can't find user for " + string);
        }
        return RubyEtc.setupPasswd(iRubyObject.getRuntime(), passwd);
    }

    @JRubyMethod(name={"passwd"}, module=true, frame=true)
    public static IRubyObject passwd(IRubyObject iRubyObject, Block block) {
        ThreadContext threadContext;
        Ruby ruby = iRubyObject.getRuntime();
        POSIX pOSIX = ruby.getPosix();
        if (block.isGiven()) {
            Passwd passwd;
            threadContext = ruby.getCurrentContext();
            pOSIX.setpwent();
            while ((passwd = pOSIX.getpwent()) != null) {
                block.yield(threadContext, RubyEtc.setupPasswd(ruby, passwd));
            }
            pOSIX.endpwent();
        }
        if ((threadContext = pOSIX.getpwent()) != null) {
            return RubyEtc.setupPasswd(ruby, (Passwd)threadContext);
        }
        return ruby.getNil();
    }

    @JRubyMethod(name={"getlogin"}, module=true)
    public static IRubyObject getlogin(IRubyObject iRubyObject) {
        Ruby ruby = iRubyObject.getRuntime();
        String string = ruby.getPosix().getlogin();
        if (string != null) {
            return ruby.newString(string);
        }
        return ruby.getNil();
    }

    @JRubyMethod(name={"endpwent"}, module=true)
    public static IRubyObject endpwent(IRubyObject iRubyObject) {
        Ruby ruby = iRubyObject.getRuntime();
        ruby.getPosix().endpwent();
        return ruby.getNil();
    }

    @JRubyMethod(name={"setpwent"}, module=true)
    public static IRubyObject setpwent(IRubyObject iRubyObject) {
        Ruby ruby = iRubyObject.getRuntime();
        ruby.getPosix().setpwent();
        return ruby.getNil();
    }

    @JRubyMethod(name={"getpwent"}, module=true)
    public static IRubyObject getpwent(IRubyObject iRubyObject) {
        Ruby ruby = iRubyObject.getRuntime();
        Passwd passwd = ruby.getPosix().getpwent();
        if (passwd != null) {
            return RubyEtc.setupPasswd(iRubyObject.getRuntime(), passwd);
        }
        return ruby.getNil();
    }

    @JRubyMethod(name={"getgrnam"}, required=1, module=true)
    public static IRubyObject getgrnam(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        String string = iRubyObject2.convertToString().toString();
        Group group = iRubyObject.getRuntime().getPosix().getgrnam(string);
        if (group == null) {
            if (Platform.IS_WINDOWS) {
                return iRubyObject.getRuntime().getNil();
            }
            throw iRubyObject.getRuntime().newArgumentError("can't find group for " + string);
        }
        return RubyEtc.setupGroup(iRubyObject.getRuntime(), group);
    }

    @JRubyMethod(name={"getgrgid"}, optional=1, module=true)
    public static IRubyObject getgrgid(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        int n;
        Ruby ruby = iRubyObject.getRuntime();
        POSIX pOSIX = ruby.getPosix();
        Group group = pOSIX.getgrgid(n = iRubyObjectArray.length == 0 ? pOSIX.getgid() : RubyNumeric.fix2int(iRubyObjectArray[0]));
        if (group == null) {
            if (Platform.IS_WINDOWS) {
                return ruby.getNil();
            }
            throw ruby.newArgumentError("can't find group for " + n);
        }
        return RubyEtc.setupGroup(ruby, group);
    }

    @JRubyMethod(name={"endgrent"}, module=true)
    public static IRubyObject endgrent(IRubyObject iRubyObject) {
        Ruby ruby = iRubyObject.getRuntime();
        ruby.getPosix().endgrent();
        return ruby.getNil();
    }

    @JRubyMethod(name={"setgrent"}, module=true)
    public static IRubyObject setgrent(IRubyObject iRubyObject) {
        Ruby ruby = iRubyObject.getRuntime();
        ruby.getPosix().setgrent();
        return ruby.getNil();
    }

    @JRubyMethod(name={"group"}, module=true, frame=true)
    public static IRubyObject group(IRubyObject iRubyObject, Block block) {
        ThreadContext threadContext;
        Ruby ruby = iRubyObject.getRuntime();
        POSIX pOSIX = ruby.getPosix();
        if (block.isGiven()) {
            Group group;
            threadContext = ruby.getCurrentContext();
            pOSIX.setgrent();
            while ((group = pOSIX.getgrent()) != null) {
                block.yield(threadContext, RubyEtc.setupGroup(ruby, group));
            }
            pOSIX.endgrent();
        }
        if ((threadContext = pOSIX.getgrent()) != null) {
            return RubyEtc.setupGroup(ruby, (Group)threadContext);
        }
        return ruby.getNil();
    }

    @JRubyMethod(name={"getgrent"}, module=true)
    public static IRubyObject getgrent(IRubyObject iRubyObject) {
        Ruby ruby = iRubyObject.getRuntime();
        Group group = ruby.getPosix().getgrent();
        if (group != null) {
            return RubyEtc.setupGroup(iRubyObject.getRuntime(), group);
        }
        return ruby.getNil();
    }
}

