/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb;

import java.io.IOException;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyClass;
import org.jruby.nb.nb.RubyFixnum;
import org.jruby.nb.nb.RubyObject;
import org.jruby.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.runtime.marshal.MarshalStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"TrueClass", "FalseClass"})
public class RubyBoolean
extends RubyObject {
    public RubyBoolean(Ruby ruby, boolean bl) {
        super(ruby, bl ? ruby.getTrueClass() : ruby.getFalseClass(), false);
        if (!bl) {
            this.flags = 1;
        }
    }

    @Override
    public int getNativeTypeIndex() {
        return (this.flags & 1) == 0 ? 6 : 7;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public RubyClass getSingletonClass() {
        return this.metaClass;
    }

    @Override
    public Class<?> getJavaClass() {
        return Boolean.TYPE;
    }

    public static RubyClass createFalseClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("FalseClass", ruby.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        ruby.setFalseClass(rubyClass);
        rubyClass.index = 7;
        rubyClass.defineAnnotatedMethods(False.class);
        rubyClass.getMetaClass().undefineMethod("new");
        return rubyClass;
    }

    public static RubyClass createTrueClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("TrueClass", ruby.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        ruby.setTrueClass(rubyClass);
        rubyClass.index = 6;
        rubyClass.defineAnnotatedMethods(True.class);
        rubyClass.getMetaClass().undefineMethod("new");
        return rubyClass;
    }

    public static RubyBoolean newBoolean(Ruby ruby, boolean bl) {
        return bl ? ruby.getTrue() : ruby.getFalse();
    }

    @Override
    public RubyFixnum id() {
        if ((this.flags & 1) == 0) {
            return RubyFixnum.newFixnum(this.getRuntime(), 2L);
        }
        return RubyFixnum.zero(this.getRuntime());
    }

    @Override
    public IRubyObject taint(ThreadContext threadContext) {
        return this;
    }

    @Override
    public IRubyObject freeze(ThreadContext threadContext) {
        return this;
    }

    public void marshalTo(MarshalStream marshalStream) throws IOException {
        marshalStream.write(this.isTrue() ? 84 : 70);
    }

    public static class True {
        @JRubyMethod(name={"&"})
        public static IRubyObject true_and(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return iRubyObject2.isTrue() ? iRubyObject : iRubyObject.getRuntime().getFalse();
        }

        @JRubyMethod(name={"|"})
        public static IRubyObject true_or(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return iRubyObject;
        }

        @JRubyMethod(name={"^"})
        public static IRubyObject true_xor(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return iRubyObject2.isTrue() ? iRubyObject.getRuntime().getFalse() : iRubyObject;
        }

        @JRubyMethod(name={"to_s"})
        public static IRubyObject true_to_s(IRubyObject iRubyObject) {
            return iRubyObject.getRuntime().newString("true");
        }
    }

    public static class False {
        @JRubyMethod(name={"&"})
        public static IRubyObject false_and(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return iRubyObject;
        }

        @JRubyMethod(name={"|"})
        public static IRubyObject false_or(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return iRubyObject2.isTrue() ? iRubyObject.getRuntime().getTrue() : iRubyObject;
        }

        @JRubyMethod(name={"^"})
        public static IRubyObject false_xor(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return iRubyObject2.isTrue() ? iRubyObject.getRuntime().getTrue() : iRubyObject;
        }

        @JRubyMethod(name={"to_s"})
        public static IRubyObject false_to_s(IRubyObject iRubyObject) {
            return iRubyObject.getRuntime().newString("false");
        }
    }
}

