/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.DynamicScope;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootNode
extends Node {
    private transient DynamicScope scope;
    private StaticScope staticScope;
    private Node bodyNode;

    public RootNode(ISourcePosition iSourcePosition, DynamicScope dynamicScope, Node node) {
        super(iSourcePosition, NodeType.ROOTNODE);
        assert (node != null) : "bodyNode is not null";
        this.scope = dynamicScope;
        this.staticScope = dynamicScope.getStaticScope();
        this.bodyNode = node;
    }

    public DynamicScope getScope() {
        return this.scope;
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitRootNode(this);
    }

    @Override
    public List<Node> childNodes() {
        return RootNode.createList(this.bodyNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        if (this.scope == null) {
            this.scope = DynamicScope.newDynamicScope(this.staticScope);
        }
        StaticScope staticScope = this.scope.getStaticScope();
        threadContext.preScopedBody(this.scope);
        if (staticScope.getModule() == null) {
            staticScope.setModule(ruby.getObject());
        }
        try {
            IRubyObject iRubyObject2 = this.bodyNode.interpret(ruby, threadContext, iRubyObject, block);
            return iRubyObject2;
        }
        finally {
            threadContext.postScopedBody();
        }
    }
}

