/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb;

import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyObject;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.common.IRubyWarnings;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.BlockCallback;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;

@JRubyClass(name={"Symbol"})
public class RubySymbol
extends RubyObject {
    private final String symbol;
    private final int id;
    private final ByteList symbolBytes;

    private RubySymbol(Ruby ruby, String string) {
        super(ruby, ruby.getSymbol(), false);
        assert (string == string.intern()) : string + " is not interned";
        this.symbol = string;
        this.symbolBytes = ByteList.create((CharSequence)this.symbol);
        this.id = ruby.allocSymbolId();
    }

    public static RubyClass createSymbolClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("Symbol", ruby.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        ruby.setSymbol(rubyClass);
        RubyClass rubyClass2 = rubyClass.getMetaClass();
        rubyClass.index = 8;
        rubyClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject iRubyObject, RubyModule rubyModule) {
                return iRubyObject instanceof RubySymbol;
            }
        };
        rubyClass.defineAnnotatedMethods(RubySymbol.class);
        rubyClass2.undefineMethod("new");
        return rubyClass;
    }

    public int getNativeTypeIndex() {
        return 8;
    }

    public String asJavaString() {
        return this.symbol;
    }

    public final boolean eql(IRubyObject iRubyObject) {
        return iRubyObject == this;
    }

    public boolean isImmediate() {
        return true;
    }

    public RubyClass getSingletonClass() {
        throw this.getRuntime().newTypeError("can't define singleton");
    }

    public static RubySymbol getSymbolLong(Ruby ruby, long l) {
        return ruby.getSymbolTable().lookup(l);
    }

    public static RubySymbol newSymbol(Ruby ruby, String string) {
        return ruby.getSymbolTable().getSymbol(string);
    }

    @JRubyMethod(name={"to_i"})
    public RubyFixnum to_i() {
        return this.getRuntime().newFixnum(this.id);
    }

    @JRubyMethod(name={"to_int"})
    public RubyFixnum to_int() {
        if (this.getRuntime().getVerbose().isTrue()) {
            this.getRuntime().getWarnings().warn(IRubyWarnings.ID.SYMBOL_AS_INTEGER, "treating Symbol as an integer", new Object[0]);
        }
        return this.to_i();
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        Ruby ruby = this.getRuntime();
        return ruby.newString(":" + (RubySymbol.isSymbolName(this.symbol) ? this.symbol : RubyString.newStringShared(ruby, this.symbolBytes).dump().toString()));
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        return RubyString.newStringShared(this.getRuntime(), this.symbolBytes);
    }

    @JRubyMethod(name={"id2name"})
    public IRubyObject id2name() {
        return this.to_s();
    }

    @JRubyMethod(name={"==="}, required=1)
    public IRubyObject op_eqq(ThreadContext threadContext, IRubyObject iRubyObject) {
        return super.op_equal(threadContext, iRubyObject);
    }

    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    public int hashCode() {
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public boolean equals(Object object) {
        return object == this;
    }

    @JRubyMethod(name={"to_sym"})
    public IRubyObject to_sym() {
        return this;
    }

    public IRubyObject freeze(ThreadContext threadContext) {
        return this;
    }

    public IRubyObject taint(ThreadContext threadContext) {
        return this;
    }

    private static boolean isIdentStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
    }

    private static boolean isIdentChar(char c) {
        return c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c == '_';
    }

    private static boolean isIdentifier(String string) {
        if (string == null || string.length() <= 0) {
            return false;
        }
        if (!RubySymbol.isIdentStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (RubySymbol.isIdentChar(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isSpecialGlobalName(String string) {
        if (string == null || string.length() <= 0) {
            return false;
        }
        int n = string.length();
        switch (string.charAt(0)) {
            case '!': 
            case '\"': 
            case '$': 
            case '&': 
            case '\'': 
            case '*': 
            case '+': 
            case ',': 
            case '.': 
            case '/': 
            case '0': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '\\': 
            case '`': 
            case '~': {
                return n == 1;
            }
            case '-': {
                return n == 1 || n == 2 && RubySymbol.isIdentChar(string.charAt(1));
            }
        }
        for (int i = 0; i < n; ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isSymbolName(String string) {
        char c;
        int n;
        if (string == null || string.length() < 1) {
            return false;
        }
        int n2 = string.length();
        char c2 = string.charAt(0);
        switch (c2) {
            case '$': {
                if (n2 > 1 && RubySymbol.isSpecialGlobalName(string.substring(1))) {
                    return true;
                }
                return RubySymbol.isIdentifier(string.substring(1));
            }
            case '@': {
                int n3 = 1;
                if (n2 >= 2 && string.charAt(1) == '@') {
                    ++n3;
                }
                return RubySymbol.isIdentifier(string.substring(n3));
            }
            case '<': {
                return n2 == 1 || n2 == 2 && (string.equals("<<") || string.equals("<=")) || n2 == 3 && string.equals("<=>");
            }
            case '>': {
                return n2 == 1 || n2 == 2 && (string.equals(">>") || string.equals(">="));
            }
            case '=': {
                return n2 == 2 && (string.equals("==") || string.equals("=~")) || n2 == 3 && string.equals("===");
            }
            case '*': {
                return n2 == 1 || n2 == 2 && string.equals("**");
            }
            case '+': {
                return n2 == 1 || n2 == 2 && string.equals("+@");
            }
            case '-': {
                return n2 == 1 || n2 == 2 && string.equals("-@");
            }
            case '%': 
            case '&': 
            case '/': 
            case '^': 
            case '`': 
            case '|': 
            case '~': {
                return n2 == 1;
            }
            case '[': {
                return string.equals("[]") || string.equals("[]=");
            }
        }
        if (!RubySymbol.isIdentStart(c2)) {
            return false;
        }
        boolean bl = c2 >= 'a' && c2 <= 'z';
        for (n = 1; n < n2 && RubySymbol.isIdentChar(c = string.charAt(n)); ++n) {
        }
        if (n == n2) {
            return true;
        }
        if (bl && n == n2 - 1) {
            c = string.charAt(n);
            return c == '!' || c == '?' || c == '=';
        }
        return false;
    }

    @JRubyMethod(name={"all_symbols"}, meta=true)
    public static IRubyObject all_symbols(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().getSymbolTable().all_symbols();
    }

    public static RubySymbol unmarshalFrom(UnmarshalStream unmarshalStream) throws IOException {
        RubySymbol rubySymbol = RubySymbol.newSymbol(unmarshalStream.getRuntime(), RubyString.byteListToString(unmarshalStream.unmarshalString()));
        unmarshalStream.registerLinkTarget(rubySymbol);
        return rubySymbol;
    }

    public static class SymbolTable {
        static final int DEFAULT_INITIAL_CAPACITY = 2048;
        static final int MAXIMUM_CAPACITY = 0x40000000;
        static final float DEFAULT_LOAD_FACTOR = 0.75f;
        private final ReentrantLock tableLock = new ReentrantLock();
        private volatile SymbolEntry[] symbolTable;
        private int size;
        private int threshold;
        private final float loadFactor;
        private final Ruby runtime;

        public SymbolTable(Ruby ruby) {
            this.runtime = ruby;
            this.loadFactor = 0.75f;
            this.threshold = 1536;
            this.symbolTable = new SymbolEntry[2048];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RubySymbol getSymbol(String string) {
            int n = string.hashCode();
            SymbolEntry[] symbolEntryArray = this.symbolTable;
            Object object = this.symbolTable[n & symbolEntryArray.length - 1];
            while (object != null) {
                if (n == ((SymbolEntry)object).hash && string.equals(((SymbolEntry)object).name)) {
                    return ((SymbolEntry)object).symbol;
                }
                object = ((SymbolEntry)object).next;
            }
            object = this.tableLock;
            ((ReentrantLock)object).lock();
            try {
                int n2 = this.size + 1;
                symbolEntryArray = n2 > this.threshold ? this.rehash() : this.symbolTable;
                int n3 = n & symbolEntryArray.length - 1;
                Object object2 = symbolEntryArray[n3];
                while (object2 != null) {
                    if (n == ((SymbolEntry)object2).hash && string.equals(((SymbolEntry)object2).name)) {
                        RubySymbol rubySymbol = ((SymbolEntry)object2).symbol;
                        return rubySymbol;
                    }
                    object2 = ((SymbolEntry)object2).next;
                }
                object2 = string.intern();
                RubySymbol rubySymbol = new RubySymbol(this.runtime, (String)object2);
                symbolEntryArray[n3] = new SymbolEntry(n, (String)object2, rubySymbol, symbolEntryArray[n3]);
                this.size = n2;
                this.symbolTable = symbolEntryArray;
                RubySymbol rubySymbol2 = rubySymbol;
                return rubySymbol2;
            }
            finally {
                ((ReentrantLock)object).unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RubySymbol fastGetSymbol(String string) {
            assert (string == string.intern()) : string + " is not interned";
            SymbolEntry[] symbolEntryArray = this.symbolTable;
            Object object = this.symbolTable[string.hashCode() & symbolEntryArray.length - 1];
            while (object != null) {
                if (string == ((SymbolEntry)object).name) {
                    return ((SymbolEntry)object).symbol;
                }
                object = ((SymbolEntry)object).next;
            }
            object = this.tableLock;
            ((ReentrantLock)object).lock();
            try {
                int n = this.size + 1;
                symbolEntryArray = n > this.threshold ? this.rehash() : this.symbolTable;
                int n2 = string.hashCode();
                int n3 = n2 & symbolEntryArray.length - 1;
                Object object2 = symbolEntryArray[n3];
                while (object2 != null) {
                    if (string == ((SymbolEntry)object2).name) {
                        RubySymbol rubySymbol = ((SymbolEntry)object2).symbol;
                        return rubySymbol;
                    }
                    object2 = ((SymbolEntry)object2).next;
                }
                object2 = new RubySymbol(this.runtime, string);
                symbolEntryArray[n3] = new SymbolEntry(n2, string, (RubySymbol)object2, symbolEntryArray[n3]);
                this.size = n;
                this.symbolTable = symbolEntryArray;
                Object object3 = object2;
                return object3;
            }
            finally {
                ((ReentrantLock)object).unlock();
            }
        }

        public RubySymbol lookup(String string) {
            int n = string.hashCode();
            SymbolEntry[] symbolEntryArray = this.symbolTable;
            SymbolEntry symbolEntry = this.symbolTable[n & symbolEntryArray.length - 1];
            while (symbolEntry != null) {
                if (n == symbolEntry.hash && string.equals(symbolEntry.name)) {
                    return symbolEntry.symbol;
                }
                symbolEntry = symbolEntry.next;
            }
            return null;
        }

        public RubySymbol lookup(long l) {
            SymbolEntry[] symbolEntryArray = this.symbolTable;
            int n = symbolEntryArray.length;
            while (--n >= 0) {
                SymbolEntry symbolEntry = symbolEntryArray[n];
                while (symbolEntry != null) {
                    if (l == (long)symbolEntry.symbol.id) {
                        return symbolEntry.symbol;
                    }
                    symbolEntry = symbolEntry.next;
                }
            }
            return null;
        }

        public RubyArray all_symbols() {
            SymbolEntry[] symbolEntryArray = this.symbolTable;
            RubyArray rubyArray = this.runtime.newArray(this.size);
            int n = symbolEntryArray.length;
            while (--n >= 0) {
                SymbolEntry symbolEntry = symbolEntryArray[n];
                while (symbolEntry != null) {
                    rubyArray.append(symbolEntry.symbol);
                    symbolEntry = symbolEntry.next;
                }
            }
            return rubyArray;
        }

        @Deprecated
        public void store(RubySymbol rubySymbol) {
            throw new UnsupportedOperationException();
        }

        private SymbolEntry[] rehash() {
            SymbolEntry[] symbolEntryArray = this.symbolTable;
            int n = symbolEntryArray.length;
            if (n >= 0x40000000) {
                return symbolEntryArray;
            }
            int n2 = n << 1;
            SymbolEntry[] symbolEntryArray2 = new SymbolEntry[n2];
            this.threshold = (int)((float)n2 * this.loadFactor);
            int n3 = n2 - 1;
            int n4 = n;
            while (--n4 >= 0) {
                int n5;
                SymbolEntry symbolEntry = symbolEntryArray[n4];
                if (symbolEntry == null) continue;
                SymbolEntry symbolEntry2 = symbolEntry.next;
                int n6 = symbolEntry.hash & n3;
                if (symbolEntry2 == null) {
                    symbolEntryArray2[n6] = symbolEntry;
                    continue;
                }
                SymbolEntry symbolEntry3 = symbolEntry;
                int n7 = n6;
                SymbolEntry symbolEntry4 = symbolEntry2;
                while (symbolEntry4 != null) {
                    n5 = symbolEntry4.hash & n3;
                    if (n5 != n7) {
                        n7 = n5;
                        symbolEntry3 = symbolEntry4;
                    }
                    symbolEntry4 = symbolEntry4.next;
                }
                symbolEntryArray2[n7] = symbolEntry3;
                symbolEntry4 = symbolEntry;
                while (symbolEntry4 != symbolEntry3) {
                    n5 = symbolEntry4.hash & n3;
                    SymbolEntry symbolEntry5 = symbolEntryArray2[n5];
                    symbolEntryArray2[n5] = new SymbolEntry(symbolEntry4.hash, symbolEntry4.name, symbolEntry4.symbol, symbolEntry5);
                    symbolEntry4 = symbolEntry4.next;
                }
            }
            this.symbolTable = symbolEntryArray2;
            return symbolEntryArray2;
        }

        static class SymbolEntry {
            final int hash;
            final String name;
            final RubySymbol symbol;
            final SymbolEntry next;

            SymbolEntry(int n, String string, RubySymbol rubySymbol, SymbolEntry symbolEntry) {
                this.hash = n;
                this.name = string;
                this.symbol = rubySymbol;
                this.next = symbolEntry;
            }
        }
    }

    private static class ToProcCallback
    implements BlockCallback {
        private RubySymbol symbol;

        public ToProcCallback(RubySymbol rubySymbol) {
            this.symbol = rubySymbol;
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
            IRubyObject[] iRubyObjectArray2 = iRubyObjectArray;
            switch (iRubyObjectArray2.length) {
                case 0: {
                    throw this.symbol.getRuntime().newArgumentError("no receiver given");
                }
                case 1: {
                    if (iRubyObjectArray2[0] instanceof RubyArray && ((RubyArray)iRubyObjectArray2[0]).getLength() != 0) {
                        iRubyObjectArray2 = ((RubyArray)iRubyObjectArray2[0]).toJavaArrayMaybeUnsafe();
                        IRubyObject[] iRubyObjectArray3 = new IRubyObject[iRubyObjectArray2.length - 1];
                        System.arraycopy(iRubyObjectArray2, 1, iRubyObjectArray3, 0, iRubyObjectArray3.length);
                        return RuntimeHelpers.invoke(threadContext, iRubyObjectArray2[0], this.symbol.symbol, iRubyObjectArray3);
                    }
                    return RuntimeHelpers.invoke(threadContext, iRubyObjectArray2[0], this.symbol.symbol);
                }
            }
            IRubyObject[] iRubyObjectArray4 = new IRubyObject[iRubyObjectArray2.length - 1];
            System.arraycopy(iRubyObjectArray2, 1, iRubyObjectArray4, 0, iRubyObjectArray4.length);
            return RuntimeHelpers.invoke(threadContext, iRubyObjectArray2[0], this.symbol.symbol, iRubyObjectArray4);
        }
    }
}

