/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Map;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.anno.JRubyModule;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.util.KCode;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyModule(name={"NKF"})
public class RubyNKF {
    public static final NKFCharset AUTO = new NKFCharset(0, "x-JISAutoDetect");
    public static final NKFCharset JIS = new NKFCharset(1, "iso-2022-jp");
    public static final NKFCharset EUC = new NKFCharset(2, "EUC-JP");
    public static final NKFCharset SJIS = new NKFCharset(3, "Windows-31J");
    public static final NKFCharset BINARY = new NKFCharset(4, null);
    public static final NKFCharset NOCONV = new NKFCharset(4, null);
    public static final NKFCharset UNKNOWN = new NKFCharset(0, null);
    public static final NKFCharset ASCII = new NKFCharset(5, "iso-8859-1");
    public static final NKFCharset UTF8 = new NKFCharset(6, "UTF-8");
    public static final NKFCharset UTF16 = new NKFCharset(8, "UTF-16");
    public static final NKFCharset UTF32 = new NKFCharset(12, "UTF-32");
    public static final NKFCharset OTHER = new NKFCharset(16, null);

    public static void createNKF(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("NKF");
        rubyModule.defineConstant("AUTO", RubyFixnum.newFixnum(ruby, AUTO.getValue()));
        rubyModule.defineConstant("JIS", RubyFixnum.newFixnum(ruby, JIS.getValue()));
        rubyModule.defineConstant("EUC", RubyFixnum.newFixnum(ruby, EUC.getValue()));
        rubyModule.defineConstant("SJIS", RubyFixnum.newFixnum(ruby, SJIS.getValue()));
        rubyModule.defineConstant("BINARY", RubyFixnum.newFixnum(ruby, BINARY.getValue()));
        rubyModule.defineConstant("NOCONV", RubyFixnum.newFixnum(ruby, NOCONV.getValue()));
        rubyModule.defineConstant("UNKNOWN", RubyFixnum.newFixnum(ruby, UNKNOWN.getValue()));
        rubyModule.defineConstant("ASCII", RubyFixnum.newFixnum(ruby, ASCII.getValue()));
        rubyModule.defineConstant("UTF8", RubyFixnum.newFixnum(ruby, UTF8.getValue()));
        rubyModule.defineConstant("UTF16", RubyFixnum.newFixnum(ruby, UTF16.getValue()));
        rubyModule.defineConstant("UTF32", RubyFixnum.newFixnum(ruby, UTF32.getValue()));
        rubyModule.defineConstant("OTHER", RubyFixnum.newFixnum(ruby, OTHER.getValue()));
        RubyString rubyString = ruby.newString("2.0.7 (JRuby 2007-05-11)");
        RubyString rubyString2 = ruby.newString("2.0.7");
        RubyString rubyString3 = ruby.newString("2007-05-11");
        ThreadContext threadContext = ruby.getCurrentContext();
        rubyString.freeze(threadContext);
        rubyString2.freeze(threadContext);
        rubyString3.freeze(threadContext);
        rubyModule.defineAnnotatedMethods(RubyNKF.class);
    }

    @JRubyMethod(name={"guess"}, required=1, module=true)
    public static IRubyObject guess(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = threadContext.getRuntime();
        if (!iRubyObject2.respondsTo("to_str")) {
            throw ruby.newTypeError("can't convert " + iRubyObject2.getMetaClass() + " into String");
        }
        ByteList byteList = iRubyObject2.convertToString().getByteList();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byteList.unsafeBytes(), byteList.begin(), byteList.length());
        CharsetDecoder charsetDecoder = Charset.forName("x-JISAutoDetect").newDecoder();
        try {
            charsetDecoder.decode(byteBuffer);
        }
        catch (CharacterCodingException characterCodingException) {
            return ruby.newFixnum(UNKNOWN.getValue());
        }
        if (!charsetDecoder.isCharsetDetected()) {
            return ruby.newFixnum(UNKNOWN.getValue());
        }
        Charset charset = charsetDecoder.detectedCharset();
        String string = charset.name();
        if ("Shift_JIS".equals(string)) {
            return ruby.newFixnum(SJIS.getValue());
        }
        if ("windows-31j".equals(string)) {
            return ruby.newFixnum(SJIS.getValue());
        }
        if ("EUC-JP".equals(string)) {
            return ruby.newFixnum(EUC.getValue());
        }
        if ("ISO-2022-JP".equals(string)) {
            return ruby.newFixnum(JIS.getValue());
        }
        return ruby.newFixnum(UNKNOWN.getValue());
    }

    @JRubyMethod(name={"guess1"}, required=1, module=true)
    public static IRubyObject guess1(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return RubyNKF.guess(threadContext, iRubyObject, iRubyObject2);
    }

    @JRubyMethod(name={"guess2"}, required=1, module=true)
    public static IRubyObject guess2(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return RubyNKF.guess(threadContext, iRubyObject, iRubyObject2);
    }

    @JRubyMethod(name={"nkf"}, required=2, module=true)
    public static IRubyObject nkf(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        Object object;
        Ruby ruby = threadContext.getRuntime();
        if (!iRubyObject2.respondsTo("to_str")) {
            throw ruby.newTypeError("can't convert " + iRubyObject2.getMetaClass() + " into String");
        }
        if (!iRubyObject3.respondsTo("to_str")) {
            throw ruby.newTypeError("can't convert " + iRubyObject3.getMetaClass() + " into String");
        }
        Map<String, NKFCharset> map = RubyNKF.parseOpt(iRubyObject2.convertToString().toString());
        NKFCharset nKFCharset = map.get("input");
        if (nKFCharset.getValue() == AUTO.getValue()) {
            object = ruby.getKCode();
            if (object == KCode.SJIS) {
                nKFCharset = SJIS;
            } else if (object == KCode.EUC) {
                nKFCharset = EUC;
            } else if (object == KCode.UTF8) {
                nKFCharset = UTF8;
            }
        }
        object = nKFCharset.getCharset();
        String string = map.get("output").getCharset();
        return RubyNKF.convert(threadContext, (String)object, string, iRubyObject3);
    }

    private static IRubyObject convert(ThreadContext threadContext, String string, String string2, IRubyObject iRubyObject) {
        Object object;
        CharsetEncoder charsetEncoder;
        CharsetDecoder charsetDecoder;
        Ruby ruby = threadContext.getRuntime();
        try {
            charsetDecoder = Charset.forName(string).newDecoder();
            charsetEncoder = Charset.forName(string2).newEncoder();
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw ruby.newArgumentError("invalid encoding");
        }
        ByteList byteList = iRubyObject.convertToString().getByteList();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byteList.unsafeBytes(), byteList.begin(), byteList.length());
        try {
            object = charsetDecoder.decode(byteBuffer);
            byteBuffer = charsetEncoder.encode((CharBuffer)object);
        }
        catch (CharacterCodingException characterCodingException) {
            throw ruby.newArgumentError("invalid encoding");
        }
        object = byteBuffer.array();
        return ruby.newString(new ByteList((byte[])object, 0, byteBuffer.limit()));
    }

    private static int optionUTF(String string, int n) {
        int n2 = 8;
        if (n + 1 < string.length() && Character.isDigit(string.charAt(n + 1))) {
            n2 = Character.digit(string.charAt(n + 1), 10);
            if (n + 2 < string.length() && Character.isDigit(string.charAt(n + 2))) {
                n2 *= 10;
                n2 += Character.digit(string.charAt(n + 2), 10);
            }
        }
        return n2;
    }

    private static Map<String, NKFCharset> parseOpt(String string) {
        HashMap<String, NKFCharset> hashMap = new HashMap<String, NKFCharset>();
        hashMap.put("input", AUTO);
        hashMap.put("output", JIS);
        block30: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case 'b': {
                    continue block30;
                }
                case 'u': {
                    continue block30;
                }
                case 'j': {
                    hashMap.put("output", JIS);
                    continue block30;
                }
                case 's': {
                    hashMap.put("output", SJIS);
                    continue block30;
                }
                case 'e': {
                    hashMap.put("output", EUC);
                    continue block30;
                }
                case 'w': {
                    int n = RubyNKF.optionUTF(string, i);
                    if (n == 32) {
                        hashMap.put("output", UTF32);
                        continue block30;
                    }
                    if (n == 16) {
                        hashMap.put("output", UTF16);
                        continue block30;
                    }
                    hashMap.put("output", UTF8);
                    continue block30;
                }
                case 'J': {
                    hashMap.put("input", JIS);
                    continue block30;
                }
                case 'S': {
                    hashMap.put("input", SJIS);
                    continue block30;
                }
                case 'E': {
                    hashMap.put("input", EUC);
                    continue block30;
                }
                case 'W': {
                    int n = RubyNKF.optionUTF(string, i);
                    if (n == 32) {
                        hashMap.put("input", UTF32);
                        continue block30;
                    }
                    if (n == 16) {
                        hashMap.put("input", UTF16);
                        continue block30;
                    }
                    hashMap.put("input", UTF8);
                    continue block30;
                }
                case 't': {
                    continue block30;
                }
                case 'r': {
                    continue block30;
                }
                case 'h': {
                    continue block30;
                }
                case 'm': {
                    continue block30;
                }
                case 'M': {
                    continue block30;
                }
                case 'l': {
                    continue block30;
                }
                case 'f': {
                    continue block30;
                }
                case 'F': {
                    continue block30;
                }
                case 'Z': {
                    continue block30;
                }
                case 'X': {
                    continue block30;
                }
                case 'x': {
                    continue block30;
                }
                case 'B': {
                    continue block30;
                }
                case 'T': {
                    continue block30;
                }
                case 'd': {
                    continue block30;
                }
                case 'c': {
                    continue block30;
                }
                case 'I': {
                    continue block30;
                }
                case 'L': {
                    continue block30;
                }
                case '-': {
                    if (string.charAt(i + 1) != '-') continue block30;
                }
            }
        }
        return hashMap;
    }

    public static class NKFCharset {
        private final int value;
        private final String charset;

        public NKFCharset(int n, String string) {
            this.value = n;
            this.charset = string;
        }

        public int getValue() {
            return this.value;
        }

        public String getCharset() {
            return this.charset;
        }
    }
}

