/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.nodes;

import com.sun.esb.management.api.administration.AdministrationService;
import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.esb.management.common.data.ServiceAssemblyStatisticsData;
import com.sun.esb.management.common.data.ServiceUnitStatisticsData;
import com.sun.jbi.ui.common.ServiceUnitInfo;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Map;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.netbeans.modules.sun.manager.jbi.management.AppserverJBIMgmtController;
import org.netbeans.modules.sun.manager.jbi.management.wrapper.api.PerformanceMeasurementServiceWrapper;
import org.netbeans.modules.sun.manager.jbi.management.wrapper.api.RuntimeManagementServiceWrapper;
import org.netbeans.modules.sun.manager.jbi.nodes.AppserverJBIMgmtLeafNode;
import org.netbeans.modules.sun.manager.jbi.nodes.JBIServiceAssemblyNode;
import org.netbeans.modules.sun.manager.jbi.nodes.NodeType;
import org.netbeans.modules.sun.manager.jbi.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Sheet;
import org.openide.util.datatransfer.ExTransferable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBIServiceUnitNode
extends AppserverJBIMgmtLeafNode {
    private static final String SERVICE_UNIT_STATISTICS_SHEET_SET_NAME = "SERVICE_UNIT_STATISTICS";
    private String componentName;
    public static final DataFlavor ServiceUnitDataFlavor = new DataFlavor((Class)Object.class, "JBIServiceUnitDataFlavor"){};

    public JBIServiceUnitNode(AppserverJBIMgmtController appserverJBIMgmtController, String string, String string2, String string3) {
        super(appserverJBIMgmtController, NodeType.SERVICE_UNIT);
        this.setName(string);
        this.setDisplayName(string2);
        this.setShortDescription(Utils.getTooltip(string3));
        this.setValue("nodeDescription", string3);
    }

    protected Sheet createSheet() {
        Sheet sheet = new Sheet();
        this.addSheetSet(sheet, "GENERAL", "LBL_GENERAL_PROPERTIES", "DSC_GENERAL_PROPERTIES", this.getGeneralSheetSetProperties());
        try {
            this.addSheetSet(sheet, SERVICE_UNIT_STATISTICS_SHEET_SET_NAME, "LBL_SERVICE_UNIT_STATISTICS_PROPERTIES", "DSC_SERVICE_UNIT_STATISTICS_PROPERTIES", this.getServiceUnitStatisticsSheetSetProperties());
        }
        catch (ManagementRemoteException managementRemoteException) {
            managementRemoteException.printStackTrace();
        }
        return sheet;
    }

    private Map<Attribute, MBeanAttributeInfo> getServiceUnitStatisticsSheetSetProperties() throws ManagementRemoteException {
        AppserverJBIMgmtController appserverJBIMgmtController = this.getAppserverJBIMgmtController();
        PerformanceMeasurementServiceWrapper performanceMeasurementServiceWrapper = appserverJBIMgmtController.getPerformanceMeasurementServiceWrapper();
        String string = this.getParentNode().getName();
        ServiceAssemblyStatisticsData serviceAssemblyStatisticsData = performanceMeasurementServiceWrapper.getServiceAssemblyStatistics(string, "server");
        String string2 = this.getName();
        for (ServiceUnitStatisticsData serviceUnitStatisticsData : serviceAssemblyStatisticsData.getServiceUnitStatisticsList()) {
            if (!serviceUnitStatisticsData.getName().equals(string2)) continue;
            return Utils.getIntrospectedPropertyMap(serviceUnitStatisticsData, true);
        }
        return null;
    }

    private Map<Attribute, MBeanAttributeInfo> getGeneralSheetSetProperties() {
        ServiceUnitInfo serviceUnitInfo = this.getServiceUnitInfo();
        return Utils.getIntrospectedPropertyMap(serviceUnitInfo, true, "org.netbeans.modules.sun.manager.jbi.management.model.beaninfo");
    }

    @Override
    public Attribute setSheetProperty(String string, Object object) {
        return null;
    }

    private ServiceUnitInfo getServiceUnitInfo() {
        try {
            String string = this.getParentNode().getName();
            RuntimeManagementServiceWrapper runtimeManagementServiceWrapper = this.getRuntimeManagementServiceWrapper();
            return runtimeManagementServiceWrapper.getServiceUnit(string, this.getName(), "server");
        }
        catch (ManagementRemoteException managementRemoteException) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)managementRemoteException.getMessage(), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return null;
        }
    }

    public Image getIcon(int n) {
        String string = "resources/ServiceUnit.png";
        ServiceUnitInfo serviceUnitInfo = this.getServiceUnitInfo();
        String string2 = serviceUnitInfo == null ? null : serviceUnitInfo.getState();
        String string3 = null;
        if ("Shutdown".equals(string2)) {
            string3 = "resources/not_deployed.png";
        } else if ("Stopped".equals(string2)) {
            string3 = "resources/down.png";
        } else if (!"Started".equals(string2)) {
            string3 = "resources/unknown.png";
        }
        return Utils.getBadgedIcon(this.getClass(), string, null, string3);
    }

    public Transferable drag() throws IOException {
        ExTransferable exTransferable = ExTransferable.create((Transferable)super.drag());
        final String string = this.getDeploymentDescriptor();
        exTransferable.put(new ExTransferable.Single(ServiceUnitDataFlavor){

            protected Object getData() throws IOException, UnsupportedFlavorException {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("JBIMGR_SU_TRANSFER");
                arrayList.add(JBIServiceUnitNode.this.getName());
                arrayList.add(JBIServiceUnitNode.this.getComponentName());
                arrayList.add(JBIServiceUnitNode.this.getShortDescription());
                arrayList.add(string);
                return arrayList;
            }
        });
        return exTransferable;
    }

    public String getDeploymentDescriptor() {
        String string = null;
        AdministrationService administrationService = this.getAdministrationService();
        String string2 = this.getParentNode().getName();
        try {
            string = administrationService.getServiceUnitDeploymentDescriptor(string2, this.getName());
        }
        catch (ManagementRemoteException managementRemoteException) {
            managementRemoteException.printStackTrace();
        }
        return string;
    }

    private String getComponentName() {
        if (this.componentName == null) {
            JBIServiceAssemblyNode jBIServiceAssemblyNode = (JBIServiceAssemblyNode)this.getParentNode();
            String string = jBIServiceAssemblyNode.getDeploymentDescriptor();
            String string2 = this.getName();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            try {
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
                NodeList nodeList = document.getElementsByTagName("service-unit");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element = (Element)nodeList.item(i);
                    String string3 = ((Element)element.getElementsByTagName("name").item(0)).getFirstChild().getNodeValue();
                    if (!string3.equals(string2)) continue;
                    this.componentName = ((Element)element.getElementsByTagName("component-name").item(0)).getFirstChild().getNodeValue();
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.componentName == null) {
                this.componentName = "?";
            }
        }
        return this.componentName;
    }
}

