/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.wizard.FileChooser;
import org.netbeans.modules.cnd.discovery.wizard.SelectProviderWizard;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SelectProviderPanel
extends JPanel
implements CsmProgressListener {
    private static boolean SHOW_RESTRICT = Boolean.getBoolean("cnd.discovery.wizard.restrictSources");
    private SelectProviderWizard wizard;
    private JPanel instructionPanel;
    private JTextArea instructionsTextArea;
    private JLabel labelForProviders;
    private JLabel labelForRoot;
    private JComboBox prividersComboBox;
    private JCheckBox restrictCompile;
    private JCheckBox restrictSources;
    private JTextField rootFolder;
    private JButton rootFolderButton;

    public SelectProviderPanel(SelectProviderWizard selectProviderWizard) {
        this.wizard = selectProviderWizard;
        this.initComponents();
        if (!SHOW_RESTRICT) {
            this.restrictSources.setVisible(false);
            this.restrictCompile.setVisible(false);
        }
        this.addListeners();
    }

    private void addListeners() {
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                SelectProviderPanel.this.update(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                SelectProviderPanel.this.update(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                SelectProviderPanel.this.update(documentEvent);
            }
        };
        this.rootFolder.getDocument().addDocumentListener(documentListener);
        CsmListeners.getDefault().addProgressListener((CsmProgressListener)this);
    }

    private void initComponents() {
        this.rootFolder = new JTextField();
        this.rootFolderButton = new JButton();
        this.instructionPanel = new JPanel();
        this.instructionsTextArea = new JTextArea();
        this.labelForRoot = new JLabel();
        this.prividersComboBox = new JComboBox();
        this.labelForProviders = new JLabel();
        this.restrictSources = new JCheckBox();
        this.restrictCompile = new JCheckBox();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.rootFolder, gridBagConstraints);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/discovery/wizard/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.rootFolderButton, (String)resourceBundle.getString("ROOT_DIR_BROWSE_BUTTON_TXT"));
        this.rootFolderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectProviderPanel.this.rootFolderButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.rootFolderButton, gridBagConstraints);
        this.instructionPanel.setLayout(new GridBagLayout());
        this.instructionsTextArea.setBackground(this.instructionPanel.getBackground());
        this.instructionsTextArea.setEditable(false);
        this.instructionsTextArea.setLineWrap(true);
        this.instructionsTextArea.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.instructionPanel.add((Component)this.instructionsTextArea, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.instructionPanel, gridBagConstraints);
        this.labelForRoot.setLabelFor(this.rootFolder);
        Mnemonics.setLocalizedText((JLabel)this.labelForRoot, (String)resourceBundle.getString("ProjectRootFolder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.labelForRoot, gridBagConstraints);
        this.prividersComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SelectProviderPanel.this.providersComboBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.prividersComboBox, gridBagConstraints);
        this.labelForProviders.setLabelFor(this.prividersComboBox);
        Mnemonics.setLocalizedText((JLabel)this.labelForProviders, (String)resourceBundle.getString("SelectDiscoveryProviderText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.labelForProviders, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.restrictSources, (String)NbBundle.getMessage(SelectProviderPanel.class, (String)"RestrictSourcesText"));
        this.restrictSources.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.restrictSources, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.restrictCompile, (String)NbBundle.getMessage(SelectProviderPanel.class, (String)"RESTRICT_COMPILE_PATH"));
        this.restrictCompile.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.restrictCompile, gridBagConstraints);
    }

    private void providersComboBoxItemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getItem();
        if (object instanceof ProviderItem) {
            ProviderItem providerItem = (ProviderItem)object;
            this.instructionsTextArea.setText(providerItem.getDescription());
            this.wizard.stateChanged(null);
            if ("make-log".equals(providerItem.getID())) {
                this.restrictCompile.setSelected(true);
            } else {
                this.restrictCompile.setSelected(false);
            }
        }
    }

    private void update(DocumentEvent documentEvent) {
        this.wizard.stateChanged(null);
    }

    private void rootFolderButtonActionPerformed(ActionEvent actionEvent) {
        String string = null;
        string = this.rootFolder.getText().length() > 0 ? this.rootFolder.getText() : (FileChooser.getCurrectChooserFile() != null ? FileChooser.getCurrectChooserFile().getPath() : System.getProperty("user.home"));
        FileChooser fileChooser = new FileChooser(this.getString("ROOT_DIR_CHOOSER_TITLE_TXT"), this.getString("ROOT_DIR_BUTTON_TXT"), 1, false, null, string, false);
        int n = ((JFileChooser)fileChooser).showOpenDialog(this);
        if (n == 1) {
            return;
        }
        String string2 = fileChooser.getSelectedFile().getPath();
        this.rootFolder.setText(string2);
    }

    /*
     * WARNING - void declaration
     */
    void read(final DiscoveryDescriptor discoveryDescriptor) {
        void var7_12;
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(DiscoveryProvider.class));
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.prividersComboBox.getModel();
        defaultComboBoxModel.removeAllElements();
        ProjectProxy projectProxy = new ProjectProxy(){

            public boolean createSubProjects() {
                return false;
            }

            public Project getProject() {
                return discoveryDescriptor.getProject();
            }

            public String getMakefile() {
                return null;
            }

            public String getSourceRoot() {
                return discoveryDescriptor.getRootFolder();
            }

            public String getExecutable() {
                return discoveryDescriptor.getBuildResult();
            }

            public String getWorkingFolder() {
                return null;
            }
        };
        ArrayList<ProviderItem> arrayList = new ArrayList<ProviderItem>();
        for (DiscoveryProvider object2 : result.allInstances()) {
            object2.clean();
            if (!object2.isApplicable(projectProxy)) continue;
            arrayList.add(new ProviderItem(object2));
        }
        Collections.sort(arrayList);
        for (ProviderItem providerItem : arrayList) {
            defaultComboBoxModel.addElement(providerItem);
        }
        ProviderItem providerItem = this.getDefaultProvider(arrayList, projectProxy, discoveryDescriptor);
        if (providerItem != null) {
            this.prividersComboBox.setSelectedItem(providerItem);
        }
        String string = discoveryDescriptor.getRootFolder();
        if (Utilities.isWindows()) {
            String string2 = string.replace('/', File.separatorChar);
        }
        this.rootFolder.setText((String)var7_12);
    }

    private ProviderItem getDefaultProvider(List<ProviderItem> list, ProjectProxy projectProxy, DiscoveryDescriptor discoveryDescriptor) {
        ProviderItem providerItem = null;
        int n = 0;
        for (ProviderItem providerItem2 : list) {
            int n2;
            if ("dwarf-executable".equals(providerItem2.getID())) {
                providerItem2.getProvider().getProperty("executable").setValue(discoveryDescriptor.getBuildResult());
            } else if ("dwarf-folder".equals(providerItem2.getID())) {
                providerItem2.getProvider().getProperty("folder").setValue(discoveryDescriptor.getRootFolder());
            }
            if ((n2 = providerItem2.getProvider().canAnalyze(projectProxy)) <= n) continue;
            providerItem = providerItem2;
            n = n2;
        }
        return providerItem;
    }

    void store(DiscoveryDescriptor discoveryDescriptor) {
        ProviderItem providerItem = (ProviderItem)this.prividersComboBox.getSelectedItem();
        discoveryDescriptor.setProvider(providerItem.getProvider());
        discoveryDescriptor.setRootFolder(this.rootFolder.getText());
        ProviderProperty providerProperty = providerItem.getProvider().getProperty("restrict_source_root");
        if (providerProperty != null) {
            if (this.restrictSources.isSelected()) {
                providerProperty.setValue(this.rootFolder.getText());
            } else {
                providerProperty.setValue("");
            }
        }
        if ((providerProperty = providerItem.getProvider().getProperty("restrict_compile_root")) != null) {
            if (this.restrictCompile.isSelected()) {
                providerProperty.setValue(this.rootFolder.getText());
            } else {
                providerProperty.setValue("");
            }
        }
    }

    boolean valid(DiscoveryDescriptor discoveryDescriptor) {
        String string = this.rootFolder.getText();
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            return false;
        }
        ProviderItem providerItem = (ProviderItem)this.prividersComboBox.getSelectedItem();
        if ("model-folder".equals(providerItem.getID())) {
            CsmProject csmProject;
            Project project = discoveryDescriptor.getProject();
            if (project != null && (csmProject = CsmModelAccessor.getModel().getProject((Object)project)) != null && csmProject.isStable(null)) {
                return true;
            }
            discoveryDescriptor.setMessage(this.getString("ModelNotFinishParsing"));
            return false;
        }
        return true;
    }

    private String getString(String string) {
        return NbBundle.getBundle(SelectProviderPanel.class).getString(string);
    }

    public void projectParsingStarted(CsmProject csmProject) {
    }

    public void projectFilesCounted(CsmProject csmProject, int n) {
    }

    public void projectParsingFinished(CsmProject csmProject) {
        this.wizard.stateChanged(null);
    }

    public void projectLoaded(CsmProject csmProject) {
        this.wizard.stateChanged(null);
    }

    public void projectParsingCancelled(CsmProject csmProject) {
    }

    public void fileInvalidated(CsmFile csmFile) {
    }

    public void fileParsingStarted(CsmFile csmFile) {
    }

    public void fileParsingFinished(CsmFile csmFile) {
    }

    public void parserIdle() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProviderItem
    implements Comparable<ProviderItem> {
        private DiscoveryProvider provider;

        private ProviderItem(DiscoveryProvider discoveryProvider) {
            this.provider = discoveryProvider;
        }

        public String toString() {
            return this.provider.getName();
        }

        public String getID() {
            return this.provider.getID();
        }

        public String getDescription() {
            return this.provider.getDescription();
        }

        public DiscoveryProvider getProvider() {
            return this.provider;
        }

        @Override
        public int compareTo(ProviderItem providerItem) {
            return this.toString().compareTo(providerItem.toString());
        }
    }
}

