/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.discovery.api.Configuration;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.api.ProjectProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.wizard.SelectConfigurationWizard;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.api.ProjectConfiguration;
import org.netbeans.modules.cnd.discovery.wizard.tree.ConfigurationFactory;
import org.netbeans.modules.cnd.discovery.wizard.tree.FileConfigurationNode;
import org.netbeans.modules.cnd.discovery.wizard.tree.FolderConfigurationNode;
import org.netbeans.modules.cnd.discovery.wizard.tree.IncludesListModel;
import org.netbeans.modules.cnd.discovery.wizard.tree.MacrosListModel;
import org.netbeans.modules.cnd.discovery.wizard.tree.ProjectConfigurationImpl;
import org.netbeans.modules.cnd.discovery.wizard.tree.ProjectConfigurationNode;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class SelectConfigurationPanel
extends JPanel {
    private SelectConfigurationWizard wizard;
    private String oldConsolidation;
    private boolean showResulting;
    private boolean wasTerminated = false;
    private boolean isStoped = false;
    private JTree configurationTree;
    private JCheckBox includeInherate;
    private JList includesList;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JCheckBox macroInherate;
    private JList macrosList;
    private JCheckBox showInherited;

    public SelectConfigurationPanel(SelectConfigurationWizard selectConfigurationWizard) {
        this.wizard = selectConfigurationWizard;
        this.initComponents();
        this.configurationTree.getSelectionModel().setSelectionMode(1);
        this.addListeners();
        this.clearListModels();
    }

    private void addListeners() {
        this.configurationTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                SelectConfigurationPanel.this.updateListModels();
            }
        });
        this.showInherited.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectConfigurationPanel.this.showResulting = SelectConfigurationPanel.this.showInherited.isSelected();
                SelectConfigurationPanel.this.updateListModels();
            }
        });
    }

    private void updateListModels() {
        TreePath treePath = this.configurationTree.getSelectionPath();
        if (treePath != null) {
            Object object = treePath.getLastPathComponent();
            if (object instanceof ProjectConfigurationNode) {
                ProjectConfigurationNode projectConfigurationNode = (ProjectConfigurationNode)object;
                this.includesList.setModel(new IncludesListModel(projectConfigurationNode.getProject(), this.showResulting));
                this.macrosList.setModel(new MacrosListModel(projectConfigurationNode.getProject(), this.showResulting));
                this.includeInherate.setSelected(false);
                this.macroInherate.setSelected(false);
            } else if (object instanceof FolderConfigurationNode) {
                FolderConfigurationNode folderConfigurationNode = (FolderConfigurationNode)object;
                this.includesList.setModel(new IncludesListModel(folderConfigurationNode.getFolder(), this.showResulting));
                this.macrosList.setModel(new MacrosListModel(folderConfigurationNode.getFolder(), this.showResulting));
                this.includeInherate.setSelected(folderConfigurationNode.isCheckedInclude());
                this.macroInherate.setSelected(folderConfigurationNode.isCheckedMacro());
            } else if (object instanceof FileConfigurationNode) {
                FileConfigurationNode fileConfigurationNode = (FileConfigurationNode)object;
                this.includesList.setModel(new IncludesListModel(fileConfigurationNode.getFile(), this.showResulting));
                this.macrosList.setModel(new MacrosListModel(fileConfigurationNode.getFile(), this.showResulting));
                this.includeInherate.setSelected(fileConfigurationNode.isCheckedInclude());
                this.macroInherate.setSelected(fileConfigurationNode.isCheckedMacro());
            } else {
                this.clearListModels();
            }
        } else {
            this.clearListModels();
        }
    }

    private void clearListModels() {
        this.includesList.setModel(new EmptyListModel());
        this.macrosList.setModel(new EmptyListModel());
        this.includeInherate.setSelected(false);
        this.macroInherate.setSelected(false);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.configurationTree = new JTree();
        this.jPanel2 = new JPanel();
        this.jSplitPane2 = new JSplitPane();
        this.jPanel3 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.includesList = new JList();
        this.includeInherate = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.macrosList = new JList();
        this.macroInherate = new JCheckBox();
        this.jPanel5 = new JPanel();
        this.showInherited = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(400, 400));
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerLocation(200);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.configurationTree);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)ResourceBundle.getBundle("org/netbeans/modules/cnd/discovery/wizard/Bundle").getString("TreeConfigurationTitle"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.configurationTree.setRootVisible(false);
        this.configurationTree.setShowsRootHandles(true);
        this.jScrollPane1.setViewportView(this.configurationTree);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.jPanel2.setLayout(new BorderLayout());
        this.jSplitPane2.setBorder(null);
        this.jSplitPane2.setDividerLocation(200);
        this.jSplitPane2.setOrientation(0);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabel2.setLabelFor(this.includesList);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)ResourceBundle.getBundle("org/netbeans/modules/cnd/discovery/wizard/Bundle").getString("InludePathsListTitle"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.jPanel3.add((Component)this.jLabel2, gridBagConstraints);
        this.jScrollPane2.setViewportView(this.includesList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jScrollPane2, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.includeInherate, (String)ResourceBundle.getBundle("org/netbeans/modules/cnd/discovery/wizard/Bundle").getString("InheriteParentIncludePathsText"));
        this.includeInherate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.includeInherate.setEnabled(false);
        this.includeInherate.setFocusable(false);
        this.includeInherate.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.includeInherate, gridBagConstraints);
        this.jSplitPane2.setTopComponent(this.jPanel3);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabel3.setLabelFor(this.macrosList);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)ResourceBundle.getBundle("org/netbeans/modules/cnd/discovery/wizard/Bundle").getString("UserMacrosListTitle"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.jPanel4.add((Component)this.jLabel3, gridBagConstraints);
        this.jScrollPane3.setViewportView(this.macrosList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.jScrollPane3, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.macroInherate, (String)ResourceBundle.getBundle("org/netbeans/modules/cnd/discovery/wizard/Bundle").getString("InheriteParentMacrosText"));
        this.macroInherate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.macroInherate.setEnabled(false);
        this.macroInherate.setFocusable(false);
        this.macroInherate.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel4.add((Component)this.macroInherate, gridBagConstraints);
        this.jSplitPane2.setRightComponent(this.jPanel4);
        this.jPanel2.add((Component)this.jSplitPane2, "Center");
        this.jSplitPane1.setRightComponent(this.jPanel2);
        this.add((Component)this.jSplitPane1, "Center");
        this.jPanel5.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.showInherited, (String)ResourceBundle.getBundle("org/netbeans/modules/cnd/discovery/wizard/Bundle").getString("ShowInheritedConfigurationName"));
        this.showInherited.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.showInherited.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel5.add((Component)this.showInherited, gridBagConstraints);
        this.add((Component)this.jPanel5, "South");
    }

    private String getString(String string) {
        return NbBundle.getBundle(SelectConfigurationPanel.class).getString(string);
    }

    private Icon getLoadingIcon() {
        String string = "org/netbeans/modules/cnd/discovery/wizard/resources/waitNode.gif";
        Image image = ImageUtilities.loadImage((String)string);
        if (image != null) {
            return new ImageIcon(image);
        }
        return null;
    }

    void read(DiscoveryDescriptor discoveryDescriptor) {
        String string = discoveryDescriptor.getLevel();
        boolean bl = false;
        if (!string.equals(this.oldConsolidation)) {
            this.oldConsolidation = string;
            bl = true;
        }
        if (discoveryDescriptor.isInvokeProvider() || this.wasTerminated) {
            discoveryDescriptor.setConfigurations(null);
            ConfigurationTreeModel configurationTreeModel = new ConfigurationTreeModel();
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(this.getString("LoadingRootText"));
            ((DefaultMutableTreeNode)configurationTreeModel.getRoot()).add(defaultMutableTreeNode);
            DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
            this.configurationTree.setCellRenderer(defaultTreeCellRenderer);
            defaultTreeCellRenderer.setLeafIcon(this.getLoadingIcon());
            this.configurationTree.setModel(configurationTreeModel);
            AnalyzingTask analyzingTask = new AnalyzingTask(discoveryDescriptor);
            RequestProcessor.getDefault().post((Runnable)analyzingTask);
            this.isStoped = false;
            this.wasTerminated = true;
        } else if (bl) {
            List<ProjectConfiguration> list = discoveryDescriptor.getConfigurations();
            if (list != null) {
                for (ProjectConfiguration projectConfiguration : list) {
                    SelectConfigurationPanel.consolidateModel(projectConfiguration, string);
                }
            }
            this.updateListModels();
        }
    }

    public static void consolidateModel(ProjectConfiguration projectConfiguration, String string) {
        if ("project".equals(string)) {
            ConfigurationFactory.consolidateProject((ProjectConfigurationImpl)projectConfiguration);
        } else if ("folder".equals(string)) {
            ConfigurationFactory.consolidateFolder((ProjectConfigurationImpl)projectConfiguration);
        } else if ("file".equals(string)) {
            ConfigurationFactory.consolidateFile((ProjectConfigurationImpl)projectConfiguration);
        }
    }

    public static void buildModel(final DiscoveryDescriptor discoveryDescriptor) {
        String string = discoveryDescriptor.getRootFolder();
        DiscoveryProvider discoveryProvider = discoveryDescriptor.getProvider();
        String string2 = discoveryDescriptor.getLevel();
        List<Configuration> list = discoveryProvider.analyze(new ProjectProxy(){

            public boolean createSubProjects() {
                return false;
            }

            public Project getProject() {
                return discoveryDescriptor.getProject();
            }

            public String getMakefile() {
                return null;
            }

            public String getSourceRoot() {
                return discoveryDescriptor.getRootFolder();
            }

            public String getExecutable() {
                return discoveryDescriptor.getBuildResult();
            }

            public String getWorkingFolder() {
                return null;
            }
        });
        ArrayList<ProjectConfiguration> arrayList = new ArrayList<ProjectConfiguration>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        discoveryDescriptor.setIncludedFiles(arrayList2);
        for (Configuration configuration : list) {
            arrayList2.addAll(configuration.getIncludedFiles());
            List<ProjectProperties> list2 = configuration.getProjectConfiguration();
            Iterator<ProjectProperties> iterator = list2.iterator();
            while (iterator.hasNext()) {
                ProjectConfigurationImpl projectConfigurationImpl = ConfigurationFactory.makeRoot(iterator.next(), string);
                SelectConfigurationPanel.consolidateModel(projectConfigurationImpl, string2);
                arrayList.add(projectConfigurationImpl);
            }
        }
        discoveryDescriptor.setInvokeProvider(false);
        discoveryDescriptor.setConfigurations(arrayList);
    }

    private void creteTreeModel(DiscoveryDescriptor discoveryDescriptor) {
        ConfigurationTreeModel configurationTreeModel = new ConfigurationTreeModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)configurationTreeModel.getRoot();
        List<ProjectConfiguration> list = discoveryDescriptor.getConfigurations();
        if (list != null) {
            for (ProjectConfiguration projectConfiguration : list) {
                defaultMutableTreeNode.add(new ProjectConfigurationNode((ProjectConfigurationImpl)projectConfiguration));
            }
        }
        this.configurationTree.setCellRenderer(new DefaultTreeCellRenderer());
        this.configurationTree.setModel(configurationTreeModel);
    }

    void store(DiscoveryDescriptor discoveryDescriptor) {
        DiscoveryProvider discoveryProvider = discoveryDescriptor.getProvider();
        List<ProjectConfiguration> list = discoveryDescriptor.getConfigurations();
        if (discoveryProvider != null && this.wasTerminated) {
            this.isStoped = true;
            discoveryProvider.stop();
        }
    }

    boolean isValid(DiscoveryDescriptor discoveryDescriptor) {
        List<ProjectConfiguration> list = discoveryDescriptor.getConfigurations();
        if (list == null || list.isEmpty()) {
            return false;
        }
        return list.get(0).getFiles().size() > 0;
    }

    private class AnalyzingTask
    extends Thread {
        private DiscoveryDescriptor wizardDescriptor;

        public AnalyzingTask(DiscoveryDescriptor discoveryDescriptor) {
            this.wizardDescriptor = discoveryDescriptor;
        }

        public void run() {
            SelectConfigurationPanel.buildModel(this.wizardDescriptor);
            SelectConfigurationPanel.this.creteTreeModel(this.wizardDescriptor);
            SelectConfigurationPanel.this.wizard.stateChanged(null);
            if (!SelectConfigurationPanel.this.isStoped) {
                SelectConfigurationPanel.this.wasTerminated = false;
            }
        }
    }

    public static class EmptyListModel
    extends AbstractListModel {
        public int getSize() {
            return 0;
        }

        public Object getElementAt(int n) {
            return null;
        }
    }

    private static class ConfigurationTreeModel
    extends DefaultTreeModel {
        public ConfigurationTreeModel() {
            super(new DefaultMutableTreeNode("Root"));
        }
    }
}

