/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.cnd.api.utils.ElfDynamicLibraryFileFilter;
import org.netbeans.modules.cnd.api.utils.ElfExecutableFileFilter;
import org.netbeans.modules.cnd.api.utils.ElfStaticLibraryFileFilter;
import org.netbeans.modules.cnd.api.utils.MacOSXDynamicLibraryFileFilter;
import org.netbeans.modules.cnd.api.utils.MacOSXExecutableFileFilter;
import org.netbeans.modules.cnd.api.utils.PeDynamicLibraryFileFilter;
import org.netbeans.modules.cnd.api.utils.PeExecutableFileFilter;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.wizard.AdditionalLibrariesListPanel;
import org.netbeans.modules.cnd.discovery.wizard.FileChooser;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ProviderControl {
    private ProviderProperty property;
    private String description;
    private JLabel label;
    private JTextField field;
    private JButton button;
    private int chooserMode = 0;
    private JPanel panel;
    private ChangeListener listener;

    public ProviderControl(ProviderProperty providerProperty, DiscoveryDescriptor discoveryDescriptor, JPanel jPanel, ChangeListener changeListener) {
        this.property = providerProperty;
        this.panel = jPanel;
        this.listener = changeListener;
        this.description = providerProperty.getDescription();
        this.label = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.label, (String)providerProperty.getName());
        switch (providerProperty.getKind()) {
            case MakeLogFile: {
                this.field = new JTextField();
                this.chooserMode = 0;
                this.initBuildOrRoot(discoveryDescriptor);
                this.button = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)this.button, (String)this.getString("ROOT_DIR_BROWSE_BUTTON_TXT"));
                this.layout(jPanel);
                this.button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ProviderControl.this.rootFolderButtonActionPerformed(actionEvent, ProviderControl.this.property.getKind() == ProviderProperty.PropertyKind.BinaryFile, ProviderControl.this.getString("LOG_FILE_CHOOSER_TITLE_TXT"));
                    }
                });
                this.addListeners();
                break;
            }
            case BinaryFile: {
                this.field = new JTextField();
                this.chooserMode = 0;
                this.initBuildOrRoot(discoveryDescriptor);
                this.button = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)this.button, (String)this.getString("ROOT_DIR_BROWSE_BUTTON_TXT"));
                this.layout(jPanel);
                this.button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ProviderControl.this.rootFolderButtonActionPerformed(actionEvent, ProviderControl.this.property.getKind() == ProviderProperty.PropertyKind.BinaryFile, ProviderControl.this.getString("BINARY_FILE_CHOOSER_TITLE_TXT"));
                    }
                });
                this.addListeners();
                break;
            }
            case Folder: {
                this.field = new JTextField();
                this.chooserMode = 1;
                this.initRoot(discoveryDescriptor);
                this.button = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)this.button, (String)this.getString("ROOT_DIR_BROWSE_BUTTON_TXT"));
                this.layout(jPanel);
                this.button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ProviderControl.this.rootFolderButtonActionPerformed(actionEvent, true, ProviderControl.this.getString("ROOT_DIR_CHOOSER_TITLE_TXT"));
                    }
                });
                this.addListeners();
                break;
            }
            case BinaryFiles: {
                this.field = new JTextField();
                this.chooserMode = 0;
                this.initArray();
                this.button = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)this.button, (String)this.getString("ROOT_DIR_EDIT_BUTTON_TXT"));
                this.layout(jPanel);
                this.button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ProviderControl.this.additionalLibrariesButtonActionPerformed(actionEvent);
                    }
                });
                this.addListeners();
                break;
            }
        }
    }

    private void initBuildOrRoot(DiscoveryDescriptor discoveryDescriptor) {
        Object object = this.property.getValue();
        String string = null;
        if (object instanceof String) {
            string = (String)object;
        }
        if (string != null && string.length() > 0) {
            this.initFields(string, this.field);
            return;
        }
        string = discoveryDescriptor.getBuildResult();
        if (string != null && string.length() > 0) {
            this.initFields(string, this.field);
            return;
        }
        this.initFields(discoveryDescriptor.getRootFolder(), this.field);
    }

    private void initRoot(DiscoveryDescriptor discoveryDescriptor) {
        Object object = this.property.getValue();
        String string = null;
        if (object instanceof String) {
            string = (String)object;
        }
        if (string != null && string.length() > 0) {
            this.initFields(string, this.field);
            return;
        }
        this.initFields(discoveryDescriptor.getRootFolder(), this.field);
    }

    private void initArray() {
        Object object = this.property.getValue();
        if (object instanceof String[]) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : (String[])object) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(';');
                }
                stringBuilder.append(string);
            }
            this.field.setText(stringBuilder.toString());
        }
    }

    private void addListeners() {
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                ProviderControl.this.update(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ProviderControl.this.update(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                ProviderControl.this.update(documentEvent);
            }
        };
        this.field.getDocument().addDocumentListener(documentListener);
    }

    private void update(DocumentEvent documentEvent) {
        this.listener.stateChanged(null);
    }

    public void store() {
        switch (this.property.getKind()) {
            case MakeLogFile: 
            case BinaryFile: 
            case Folder: {
                this.property.setValue(this.field.getText());
                break;
            }
            case BinaryFiles: {
                String string = this.field.getText();
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                ArrayList<String> arrayList = new ArrayList<String>();
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
                this.property.setValue(arrayList.toArray(new String[arrayList.size()]));
                break;
            }
        }
    }

    public boolean valid() {
        String string = this.field.getText();
        switch (this.property.getKind()) {
            case Folder: {
                if (string.length() == 0) {
                    return false;
                }
                File file = new File(string);
                if (!file.exists() || !file.isDirectory()) break;
                return true;
            }
            case MakeLogFile: 
            case BinaryFile: {
                if (string.length() == 0) {
                    return false;
                }
                File file = new File(string);
                if (!file.exists() || !file.isFile()) break;
                return true;
            }
            case BinaryFiles: {
                String string2 = this.field.getText();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    if (string.length() == 0) {
                        return false;
                    }
                    File file = new File(string);
                    if (file.exists() && file.isFile()) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private void layout(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = null;
        this.label.setLabelFor(this.field);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        jPanel.add((Component)this.label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        jPanel.add((Component)this.field, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        jPanel.add((Component)this.button, gridBagConstraints);
    }

    private void additionalLibrariesButtonActionPerformed(ActionEvent actionEvent) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.field.getText(), ";");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        AdditionalLibrariesListPanel additionalLibrariesListPanel = new AdditionalLibrariesListPanel(arrayList.toArray());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)AdditionalLibrariesListPanel.wrapPanel(additionalLibrariesListPanel), this.getString("ADDITIONAL_LIBRARIES_TXT"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            Vector vector = additionalLibrariesListPanel.getListData();
            String string = "";
            for (int i = 0; i < vector.size(); ++i) {
                if (i > 0) {
                    string = string + ";";
                }
                string = string + vector.elementAt(i);
            }
            this.field.setText(string);
        }
    }

    private void rootFolderButtonActionPerformed(ActionEvent actionEvent, boolean bl, String string) {
        FileChooser fileChooser;
        int n;
        String string2 = null;
        string2 = this.field.getText().length() > 0 ? this.field.getText() : (FileChooser.getCurrectChooserFile() != null ? FileChooser.getCurrectChooserFile().getPath() : System.getProperty("user.home"));
        FileFilter[] fileFilterArray = null;
        if (this.chooserMode == 0) {
            fileFilterArray = bl ? (Utilities.isWindows() ? new FileFilter[]{PeExecutableFileFilter.getInstance(), ElfStaticLibraryFileFilter.getInstance(), PeDynamicLibraryFileFilter.getInstance()} : (Utilities.getOperatingSystem() == 4096 ? new FileFilter[]{MacOSXExecutableFileFilter.getInstance(), ElfStaticLibraryFileFilter.getInstance(), MacOSXDynamicLibraryFileFilter.getInstance()} : new FileFilter[]{ElfExecutableFileFilter.getInstance(), ElfStaticLibraryFileFilter.getInstance(), ElfDynamicLibraryFileFilter.getInstance()})) : new FileFilter[]{new LogFileFilter()};
        }
        if ((n = ((JFileChooser)(fileChooser = new FileChooser(string, this.getString("ROOT_DIR_BUTTON_TXT"), this.chooserMode, false, fileFilterArray, string2, false))).showOpenDialog(this.panel)) == 1) {
            return;
        }
        String string3 = fileChooser.getSelectedFile().getPath();
        this.field.setText(string3);
    }

    private void initFields(String string, JTextField jTextField) {
        if (string == null) {
            jTextField.setText("");
        } else {
            if (Utilities.isWindows()) {
                string = string.replace('/', File.separatorChar);
            }
            jTextField.setText(string);
        }
    }

    private String getString(String string) {
        return NbBundle.getBundle(ProviderControl.class).getString(string);
    }

    private class LogFileFilter
    extends FileFilter {
        public String getDescription() {
            return ProviderControl.this.getString("FILECHOOSER_MAK_LOG_FILEFILTER");
        }

        public boolean accept(File file) {
            if (file != null) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().endsWith(".log");
            }
            return false;
        }
    }
}

