/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jspparser;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jspparser.FastOpenInfoParser;
import org.netbeans.modules.web.jspparser.TldChangeSupport;
import org.netbeans.modules.web.jspparser.WebAppParseProxy;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.netbeans.modules.web.jsps.parserapi.TldChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspParserImpl
implements JspParserAPI {
    final Map<WebModule, WebAppParseProxy> parseSupports = new WeakHashMap<WebModule, WebAppParseProxy>();
    private final TldChangeSupport tldChangeSupport = new TldChangeSupport(this);
    private static final Logger LOGGER = Logger.getLogger(JspParserImpl.class.getName());
    private static Constructor webAppParserImplConstructor;
    private static final JspParserAPI.JspOpenInfo DEFAULT_OPENINFO;

    private static void initReflection() {
        if (webAppParserImplConstructor == null) {
            File[] fileArray = new File[]{InstalledFileLocator.getDefault().locate("ant/lib/ant.jar", null, false), InstalledFileLocator.getDefault().locate("modules/ext/glassfish-jspparser-2.0.jar", null, false), InstalledFileLocator.getDefault().locate("modules/ext/jsp-parser-ext.jar", null, false), InstalledFileLocator.getDefault().locate("modules/ext/servlet2.5-jsp2.1-api.jar", null, false), InstalledFileLocator.getDefault().locate("ant/lib/ant-launcher.jar", null, false)};
            try {
                URL[] uRLArray = new URL[fileArray.length];
                for (int i = 0; i < fileArray.length; ++i) {
                    uRLArray[i] = fileArray[i].toURI().toURL();
                }
                ExtClassLoader extClassLoader = new ExtClassLoader(uRLArray, JspParserImpl.class.getClassLoader());
                Class<?> clazz = extClassLoader.loadClass("org.netbeans.modules.web.jspparser_ext.WebAppParseSupport");
                webAppParserImplConstructor = clazz.getDeclaredConstructor(JspParserImpl.class, WebModule.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LOGGER.log(Level.INFO, null, noSuchMethodException);
            }
            catch (MalformedURLException malformedURLException) {
                LOGGER.log(Level.INFO, null, malformedURLException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOGGER.log(Level.INFO, null, classNotFoundException);
            }
        }
    }

    @Override
    public JspParserAPI.JspOpenInfo getJspOpenInfo(FileObject fileObject, WebModule webModule, boolean bl) {
        WebAppParseProxy webAppParseProxy;
        JspParserAPI.JspOpenInfo jspOpenInfo;
        FastOpenInfoParser fastOpenInfoParser = FastOpenInfoParser.get(webModule);
        if (fastOpenInfoParser != null && (jspOpenInfo = fastOpenInfoParser.getJspOpenInfo(fileObject, bl)) != null) {
            return jspOpenInfo;
        }
        if (webModule != null && (jspOpenInfo = webModule.getDocumentBase()) != null && (webAppParseProxy = this.getParseProxy(webModule)) != null) {
            return webAppParseProxy.getJspOpenInfo(fileObject, bl);
        }
        return DEFAULT_OPENINFO;
    }

    @Override
    public JspParserAPI.ParseResult analyzePage(FileObject fileObject, WebModule webModule, int n) {
        if (webModule == null) {
            return this.getNoWebModuleResult(fileObject, null);
        }
        FileObject fileObject2 = webModule.getDocumentBase();
        if (fileObject2 == null) {
            return this.getNoWebModuleResult(fileObject, webModule);
        }
        WebAppParseProxy webAppParseProxy = this.getParseProxy(webModule);
        if (webAppParseProxy == null) {
            return this.getNoWebModuleResult(fileObject, webModule);
        }
        return webAppParseProxy.analyzePage(fileObject, n);
    }

    @Override
    public Map<String, String[]> getTaglibMap(WebModule webModule) throws IOException {
        FileObject fileObject = webModule.getDocumentBase();
        if (fileObject == null) {
            throw new IOException();
        }
        WebAppParseProxy webAppParseProxy = this.getParseProxy(webModule);
        return webAppParseProxy.getTaglibMap(true);
    }

    private synchronized WebAppParseProxy getParseProxy(WebModule webModule) {
        WebAppParseProxy webAppParseProxy = this.parseSupports.get(webModule);
        if (webAppParseProxy == null) {
            webAppParseProxy = this.createParseProxy(webModule);
            this.parseSupports.put(webModule, webAppParseProxy);
        }
        return webAppParseProxy;
    }

    private WebAppParseProxy createParseProxy(WebModule webModule) {
        try {
            JspParserImpl.initReflection();
            return (WebAppParseProxy)webAppParserImplConstructor.newInstance(this, webModule);
        }
        catch (IllegalAccessException illegalAccessException) {
            LOGGER.log(Level.INFO, null, illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            LOGGER.log(Level.INFO, null, instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            LOGGER.log(Level.INFO, null, invocationTargetException);
        }
        return null;
    }

    @Override
    public URLClassLoader getModuleClassLoader(WebModule webModule) {
        WebAppParseProxy webAppParseProxy = this.getParseProxy(webModule);
        return webAppParseProxy.getWAClassLoader();
    }

    private JspParserAPI.ParseResult getNoWebModuleResult(FileObject fileObject, WebModule webModule) {
        JspParserAPI.ErrorDescriptor errorDescriptor = new JspParserAPI.ErrorDescriptor(null, fileObject, -1, -1, NbBundle.getMessage(JspParserImpl.class, (String)"MSG_webModuleNotFound", (Object)fileObject.getNameExt()), "");
        return new JspParserAPI.ParseResult(new JspParserAPI.ErrorDescriptor[]{errorDescriptor});
    }

    @Override
    public void addTldChangeListener(TldChangeListener tldChangeListener) {
        this.tldChangeSupport.addTldChangeListener(tldChangeListener);
    }

    @Override
    public void removeTldChangeListener(TldChangeListener tldChangeListener) {
        this.tldChangeSupport.removeTldChangeListener(tldChangeListener);
    }

    public void fireChange(WebModule webModule) {
        this.tldChangeSupport.fireChange(webModule);
    }

    static {
        DEFAULT_OPENINFO = new JspParserAPI.JspOpenInfo(false, "ISO-8859-1");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtClassLoader
    extends URLClassLoader {
        private static final AllPermission ALL_PERM = new AllPermission();

        public ExtClassLoader(URL[] uRLArray, ClassLoader classLoader) {
            super(uRLArray, classLoader);
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource codeSource) {
            PermissionCollection permissionCollection = super.getPermissions(codeSource);
            permissionCollection.add(ALL_PERM);
            return permissionCollection;
        }

        @Override
        protected synchronized Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
            if (string.startsWith("org.apache.tools.ant.")) {
                Class<?> clazz = this.findClass(string);
                return clazz;
            }
            return super.loadClass(string, bl);
        }
    }
}

