/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer.cssengine;

import com.sun.org.apache.xerces.internal.dom.DocumentImpl;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.CSSStyleSheetNode;
import org.apache.batik.css.engine.ImportRule;
import org.apache.batik.css.engine.Rule;
import org.apache.batik.css.engine.StyleDeclaration;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.StyleRule;
import org.apache.batik.css.engine.StyleSetting;
import org.apache.batik.css.engine.StyleSheet;
import org.apache.batik.css.engine.StyleSheetCache;
import org.apache.batik.css.engine.value.AbstractValue;
import org.apache.batik.css.engine.value.ComputedValue;
import org.apache.batik.css.engine.value.IdentifierProvider;
import org.apache.batik.css.engine.value.InheritValue;
import org.apache.batik.css.engine.value.StringMap;
import org.apache.batik.css.engine.value.URIValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueManager;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssEngineService;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssProvider;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssValue;
import org.netbeans.modules.visualweb.api.designer.cssengine.ResourceData;
import org.netbeans.modules.visualweb.api.designer.cssengine.StyleData;
import org.netbeans.modules.visualweb.designer.cssengine.CssValueFactory;
import org.netbeans.modules.visualweb.designer.cssengine.CssValueImpl;
import org.netbeans.modules.visualweb.designer.cssengine.PreviewElement;
import org.netbeans.modules.visualweb.designer.cssengine.XhtmlCssEngine;
import org.netbeans.modules.visualweb.spi.designer.cssengine.CssUserAgentInfo;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.SACMediaList;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.UserDataHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CssEngineServiceImpl
implements CssEngineService {
    private static String[] properties;
    private static final CssEngineServiceImpl instance;
    private static final String KEY_CSS_ENGINE = "vwpXhtmlCssEngine";

    private CssEngineServiceImpl() {
    }

    public static CssEngineService getDefault() {
        return CssEngineServiceImpl.get();
    }

    static CssEngineServiceImpl get() {
        return instance;
    }

    private XhtmlCssEngine getCssEngine(org.w3c.dom.Document document) {
        if (document == null) {
            return null;
        }
        return (XhtmlCssEngine)((Object)document.getUserData(KEY_CSS_ENGINE));
    }

    @Override
    public void createCssEngineForDocument(org.w3c.dom.Document document, URL uRL) {
        if (document == null) {
            return;
        }
        CssUserAgentInfo cssUserAgentInfo = CssEngineServiceImpl.getUserAgentInfo();
        XhtmlCssEngine xhtmlCssEngine = XhtmlCssEngine.create(document, uRL, cssUserAgentInfo);
        document.setUserData(KEY_CSS_ENGINE, (Object)xhtmlCssEngine, CssEngineDataHandler.getDefault());
    }

    static CssUserAgentInfo getUserAgentInfo() {
        CssUserAgentInfo cssUserAgentInfo = (CssUserAgentInfo)Lookup.getDefault().lookup(CssUserAgentInfo.class);
        if (cssUserAgentInfo == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("No CssUserAgentInfo available! Using dummy one!"));
            cssUserAgentInfo = new DummyUserAgentInfo();
        }
        return cssUserAgentInfo;
    }

    @Override
    public void removeCssEngineForDocument(org.w3c.dom.Document document) {
        if (document == null) {
            return;
        }
        XhtmlCssEngine xhtmlCssEngine = (XhtmlCssEngine)((Object)document.getUserData(KEY_CSS_ENGINE));
        if (xhtmlCssEngine != null) {
            xhtmlCssEngine.dispose();
        }
    }

    @Override
    public void reuseCssEngineForDocument(org.w3c.dom.Document document, org.w3c.dom.Document document2) {
        if (document == null || document2 == null) {
            return;
        }
        XhtmlCssEngine xhtmlCssEngine = (XhtmlCssEngine)((Object)document2.getUserData(KEY_CSS_ENGINE));
        document.setUserData(KEY_CSS_ENGINE, (Object)xhtmlCssEngine, CssEngineDataHandler.getDefault());
    }

    @Override
    public Collection<String> getCssStyleClassesForDocument(org.w3c.dom.Document document) {
        XhtmlCssEngine xhtmlCssEngine = this.getCssEngine(document);
        if (xhtmlCssEngine == null) {
            return Collections.emptySet();
        }
        return xhtmlCssEngine.getStyleClasses();
    }

    @Override
    public Map<String, String> getStyleMapFromStringForDocument(org.w3c.dom.Document document, String string) {
        XhtmlCssEngine xhtmlCssEngine = this.getCssEngine(document);
        if (xhtmlCssEngine == null) {
            return Collections.emptyMap();
        }
        return xhtmlCssEngine.styleToMap(string);
    }

    @Override
    public String getStringFromStyleMapForDocument(org.w3c.dom.Document document, Map<String, String> map) {
        XhtmlCssEngine xhtmlCssEngine = this.getCssEngine(document);
        if (xhtmlCssEngine == null) {
            return "";
        }
        return xhtmlCssEngine.mapToStyle(map);
    }

    @Override
    public void addTransientStyleSheetNodeForDocument(org.w3c.dom.Document document, Node node) {
        if (!(node instanceof CSSStyleSheetNode)) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalArgumentException("Node has to be of CSSStyleSheetNode type, node=" + node));
            return;
        }
        XhtmlCssEngine xhtmlCssEngine = this.getCssEngine(document);
        if (xhtmlCssEngine != null) {
            xhtmlCssEngine.addTransientStyleSheetNode((CSSStyleSheetNode)node);
        }
    }

    @Override
    public void clearTransientStyleSheetNodesForDocument(org.w3c.dom.Document document) {
        XhtmlCssEngine xhtmlCssEngine = this.getCssEngine(document);
        if (xhtmlCssEngine != null) {
            xhtmlCssEngine.clearTransientStyleSheetNodes();
        }
    }

    @Override
    public String getUpdatedLocalStyleValuesForElement(Element element, StyleData[] styleDataArray, StyleData[] styleDataArray2) throws Exception {
        if (!(element instanceof CSSStylableElement)) {
            return "";
        }
        org.w3c.dom.Document document = element.getOwnerDocument();
        XhtmlCssEngine xhtmlCssEngine = this.getCssEngine(document);
        if (xhtmlCssEngine != null) {
            CSSStylableElement cSSStylableElement = (CSSStylableElement)element;
            return xhtmlCssEngine.getUpdatedLocalStyleValues(cSSStylableElement, CssEngineServiceImpl.convertToStyleSettings(styleDataArray), CssEngineServiceImpl.convertToStyleSettings(styleDataArray2));
        }
        return "";
    }

    private static StyleSetting[] convertToStyleSettings(StyleData[] styleDataArray) {
        if (styleDataArray == null) {
            return null;
        }
        ArrayList<StyleSetting> arrayList = new ArrayList<StyleSetting>();
        for (int i = 0; i < styleDataArray.length; ++i) {
            StyleData styleData = styleDataArray[i];
            arrayList.add(new StyleSetting(styleData.getIndex(), styleData.getValue()));
        }
        return arrayList.toArray(new StyleSetting[arrayList.size()]);
    }

    @Override
    public void setStyleAttributeForElement(Element element, String string) {
        if (element == null) {
            return;
        }
        org.w3c.dom.Document document = element.getOwnerDocument();
        XhtmlCssEngine xhtmlCssEngine = this.getCssEngine(document);
        if (xhtmlCssEngine != null) {
            xhtmlCssEngine.setStyleAttributeValue(element, string);
        }
    }

    @Override
    public void clearComputedStylesForElement(Element element) {
        if (element == null) {
            return;
        }
        org.w3c.dom.Document document = element.getOwnerDocument();
        XhtmlCssEngine xhtmlCssEngine = this.getCssEngine(document);
        if (xhtmlCssEngine != null) {
            xhtmlCssEngine.clearComputedStyles(element);
        }
    }

    @Override
    public void setSilentErrorHandlerForDocument(org.w3c.dom.Document document) {
        this.setErrorHandlerForDocument(document, XhtmlCssEngine.SILENT_ERROR_HANDLER);
    }

    @Override
    public void setNullErrorHandlerForDocument(org.w3c.dom.Document document) {
        this.setErrorHandlerForDocument(document, null);
    }

    private void setErrorHandlerForDocument(org.w3c.dom.Document document, ErrorHandler errorHandler) {
        XhtmlCssEngine xhtmlCssEngine = this.getCssEngine(document);
        if (xhtmlCssEngine != null) {
            xhtmlCssEngine.setErrorHandler(errorHandler);
        }
    }

    @Override
    public boolean isInheritedStyleValueForElement(Element element, int n) {
        if (!(element instanceof CSSStylableElement)) {
            return false;
        }
        org.w3c.dom.Document document = element.getOwnerDocument();
        XhtmlCssEngine xhtmlCssEngine = this.getCssEngine(document);
        if (xhtmlCssEngine != null) {
            CSSStylableElement cSSStylableElement = (CSSStylableElement)element;
            return xhtmlCssEngine.isInheritedValue(cSSStylableElement, n);
        }
        return false;
    }

    @Override
    public boolean isDefaultStyleValueForElement(Element element, String string, int n) {
        if (!(element instanceof CSSStylableElement)) {
            return false;
        }
        org.w3c.dom.Document document = element.getOwnerDocument();
        XhtmlCssEngine xhtmlCssEngine = this.getCssEngine(document);
        if (xhtmlCssEngine != null) {
            CSSStylableElement cSSStylableElement = (CSSStylableElement)element;
            return xhtmlCssEngine.isDefaultValue(cSSStylableElement, string, n);
        }
        return false;
    }

    @Override
    public void refreshStylesForDocument(org.w3c.dom.Document document) {
        XhtmlCssEngine xhtmlCssEngine = this.getCssEngine(document);
        if (xhtmlCssEngine != null) {
            xhtmlCssEngine.refreshStyles();
        }
    }

    @Override
    public boolean isInlineStyleValue(Element element, int n) {
        if (!(element instanceof CSSStylableElement)) {
            return false;
        }
        CSSStylableElement cSSStylableElement = (CSSStylableElement)element;
        String string = "";
        StyleMap styleMap = cSSStylableElement.getComputedStyleMap(string);
        if (styleMap == null) {
            return false;
        }
        Value value = styleMap.getValue(n);
        if (value == null) {
            return false;
        }
        return styleMap.getOrigin(n) == Short.MIN_VALUE;
    }

    @Override
    public String getAllStylesForElement(Element element) {
        CSSStylableElement cSSStylableElement;
        StyleMap styleMap;
        if (!(element instanceof CSSStylableElement)) {
            return "";
        }
        org.w3c.dom.Document document = element.getOwnerDocument();
        XhtmlCssEngine xhtmlCssEngine = this.getCssEngine(document);
        if (xhtmlCssEngine != null && (styleMap = (cSSStylableElement = (CSSStylableElement)element).getComputedStyleMap(null)) != null) {
            return styleMap.toString((CSSEngine)xhtmlCssEngine);
        }
        return "";
    }

    @Override
    public String getAllComputedStylesForElement(Element element) {
        if (!(element instanceof CSSStylableElement)) {
            return "";
        }
        org.w3c.dom.Document document = element.getOwnerDocument();
        XhtmlCssEngine xhtmlCssEngine = this.getCssEngine(document);
        if (xhtmlCssEngine == null) {
            return "";
        }
        CSSStylableElement cSSStylableElement = (CSSStylableElement)element;
        StyleMap styleMap = cSSStylableElement.getComputedStyleMap(null);
        StyleMap styleMap2 = xhtmlCssEngine.getCascadedStyleMap(cSSStylableElement, null);
        StringBuffer stringBuffer = new StringBuffer(400);
        int n = styleMap.getSize(true);
        for (int i = 0; i < n; ++i) {
            AbstractValue abstractValue;
            String string;
            ValueManager valueManager;
            Value value;
            Value value2 = xhtmlCssEngine.getComputedStyle((CSSStylableElement)element, null, i);
            if (!value2.equals(value = (valueManager = xhtmlCssEngine.getValueManagers()[i]).getDefaultValue())) {
                stringBuffer.append("*");
            }
            int n2 = stringBuffer.length();
            stringBuffer.append(xhtmlCssEngine.getPropertyName(i));
            stringBuffer.append(": ");
            stringBuffer.append(value2);
            stringBuffer.append("       ");
            if (styleMap2.getOrigin(i) == 16384) {
                stringBuffer.append("(from HTML attribute) ");
            }
            if (styleMap2.getValue(i) == InheritValue.INSTANCE) {
                stringBuffer.append("(inherited) ");
            }
            if (styleMap.isImportant(i)) {
                stringBuffer.append("!important ");
            }
            if (value2 instanceof AbstractValue && (string = xhtmlCssEngine.computeFileName((abstractValue = (AbstractValue)value2).getLocation())) != null) {
                String string2 = null;
                String string3 = string.substring(string.lastIndexOf(47) + 1);
                int n3 = xhtmlCssEngine.computeLineNumber(abstractValue.getLocation(), abstractValue.getLineNumber()) + 1;
                if (string3.length() != 0 && !string3.equals("default.css")) {
                    string2 = n3 > 0 && string3.length() > 0 ? string3 + ':' + Integer.toString(n3) : string3;
                }
                if (string2 != null) {
                    stringBuffer.append(' ');
                    for (int j = stringBuffer.length(); j < n2 + 40; ++j) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(string2);
                }
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    @Override
    public String getAllRulesForElement(Element element) {
        if (element == null) {
            return "";
        }
        org.w3c.dom.Document document = element.getOwnerDocument();
        XhtmlCssEngine xhtmlCssEngine = this.getCssEngine(document);
        if (xhtmlCssEngine != null) {
            return xhtmlCssEngine.getMatchingRules(element, false);
        }
        return "";
    }

    @Override
    public void uncomputeValueForElement(Element element, int n) {
        Value value;
        if (!(element instanceof CSSStylableElement)) {
            return;
        }
        org.w3c.dom.Document document = element.getOwnerDocument();
        XhtmlCssEngine xhtmlCssEngine = this.getCssEngine(document);
        if (xhtmlCssEngine == null) {
            return;
        }
        CSSStylableElement cSSStylableElement = (CSSStylableElement)element;
        StyleMap styleMap = cSSStylableElement.getComputedStyleMap(null);
        if (styleMap != null && (value = styleMap.getValue(n)) instanceof ComputedValue) {
            ComputedValue computedValue = (ComputedValue)value;
            styleMap.putComputed(n, false);
            styleMap.putValue(n, computedValue.getCascadedValue());
        }
    }

    @Override
    public CssValue getComputedValueForElement(Element element, int n) {
        return this.getComputedValueImplForElement(element, n);
    }

    CssValueImpl getComputedValueImplForElement(Element element, int n) {
        if (!(element instanceof CSSStylableElement)) {
            return null;
        }
        org.w3c.dom.Document document = element.getOwnerDocument();
        XhtmlCssEngine xhtmlCssEngine = this.getCssEngine(document);
        if (xhtmlCssEngine == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("There is no css engine associated with the element's document,\nelement=" + element + "\ndocument=" + document + "\ndocument class=" + (document == null ? null : document.getClass()) + "\ndocument hashCode=" + (document == null ? null : Integer.valueOf(document.hashCode()))));
            return null;
        }
        CSSStylableElement cSSStylableElement = (CSSStylableElement)element;
        Value value = xhtmlCssEngine.getComputedStyle(cSSStylableElement, null, n);
        return (CssValueImpl)CssValueFactory.createCssValue(value);
    }

    private boolean isMediaMatchingForDocument(org.w3c.dom.Document document, SACMediaList sACMediaList) {
        XhtmlCssEngine xhtmlCssEngine = this.getCssEngine(document);
        if (xhtmlCssEngine == null) {
            return false;
        }
        return xhtmlCssEngine.mediaMatch(sACMediaList);
    }

    private StyleDeclaration parseStyleDeclarationForElement(Element element, String string) {
        if (!(element instanceof CSSStylableElement)) {
            return new StyleDeclaration();
        }
        org.w3c.dom.Document document = element.getOwnerDocument();
        XhtmlCssEngine xhtmlCssEngine = this.getCssEngine(document);
        if (xhtmlCssEngine == null) {
            return new StyleDeclaration();
        }
        CSSStylableElement cSSStylableElement = (CSSStylableElement)element;
        return xhtmlCssEngine.parseStyleDeclaration(cSSStylableElement, string);
    }

    private StyleSheet parseStyleSheetForDocument(org.w3c.dom.Document document, InputSource inputSource, URL uRL, String string, Object object) {
        XhtmlCssEngine xhtmlCssEngine = this.getCssEngine(document);
        if (xhtmlCssEngine == null) {
            return new StyleSheet();
        }
        return xhtmlCssEngine.parseStyleSheet(inputSource, uRL, string, object);
    }

    @Override
    public StyleSheet parseStyleSheetForDocument(org.w3c.dom.Document document, String string, URL uRL, String string2, Object object) {
        XhtmlCssEngine xhtmlCssEngine = this.getCssEngine(document);
        if (xhtmlCssEngine == null) {
            return new StyleSheet();
        }
        return xhtmlCssEngine.parseStyleSheet(string, uRL, string2, object);
    }

    @Override
    public StyleSheet parseStyleSheetForDocument(org.w3c.dom.Document document, URL uRL, String string, Object object) {
        XhtmlCssEngine xhtmlCssEngine = this.getCssEngine(document);
        if (xhtmlCssEngine == null) {
            return new StyleSheet();
        }
        return xhtmlCssEngine.parseStyleSheet(uRL, string, object);
    }

    private static ValueManager[] getXhtmlValueManagers() {
        return XhtmlCssEngine.XHTML_VALUE_MANAGERS;
    }

    @Override
    public int getXhtmlPropertyIndex(String string) {
        return XhtmlCssEngine.getXhtmlPropertyIndex(string);
    }

    private static int getXhtmlShorthandIndex(String string) {
        return XhtmlCssEngine.getXhtmlShorthandIndex(string);
    }

    @Override
    public Element createPreviewElementForDocument(org.w3c.dom.Document document, URL uRL, String string) {
        return new PreviewElement(document, uRL, string);
    }

    @Override
    public void clearEngineStyleLookupCount() {
        CSSEngine.styleLookupCount = 0;
    }

    @Override
    public int getEngineStyleLookupCount() {
        return CSSEngine.styleLookupCount;
    }

    @Override
    public void flushStyleSheetCache() {
        StyleSheetCache.getInstance().flush();
    }

    @Override
    public String[] getCssIdentifiers(String string) {
        StringMap stringMap = this.getIdentifiers(string);
        if (stringMap == null) {
            return new String[0];
        }
        int n = stringMap.size();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        Iterator iterator = stringMap.keys();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            arrayList.add(string2);
        }
        arrayList.add("inherit");
        Collections.sort(arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private StringMap getIdentifiers(String string) {
        int n = this.getXhtmlPropertyIndex(string);
        if (n == -1) {
            n = CssEngineServiceImpl.getXhtmlShorthandIndex(string);
            if (n == -1) {
                return null;
            }
            return null;
        }
        ValueManager valueManager = CssEngineServiceImpl.getXhtmlValueManagers()[n];
        if (valueManager instanceof IdentifierProvider) {
            return ((IdentifierProvider)valueManager).getIdentifierMap();
        }
        return null;
    }

    @Override
    public String[] getCssProperties() {
        if (properties == null) {
            ValueManager[] valueManagerArray = CssEngineServiceImpl.getXhtmlValueManagers();
            ArrayList<String> arrayList = new ArrayList<String>(valueManagerArray.length);
            int n = valueManagerArray.length;
            for (int i = 0; i < n; ++i) {
                String string = valueManagerArray[i].getPropertyName();
                if (string.charAt(0) == '-') continue;
                arrayList.add(string);
            }
            Collections.sort(arrayList);
            properties = arrayList.toArray(new String[arrayList.size()]);
        }
        return properties;
    }

    @Override
    public void setStyleParentForElement(Element element, Element element2) {
        if (element == element2) {
            return;
        }
        if (element instanceof CSSStylableElement && element2 instanceof CSSStylableElement) {
            CSSEngine.StyleElementLink styleElementLink = (CSSEngine.StyleElementLink)element;
            styleElementLink.setStyleParent((CSSStylableElement)element2);
        }
    }

    @Override
    public Element getStyleParentForElement(Element element) {
        if (element instanceof CSSEngine.StyleElementLink) {
            return ((CSSEngine.StyleElementLink)element).getStyleParent();
        }
        return null;
    }

    @Override
    public String[] getStyleResourcesForElement(Element element, String string, org.w3c.dom.Document document, URL uRL, int[] nArray) {
        this.createCssEngineForDocument(document, uRL);
        StyleDeclaration styleDeclaration = this.parseStyleDeclarationForElement(element, string);
        return CssEngineServiceImpl.getStyleResourcesFromStyleDeclaration(styleDeclaration, nArray);
    }

    @Override
    public ResourceData[] getStyleResourcesForRules(String string, org.w3c.dom.Document document, URL uRL, URL uRL2, int[] nArray) {
        this.createCssEngineForDocument(document, uRL);
        InputSource inputSource = new InputSource((Reader)new StringReader(string));
        StyleSheet styleSheet = this.parseStyleSheetForDocument(document, inputSource, uRL2, "all", (Object)uRL2);
        return this.getStyleResourcesFromStyleSheet(document, styleSheet, nArray);
    }

    @Override
    public ResourceData[] getStyleResourcesForUrl(URL uRL, org.w3c.dom.Document document, URL uRL2, int[] nArray) {
        this.createCssEngineForDocument(document, uRL2);
        InputSource inputSource = new InputSource(uRL.toString());
        StyleSheet styleSheet = this.parseStyleSheetForDocument(document, inputSource, uRL, "all", (Object)uRL);
        return this.getStyleResourcesFromStyleSheet(document, styleSheet, nArray);
    }

    private static String[] getStyleResourcesFromStyleDeclaration(StyleDeclaration styleDeclaration, int[] nArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = styleDeclaration.size();
        for (int i = 0; i < n; ++i) {
            URIValue uRIValue;
            String string;
            Value value;
            int n2 = styleDeclaration.getIndex(i);
            boolean bl = false;
            for (int j = 0; j < nArray.length; ++j) {
                if (n2 != nArray[j]) continue;
                bl = true;
                break;
            }
            if (!bl || !((value = styleDeclaration.getValue(i)) instanceof URIValue) || arrayList.contains(string = (uRIValue = (URIValue)value).getRawCssText())) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private ResourceData[] getStyleResourcesFromStyleSheet(org.w3c.dom.Document document, StyleSheet styleSheet, int[] nArray) {
        ArrayList<ResourceData> arrayList = new ArrayList<ResourceData>();
        int n = styleSheet.getSize();
        block4: for (int i = 0; i < n; ++i) {
            Rule rule = styleSheet.getRule(i);
            switch (rule.getType()) {
                case 0: {
                    StyleRule styleRule = (StyleRule)rule;
                    StyleDeclaration styleDeclaration = styleRule.getStyleDeclaration();
                    String[] stringArray = CssEngineServiceImpl.getStyleResourcesFromStyleDeclaration(styleDeclaration, nArray);
                    arrayList.add(new UrlStringsResourceData(stringArray));
                    continue block4;
                }
                case 2: {
                    ImportRule importRule = (ImportRule)rule;
                    if (!this.isMediaMatchingForDocument(document, importRule.getMediaList())) continue block4;
                    URL uRL = importRule.getURI();
                    String string = importRule.getRelativeUri();
                    arrayList.add(new UrlResourceData(uRL, string));
                }
            }
        }
        return arrayList.toArray(new ResourceData[arrayList.size()]);
    }

    @Override
    public CssEngineService.CssSyntaxErrorInfo[] parseCss(Document document) {
        String string;
        if (document == null) {
            throw new IllegalArgumentException("Parameter document may not be null!");
        }
        FakeDocument fakeDocument = new FakeDocument();
        this.createCssEngineForDocument(fakeDocument, null);
        ArrayList<CssEngineService.CssSyntaxErrorInfo> arrayList = new ArrayList<CssEngineService.CssSyntaxErrorInfo>();
        DefaultErrorHandler defaultErrorHandler = new DefaultErrorHandler(arrayList);
        this.setErrorHandlerForDocument(fakeDocument, defaultErrorHandler);
        try {
            string = document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
            return arrayList.toArray(new CssEngineService.CssSyntaxErrorInfo[arrayList.size()]);
        }
        this.parseStyleSheetForDocument((org.w3c.dom.Document)fakeDocument, string, null, "all", null);
        this.setErrorHandlerForDocument(fakeDocument, null);
        return arrayList.toArray(new CssEngineService.CssSyntaxErrorInfo[arrayList.size()]);
    }

    @Override
    public URL getBackgroundImageUrlForElement(Element element, URL uRL) {
        CssValue cssValue = this.getComputedValueForElement(element, 1);
        if (cssValue == null || CssProvider.getValueService().isNoneValue(cssValue)) {
            return null;
        }
        String string = cssValue.getStringValue();
        try {
            return new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            ErrorManager.getDefault().notify(1, (Throwable)malformedURLException);
            return null;
        }
    }

    static {
        instance = new CssEngineServiceImpl();
    }

    private static class CssEngineDataHandler
    implements UserDataHandler {
        private static final CssEngineDataHandler INSTANCE = new CssEngineDataHandler();

        private CssEngineDataHandler() {
        }

        public static CssEngineDataHandler getDefault() {
            return INSTANCE;
        }

        public void handle(short s, String string, Object object, Node node, Node node2) {
        }
    }

    private static class DefaultCssSyntaxErrorInfo
    implements CssEngineService.CssSyntaxErrorInfo {
        private final int lineNumber;
        private final String localizedMessage;

        public DefaultCssSyntaxErrorInfo(int n, String string) {
            this.lineNumber = n;
            this.localizedMessage = string;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getLocalizedMessage() {
            return this.localizedMessage;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultErrorHandler
    implements ErrorHandler {
        private final List<CssEngineService.CssSyntaxErrorInfo> parseErrors;

        public DefaultErrorHandler(List<CssEngineService.CssSyntaxErrorInfo> list) {
            this.parseErrors = list;
        }

        public void warning(CSSParseException cSSParseException) {
            this.parseErrors.add(new DefaultCssSyntaxErrorInfo(cSSParseException.getLineNumber(), cSSParseException.getLocalizedMessage()));
        }

        public void error(CSSParseException cSSParseException) {
            this.parseErrors.add(new DefaultCssSyntaxErrorInfo(cSSParseException.getLineNumber(), cSSParseException.getLocalizedMessage()));
        }

        public void fatalError(CSSParseException cSSParseException) {
            this.parseErrors.add(new DefaultCssSyntaxErrorInfo(cSSParseException.getLineNumber(), cSSParseException.getLocalizedMessage()));
        }
    }

    private static class FakeDocument
    extends DocumentImpl {
        private FakeDocument() {
        }
    }

    private static class UrlResourceData
    implements ResourceData.UrlResourceData {
        private final URL url;
        private final String urlString;

        public UrlResourceData(URL uRL, String string) {
            this.url = uRL;
            this.urlString = string;
        }

        public URL getUrl() {
            return this.url;
        }

        public String getUrlString() {
            return this.urlString;
        }
    }

    private static class UrlStringsResourceData
    implements ResourceData.UrlStringsResourceData {
        private final String[] urlStrings;

        public UrlStringsResourceData(String[] stringArray) {
            this.urlStrings = stringArray;
        }

        public String[] getUrlStrings() {
            return this.urlStrings;
        }
    }

    private static class DummyUserAgentInfo
    implements CssUserAgentInfo {
        private DummyUserAgentInfo() {
        }

        public float getBlockWidth(org.w3c.dom.Document document, Element element) {
            return 0.0f;
        }

        public float getBlockHeight(org.w3c.dom.Document document, Element element) {
            return 0.0f;
        }

        public int getDefaultFontSize() {
            return 16;
        }

        public String computeFileName(Object object) {
            return object == null ? null : object.toString();
        }

        public int computeLineNumber(Object object, int n) {
            return n;
        }

        public URL getDocumentUrl(org.w3c.dom.Document document) {
            return null;
        }

        public void displayErrorForLocation(String string, Object object, int n, int n2) {
        }

        public Element getHtmlBodyForDocument(org.w3c.dom.Document document) {
            return null;
        }

        public DocumentFragment getHtmlDomFragmentForDocument(org.w3c.dom.Document document) {
            return null;
        }
    }
}

