/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.lexer;

import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.db.api.sql.SQLKeywords;
import org.netbeans.modules.db.sql.lexer.SQLTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLLexer
implements Lexer<SQLTokenId> {
    private static final int INIT = 1;
    private static final int ISI_WHITESPACE = 2;
    private static final int ISI_LINE_COMMENT = 4;
    private static final int ISI_BLOCK_COMMENT = 5;
    private static final int ISI_STRING = 6;
    private static final int ISI_IDENTIFIER = 10;
    private static final int ISA_SLASH = 11;
    private static final int ISA_MINUS = 13;
    private static final int ISA_STAR_IN_BLOCK_COMMENT = 21;
    private static final int ISA_ZERO = 27;
    private static final int ISI_INT = 28;
    private static final int ISI_DOUBLE = 30;
    private static final int ISA_DOT = 33;
    private final LexerRestartInfo info;
    private final LexerInput input;
    private final TokenFactory<SQLTokenId> factory;
    private int state = 1;
    private int startQuoteChar = -1;

    public SQLLexer(LexerRestartInfo<SQLTokenId> lexerRestartInfo) {
        this.info = lexerRestartInfo;
        this.input = lexerRestartInfo.input();
        this.factory = lexerRestartInfo.tokenFactory();
    }

    public Token<SQLTokenId> nextToken() {
        int n;
        while ((n = this.input.read()) != -1) {
            block0 : switch (this.state) {
                case 1: {
                    switch (n) {
                        case 39: {
                            this.state = 6;
                            break block0;
                        }
                        case 47: {
                            this.state = 11;
                            break block0;
                        }
                        case 35: {
                            this.state = 4;
                            break block0;
                        }
                        case 33: 
                        case 42: 
                        case 43: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: {
                            this.state = 1;
                            return this.factory.createToken((TokenId)SQLTokenId.OPERATOR);
                        }
                        case 40: {
                            this.state = 1;
                            return this.factory.createToken((TokenId)SQLTokenId.LPAREN);
                        }
                        case 41: {
                            this.state = 1;
                            return this.factory.createToken((TokenId)SQLTokenId.RPAREN);
                        }
                        case 44: {
                            this.state = 1;
                            return this.factory.createToken((TokenId)SQLTokenId.COMMA);
                        }
                        case 45: {
                            this.state = 13;
                            break block0;
                        }
                        case 48: {
                            this.state = 27;
                            break block0;
                        }
                        case 46: {
                            this.state = 33;
                            break block0;
                        }
                    }
                    if (Character.isWhitespace(n)) {
                        this.state = 2;
                        break;
                    }
                    if (Character.isDigit(n)) {
                        this.state = 28;
                        break;
                    }
                    if (SQLLexer.isStartQuoteChar(n)) {
                        this.startQuoteChar = n;
                    }
                    this.state = 10;
                    break;
                }
                case 2: {
                    if (Character.isWhitespace(n)) break;
                    this.state = 1;
                    this.input.backup(1);
                    return this.factory.createToken((TokenId)SQLTokenId.WHITESPACE);
                }
                case 4: {
                    if (n != 10) break;
                    this.state = 1;
                    return this.factory.createToken((TokenId)SQLTokenId.LINE_COMMENT);
                }
                case 5: {
                    if (n != 42) break;
                    this.state = 21;
                    break;
                }
                case 6: {
                    switch (n) {
                        case 39: {
                            this.state = 1;
                            return this.factory.createToken((TokenId)SQLTokenId.STRING);
                        }
                    }
                    break;
                }
                case 10: {
                    if (this.startQuoteChar != -1) {
                        if (!SQLLexer.isEndQuoteChar(this.startQuoteChar, n)) {
                            break;
                        }
                    } else {
                        if (Character.isLetterOrDigit(n) || n == 95) break;
                        this.input.backup(1);
                    }
                    this.state = 1;
                    this.startQuoteChar = -1;
                    return this.factory.createToken((TokenId)SQLLexer.testKeyword(this.input.readText()));
                }
                case 11: {
                    switch (n) {
                        case 42: {
                            this.state = 5;
                            break block0;
                        }
                    }
                    this.state = 1;
                    this.input.backup(1);
                    return this.factory.createToken((TokenId)SQLTokenId.OPERATOR);
                }
                case 13: {
                    switch (n) {
                        case 45: {
                            this.state = 4;
                            break block0;
                        }
                    }
                    this.state = 1;
                    this.input.backup(1);
                    return this.factory.createToken((TokenId)SQLTokenId.OPERATOR);
                }
                case 21: {
                    switch (n) {
                        case 47: {
                            this.state = 1;
                            return this.factory.createToken((TokenId)SQLTokenId.BLOCK_COMMENT);
                        }
                    }
                    this.state = 5;
                    break;
                }
                case 27: {
                    switch (n) {
                        case 46: {
                            this.state = 30;
                            break block0;
                        }
                    }
                    if (Character.isDigit(n)) {
                        this.state = 28;
                        break;
                    }
                    this.state = 1;
                    this.input.backup(1);
                    return this.factory.createToken((TokenId)SQLTokenId.INT_LITERAL);
                }
                case 28: {
                    switch (n) {
                        case 46: {
                            this.state = 30;
                            break block0;
                        }
                    }
                    if (Character.isDigit(n)) {
                        this.state = 28;
                        break;
                    }
                    this.state = 1;
                    this.input.backup(1);
                    return this.factory.createToken((TokenId)SQLTokenId.INT_LITERAL);
                }
                case 30: {
                    if (n >= 48 && n <= 57) {
                        this.state = 30;
                        break;
                    }
                    this.state = 1;
                    this.input.backup(1);
                    return this.factory.createToken((TokenId)SQLTokenId.DOUBLE_LITERAL);
                }
                case 33: {
                    if (Character.isDigit(n)) {
                        this.state = 30;
                        break;
                    }
                    this.state = 1;
                    this.input.backup(1);
                    return this.factory.createToken((TokenId)SQLTokenId.DOT);
                }
            }
        }
        SQLTokenId sQLTokenId = null;
        PartType partType = PartType.COMPLETE;
        switch (this.state) {
            case 2: {
                sQLTokenId = SQLTokenId.WHITESPACE;
                break;
            }
            case 10: {
                this.startQuoteChar = -1;
                sQLTokenId = SQLLexer.testKeyword(this.input.readText());
                break;
            }
            case 4: {
                sQLTokenId = SQLTokenId.LINE_COMMENT;
                break;
            }
            case 5: 
            case 21: {
                sQLTokenId = SQLTokenId.BLOCK_COMMENT;
                partType = PartType.START;
                break;
            }
            case 6: {
                sQLTokenId = SQLTokenId.INCOMPLETE_STRING;
                partType = PartType.START;
                break;
            }
            case 27: 
            case 28: {
                sQLTokenId = SQLTokenId.INT_LITERAL;
                break;
            }
            case 30: {
                sQLTokenId = SQLTokenId.DOUBLE_LITERAL;
                break;
            }
            case 33: {
                sQLTokenId = SQLTokenId.DOT;
                break;
            }
            case 11: {
                sQLTokenId = SQLTokenId.OPERATOR;
                break;
            }
            case 13: {
                sQLTokenId = SQLTokenId.OPERATOR;
            }
        }
        if (sQLTokenId != null) {
            this.state = 1;
            return this.factory.createToken((TokenId)sQLTokenId, this.input.readLength(), partType);
        }
        if (this.state != 1) {
            throw new IllegalStateException("Unhandled state " + this.state + " at end of file");
        }
        return null;
    }

    public Object state() {
        return null;
    }

    public void release() {
    }

    private static boolean isStartQuoteChar(int n) {
        return n == 34 || n == 96 || n == 91;
    }

    private static boolean isEndQuoteChar(int n, int n2) {
        return n == 34 && n2 == n || n == 96 && n2 == n || n == 91 && n2 == 93;
    }

    private static SQLTokenId testKeyword(CharSequence charSequence) {
        if (SQLKeywords.isSQL99Keyword((String)((Object)charSequence).toString())) {
            return SQLTokenId.KEYWORD;
        }
        return SQLTokenId.IDENTIFIER;
    }
}

