/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.config;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.common.api.OriginalCMPMapping;
import org.netbeans.modules.j2ee.deployment.config.J2eeModuleAccessor;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeApplication;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.execution.ModuleConfigurationProvider;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ContextRootConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DatasourceConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DeploymentPlanConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.EjbResourceConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.MappingConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.MessageDestinationConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfigurationFactory;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigSupportImpl
implements J2eeModuleProvider.ConfigSupport,
ModuleConfigurationProvider {
    private static final File[] EMPTY_FILE_LIST = new File[0];
    private static final String GENERIC_EXTENSION = ".dpf";
    private String configurationPrimaryFileName = null;
    private Map relativePaths = null;
    private Map allRelativePaths = null;
    private final J2eeModuleProvider provider;
    private final J2eeModule j2eeModule;
    private Server server;
    private ServerInstance instance;
    private ModuleConfiguration moduleConfiguration;

    public ConfigSupportImpl(J2eeModuleProvider j2eeModuleProvider) {
        String string;
        this.provider = j2eeModuleProvider;
        this.j2eeModule = j2eeModuleProvider.getJ2eeModule();
        J2eeModuleAccessor.getDefault().setJ2eeModuleProvider(this.j2eeModule, j2eeModuleProvider);
        String string2 = j2eeModuleProvider.getServerInstanceID();
        if (string2 != null) {
            this.instance = ServerRegistry.getInstance().getServerInstance(string2);
            if (this.instance != null) {
                this.server = this.instance.getServer();
            }
        }
        if (this.server == null && (string = j2eeModuleProvider.getServerID()) != null) {
            this.server = ServerRegistry.getInstance().getServer(string);
        }
    }

    public File getConfigurationFile() {
        try {
            return this.getDeploymentPlanFileForDistribution();
        }
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.INFO, null, exception);
            return null;
        }
    }

    public static File[] getDeploymentConfigurationFiles(J2eeModuleProvider j2eeModuleProvider, Server server) {
        return ConfigSupportImpl.getDeploymentConfigurationFiles(j2eeModuleProvider, server, false);
    }

    public static FileObject[] getConfigurationFiles(J2eeModuleProvider j2eeModuleProvider) {
        Collection<Server> collection = ServerRegistry.getInstance().getServers();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (Server server : collection) {
            File[] fileArray = ConfigSupportImpl.getDeploymentConfigurationFiles(j2eeModuleProvider, server, true);
            for (int i = 0; i < fileArray.length; ++i) {
                arrayList.add(FileUtil.toFileObject((File)fileArray[i]));
            }
        }
        return arrayList.toArray(new FileObject[arrayList.size()]);
    }

    public String getDeploymentName() {
        try {
            String string;
            File file;
            FileObject fileObject = this.getProvider().getJ2eeModule().getContentDirectory();
            if (fileObject == null && (file = this.j2eeModule.getDeploymentConfigurationFile(string = this.getPrimaryConfigurationFileName())) != null) {
                fileObject = FileUtil.toFileObject((File)file);
            }
            if (fileObject == null) {
                return null;
            }
            string = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (string != null) {
                return string.getProjectDirectory().getNameExt();
            }
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, null, iOException);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.server != null) {
            ModuleConfiguration moduleConfiguration = null;
            ConfigSupportImpl configSupportImpl = this;
            synchronized (configSupportImpl) {
                moduleConfiguration = this.moduleConfiguration;
            }
            if (moduleConfiguration != null) {
                moduleConfiguration.dispose();
            }
        }
    }

    @Override
    public boolean createInitialConfiguration() {
        return this.getModuleConfiguration() != null;
    }

    @Override
    public boolean ensureConfigurationReady() {
        return this.getModuleConfiguration() != null;
    }

    @Override
    public String getWebContextRoot() {
        if (!this.getProvider().getJ2eeModule().getModuleType().equals(J2eeModule.WAR)) {
            Logger.getLogger("global").log(Level.INFO, "getWebContextRoot called on other module type then WAR");
            return null;
        }
        if (this.server == null) {
            return null;
        }
        ModuleConfiguration moduleConfiguration = this.getModuleConfiguration();
        if (moduleConfiguration == null) {
            return null;
        }
        try {
            ContextRootConfiguration contextRootConfiguration = (ContextRootConfiguration)moduleConfiguration.getLookup().lookup(ContextRootConfiguration.class);
            if (contextRootConfiguration != null) {
                return contextRootConfiguration.getContextRoot();
            }
        }
        catch (ConfigurationException configurationException) {
            Logger.getLogger("global").log(Level.INFO, null, configurationException);
        }
        return null;
    }

    @Override
    public void setWebContextRoot(String string) {
        if (!this.getProvider().getJ2eeModule().getModuleType().equals(J2eeModule.WAR)) {
            Logger.getLogger("global").log(Level.INFO, "setWebContextRoot called on other module type then WAR");
            return;
        }
        if (this.server == null) {
            return;
        }
        ModuleConfiguration moduleConfiguration = this.getModuleConfiguration();
        if (moduleConfiguration == null) {
            return;
        }
        try {
            ContextRootConfiguration contextRootConfiguration = (ContextRootConfiguration)moduleConfiguration.getLookup().lookup(ContextRootConfiguration.class);
            if (contextRootConfiguration != null) {
                contextRootConfiguration.setContextRoot(string);
            }
        }
        catch (ConfigurationException configurationException) {
            Logger.getLogger("global").log(Level.INFO, null, configurationException);
        }
    }

    @Override
    public String[] getDeploymentConfigurationFileNames() {
        if (this.server == null) {
            return new String[0];
        }
        if (this.hasCustomSupport()) {
            return this.getRelativePaths().keySet().toArray(new String[this.relativePaths.size()]);
        }
        return new String[]{this.getStandardDeploymentPlanName()};
    }

    @Override
    public String getContentRelativePath(String string) {
        if (!this.hasCustomSupport()) {
            return string;
        }
        return (String)this.getAllRelativePaths().get(string);
    }

    @Override
    public void setCMPMappingInfo(OriginalCMPMapping[] originalCMPMappingArray) throws ConfigurationException {
        if (this.server == null) {
            return;
        }
        ModuleConfiguration moduleConfiguration = this.getModuleConfiguration();
        if (moduleConfiguration == null) {
            return;
        }
        MappingConfiguration mappingConfiguration = (MappingConfiguration)moduleConfiguration.getLookup().lookup(MappingConfiguration.class);
        if (mappingConfiguration != null) {
            mappingConfiguration.setMappingInfo(originalCMPMappingArray);
        }
    }

    @Override
    public void setCMPResource(String string, String string2) throws ConfigurationException {
        Parameters.notNull((CharSequence)"ejbName", (Object)string);
        Parameters.notNull((CharSequence)"jndiName", (Object)string2);
        if (this.server == null) {
            return;
        }
        ModuleConfiguration moduleConfiguration = this.getModuleConfiguration();
        if (moduleConfiguration == null) {
            return;
        }
        MappingConfiguration mappingConfiguration = (MappingConfiguration)moduleConfiguration.getLookup().lookup(MappingConfiguration.class);
        if (mappingConfiguration != null) {
            mappingConfiguration.setCMPResource(string, string2);
        }
    }

    @Override
    public Set<Datasource> getDatasources() throws ConfigurationException {
        DatasourceConfiguration datasourceConfiguration;
        ModuleConfiguration moduleConfiguration;
        Set<Datasource> set = Collections.emptySet();
        if (this.server != null && (moduleConfiguration = this.getModuleConfiguration()) != null && (datasourceConfiguration = (DatasourceConfiguration)moduleConfiguration.getLookup().lookup(DatasourceConfiguration.class)) != null) {
            set = datasourceConfiguration.getDatasources();
        }
        return set;
    }

    @Override
    public boolean isDatasourceCreationSupported() {
        DatasourceConfiguration datasourceConfiguration;
        if (this.server == null) {
            return false;
        }
        ModuleConfiguration moduleConfiguration = this.getModuleConfiguration();
        if (moduleConfiguration != null && (datasourceConfiguration = (DatasourceConfiguration)moduleConfiguration.getLookup().lookup(DatasourceConfiguration.class)) != null) {
            return datasourceConfiguration.supportsCreateDatasource();
        }
        return false;
    }

    @Override
    public Datasource createDatasource(String string, String string2, String string3, String string4, String string5) throws UnsupportedOperationException, DatasourceAlreadyExistsException {
        DatasourceConfiguration datasourceConfiguration;
        ModuleConfiguration moduleConfiguration;
        Datasource datasource = null;
        if (this.server != null && (moduleConfiguration = this.getModuleConfiguration()) != null && (datasourceConfiguration = (DatasourceConfiguration)moduleConfiguration.getLookup().lookup(DatasourceConfiguration.class)) != null) {
            try {
                datasource = datasourceConfiguration.createDatasource(string, string2, string3, string4, string5);
            }
            catch (ConfigurationException configurationException) {
                Logger.getLogger("global").log(Level.INFO, null, configurationException);
            }
        }
        return datasource;
    }

    @Override
    public void bindDatasourceReference(String string, String string2) throws ConfigurationException {
        DatasourceConfiguration datasourceConfiguration;
        ModuleConfiguration moduleConfiguration;
        Parameters.notNull((CharSequence)"referenceName", (Object)string);
        Parameters.notNull((CharSequence)"jndiName", (Object)string2);
        if (this.server != null && (moduleConfiguration = this.getModuleConfiguration()) != null && (datasourceConfiguration = (DatasourceConfiguration)moduleConfiguration.getLookup().lookup(DatasourceConfiguration.class)) != null) {
            datasourceConfiguration.bindDatasourceReference(string, string2);
        }
    }

    @Override
    public void bindDatasourceReferenceForEjb(String string, String string2, String string3, String string4) throws ConfigurationException {
        DatasourceConfiguration datasourceConfiguration;
        ModuleConfiguration moduleConfiguration;
        Parameters.notNull((CharSequence)"ejbName", (Object)string);
        Parameters.notNull((CharSequence)"ejbType", (Object)string2);
        Parameters.notNull((CharSequence)"referenceName", (Object)string3);
        Parameters.notNull((CharSequence)"jndiName", (Object)string4);
        if (!("Session".equals(string2) || "Entity".equals(string2) || "MessageDriven".equals(string2))) {
            throw new IllegalArgumentException("ejbType parameter doesn't have an allowed value.");
        }
        if (this.server != null && (moduleConfiguration = this.getModuleConfiguration()) != null && (datasourceConfiguration = (DatasourceConfiguration)moduleConfiguration.getLookup().lookup(DatasourceConfiguration.class)) != null) {
            datasourceConfiguration.bindDatasourceReferenceForEjb(string, string2, string3, string4);
        }
    }

    @Override
    public String findDatasourceJndiName(String string) throws ConfigurationException {
        DatasourceConfiguration datasourceConfiguration;
        ModuleConfiguration moduleConfiguration;
        Parameters.notNull((CharSequence)"referenceName", (Object)string);
        String string2 = null;
        if (this.server != null && (moduleConfiguration = this.getModuleConfiguration()) != null && (datasourceConfiguration = (DatasourceConfiguration)moduleConfiguration.getLookup().lookup(DatasourceConfiguration.class)) != null) {
            string2 = datasourceConfiguration.findDatasourceJndiName(string);
        }
        return string2;
    }

    @Override
    public String findDatasourceJndiNameForEjb(String string, String string2) throws ConfigurationException {
        DatasourceConfiguration datasourceConfiguration;
        ModuleConfiguration moduleConfiguration;
        Parameters.notNull((CharSequence)"ejbName", (Object)string);
        Parameters.notNull((CharSequence)"referenceName", (Object)string2);
        String string3 = null;
        if (this.server != null && (moduleConfiguration = this.getModuleConfiguration()) != null && (datasourceConfiguration = (DatasourceConfiguration)moduleConfiguration.getLookup().lookup(DatasourceConfiguration.class)) != null) {
            string3 = datasourceConfiguration.findDatasourceJndiNameForEjb(string, string2);
        }
        return string3;
    }

    @Override
    public Datasource findDatasource(String string) throws ConfigurationException {
        Parameters.notNull((CharSequence)"jndiName", (Object)string);
        Set<Datasource> set = this.getDatasources();
        for (Datasource datasource : set) {
            if (!string.equals(datasource.getJndiName())) continue;
            return datasource;
        }
        set = this.provider.getServerDatasources();
        for (Datasource datasource : set) {
            if (!string.equals(datasource.getJndiName())) continue;
            return datasource;
        }
        return null;
    }

    @Override
    public Set<MessageDestination> getMessageDestinations() throws ConfigurationException {
        MessageDestinationConfiguration messageDestinationConfiguration;
        ModuleConfiguration moduleConfiguration;
        Set<MessageDestination> set = Collections.emptySet();
        if (this.server != null && (moduleConfiguration = this.getModuleConfiguration()) != null && (messageDestinationConfiguration = (MessageDestinationConfiguration)moduleConfiguration.getLookup().lookup(MessageDestinationConfiguration.class)) != null) {
            set = messageDestinationConfiguration.getMessageDestinations();
        }
        return set;
    }

    @Override
    public Set<MessageDestination> getServerMessageDestinations() throws ConfigurationException {
        ServerInstance serverInstance = ServerRegistry.getInstance().getServerInstance(this.provider.getServerInstanceID());
        if (serverInstance == null) {
            Logger.getLogger("global").log(Level.WARNING, "The server data sources cannot be retrieved because the server instance cannot be found.");
            return Collections.emptySet();
        }
        return serverInstance.getMessageDestinations();
    }

    @Override
    public boolean supportsCreateMessageDestination() {
        MessageDestinationConfiguration messageDestinationConfiguration;
        if (this.server == null) {
            return false;
        }
        ModuleConfiguration moduleConfiguration = this.getModuleConfiguration();
        if (moduleConfiguration != null && (messageDestinationConfiguration = (MessageDestinationConfiguration)moduleConfiguration.getLookup().lookup(MessageDestinationConfiguration.class)) != null) {
            return messageDestinationConfiguration.supportsCreateMessageDestination();
        }
        return false;
    }

    @Override
    public MessageDestination createMessageDestination(String string, MessageDestination.Type type) throws UnsupportedOperationException, ConfigurationException {
        Parameters.notNull((CharSequence)"name", (Object)string);
        Parameters.notNull((CharSequence)"type", (Object)((Object)type));
        if (this.server == null) {
            return null;
        }
        ModuleConfiguration moduleConfiguration = this.getModuleConfiguration();
        if (moduleConfiguration == null) {
            return null;
        }
        MessageDestinationConfiguration messageDestinationConfiguration = (MessageDestinationConfiguration)moduleConfiguration.getLookup().lookup(MessageDestinationConfiguration.class);
        if (messageDestinationConfiguration != null) {
            return messageDestinationConfiguration.createMessageDestination(string, type);
        }
        return null;
    }

    @Override
    public void bindMdbToMessageDestination(String string, String string2, MessageDestination.Type type) throws ConfigurationException {
        Parameters.notNull((CharSequence)"mdbName", (Object)string);
        Parameters.notNull((CharSequence)"name", (Object)string2);
        Parameters.notNull((CharSequence)"type", (Object)((Object)type));
        ModuleConfiguration moduleConfiguration = this.getModuleConfiguration();
        if (this.server == null || moduleConfiguration == null) {
            return;
        }
        MessageDestinationConfiguration messageDestinationConfiguration = (MessageDestinationConfiguration)moduleConfiguration.getLookup().lookup(MessageDestinationConfiguration.class);
        if (messageDestinationConfiguration != null) {
            messageDestinationConfiguration.bindMdbToMessageDestination(string, string2, type);
        }
    }

    @Override
    public String findMessageDestinationName(String string) throws ConfigurationException {
        Parameters.notNull((CharSequence)"mdbName", (Object)string);
        ModuleConfiguration moduleConfiguration = this.getModuleConfiguration();
        if (this.server == null || moduleConfiguration == null) {
            return null;
        }
        MessageDestinationConfiguration messageDestinationConfiguration = (MessageDestinationConfiguration)moduleConfiguration.getLookup().lookup(MessageDestinationConfiguration.class);
        if (messageDestinationConfiguration != null) {
            return messageDestinationConfiguration.findMessageDestinationName(string);
        }
        return null;
    }

    @Override
    public MessageDestination findMessageDestination(String string) throws ConfigurationException {
        Parameters.notNull((CharSequence)"name", (Object)string);
        Set<MessageDestination> set = this.getMessageDestinations();
        for (MessageDestination messageDestination : set) {
            if (!string.equals(messageDestination.getName())) continue;
            return messageDestination;
        }
        set = this.provider.getConfigSupport().getServerMessageDestinations();
        for (MessageDestination messageDestination : set) {
            if (!string.equals(messageDestination.getName())) continue;
            return messageDestination;
        }
        return null;
    }

    @Override
    public void bindMessageDestinationReference(String string, String string2, String string3, MessageDestination.Type type) throws ConfigurationException {
        Parameters.notNull((CharSequence)"referenceName", (Object)string);
        Parameters.notNull((CharSequence)"connectionFactoryName", (Object)string2);
        Parameters.notNull((CharSequence)"destName", (Object)string3);
        Parameters.notNull((CharSequence)"type", (Object)((Object)type));
        ModuleConfiguration moduleConfiguration = this.getModuleConfiguration();
        if (this.server == null || moduleConfiguration == null) {
            return;
        }
        MessageDestinationConfiguration messageDestinationConfiguration = (MessageDestinationConfiguration)moduleConfiguration.getLookup().lookup(MessageDestinationConfiguration.class);
        if (messageDestinationConfiguration != null) {
            messageDestinationConfiguration.bindMessageDestinationReference(string, string2, string3, type);
        }
    }

    @Override
    public void bindMessageDestinationReferenceForEjb(String string, String string2, String string3, String string4, String string5, MessageDestination.Type type) throws ConfigurationException {
        Parameters.notNull((CharSequence)"ejbName", (Object)string);
        Parameters.notNull((CharSequence)"ejbType", (Object)string2);
        Parameters.notNull((CharSequence)"referenceName", (Object)string3);
        Parameters.notNull((CharSequence)"connectionFactoryName", (Object)string4);
        Parameters.notNull((CharSequence)"destName", (Object)string5);
        Parameters.notNull((CharSequence)"type", (Object)((Object)type));
        if (!("Session".equals(string2) || "Entity".equals(string2) || "MessageDriven".equals(string2))) {
            throw new IllegalArgumentException("ejbType parameter doesn't have an allowed value.");
        }
        ModuleConfiguration moduleConfiguration = this.getModuleConfiguration();
        if (this.server == null || moduleConfiguration == null) {
            return;
        }
        MessageDestinationConfiguration messageDestinationConfiguration = (MessageDestinationConfiguration)moduleConfiguration.getLookup().lookup(MessageDestinationConfiguration.class);
        if (messageDestinationConfiguration != null) {
            messageDestinationConfiguration.bindMessageDestinationReferenceForEjb(string, string2, string3, string4, string5, type);
        }
    }

    @Override
    public String findJndiNameForEjb(String string) throws ConfigurationException {
        Parameters.notNull((CharSequence)"ejbName", (Object)string);
        ModuleConfiguration moduleConfiguration = this.getModuleConfiguration();
        if (this.server == null || moduleConfiguration == null) {
            return null;
        }
        EjbResourceConfiguration ejbResourceConfiguration = (EjbResourceConfiguration)moduleConfiguration.getLookup().lookup(EjbResourceConfiguration.class);
        if (ejbResourceConfiguration != null) {
            return ejbResourceConfiguration.findJndiNameForEjb(string);
        }
        return null;
    }

    @Override
    public void bindEjbReference(String string, String string2) throws ConfigurationException {
        Parameters.notNull((CharSequence)"referenceName", (Object)string);
        Parameters.notNull((CharSequence)"referencedEjbName", (Object)string2);
        ModuleConfiguration moduleConfiguration = this.getModuleConfiguration();
        if (this.server == null || moduleConfiguration == null) {
            return;
        }
        EjbResourceConfiguration ejbResourceConfiguration = (EjbResourceConfiguration)moduleConfiguration.getLookup().lookup(EjbResourceConfiguration.class);
        if (ejbResourceConfiguration != null) {
            ejbResourceConfiguration.bindEjbReference(string, string2);
        }
    }

    @Override
    public void bindEjbReferenceForEjb(String string, String string2, String string3, String string4) throws ConfigurationException {
        Parameters.notNull((CharSequence)"ejbName", (Object)string);
        Parameters.notNull((CharSequence)"ejbType", (Object)string2);
        Parameters.notNull((CharSequence)"referenceName", (Object)string3);
        Parameters.notNull((CharSequence)"referencedEjbName", (Object)string4);
        if (!("Session".equals(string2) || "Entity".equals(string2) || "MessageDriven".equals(string2))) {
            throw new IllegalArgumentException("ejbType parameter doesn't have an allowed value.");
        }
        ModuleConfiguration moduleConfiguration = this.getModuleConfiguration();
        if (this.server == null || moduleConfiguration == null) {
            return;
        }
        EjbResourceConfiguration ejbResourceConfiguration = (EjbResourceConfiguration)moduleConfiguration.getLookup().lookup(EjbResourceConfiguration.class);
        if (ejbResourceConfiguration != null) {
            ejbResourceConfiguration.bindEjbReferenceForEjb(string, string2, string3, string4);
        }
    }

    @Override
    public synchronized ModuleConfiguration getModuleConfiguration() {
        if (this.moduleConfiguration == null) {
            try {
                if (this.server == null) {
                    return null;
                }
                ModuleConfigurationFactory moduleConfigurationFactory = this.server.getModuleConfigurationFactory();
                this.moduleConfiguration = moduleConfigurationFactory.create(this.j2eeModule);
            }
            catch (ConfigurationException configurationException) {
                Logger.getLogger("global").log(Level.INFO, null, configurationException);
                return null;
            }
        }
        return this.moduleConfiguration;
    }

    @Override
    public J2eeModule getJ2eeModule(String string) {
        if (this.j2eeModule instanceof J2eeApplication) {
            if (string == null) {
                return this.j2eeModule;
            }
            for (J2eeModule j2eeModule : ((J2eeApplication)this.j2eeModule).getModules()) {
                if (!string.equals(j2eeModule.getUrl())) continue;
                return j2eeModule;
            }
        }
        return this.j2eeModule;
    }

    private static File[] getDeploymentConfigurationFiles(J2eeModuleProvider j2eeModuleProvider, Server server, boolean bl) {
        String[] stringArray;
        if (j2eeModuleProvider == null || server == null) {
            return new File[0];
        }
        ModuleType moduleType = (ModuleType)j2eeModuleProvider.getJ2eeModule().getModuleType();
        if (ConfigSupportImpl.hasCustomSupport(server, moduleType)) {
            stringArray = server.getDeploymentPlanFiles(moduleType);
        } else if (server.supportsModuleType(moduleType)) {
            stringArray = new String[]{ConfigSupportImpl.getStandardDeploymentPlanName(server)};
        } else {
            return EMPTY_FILE_LIST;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(stringArray[i]);
            String string = file.getName();
            File file2 = j2eeModuleProvider.getJ2eeModule().getDeploymentConfigurationFile(string);
            if (file2 == null || bl && !file2.exists()) continue;
            arrayList.add(file2);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getDeploymentPlanFileForDistribution() throws IOException, ConfigurationException {
        if (this.server == null) {
            String string = NbBundle.getMessage(ConfigSupportImpl.class, (String)"MSG_NoTargetSelected");
            throw new ConfigurationException(string);
        }
        FileLock fileLock = null;
        OutputStream outputStream = null;
        try {
            DeploymentPlanConfiguration deploymentPlanConfiguration;
            FileObject fileObject = this.getProvider().getJ2eeModule().getContentDirectory();
            String string = this.getStandardDeploymentPlanName();
            FileObject fileObject2 = null;
            if (fileObject != null) {
                fileObject2 = fileObject.getFileObject(string);
                if (fileObject2 == null) {
                    fileObject2 = fileObject.createData(string);
                }
            } else {
                File file = null;
                return file;
            }
            fileLock = fileObject2.lock();
            outputStream = fileObject2.getOutputStream(fileLock);
            ModuleConfiguration moduleConfiguration = this.getModuleConfiguration();
            if (moduleConfiguration != null && (deploymentPlanConfiguration = (DeploymentPlanConfiguration)moduleConfiguration.getLookup().lookup(DeploymentPlanConfiguration.class)) != null) {
                deploymentPlanConfiguration.save(outputStream);
                File file = FileUtil.toFile((FileObject)fileObject2);
                return file;
            }
            deploymentPlanConfiguration = null;
            return deploymentPlanConfiguration;
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, iOException.toString());
            }
        }
    }

    private String getPrimaryConfigurationFileName() {
        this.getRelativePaths();
        if (this.configurationPrimaryFileName == null) {
            return this.getStandardDeploymentPlanName();
        }
        return this.configurationPrimaryFileName;
    }

    private String getStandardDeploymentPlanName() {
        return ConfigSupportImpl.getStandardDeploymentPlanName(this.server);
    }

    private static String getStandardDeploymentPlanName(Server server) {
        return server.getShortName() + GENERIC_EXTENSION;
    }

    private FileObject findPrimaryConfigurationFO() throws IOException {
        String string = this.getPrimaryConfigurationFileName();
        File file = this.j2eeModule.getDeploymentConfigurationFile(string);
        return FileUtil.toFileObject((File)file);
    }

    private ModuleType getModuleType() {
        return (ModuleType)this.getProvider().getJ2eeModule().getModuleType();
    }

    private boolean hasCustomSupport() {
        return ConfigSupportImpl.hasCustomSupport(this.server, this.getModuleType());
    }

    private static boolean hasCustomSupport(Server server, ModuleType moduleType) {
        if (server == null || server.getModuleConfigurationFactory() == null) {
            return false;
        }
        return server.getDeploymentPlanFiles(moduleType) != null;
    }

    private J2eeModuleProvider getProvider() {
        return this.provider;
    }

    private Map getRelativePaths() {
        if (this.relativePaths != null) {
            return this.relativePaths;
        }
        this.relativePaths = new HashMap();
        if (this.hasCustomSupport()) {
            String[] stringArray = this.server.getDeploymentPlanFiles(this.getModuleType());
            this.configurationPrimaryFileName = stringArray[0].substring(stringArray[0].lastIndexOf("/") + 1);
            this.collectData(this.server, this.relativePaths);
        }
        return this.relativePaths;
    }

    private void collectData(Server server, Map map) {
        if (!ConfigSupportImpl.hasCustomSupport(server, this.getModuleType())) {
            return;
        }
        String[] stringArray = server.getDeploymentPlanFiles(this.getModuleType());
        stringArray = stringArray == null ? new String[]{} : stringArray;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].substring(stringArray[i].lastIndexOf("/") + 1);
            map.put(string, stringArray[i]);
        }
    }

    private Map getAllRelativePaths() {
        if (this.allRelativePaths != null) {
            return this.allRelativePaths;
        }
        this.allRelativePaths = new HashMap();
        Collection<Server> collection = ServerRegistry.getInstance().getServers();
        for (Server server : collection) {
            this.collectData(server, this.allRelativePaths);
        }
        return this.allRelativePaths;
    }
}

