/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.coloring;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.html.parser.SyntaxElement;
import org.netbeans.editor.ext.html.parser.SyntaxParserListener;
import org.netbeans.modules.editor.NbEditorUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddingUpdater
implements SyntaxParserListener {
    private static final String JAVASCRIPT_MIMETYPE = "text/javascript";
    private static final String JAVASCRIPT_HREF_PREFIX = "javascript:";
    private static final String CSS_INLINED_MIMETYPE = "text/x-css";
    private static final Logger LOGGER = Logger.getLogger(EmbeddingUpdater.class.getName());
    private final Document doc;
    private LanguagePath languagePath;

    public EmbeddingUpdater(Document document) {
        this.doc = document;
        String string = NbEditorUtilities.getMimeType((Document)document);
        if (string == null) {
            throw new IllegalArgumentException("Cannot determine document mimetype " + document);
        }
        Language language = Language.find((String)string);
        if (language == null) {
            throw new IllegalArgumentException("Cannot find language " + string);
        }
        this.languagePath = "text/html".equals(string) ? LanguagePath.get((Language)language) : LanguagePath.get((LanguagePath)LanguagePath.get((Language)language), (Language)Language.find((String)"text/html"));
    }

    public void parsingFinished(List<SyntaxElement> list) {
        for (SyntaxElement syntaxElement : list) {
            if (syntaxElement.type() != 4) continue;
            this.startTag((SyntaxElement.Tag)syntaxElement);
        }
    }

    private void startTag(SyntaxElement.Tag tag) {
        Object object;
        if ("a".equalsIgnoreCase(tag.getName()) && (object = tag.getAttribute("href")) != null) {
            boolean bl;
            String string = this.unquote(object.getValue());
            boolean bl2 = bl = object.getValue().length() > 0 && this.isQuotationChar(object.getValue().charAt(0));
            if (string.startsWith(JAVASCRIPT_HREF_PREFIX)) {
                this.createEmbedding(JAVASCRIPT_MIMETYPE, object.getValueOffset(), object.getValueOffset() + object.getValue().length(), JAVASCRIPT_HREF_PREFIX.length() + (bl ? 1 : 0), bl ? 1 : 0);
            }
        }
        for (String string : tag.getAttributes()) {
            if ("style".equalsIgnoreCase(string.getName())) {
                this.createEmbedding(CSS_INLINED_MIMETYPE, (SyntaxElement.TagAttribute)string);
                continue;
            }
            if (!string.getName().startsWith("on") && !string.getName().startsWith("ON")) continue;
            this.createEmbedding(JAVASCRIPT_MIMETYPE, (SyntaxElement.TagAttribute)string);
        }
    }

    private String unquote(String string) {
        if (string.length() == 0) {
            return string;
        }
        if (this.isQuotationChar(string.charAt(0))) {
            string = string.substring(1);
        }
        if (string.length() == 0) {
            return string;
        }
        if (this.isQuotationChar(string.charAt(string.length() - 1))) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private boolean isQuotationChar(char c) {
        return c == '\"' || c == '\'';
    }

    private void createEmbedding(String string, SyntaxElement.TagAttribute tagAttribute) {
        if (tagAttribute.getValue().length() > 0 && (tagAttribute.getValue().charAt(0) == '\'' || tagAttribute.getValue().charAt(0) == '\"')) {
            this.createEmbedding(string, tagAttribute.getValueOffset(), tagAttribute.getValueOffset() + tagAttribute.getValueLength(), 1, 1);
        } else {
            this.createEmbedding(string, tagAttribute.getValueOffset(), tagAttribute.getValueOffset() + tagAttribute.getValueLength(), 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEmbedding(String string, int n, int n2, int n3, int n4) {
        if (n >= n2) {
            LOGGER.log(Level.WARNING, "startOffset >= endOffset: " + n + " >= " + n2);
            return;
        }
        Language language = Language.find((String)string);
        if (language == null) {
            LOGGER.log(Level.WARNING, "No " + string + " language found! (" + n + " - " + n2 + ")");
            return;
        }
        ((BaseDocument)this.doc).extWriteLock();
        try {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.doc);
            List list = tokenHierarchy.tokenSequenceList(this.languagePath, n, n2);
            boolean bl = true;
            boolean bl2 = false;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                TokenSequence tokenSequence = (TokenSequence)iterator.next();
                tokenSequence.move(n);
                if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                    return;
                }
                if (tokenSequence.offset() < n || tokenSequence.offset() > n2) continue;
                do {
                    boolean bl3;
                    boolean bl4;
                    Token token;
                    if ((token = tokenSequence.token()) == null) {
                        LOGGER.log(Level.FINE, "Please refer to issue #126628: tokenSequence.token() returned null after tokenSequence.moveNext/Previous() called! This seems to be a bug in lexer. Please attach the info dumped into the log, the document and possibly steps to reproduce.");
                        LOGGER.log(Level.FINE, "TokenSequence:\n" + tokenSequence.toString());
                    }
                    bl2 = !(bl4 = tokenSequence.moveNext()) || tokenSequence.offset() >= n2;
                    boolean bl5 = bl3 = !iterator.hasNext();
                    if (bl4) {
                        tokenSequence.movePrevious();
                    }
                    if (tokenSequence.embedded(language) == null) {
                        CharSequence charSequence;
                        if (!tokenSequence.createEmbedding(language, bl ? n3 : 0, bl2 && bl3 ? n4 : 0, true)) {
                            charSequence = token.text();
                            if (charSequence == null) {
                                LOGGER.log(Level.FINE, null, new IllegalStateException("Please refer to issue #126628: Token.text() of " + token.toString() + " == null without any previous modification of the underlying document! This seems to be a bug in lexer. Please attach the info dumped into the log, the document and possibly steps to reproduce."));
                                LOGGER.log(Level.FINE, "TokenSequence:\n" + tokenSequence.toString());
                            } else {
                                LOGGER.log(Level.FINE, "Cannot create embedding for " + string + " [" + n + " - " + n2 + "] (" + charSequence + ")\n");
                            }
                        } else {
                            charSequence = token.text();
                            if (charSequence == null) {
                                LOGGER.log(Level.FINE, null, new IllegalStateException("Token.text() of " + token.toString() + " == null without any previous modification of the underlying document! This seems to be a bug in lexer. Please report the issue to lexer module and attach the info dumped into the log, the document and possibly steps to reproduce."));
                                LOGGER.log(Level.FINE, "TokenSequence:\n" + tokenSequence.toString());
                            } else {
                                LOGGER.log(Level.FINE, "Embedding for " + string + " created [" + n + " - " + n2 + "] (" + this.printEmbeddedText(charSequence, bl ? n3 : 0, bl2 && bl3 ? n4 : 0) + ")\n");
                            }
                        }
                    }
                    bl = false;
                    if (bl2) continue;
                    tokenSequence.moveNext();
                } while (!bl2);
            }
        }
        finally {
            ((BaseDocument)this.doc).extWriteUnlock();
        }
    }

    private CharSequence printEmbeddedText(CharSequence charSequence, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(charSequence);
        if (n >= 0) {
            stringBuffer.insert(n, '[');
        }
        if (n2 >= 0) {
            stringBuffer.insert(stringBuffer.length() - n2, ']');
        }
        return stringBuffer;
    }
}

