/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbGroup;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class EjbDataSourcePropertiesPanel
extends JPanel {
    private EjbGroup ejbGrp;
    private JLabel containerTypeLabel;
    private JTextField containerTypeTextField;
    private JPanel fillPanel;
    private JLabel iiopPortLabel;
    private JTextField iiopPortTextField;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JLabel serverHostLabel;
    private JTextField serverHostTextField;

    public EjbDataSourcePropertiesPanel() {
        this.initComponents();
    }

    public void clear() {
        this.nameTextField.setText("");
        this.containerTypeTextField.setText("");
        this.serverHostTextField.setText("");
        this.iiopPortTextField.setText("");
    }

    public void setDataSourceProperties(EjbGroup ejbGroup) {
        this.ejbGrp = ejbGroup;
        this.nameTextField.setText(ejbGroup.getName());
        this.containerTypeTextField.setText(ejbGroup.getAppServerVendor());
        this.serverHostTextField.setText(ejbGroup.getServerHost());
        this.iiopPortTextField.setText(Integer.toString(ejbGroup.getIIOPPort()));
    }

    public boolean saveChange() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.validateData(stringBuffer)) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)stringBuffer.toString(), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return false;
        }
        this.ejbGrp.setName(this.getName());
        this.ejbGrp.setServerHost(this.getServerHost());
        this.ejbGrp.setIIOPPort(Integer.parseInt(this.getIIOPPort()));
        return true;
    }

    public String getName() {
        if (this.nameTextField == null) {
            return "";
        }
        return this.nameTextField.getText().trim();
    }

    public String getServerHost() {
        return this.serverHostTextField.getText().trim();
    }

    public String getIIOPPort() {
        return this.iiopPortTextField.getText();
    }

    private boolean validateData(StringBuffer stringBuffer) {
        boolean bl = true;
        if (this.getName() == null || this.getName().length() == 0) {
            if (bl) {
                this.nameTextField.requestFocus();
                bl = false;
            }
            stringBuffer.append(NbBundle.getMessage(EjbDataSourcePropertiesPanel.class, (String)"EMPTY_GROUP_NAME"));
            stringBuffer.append("\n");
        }
        if (this.getServerHost() == null || this.getServerHost().length() == 0) {
            if (bl) {
                this.serverHostTextField.requestFocus();
                bl = false;
            }
            stringBuffer.append(NbBundle.getMessage(EjbDataSourcePropertiesPanel.class, (String)"EMPTY_SERVER_HOST"));
            stringBuffer.append("\n");
        } else if (this.getServerHost().indexOf(32) != -1) {
            if (bl) {
                this.serverHostTextField.requestFocus();
                this.serverHostTextField.selectAll();
                bl = false;
            }
            stringBuffer.append(NbBundle.getMessage(EjbDataSourcePropertiesPanel.class, (String)"SPACES_IN_SERVER_HOST", (Object)("'" + this.getServerHost() + "'")));
            stringBuffer.append("\n");
        }
        if (this.getIIOPPort() == null || this.getIIOPPort().length() == 0) {
            if (bl) {
                this.iiopPortTextField.requestFocus();
                bl = false;
            }
            stringBuffer.append(NbBundle.getMessage(EjbDataSourcePropertiesPanel.class, (String)"EMPTY_IIOP_PORT"));
            stringBuffer.append("\n");
        } else {
            try {
                int n = Integer.parseInt(this.getIIOPPort());
            }
            catch (NumberFormatException numberFormatException) {
                if (bl) {
                    this.iiopPortTextField.requestFocus();
                    this.iiopPortTextField.selectAll();
                    bl = false;
                }
                stringBuffer.append(NbBundle.getMessage(EjbDataSourcePropertiesPanel.class, (String)"IIOP_PORT_NOT_NUMBER"));
                stringBuffer.append("\n");
            }
        }
        return bl;
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.iiopPortLabel = new JLabel();
        this.iiopPortTextField = new JTextField();
        this.containerTypeLabel = new JLabel();
        this.containerTypeTextField = new JTextField();
        this.serverHostLabel = new JLabel();
        this.serverHostTextField = new JTextField();
        this.fillPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.nameLabel.setDisplayedMnemonic(NbBundle.getMessage(EjbDataSourcePropertiesPanel.class, (String)"EJB_GROUP_NAME_MNEMONIC").charAt(0));
        this.nameLabel.setHorizontalAlignment(2);
        this.nameLabel.setLabelFor(this.nameTextField);
        this.nameLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("EJB_GROUP_NAME_LABEL"));
        this.nameLabel.setPreferredSize(null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.nameLabel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("EJB_GROUP_NAME_DESC"));
        this.nameTextField.setMinimumSize(new Dimension(250, 20));
        this.nameTextField.setPreferredSize(null);
        this.nameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                EjbDataSourcePropertiesPanel.this.nameTextFieldFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.nameTextField, gridBagConstraints);
        this.nameTextField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("EJB_GROUP_NAME_DESC"));
        this.iiopPortLabel.setDisplayedMnemonic(NbBundle.getMessage(EjbDataSourcePropertiesPanel.class, (String)"IIOP_PORT_MNEMONIC_R").charAt(0));
        this.iiopPortLabel.setHorizontalAlignment(2);
        this.iiopPortLabel.setLabelFor(this.iiopPortTextField);
        this.iiopPortLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("IIOP_PORT_LABEL"));
        this.iiopPortLabel.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.iiopPortLabel, gridBagConstraints);
        this.iiopPortLabel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("IIOP_PORT_DESC"));
        this.iiopPortTextField.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        this.add((Component)this.iiopPortTextField, gridBagConstraints);
        this.iiopPortTextField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("IIOP_PORT_DESC"));
        this.containerTypeLabel.setDisplayedMnemonic(NbBundle.getMessage(EjbDataSourcePropertiesPanel.class, (String)"APP_SERVER_LABEL2_MNEMONIC").charAt(0));
        this.containerTypeLabel.setHorizontalAlignment(2);
        this.containerTypeLabel.setLabelFor(this.containerTypeTextField);
        this.containerTypeLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("APP_SERVER_LABEL2"));
        this.containerTypeLabel.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.containerTypeLabel, gridBagConstraints);
        this.containerTypeLabel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("APP_SERVER_DESC"));
        this.containerTypeTextField.setEditable(false);
        this.containerTypeTextField.setMinimumSize(new Dimension(250, 20));
        this.containerTypeTextField.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 5, 0, 0);
        this.add((Component)this.containerTypeTextField, gridBagConstraints);
        this.containerTypeTextField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("APP_SERVER_DESC"));
        this.serverHostLabel.setDisplayedMnemonic(NbBundle.getMessage(EjbDataSourcePropertiesPanel.class, (String)"SERVER_HOST_MNEMONIC").charAt(0));
        this.serverHostLabel.setHorizontalAlignment(2);
        this.serverHostLabel.setLabelFor(this.serverHostTextField);
        this.serverHostLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("SERVER_HOST_LABEL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.serverHostLabel, gridBagConstraints);
        this.serverHostLabel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("SERVER_HOST_DESC"));
        this.serverHostTextField.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 5, 0, 0);
        this.add((Component)this.serverHostTextField, gridBagConstraints);
        this.serverHostTextField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("SERVER_HOST_DESC"));
        this.fillPanel.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fillPanel, gridBagConstraints);
    }

    private void nameTextFieldFocusLost(FocusEvent focusEvent) {
    }
}

