/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component.customizers;

import com.sun.webui.jsf.model.Option;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.ResourceBundle;
import javax.faces.model.SelectItem;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class OptionsListPanel
extends JPanel {
    static ResourceBundle bundle = ResourceBundle.getBundle(OptionsListPanel.class.getPackage().getName() + ".Bundle-DT");
    private ItemsTableModel tableModel = new ItemsTableModel();
    private boolean acceptsMultipleChoice;
    private JPanel buttonsPanel;
    private JPanel checkBoxesPanel;
    private JScrollPane dataPane;
    private JTable dataTable;
    private JButton deleteButton;
    private JButton downButton;
    private JCheckBox multipleChoiceCheckBox;
    private JButton newButton;
    private JCheckBox selectValuesCheckBox;
    private JButton upButton;

    public OptionsListPanel() {
        this(false);
    }

    public OptionsListPanel(boolean acceptsMultipleChoice) {
        this.acceptsMultipleChoice = acceptsMultipleChoice;
        this.initComponents();
        SelectedCellEditor selectedCellEditor = new SelectedCellEditor(this.selectValuesCheckBox, this.multipleChoiceCheckBox);
        this.dataTable.setDefaultEditor(Boolean.class, selectedCellEditor);
    }

    private void initComponents() {
        this.dataPane = new JScrollPane();
        this.dataTable = new JTable(this.tableModel);
        this.dataTable.setSelectionMode(0);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(0);
        renderer.setBackground(new Color(212, 208, 200));
        this.dataTable.getTableHeader().setDefaultRenderer(renderer);
        JTextField textField = new JTextField();
        CellEditor stringEditor = new CellEditor(this.dataTable, textField);
        this.dataTable.setDefaultEditor(String.class, stringEditor);
        this.dataTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        ((DefaultCellEditor)this.dataTable.getDefaultEditor(String.class)).setClickCountToStart(1);
        this.dataTable.setDefaultRenderer(String.class, new HomogonousCellRenderer());
        SelectedCellRenderer booleanRenderer = new SelectedCellRenderer();
        this.dataTable.setDefaultRenderer(Boolean.class, booleanRenderer);
        this.buttonsPanel = new JPanel();
        this.newButton = new JButton();
        this.deleteButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.checkBoxesPanel = new JPanel();
        this.selectValuesCheckBox = new JCheckBox();
        this.multipleChoiceCheckBox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.dataPane.setEnabled(false);
        this.dataTable.setAutoResizeMode(4);
        this.dataPane.setViewportView(this.dataTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        this.add((Component)this.dataPane, gridBagConstraints);
        this.buttonsPanel.setLayout(new GridLayout(4, 1, 0, 5));
        this.newButton.setMnemonic(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("NEW_BUTTON_MNEMONIC").charAt(0));
        this.newButton.setText(bundle.getString("OptionsListPanel.button.new"));
        this.newButton.setLabel(bundle.getString("OptionsListPanel.button.new"));
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsListPanel.this.newActionPerformed(evt);
            }
        });
        this.buttonsPanel.add(this.newButton);
        this.newButton.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("OptionsListPanel.button.new"));
        this.newButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("OptionsListPanel.button.new"));
        this.deleteButton.setMnemonic(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("DELETE_BUTTON_MNEMONIC").charAt(0));
        this.deleteButton.setText(bundle.getString("OptionsListPanel.button.delete"));
        this.deleteButton.setLabel(bundle.getString("OptionsListPanel.button.delete"));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsListPanel.this.deleteActionPerformed(evt);
            }
        });
        this.buttonsPanel.add(this.deleteButton);
        this.deleteButton.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("OptionsListPanel.button.delete"));
        this.deleteButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("OptionsListPanel.button.delete"));
        this.upButton.setMnemonic(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("UP_BUTTON_MNEMONIC").charAt(0));
        this.upButton.setText(bundle.getString("OptionsListPanel.button.up"));
        this.upButton.setLabel(bundle.getString("OptionsListPanel.button.up"));
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsListPanel.this.upActionPerformed(evt);
            }
        });
        this.buttonsPanel.add(this.upButton);
        this.upButton.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("OptionsListPanel.button.up"));
        this.upButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("OptionsListPanel.button.up"));
        this.downButton.setMnemonic(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("DOWN_BUTTON_MNEMONIC").charAt(0));
        this.downButton.setText(bundle.getString("OptionsListPanel.button.down"));
        this.downButton.setLabel(bundle.getString("OptionsListPanel.button.down"));
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsListPanel.this.downActionPerformed(evt);
            }
        });
        this.buttonsPanel.add(this.downButton);
        this.downButton.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("OptionsListPanel.button.down"));
        this.downButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("OptionsListPanel.button.down"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 6, 0, 10);
        this.add((Component)this.buttonsPanel, gridBagConstraints);
        this.checkBoxesPanel.setLayout(new FlowLayout(0, 6, 0));
        this.selectValuesCheckBox.setMnemonic(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("SELECT_VALUES_CHECKBOX_MNEMONIC").charAt(0));
        this.selectValuesCheckBox.setLabel(bundle.getString("OptionsListPanel.checkbox.select.label"));
        this.selectValuesCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                OptionsListPanel.this.selectValuesCheckBoxStateChanged(evt);
            }
        });
        this.selectValuesCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsListPanel.this.selectValuesCheckBoxActionPerformed(evt);
            }
        });
        this.checkBoxesPanel.add(this.selectValuesCheckBox);
        this.selectValuesCheckBox.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("OptionsListPanel.checkbox.select.label"));
        this.selectValuesCheckBox.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("OptionsListPanel.checkbox.select.label"));
        this.multipleChoiceCheckBox.setMnemonic(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("MULTIPLE_CHOICE_CHECKBOX_MNEMONIC").charAt(0));
        this.multipleChoiceCheckBox.setEnabled(this.acceptsMultipleChoice && this.selectValuesCheckBox.isSelected());
        this.multipleChoiceCheckBox.setLabel(bundle.getString("OptionsListPanel.checkbox.multiple.label"));
        this.multipleChoiceCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                OptionsListPanel.this.multipleChoiceCheckBoxStateChanged(evt);
            }
        });
        this.checkBoxesPanel.add(this.multipleChoiceCheckBox);
        this.multipleChoiceCheckBox.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("OptionsListPanel.checkbox.multiple.label"));
        this.multipleChoiceCheckBox.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("OptionsListPanel.checkbox.multiple.label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.checkBoxesPanel, gridBagConstraints);
    }

    private void selectValuesCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void multipleChoiceCheckBoxStateChanged(ItemEvent evt) {
        ItemsTableModel tableModel = (ItemsTableModel)this.dataTable.getModel();
        if (evt.getStateChange() == 1) {
            tableModel.setMultipleSelect(true);
            ((SelectedCellRenderer)this.dataTable.getDefaultRenderer(Boolean.class)).setMultipleChoice(true);
        } else {
            tableModel.setMultipleSelect(false);
            ((SelectedCellRenderer)this.dataTable.getDefaultRenderer(Boolean.class)).setMultipleChoice(false);
        }
        SelectItem[] items = tableModel.getItems();
        for (int i = 0; i < items.length; ++i) {
            tableModel.fireTableCellUpdated(i, 2);
        }
    }

    private void selectValuesCheckBoxStateChanged(ItemEvent evt) {
        ItemsTableModel tableModel = (ItemsTableModel)this.dataTable.getModel();
        int selectedRow = this.dataTable.getSelectedRow();
        if (evt.getStateChange() == 1) {
            tableModel.setItemsSelectable(true);
            this.adjustColumnWidth(this.dataTable, 2);
            this.dataTable.revalidate();
            if (this.acceptsMultipleChoice) {
                this.multipleChoiceCheckBox.setEnabled(true);
            }
        } else {
            this.multipleChoiceCheckBox.setEnabled(false);
            tableModel.setItemsSelectable(false);
        }
        this.dataTable.changeSelection(selectedRow, 0, false, false);
    }

    private void downActionPerformed(ActionEvent evt) {
        ItemsTableModel tableModel = (ItemsTableModel)this.dataTable.getModel();
        if (this.dataTable.getSelectedRowCount() > 0) {
            int[] selectedRows = this.dataTable.getSelectedRows();
            tableModel.moveRowDown(selectedRows[0]);
            this.dataTable.setModel(tableModel);
            this.dataTable.changeSelection(selectedRows[0] + 1, 0, false, false);
        }
    }

    private void upActionPerformed(ActionEvent evt) {
        ItemsTableModel tableModel = (ItemsTableModel)this.dataTable.getModel();
        if (this.dataTable.getSelectedRowCount() > 0) {
            int[] selectedRows = this.dataTable.getSelectedRows();
            tableModel.moveRowUp(selectedRows[0]);
            this.dataTable.setModel(tableModel);
            this.dataTable.changeSelection(selectedRows[0] - 1, 0, false, false);
        }
    }

    private void deleteActionPerformed(ActionEvent evt) {
        ItemsTableModel tableModel = (ItemsTableModel)this.dataTable.getModel();
        int numRows = tableModel.getRowCount();
        if (this.dataTable.getSelectedRowCount() > 0) {
            boolean lastRowRemoved;
            int[] selectedRows = this.dataTable.getSelectedRows();
            boolean bl = lastRowRemoved = selectedRows[0] == numRows - 1;
            if (tableModel.canRemoveRow(selectedRows[0])) {
                tableModel.removeRow(selectedRows[0]);
                this.dataTable.setModel(tableModel);
                this.dataTable.changeSelection(selectedRows[0], 0, false, false);
            }
            if (tableModel.getRowCount() == 0) {
                return;
            }
            if (lastRowRemoved) {
                this.dataTable.changeSelection(tableModel.getRowCount() - 1, 0, false, false);
            } else {
                this.dataTable.changeSelection(selectedRows[0], 0, false, false);
            }
        }
    }

    private void newActionPerformed(ActionEvent evt) {
        ItemsTableModel tableModel = (ItemsTableModel)this.dataTable.getModel();
        if (tableModel.canAddRow()) {
            tableModel.addRow();
            this.dataTable.setModel(tableModel);
            this.dataTable.changeSelection(tableModel.getRowCount() - 1, 0, false, false);
            this.dataTable.requestFocusInWindow();
        }
    }

    public void setItems(SelectItem[] items) {
        this.tableModel.setItems(items);
    }

    public SelectItem[] getItems() {
        return this.tableModel.getItems();
    }

    public void setOptions(Option[] options) {
        this.setItems((SelectItem[])options);
        if (options.length > 0) {
            this.dataTable.changeSelection(0, 0, false, false);
        }
    }

    public Option[] getOptions() {
        SelectItem[] items = this.getItems();
        Option[] options = new Option[items.length];
        for (int i = 0; i < items.length; ++i) {
            options[i] = new Option(items[i].getValue(), items[i].getLabel());
        }
        return options;
    }

    public boolean isMultipleChoice() {
        return this.multipleChoiceCheckBox.getSelectedObjects() != null;
    }

    public void setMultipleChoice(boolean multipleChoice) {
        this.multipleChoiceCheckBox.setSelected(multipleChoice);
    }

    public boolean isValueSelecting() {
        return this.selectValuesCheckBox.isSelected();
    }

    public void setValueSelecting(boolean valueSelecting) {
        this.selectValuesCheckBox.setSelected(valueSelecting);
    }

    public Object getSelectedValues() {
        Object[] selectedValues = this.tableModel.getSelectedValues();
        if (selectedValues.length == 0) {
            return null;
        }
        return this.isMultipleChoice() ? selectedValues : selectedValues[0];
    }

    public void setSelectedValues(Object selectedValues) {
        if (selectedValues == null) {
            this.tableModel.setSelectedValues(new Object[0]);
        } else if (this.isMultipleChoice() && selectedValues instanceof Object[]) {
            this.tableModel.setSelectedValues((Object[])selectedValues);
        } else {
            this.tableModel.setSelectedValues(new Object[]{selectedValues});
        }
    }

    private void adjustColumnWidth(JTable table, int columnIndex) {
        TableColumnModel columnModel = table.getColumnModel();
        TableModel tableModel = table.getModel();
        TableColumn column = columnModel.getColumn(columnIndex);
        TableCellRenderer headerRenderer = column.getHeaderRenderer();
        if (headerRenderer == null) {
            headerRenderer = table.getTableHeader().getDefaultRenderer();
        }
        Component headerComponent = headerRenderer.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, 0, columnIndex);
        int maxWidth = headerComponent.getPreferredSize().width;
        column.setPreferredWidth(maxWidth);
    }

    class SelectedCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JRadioButton radioBtn;
        JCheckBox checkbox;
        JCheckBox selectValuesCheckBox;
        JCheckBox multipleChoiceCheckBox;

        public SelectedCellEditor(JCheckBox selectValuesCheckBox, JCheckBox multipleChoiceCheckBox) {
            this.selectValuesCheckBox = selectValuesCheckBox;
            this.multipleChoiceCheckBox = multipleChoiceCheckBox;
            this.radioBtn = new JRadioButton();
            this.checkbox = new JCheckBox();
            this.radioBtn.setHorizontalAlignment(0);
            this.checkbox.setHorizontalAlignment(0);
            this.radioBtn.addActionListener(this);
            this.checkbox.addActionListener(this);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
            if (this.selectValuesCheckBox.isSelected() && this.multipleChoiceCheckBox.isSelected()) {
                this.checkbox.setSelected((Boolean)value);
                return this.checkbox;
            }
            this.radioBtn.setSelected((Boolean)value);
            return this.radioBtn;
        }

        public Object getCellEditorValue() {
            if (this.selectValuesCheckBox.isSelected() && this.multipleChoiceCheckBox.isSelected()) {
                return new Boolean(this.checkbox.isSelected());
            }
            return new Boolean(this.radioBtn.isSelected());
        }

        public boolean isCellEditable(EventObject evt) {
            if (evt instanceof MouseEvent) {
                int clickCount = 1;
                return ((MouseEvent)evt).getClickCount() >= clickCount;
            }
            return true;
        }

        public void actionPerformed(ActionEvent e) {
            this.fireEditingStopped();
        }
    }

    class CellEditor
    extends DefaultCellEditor {
        private JTable table;

        public CellEditor(JTable table, JTextField component) {
            super(component);
            this.table = table;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
            ((JTextField)super.getComponent()).setText((String)value);
            if (isSelected) {
                ((JTextField)super.getComponent()).selectAll();
                table.repaint();
            }
            return super.getComponent();
        }
    }

    class HomogonousCellRenderer
    extends DefaultTableCellRenderer {
        Color SELECTION_BACKGROUND = UIManager.getDefaults().getColor("TextField.selectionBackground");

        HomogonousCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (isSelected) {
                c.setBackground(this.SELECTION_BACKGROUND);
            } else {
                c.setBackground(Color.WHITE);
            }
            return c;
        }
    }

    class SelectedCellRenderer
    extends DefaultTableCellRenderer {
        Color SELECTION_BACKGROUND = UIManager.getDefaults().getColor("TextField.selectionBackground");
        JCheckBox checkBox = new JCheckBox();
        JRadioButton radioButton;
        JToggleButton currentComponent;

        SelectedCellRenderer() {
            this.checkBox.setHorizontalAlignment(0);
            this.checkBox.setBackground(Color.WHITE);
            this.radioButton = new JRadioButton();
            this.radioButton.setHorizontalAlignment(0);
            this.radioButton.setBackground(Color.WHITE);
            this.currentComponent = this.radioButton;
        }

        public void setMultipleChoice(boolean multipleChoice) {
            this.currentComponent = multipleChoice ? this.checkBox : this.radioButton;
        }

        public boolean isMultipleChoice() {
            return this.currentComponent == this.checkBox;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.currentComponent.setBackground(this.SELECTION_BACKGROUND);
            } else {
                this.currentComponent.setBackground(Color.WHITE);
            }
            if (Boolean.TRUE.equals(value)) {
                this.currentComponent.setSelected(true);
            } else {
                this.currentComponent.setSelected(false);
            }
            return this.currentComponent;
        }
    }

    static class ItemRowModel {
        private String label;
        private Object value;
        private boolean selected;

        ItemRowModel(String label, Object value) {
            this.setLabel(label);
            this.setValue(value);
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }
    }

    static class ItemsTableModel
    extends AbstractTableModel {
        static final int DISPLAY_COLUMN = 0;
        static final int VALUE_COLUMN = 1;
        static final int SELECT_COLUMN = 2;
        int columnCount = 2;
        boolean multipleSelect;
        ArrayList rows = new ArrayList();

        ItemsTableModel() {
        }

        public SelectItem[] getItems() {
            SelectItem[] items = new SelectItem[this.rows.size()];
            for (int i = 0; i < this.rows.size(); ++i) {
                items[i] = new SelectItem();
                items[i].setLabel(((ItemRowModel)this.rows.get(i)).getLabel());
                items[i].setValue(((ItemRowModel)this.rows.get(i)).getValue());
            }
            return items;
        }

        public void setItems(SelectItem[] items) {
            this.rows.clear();
            if (items != null) {
                for (int i = 0; i < items.length; ++i) {
                    this.rows.add(new ItemRowModel(items[i].getLabel(), items[i].getValue()));
                }
            }
            this.fireTableDataChanged();
        }

        public void setItemsSelectable(boolean selectItems) {
            int newColumnCount;
            int n = newColumnCount = selectItems ? 3 : 2;
            if (newColumnCount != this.columnCount) {
                this.columnCount = newColumnCount;
                this.fireTableStructureChanged();
            }
        }

        public boolean isItemsSelectable() {
            return this.columnCount == 3;
        }

        public void setMultipleSelect(boolean multipleSelect) {
            if (!multipleSelect && this.multipleSelect) {
                int r = -1;
                for (int i = this.rows.size() - 1; i >= 0; --i) {
                    if (!((ItemRowModel)this.rows.get(i)).isSelected()) continue;
                    ((ItemRowModel)this.rows.get(i)).setSelected(false);
                    this.fireTableCellUpdated(i, 2);
                    r = i;
                }
                if (r >= 0) {
                    ((ItemRowModel)this.rows.get(r)).setSelected(true);
                    this.fireTableCellUpdated(r, 2);
                }
            }
            this.multipleSelect = multipleSelect;
        }

        public void setSelectedValues(Object[] values) {
            ArrayList<Object> valuesList = new ArrayList<Object>(Arrays.asList(values));
            for (int i = 0; i < this.rows.size(); ++i) {
                if (valuesList.contains(((ItemRowModel)this.rows.get(i)).getValue())) {
                    ((ItemRowModel)this.rows.get(i)).setSelected(true);
                    continue;
                }
                ((ItemRowModel)this.rows.get(i)).setSelected(false);
            }
        }

        public Object[] getSelectedValues() {
            ArrayList<Object> values = new ArrayList<Object>();
            for (int i = 0; i < this.rows.size(); ++i) {
                if (!((ItemRowModel)this.rows.get(i)).isSelected()) continue;
                values.add(((ItemRowModel)this.rows.get(i)).getValue());
            }
            return values.toArray(new Object[values.size()]);
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return String.class;
            }
            if (columnIndex == 2) {
                return Boolean.class;
            }
            if (this.rows.size() > 0) {
                return ((ItemRowModel)this.rows.get(0)).getValue().getClass();
            }
            return String.class;
        }

        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return bundle.getString("OptionsListPanel.table.column.display");
            }
            if (columnIndex == 1) {
                return bundle.getString("OptionsListPanel.table.column.value");
            }
            if (columnIndex == 2) {
                return bundle.getString("OptionsListPanel.table.column.selected");
            }
            return null;
        }

        public int getColumnCount() {
            return this.columnCount;
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public boolean canRemoveRow(int index) {
            return index >= 0 && index < this.rows.size();
        }

        public boolean removeRow(int index) {
            if (this.canRemoveRow(index)) {
                this.rows.remove(index);
                this.fireTableRowsDeleted(index, index);
                return true;
            }
            return false;
        }

        public boolean removeAllRows() {
            if (this.rows.isEmpty()) {
                return true;
            }
            int numRows = this.rows.size();
            this.rows.clear();
            this.fireTableRowsDeleted(0, numRows);
            return true;
        }

        public void setValueAt(Object newValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                ((ItemRowModel)this.rows.get(rowIndex)).setLabel((String)newValue);
            } else if (columnIndex == 1) {
                ((ItemRowModel)this.rows.get(rowIndex)).setValue(newValue);
            } else if (columnIndex == 2) {
                if (!this.multipleSelect && Boolean.TRUE.equals(newValue)) {
                    for (int i = 0; i < this.rows.size(); ++i) {
                        if (!((ItemRowModel)this.rows.get(i)).isSelected()) continue;
                        ((ItemRowModel)this.rows.get(i)).setSelected(false);
                        this.fireTableCellUpdated(i, columnIndex);
                    }
                }
                ((ItemRowModel)this.rows.get(rowIndex)).setSelected(Boolean.TRUE.equals(newValue));
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return ((ItemRowModel)this.rows.get(rowIndex)).getLabel();
            }
            if (columnIndex == 1) {
                return ((ItemRowModel)this.rows.get(rowIndex)).getValue();
            }
            if (columnIndex == 2) {
                return ((ItemRowModel)this.rows.get(rowIndex)).isSelected() ? Boolean.TRUE : Boolean.FALSE;
            }
            return null;
        }

        public boolean canAddRow() {
            return true;
        }

        public void addRow() {
            this.rows.add(new ItemRowModel(bundle.getString("OptionsListPanel.default.display"), bundle.getString("OptionsListPanel.default.value")));
            this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size() - 1);
        }

        public boolean canMoveRowUp(int index) {
            return index > 0;
        }

        public boolean canMoveRowDown(int index) {
            return index < this.rows.size() - 1;
        }

        public void moveRowUp(int index) {
            if (this.canMoveRowUp(index)) {
                Object row = this.rows.remove(index);
                this.rows.add(index - 1, row);
                this.fireTableDataChanged();
            }
        }

        public void moveRowDown(int index) {
            if (this.canMoveRowDown(index)) {
                Object row = this.rows.remove(index);
                this.rows.add(index + 1, row);
                this.fireTableDataChanged();
            }
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }
    }
}

