/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.svnkit;

import java.io.File;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.Notify2;
import org.tigris.subversion.javahl.ProgressListener;
import org.tigris.subversion.javahl.PromptUserPassword;
import org.tigris.subversion.svnclientadapter.ISVNPromptUserPassword;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNStatusUnversioned;
import org.tigris.subversion.svnclientadapter.javahl.AbstractJhlClientAdapter;
import org.tigris.subversion.svnclientadapter.javahl.JhlNotificationHandler;
import org.tigris.subversion.svnclientadapter.javahl.JhlProgressListener;
import org.tigris.subversion.svnclientadapter.svnkit.SvnKitPromptUserPassword;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.javahl.SVNClientImpl;

public class SvnKitClientAdapter
extends AbstractJhlClientAdapter {
    public SvnKitClientAdapter() {
        this.svnClient = SVNClientImpl.newInstance();
        this.notificationHandler = new JhlNotificationHandler();
        this.progressListener = new JhlProgressListener();
        this.svnClient.notification2((Notify2)this.notificationHandler);
        this.svnClient.setPrompt((PromptUserPassword)new AbstractJhlClientAdapter.DefaultPromptUserPassword());
        this.svnClient.setProgressListener((ProgressListener)this.progressListener);
    }

    public boolean isThreadsafe() {
        return false;
    }

    public void createRepository(File path, String repositoryType) throws SVNClientException {
        if ("bdb".equalsIgnoreCase(repositoryType)) {
            throw new SVNClientException("SVNKit only supports fsfs repository type.");
        }
        try {
            boolean force = false;
            boolean enableRevisionProperties = false;
            SVNRepositoryFactory.createLocalRepository((File)path, (boolean)enableRevisionProperties, (boolean)force);
        }
        catch (SVNException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void addPasswordCallback(ISVNPromptUserPassword callback) {
        if (callback != null) {
            SvnKitPromptUserPassword prompt = new SvnKitPromptUserPassword(callback);
            this.setPromptUserPassword((PromptUserPassword)prompt);
        }
    }

    public boolean statusReturnsRemoteInfo() {
        return true;
    }

    public long[] commitAcrossWC(File[] paths, String message, boolean recurse, boolean keepLocks, boolean atomic) throws SVNClientException {
        try {
            String messageString = message == null ? "" : message;
            this.notificationHandler.setCommand(3);
            String[] files = new String[paths.length];
            String commandLine = "commit -m \"" + messageString + "\"";
            if (!recurse) {
                commandLine = commandLine + " -N";
            }
            if (keepLocks) {
                commandLine = commandLine + " --no-unlock";
            }
            for (int i = 0; i < paths.length; ++i) {
                files[i] = SvnKitClientAdapter.fileToSVNPath(paths[i], false);
                commandLine = commandLine + " " + files[i];
            }
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            long[] newRev = ((SVNClientImpl)this.svnClient).commit(files, messageString, recurse, keepLocks, atomic);
            return newRev;
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public boolean canCommitAcrossWC() {
        return true;
    }

    public ISVNStatus[] getStatus(File path, boolean descend, boolean getAll, boolean contactServer, boolean ignoreExternals) throws SVNClientException {
        ISVNStatus[] statuses = super.getStatus(path, descend, getAll, contactServer, ignoreExternals);
        if (statuses.length == 0) {
            if (getAll) {
                return new ISVNStatus[]{new SVNStatusUnversioned(path)};
            }
            ISVNStatus[] reCheckStatuses = super.getStatus(path, false, true, false, true);
            if (reCheckStatuses.length == 0) {
                return new ISVNStatus[]{new SVNStatusUnversioned(path)};
            }
            return new ISVNStatus[0];
        }
        return statuses;
    }
}

