/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.groovy.grailsproject.ui.DebugCustomizerPanel;
import org.netbeans.modules.groovy.grailsproject.ui.GeneralCustomizerPanel;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionStarterService;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class GrailsProjectCustomizerProvider
implements CustomizerProvider {
    public static final String CUSTOMIZER_FOLDER_PATH = "Projects/org-netbeans-modules-groovy-grailsproject/Customizer";
    private static final String GENERAL_CATEGORY = "GeneralCategory";
    private static final String DEBUG_CATEGORY = "DebugCategory";
    private final Project project;

    public GrailsProjectCustomizerProvider(Project project) {
        this.project = project;
    }

    public void showCustomizer() {
        this.showCustomizer(null);
    }

    public void showCustomizer(String string) {
        Lookup lookup = Lookups.fixed((Object[])new Object[]{this.project});
        OptionListener optionListener = new OptionListener(this.project);
        Dialog dialog = ProjectCustomizer.createCustomizerDialog((String)CUSTOMIZER_FOLDER_PATH, (Lookup)lookup, (String)string, (ActionListener)optionListener, null, null);
        dialog.addWindowListener(optionListener);
        dialog.setTitle(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        dialog.setVisible(true);
    }

    public static ProjectCustomizer.CompositeCategoryProvider createGeneral() {
        return new ProjectCustomizer.CompositeCategoryProvider(){

            public ProjectCustomizer.Category createCategory(Lookup lookup) {
                return ProjectCustomizer.Category.create((String)GrailsProjectCustomizerProvider.GENERAL_CATEGORY, (String)NbBundle.getMessage(GrailsProjectCustomizerProvider.class, (String)"LBL_GeneralSettings"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
            }

            public JComponent createComponent(ProjectCustomizer.Category category, Lookup lookup) {
                return new GeneralCustomizerPanel((Project)lookup.lookup(Project.class));
            }
        };
    }

    public static ProjectCustomizer.CompositeCategoryProvider createDebugging() {
        return new ProjectCustomizer.CompositeCategoryProvider(){

            public ProjectCustomizer.Category createCategory(Lookup lookup) {
                if (WebClientToolsSessionStarterService.isAvailable()) {
                    return ProjectCustomizer.Category.create((String)GrailsProjectCustomizerProvider.DEBUG_CATEGORY, (String)NbBundle.getMessage(GrailsProjectCustomizerProvider.class, (String)"DEBUG_CATEGORY"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
                }
                return null;
            }

            public JComponent createComponent(ProjectCustomizer.Category category, Lookup lookup) {
                return new DebugCustomizerPanel((Project)lookup.lookup(Project.class));
            }
        };
    }

    private class OptionListener
    extends WindowAdapter
    implements ActionListener {
        private Project project;

        OptionListener(Project project) {
            this.project = project;
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
        }
    }
}

