/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.extexecution.api.ExecutionDescriptor;
import org.netbeans.modules.extexecution.api.ExecutionService;
import org.netbeans.modules.extexecution.api.input.InputProcessor;
import org.netbeans.modules.extexecution.api.input.InputProcessors;
import org.netbeans.modules.extexecution.api.input.LineProcessor;
import org.netbeans.modules.groovy.grails.api.ExecutionSupport;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.netbeans.modules.groovy.grails.api.GrailsRuntime;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.GrailsServerState;
import org.netbeans.modules.groovy.grailsproject.actions.ConfigSupport;
import org.netbeans.modules.groovy.grailsproject.actions.RefreshProjectRunnable;
import org.netbeans.modules.web.client.tools.api.LocationMappersFactory;
import org.netbeans.modules.web.client.tools.api.NbJSToJSLocationMapper;
import org.netbeans.modules.web.client.tools.api.WebClientToolsProjectUtils;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionException;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionStarterService;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.LifecycleManager;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class GrailsActionProvider
implements ActionProvider {
    public static final String COMMAND_GRAILS_SHELL = "grails-shell";
    public static final String COMMAND_COMPILE = "compile";
    public static final String COMMAND_STATS = "stats";
    public static final String COMMAND_UPGRADE = "upgrade";
    public static final String COMMAND_WAR = "war";
    private static final ExecutionDescriptor GRAILS_DESCRIPTOR = new ExecutionDescriptor().controllable(true).frontWindow(true).inputVisible(true).showProgress(true).optionsPath("Advanced/org-netbeans-modules-groovy-support-api-GroovySettings");
    private static final ExecutionDescriptor RUN_DESCRIPTOR = GRAILS_DESCRIPTOR.showSuspended(true);
    private static final Logger LOGGER = Logger.getLogger(GrailsActionProvider.class.getName());
    private static final String[] supportedActions = new String[]{"run", "test", "clean", "delete", "grails-shell", "compile", "stats", "upgrade", "war"};
    private final GrailsProject project;

    public GrailsActionProvider(GrailsProject grailsProject) {
        this.project = grailsProject;
    }

    public String[] getSupportedActions() {
        if (WebClientToolsSessionStarterService.isAvailable()) {
            String[] stringArray = new String[supportedActions.length + 1];
            for (int i = 0; i < supportedActions.length; ++i) {
                stringArray[i] = supportedActions[i];
            }
            stringArray[GrailsActionProvider.supportedActions.length] = "debug";
            return stringArray;
        }
        return (String[])supportedActions.clone();
    }

    public void invokeAction(String string, Lookup lookup) throws IllegalArgumentException {
        GrailsRuntime grailsRuntime = GrailsRuntime.getInstance();
        if (!grailsRuntime.isConfigured()) {
            ConfigSupport.showConfigurationWarning(grailsRuntime);
            return;
        }
        if ("run".equals(string)) {
            LifecycleManager.getDefault().saveAll();
            this.executeRunAction();
        } else if ("debug".equals(string)) {
            LifecycleManager.getDefault().saveAll();
            this.executeRunAction(true);
        } else if (COMMAND_GRAILS_SHELL.equals(string)) {
            this.executeShellAction();
        } else if ("test".equals(string)) {
            this.executeSimpleAction("test-app");
        } else if ("clean".equals(string)) {
            this.executeSimpleAction("clean");
        } else if (COMMAND_COMPILE.equals(string)) {
            this.executeSimpleAction(COMMAND_COMPILE);
        } else if (COMMAND_STATS.equals(string)) {
            this.executeSimpleAction(COMMAND_STATS);
        } else if (COMMAND_UPGRADE.equals(string)) {
            this.executeSimpleAction(COMMAND_UPGRADE);
        } else if ("delete".equals(string)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
        }
    }

    public boolean isActionEnabled(String string, Lookup lookup) throws IllegalArgumentException {
        return true;
    }

    private void executeRunAction() {
        this.executeRunAction(false);
    }

    private void executeRunAction(final boolean bl) {
        GrailsServerState grailsServerState = (GrailsServerState)this.project.getLookup().lookup(GrailsServerState.class);
        if (grailsServerState != null && grailsServerState.isRunning()) {
            URL uRL = grailsServerState.getRunningUrl();
            if (uRL != null) {
                GrailsActionProvider.showURL(uRL, bl, this.project);
            }
            return;
        }
        Callable<Process> callable = new Callable<Process>(){

            @Override
            public Process call() throws Exception {
                Callable callable = ExecutionSupport.getInstance().createRunApp(GrailsProjectConfig.forProject((Project)GrailsActionProvider.this.project));
                Process process = (Process)callable.call();
                GrailsServerState grailsServerState = (GrailsServerState)GrailsActionProvider.this.project.getLookup().lookup(GrailsServerState.class);
                if (grailsServerState != null) {
                    grailsServerState.setProcess(process);
                }
                return process;
            }
        };
        ProjectInformation projectInformation = (ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class);
        String string = projectInformation.getDisplayName() + " (run-app)";
        Runnable runnable = new Runnable(){

            public void run() {
                GrailsServerState grailsServerState = (GrailsServerState)GrailsActionProvider.this.project.getLookup().lookup(GrailsServerState.class);
                if (grailsServerState != null) {
                    grailsServerState.setProcess(null);
                    grailsServerState.setRunningUrl(null);
                }
            }
        };
        ExecutionDescriptor executionDescriptor = RUN_DESCRIPTOR;
        executionDescriptor = executionDescriptor.outProcessorFactory(new ExecutionDescriptor.InputProcessorFactory(){

            public InputProcessor newInputProcessor() {
                return InputProcessors.bridge((LineProcessor)new ServerURLProcessor(GrailsActionProvider.this.project, bl));
            }
        });
        executionDescriptor = executionDescriptor.postExecution(runnable);
        ExecutionService executionService = ExecutionService.newService((Callable)callable, (ExecutionDescriptor)executionDescriptor, (String)string);
        executionService.run();
    }

    private void executeShellAction() {
        String string = "shell";
        GrailsProjectConfig grailsProjectConfig = GrailsProjectConfig.forProject((Project)this.project);
        File file = FileUtil.toFile((FileObject)grailsProjectConfig.getProject().getProjectDirectory());
        Properties properties = new Properties();
        properties.setProperty("jline.WindowsTerminal.directConsole", "false");
        GrailsRuntime.CommandDescriptor commandDescriptor = new GrailsRuntime.CommandDescriptor(string, file, grailsProjectConfig.getEnvironment(), new String[0], properties);
        Callable callable = GrailsRuntime.getInstance().createCommand(commandDescriptor);
        ProjectInformation projectInformation = (ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class);
        String string2 = projectInformation.getDisplayName() + " (shell)";
        ExecutionDescriptor executionDescriptor = RUN_DESCRIPTOR.postExecution((Runnable)new RefreshProjectRunnable(this.project));
        ExecutionService executionService = ExecutionService.newService((Callable)callable, (ExecutionDescriptor)executionDescriptor, (String)string2);
        executionService.run();
    }

    private void executeSimpleAction(String string) {
        ProjectInformation projectInformation = (ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class);
        String string2 = projectInformation.getDisplayName() + " (" + string + ")";
        Callable callable = ExecutionSupport.getInstance().createSimpleCommand(string, GrailsProjectConfig.forProject((Project)this.project), new String[0]);
        ExecutionDescriptor executionDescriptor = GRAILS_DESCRIPTOR.postExecution((Runnable)new RefreshProjectRunnable(this.project));
        ExecutionService executionService = ExecutionService.newService((Callable)callable, (ExecutionDescriptor)executionDescriptor, (String)string2);
        executionService.run();
    }

    private static final void showURL(URL uRL, boolean bl, GrailsProject grailsProject) {
        boolean bl2 = WebClientToolsSessionStarterService.isAvailable();
        if (!bl || !bl2) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
        } else {
            Object object;
            URI uRI;
            Object object2;
            Lookup lookup;
            FileObject fileObject = grailsProject.getProjectDirectory().getFileObject("web-app");
            GrailsProjectConfig grailsProjectConfig = GrailsProjectConfig.forProject((Project)grailsProject);
            String string = grailsProjectConfig.getPort();
            String string2 = uRL.getProtocol() + "://" + uRL.getHost() + ":" + string + "/" + grailsProject.getProjectDirectory().getName();
            String string3 = uRL.toExternalForm();
            if (!string3.startsWith(string2)) {
                LOGGER.warning("Could not construct URL mapper for JavaScript debugger.");
                lookup = Lookups.fixed((Object[])new Object[]{grailsProject});
            } else {
                object2 = (LocationMappersFactory)Lookup.getDefault().lookup(LocationMappersFactory.class);
                if (object2 == null) {
                    lookup = Lookups.fixed((Object[])new Object[]{grailsProject});
                } else {
                    try {
                        uRI = new URI(string2);
                        object = object2.getJSToNbJSLocationMapper(fileObject, uRI, null);
                        NbJSToJSLocationMapper nbJSToJSLocationMapper = object2.getNbJSToJSLocationMapper(fileObject, uRI, null);
                        lookup = Lookups.fixed((Object[])new Object[]{object, nbJSToJSLocationMapper, grailsProject});
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        LOGGER.log(Level.WARNING, "Server URI could not be constructed from displayed URL", uRISyntaxException);
                        lookup = Lookups.fixed((Object[])new Object[]{grailsProject});
                    }
                }
            }
            try {
                object2 = uRL.toURI();
                uRI = WebClientToolsProjectUtils.getFirefoxBrowser();
                object = grailsProjectConfig.getDebugBrowser();
                if (object == null) {
                    object = WebClientToolsProjectUtils.Browser.FIREFOX.name();
                }
                if (WebClientToolsProjectUtils.Browser.valueOf((String)object) == WebClientToolsProjectUtils.Browser.INTERNET_EXPLORER) {
                    uRI = WebClientToolsProjectUtils.getInternetExplorerBrowser();
                }
                WebClientToolsSessionStarterService.startSession((URI)object2, (HtmlBrowser.Factory)uRI, (Lookup)lookup);
            }
            catch (URISyntaxException uRISyntaxException) {
                LOGGER.log(Level.SEVERE, "Unable to obtain URI for URL", uRISyntaxException);
            }
            catch (WebClientToolsSessionException webClientToolsSessionException) {
                LOGGER.log(Level.SEVERE, "Unexpected exception launching javascript debugger", webClientToolsSessionException);
            }
        }
    }

    private static class ServerURLProcessor
    implements LineProcessor {
        private final GrailsProject project;
        private final boolean debug;

        public ServerURLProcessor(GrailsProject grailsProject, boolean bl) {
            this.project = grailsProject;
            this.debug = bl;
        }

        public void processLine(String string) {
            if (string.contains("Browse to http:/")) {
                URL uRL;
                String string2 = string.substring(string.indexOf("http://"));
                try {
                    uRL = new URL(string2);
                }
                catch (MalformedURLException malformedURLException) {
                    LOGGER.log(Level.WARNING, "Could not start browser", malformedURLException);
                    return;
                }
                GrailsServerState grailsServerState = (GrailsServerState)this.project.getLookup().lookup(GrailsServerState.class);
                if (grailsServerState != null) {
                    grailsServerState.setRunningUrl(uRL);
                }
                GrailsActionProvider.showURL(uRL, this.debug, this.project);
            }
        }

        public void reset() {
        }

        public void close() {
        }
    }
}

