/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.execution;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.modules.ruby.platform.RubyExecution;
import org.netbeans.modules.ruby.platform.Util;
import org.netbeans.modules.ruby.platform.execution.FileLocator;
import org.netbeans.modules.ruby.platform.execution.OutputProcessor;
import org.netbeans.modules.ruby.platform.execution.OutputRecognizer;
import org.netbeans.modules.ruby.platform.execution.RegexpOutputRecognizer;
import org.netbeans.modules.ruby.platform.execution.StopAction;
import org.openide.util.Exceptions;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OutputForwarder
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(OutputForwarder.class.getName());
    static final Pattern RANGE_ERROR_RE = Pattern.compile("#<RangeError: 0x[0-9a-f]+ is recycled object>");
    private StopAction stopAction;
    private InputStream str;
    private OutputWriter writer;
    private FileLocator fileLocator;
    private List<OutputRecognizer> recognizers;
    private String encoding;
    private final int readMaxWaitTime;
    private final boolean runBeforeFinishHook;

    OutputForwarder(InputStream inputStream, OutputWriter outputWriter, FileLocator fileLocator, List<OutputRecognizer> list, StopAction stopAction) {
        this(inputStream, outputWriter, fileLocator, list, stopAction, null, 50);
    }

    OutputForwarder(InputStream inputStream, OutputWriter outputWriter, FileLocator fileLocator, List<OutputRecognizer> list, StopAction stopAction, String string, int n) {
        this(inputStream, outputWriter, fileLocator, list, stopAction, null, n, false);
    }

    OutputForwarder(InputStream inputStream, OutputWriter outputWriter, FileLocator fileLocator, List<OutputRecognizer> list, StopAction stopAction, String string, int n, boolean bl) {
        this.str = inputStream;
        this.writer = outputWriter;
        this.fileLocator = fileLocator;
        this.recognizers = list;
        this.stopAction = stopAction;
        this.encoding = string;
        this.readMaxWaitTime = n;
        this.runBeforeFinishHook = bl;
    }

    void processLine(String string) throws IOException {
        if (RANGE_ERROR_RE.matcher(string).matches()) {
            LOGGER.log(Level.FINE, "Filtering line from Output Window (issue #110763): " + string);
            return;
        }
        if (Util.containsAnsiColors(string)) {
            string = Util.stripAnsiColors(string);
        }
        OutputRecognizer.FileLocation fileLocation = null;
        boolean bl = false;
        for (OutputRecognizer outputRecognizer : this.recognizers) {
            String[] stringArray;
            OutputRecognizer.RecognizedOutput recognizedOutput = outputRecognizer.processLine(string);
            if (recognizedOutput instanceof OutputRecognizer.FileLocation) {
                fileLocation = (OutputRecognizer.FileLocation)recognizedOutput;
                continue;
            }
            if (recognizedOutput instanceof OutputRecognizer.ActionText) {
                Object object;
                int n;
                int n2;
                Object[] objectArray;
                stringArray = (String[])recognizedOutput;
                String[] stringArray2 = stringArray.getPlainLinesPre();
                if (stringArray2 != null) {
                    objectArray = stringArray2;
                    n2 = objectArray.length;
                    for (n = 0; n < n2; ++n) {
                        object = objectArray[n];
                        this.writer.println((String)object);
                    }
                }
                if ((stringArray2 = stringArray.getActionLines()) != null) {
                    objectArray = stringArray.getActions();
                    for (n2 = 0; n2 < objectArray.length; ++n2) {
                        String string2 = stringArray2[n2];
                        this.writer.println(string2, (OutputListener)new ActionHandler((Runnable)objectArray[n2]));
                    }
                }
                if ((stringArray2 = stringArray.getPlainLinesPost()) != null) {
                    objectArray = stringArray2;
                    n2 = objectArray.length;
                    for (n = 0; n < n2; ++n) {
                        object = objectArray[n];
                        this.writer.println((String)object);
                    }
                }
                bl = true;
                continue;
            }
            if (!(recognizedOutput instanceof OutputRecognizer.FilteredOutput)) continue;
            stringArray = ((OutputRecognizer.FilteredOutput)recognizedOutput).getLinesToPrint();
            if (stringArray != null) {
                for (String string3 : stringArray) {
                    boolean bl2 = false;
                    for (RegexpOutputRecognizer regexpOutputRecognizer : RubyExecution.getStandardRubyRecognizers()) {
                        OutputRecognizer.RecognizedOutput recognizedOutput2 = ((OutputRecognizer)regexpOutputRecognizer).processLine(string3);
                        if (!(recognizedOutput2 instanceof OutputRecognizer.FileLocation)) continue;
                        OutputRecognizer.FileLocation fileLocation2 = (OutputRecognizer.FileLocation)recognizedOutput2;
                        this.writer.println(string3, (OutputListener)new OutputProcessor(fileLocation2.file, fileLocation2.line, this.fileLocator));
                        bl2 = true;
                        break;
                    }
                    if (bl2) continue;
                    this.writer.println(string3);
                }
            }
            bl = true;
        }
        if (!bl) {
            if (fileLocation != null) {
                this.writer.println(string, (OutputListener)new OutputProcessor(fileLocation.file, fileLocation.line, this.fileLocator));
            } else {
                this.writer.println(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        for (OutputRecognizer var2_2 : this.recognizers) {
            var2_2.start();
        }
        var1_1 = null;
        try {
            var2_3 = this.encoding == null ? new InputStreamReader(this.str) : new InputStreamReader(this.str, this.encoding);
            var1_1 = new BufferedReader(var2_3, 1200);
        }
        catch (UnsupportedEncodingException var2_4) {
            Exceptions.printStackTrace((Throwable)var2_4);
            return;
        }
        var2_5 = new StringBuilder();
        try {
            block154: {
                block153: {
                    block152: {
                        block139: {
                            block151: {
                                block150: {
                                    block149: {
                                        block138: {
                                            block148: {
                                                block147: {
                                                    block146: {
                                                        block134: {
                                                            try {
                                                                while (true) {
                                                                    if (!var1_1.ready()) {
                                                                        if (this.stopAction.process == null) {
                                                                            var7_14 = null;
                                                                            break block134;
                                                                        }
                                                                        for (var4_9 = 0; !var1_1.ready() && var4_9 < this.readMaxWaitTime; var4_9 += 25) {
                                                                            try {
                                                                                Thread.sleep(25L);
                                                                                continue;
                                                                            }
                                                                            catch (InterruptedException var5_13) {
                                                                                var7_15 = null;
                                                                                try {
                                                                                    try {
                                                                                        if (Thread.interrupted()) {
                                                                                            // empty if block
                                                                                        }
                                                                                        if (this.stopAction.process == null) {
                                                                                            var8_23 = false;
                                                                                        } else {
                                                                                            try {
                                                                                                this.stopAction.process.exitValue();
                                                                                                var8_23 = false;
                                                                                            }
                                                                                            catch (IllegalThreadStateException var9_36) {
                                                                                                var8_23 = true;
                                                                                            }
                                                                                        }
                                                                                        if (var8_23) {
                                                                                            if (this.str.available() > 0) {
                                                                                                var9_36 = var1_1.readLine();
                                                                                                var2_5.append((String)var9_36);
                                                                                            }
                                                                                            if (var2_5.length() > 0) {
                                                                                                this.processLine(var2_5.toString());
                                                                                            }
                                                                                        } else {
                                                                                            while ((var9_36 = var1_1.readLine()) != null) {
                                                                                                var2_5.append((String)var9_36);
                                                                                                this.processLine(var2_5.toString());
                                                                                                var2_5.setLength(0);
                                                                                            }
                                                                                        }
                                                                                        v0 = null;
                                                                                    }
                                                                                    catch (IOException var8_24) {
                                                                                        OutputForwarder.LOGGER.log(Level.INFO, "Process finished unexpectedly: " + var8_24.getMessage(), var8_24);
                                                                                        v0 = null;
                                                                                    }
                                                                                }
                                                                                catch (Throwable var10_43) {
                                                                                    v0 = null;
                                                                                }
                                                                                var11_50 = v0;
                                                                                try {
                                                                                    var1_1.close();
                                                                                }
                                                                                catch (IOException var12_57) {
                                                                                    OutputForwarder.LOGGER.log(Level.WARNING, var12_57.getMessage(), (Throwable)var12_57);
                                                                                }
                                                                                if (this.runBeforeFinishHook) {
                                                                                    for (OutputRecognizer var13_64 : this.recognizers) {
                                                                                        for (String var17_92 : var13_64.beforeFinish()) {
                                                                                            this.writer.println(var17_92);
                                                                                        }
                                                                                    }
                                                                                }
                                                                                this.writer.flush();
                                                                                this.writer.close();
                                                                                var12_57 = this.recognizers.iterator();
                                                                                while (true) {
                                                                                    if (!var12_57.hasNext()) {
                                                                                        return;
                                                                                    }
                                                                                    var13_64 = var12_57.next();
                                                                                    var13_64.finish();
                                                                                }
                                                                            }
                                                                        }
                                                                        if (var1_1.ready() || var2_5.length() <= 0) continue;
                                                                        var5_12 = var2_5.toString();
                                                                        var2_5.setLength(0);
                                                                        OutputForwarder.LOGGER.log(Level.INFO, "Process seems to be stalling, emitting chars read so far: " + var5_12);
                                                                        this.writer.print(var5_12);
                                                                        continue;
                                                                    }
                                                                    while (var1_1.ready()) {
                                                                        var3_6 = -1;
                                                                        var3_6 = var1_1.read();
                                                                        if (var3_6 == -1) {
                                                                            var4_10 = var2_5.toString();
                                                                            var2_5.setLength(0);
                                                                            this.processLine(var4_10);
                                                                            break block138;
                                                                        }
                                                                        var2_5.append((char)var3_6);
                                                                    }
                                                                    if (Thread.interrupted()) break;
                                                                }
                                                                break block139;
                                                            }
                                                            catch (IOException var3_7) {
                                                                block142: {
                                                                    block141: {
                                                                        block140: {
                                                                            OutputForwarder.LOGGER.log(Level.INFO, var3_7.getMessage(), var3_7);
                                                                            var7_18 = null;
                                                                            ** try [egrp 4[TRYBLOCK] [19 : 366->541)] { 
lbl115:
                                                                            // 1 sources

                                                                            ** try [egrp 5[TRYBLOCK] [18 : 366->493)] { 
lbl116:
                                                                            // 1 sources

                                                                            if (Thread.interrupted()) {
                                                                                // empty if block
                                                                            }
                                                                            if (this.stopAction.process == null) {
                                                                                var8_29 = false;
                                                                            } else {
                                                                                ** try [egrp 6[TRYBLOCK] [17 : 388->405)] { 
lbl122:
                                                                                // 1 sources

                                                                                this.stopAction.process.exitValue();
                                                                                var8_29 = false;
                                                                            }
                                                                            break block140;
lbl126:
                                                                            // 1 sources

                                                                            catch (IllegalThreadStateException var9_39) {
                                                                                var8_29 = true;
                                                                            }
                                                                        }
                                                                        if (var8_29) {
                                                                            if (this.str.available() > 0) {
                                                                                var9_39 = var1_1.readLine();
                                                                                var2_5.append((String)var9_39);
                                                                            }
                                                                            if (var2_5.length() > 0) {
                                                                                this.processLine(var2_5.toString());
                                                                            }
                                                                        } else {
                                                                            while ((var9_39 = var1_1.readLine()) != null) {
                                                                                var2_5.append((String)var9_39);
                                                                                this.processLine(var2_5.toString());
                                                                                var2_5.setLength(0);
                                                                            }
                                                                        }
                                                                        v1 = null;
lbl145:
                                                                        // 1 sources

                                                                        catch (IOException var8_30) {
                                                                            OutputForwarder.LOGGER.log(Level.INFO, "Process finished unexpectedly: " + var8_30.getMessage(), var8_30);
                                                                            v1 = null;
                                                                        }
                                                                        break block141;
lbl149:
                                                                        // 1 sources

                                                                        catch (Throwable var10_46) {
                                                                            v1 = null;
                                                                        }
                                                                    }
                                                                    var11_53 = v1;
                                                                    ** try [egrp 7[TRYBLOCK] [22 : 551->558)] { 
lbl154:
                                                                    // 1 sources

                                                                    var1_1.close();
                                                                    break block142;
lbl156:
                                                                    // 1 sources

                                                                    catch (IOException var12_60) {
                                                                        OutputForwarder.LOGGER.log(Level.WARNING, var12_60.getMessage(), (Throwable)var12_60);
                                                                    }
                                                                }
                                                                if (this.runBeforeFinishHook) {
                                                                    for (OutputRecognizer var13_67 : this.recognizers) {
                                                                        for (String var17_95 : var13_67.beforeFinish()) {
                                                                            this.writer.println(var17_95);
                                                                        }
                                                                    }
                                                                }
                                                                this.writer.flush();
                                                                this.writer.close();
                                                                for (OutputRecognizer var13_67 : this.recognizers) {
                                                                    var13_67.finish();
                                                                }
                                                                return;
                                                            }
                                                            catch (Throwable var3_8) {
                                                                block145: {
                                                                    block144: {
                                                                        block143: {
                                                                            OutputForwarder.LOGGER.log(Level.INFO, var3_8.getMessage(), var3_8);
                                                                            var7_19 = null;
                                                                            ** try [egrp 4[TRYBLOCK] [19 : 366->541)] { 
lbl176:
                                                                            // 1 sources

                                                                            ** try [egrp 5[TRYBLOCK] [18 : 366->493)] { 
lbl177:
                                                                            // 1 sources

                                                                            if (Thread.interrupted()) {
                                                                                // empty if block
                                                                            }
                                                                            if (this.stopAction.process == null) {
                                                                                var8_31 = false;
                                                                            } else {
                                                                                ** try [egrp 6[TRYBLOCK] [17 : 388->405)] { 
lbl183:
                                                                                // 1 sources

                                                                                this.stopAction.process.exitValue();
                                                                                var8_31 = false;
                                                                            }
                                                                            break block143;
lbl187:
                                                                            // 1 sources

                                                                            catch (IllegalThreadStateException var9_40) {
                                                                                var8_31 = true;
                                                                            }
                                                                        }
                                                                        if (var8_31) {
                                                                            if (this.str.available() > 0) {
                                                                                var9_40 = var1_1.readLine();
                                                                                var2_5.append((String)var9_40);
                                                                            }
                                                                            if (var2_5.length() > 0) {
                                                                                this.processLine(var2_5.toString());
                                                                            }
                                                                        } else {
                                                                            while ((var9_40 = var1_1.readLine()) != null) {
                                                                                var2_5.append((String)var9_40);
                                                                                this.processLine(var2_5.toString());
                                                                                var2_5.setLength(0);
                                                                            }
                                                                        }
                                                                        v2 = null;
lbl206:
                                                                        // 1 sources

                                                                        catch (IOException var8_32) {
                                                                            OutputForwarder.LOGGER.log(Level.INFO, "Process finished unexpectedly: " + var8_32.getMessage(), var8_32);
                                                                            v2 = null;
                                                                        }
                                                                        break block144;
lbl210:
                                                                        // 1 sources

                                                                        catch (Throwable var10_47) {
                                                                            v2 = null;
                                                                        }
                                                                    }
                                                                    var11_54 = v2;
                                                                    ** try [egrp 7[TRYBLOCK] [22 : 551->558)] { 
lbl215:
                                                                    // 1 sources

                                                                    var1_1.close();
                                                                    break block145;
lbl217:
                                                                    // 1 sources

                                                                    catch (IOException var12_61) {
                                                                        OutputForwarder.LOGGER.log(Level.WARNING, var12_61.getMessage(), (Throwable)var12_61);
                                                                    }
                                                                }
                                                                if (this.runBeforeFinishHook) {
                                                                    for (OutputRecognizer var13_68 : this.recognizers) {
                                                                        for (String var17_96 : var13_68.beforeFinish()) {
                                                                            this.writer.println(var17_96);
                                                                        }
                                                                    }
                                                                }
                                                                this.writer.flush();
                                                                this.writer.close();
                                                                for (OutputRecognizer var13_68 : this.recognizers) {
                                                                    var13_68.finish();
                                                                }
                                                                return;
                                                            }
                                                        }
                                                        ** try [egrp 4[TRYBLOCK] [19 : 366->541)] { 
lbl234:
                                                        // 1 sources

                                                        ** try [egrp 5[TRYBLOCK] [18 : 366->493)] { 
lbl235:
                                                        // 1 sources

                                                        if (Thread.interrupted()) {
                                                            // empty if block
                                                        }
                                                        if (this.stopAction.process == null) {
                                                            var8_21 = false;
                                                        } else {
                                                            ** try [egrp 6[TRYBLOCK] [17 : 388->405)] { 
lbl241:
                                                            // 1 sources

                                                            this.stopAction.process.exitValue();
                                                            var8_21 = false;
                                                        }
                                                        break block146;
lbl245:
                                                        // 1 sources

                                                        catch (IllegalThreadStateException var9_35) {
                                                            var8_21 = true;
                                                        }
                                                    }
                                                    if (var8_21) {
                                                        if (this.str.available() > 0) {
                                                            var9_35 = var1_1.readLine();
                                                            var2_5.append((String)var9_35);
                                                        }
                                                        if (var2_5.length() > 0) {
                                                            this.processLine(var2_5.toString());
                                                        }
                                                    } else {
                                                        while ((var9_35 = var1_1.readLine()) != null) {
                                                            var2_5.append((String)var9_35);
                                                            this.processLine(var2_5.toString());
                                                            var2_5.setLength(0);
                                                        }
                                                    }
                                                    v3 = null;
lbl264:
                                                    // 1 sources

                                                    catch (IOException var8_22) {
                                                        OutputForwarder.LOGGER.log(Level.INFO, "Process finished unexpectedly: " + var8_22.getMessage(), var8_22);
                                                        v3 = null;
                                                    }
                                                    break block147;
lbl268:
                                                    // 1 sources

                                                    catch (Throwable var10_42) {
                                                        v3 = null;
                                                    }
                                                }
                                                var11_49 = v3;
                                                ** try [egrp 7[TRYBLOCK] [22 : 551->558)] { 
lbl273:
                                                // 1 sources

                                                var1_1.close();
                                                break block148;
lbl275:
                                                // 1 sources

                                                catch (IOException var12_56) {
                                                    OutputForwarder.LOGGER.log(Level.WARNING, var12_56.getMessage(), (Throwable)var12_56);
                                                }
                                            }
                                            if (this.runBeforeFinishHook) {
                                                for (OutputRecognizer var13_63 : this.recognizers) {
                                                    for (String var17_91 : var13_63.beforeFinish()) {
                                                        this.writer.println(var17_91);
                                                    }
                                                }
                                            }
                                            this.writer.flush();
                                            this.writer.close();
                                            for (OutputRecognizer var13_63 : this.recognizers) {
                                                var13_63.finish();
                                            }
                                            return;
                                        }
                                        var7_16 = null;
                                        ** try [egrp 4[TRYBLOCK] [19 : 366->541)] { 
lbl293:
                                        // 1 sources

                                        ** try [egrp 5[TRYBLOCK] [18 : 366->493)] { 
lbl294:
                                        // 1 sources

                                        if (Thread.interrupted()) {
                                            // empty if block
                                        }
                                        if (this.stopAction.process == null) {
                                            var8_25 = false;
                                        } else {
                                            ** try [egrp 6[TRYBLOCK] [17 : 388->405)] { 
lbl300:
                                            // 1 sources

                                            this.stopAction.process.exitValue();
                                            var8_25 = false;
                                        }
                                        break block149;
lbl304:
                                        // 1 sources

                                        catch (IllegalThreadStateException var9_37) {
                                            var8_25 = true;
                                        }
                                    }
                                    if (var8_25) {
                                        if (this.str.available() > 0) {
                                            var9_37 = var1_1.readLine();
                                            var2_5.append((String)var9_37);
                                        }
                                        if (var2_5.length() > 0) {
                                            this.processLine(var2_5.toString());
                                        }
                                    } else {
                                        while ((var9_37 = var1_1.readLine()) != null) {
                                            var2_5.append((String)var9_37);
                                            this.processLine(var2_5.toString());
                                            var2_5.setLength(0);
                                        }
                                    }
                                    v4 = null;
lbl323:
                                    // 1 sources

                                    catch (IOException var8_26) {
                                        OutputForwarder.LOGGER.log(Level.INFO, "Process finished unexpectedly: " + var8_26.getMessage(), var8_26);
                                        v4 = null;
                                    }
                                    break block150;
lbl327:
                                    // 1 sources

                                    catch (Throwable var10_44) {
                                        v4 = null;
                                    }
                                }
                                var11_51 = v4;
                                ** try [egrp 7[TRYBLOCK] [22 : 551->558)] { 
lbl332:
                                // 1 sources

                                var1_1.close();
                                break block151;
lbl334:
                                // 1 sources

                                catch (IOException var12_58) {
                                    OutputForwarder.LOGGER.log(Level.WARNING, var12_58.getMessage(), (Throwable)var12_58);
                                }
                            }
                            if (this.runBeforeFinishHook) {
                                for (OutputRecognizer var13_65 : this.recognizers) {
                                    for (String var17_93 : var13_65.beforeFinish()) {
                                        this.writer.println(var17_93);
                                    }
                                }
                            }
                            this.writer.flush();
                            this.writer.close();
                            for (OutputRecognizer var13_65 : this.recognizers) {
                                var13_65.finish();
                            }
                            return;
                        }
                        var7_17 = null;
                        ** try [egrp 4[TRYBLOCK] [19 : 366->541)] { 
lbl352:
                        // 1 sources

                        ** try [egrp 5[TRYBLOCK] [18 : 366->493)] { 
lbl353:
                        // 1 sources

                        if (Thread.interrupted()) {
                            // empty if block
                        }
                        if (this.stopAction.process == null) {
                            var8_27 = false;
                        } else {
                            ** try [egrp 6[TRYBLOCK] [17 : 388->405)] { 
lbl359:
                            // 1 sources

                            this.stopAction.process.exitValue();
                            var8_27 = false;
                        }
                        break block152;
lbl363:
                        // 1 sources

                        catch (IllegalThreadStateException var9_38) {
                            var8_27 = true;
                        }
                    }
                    if (var8_27) {
                        if (this.str.available() > 0) {
                            var9_38 = var1_1.readLine();
                            var2_5.append((String)var9_38);
                        }
                        if (var2_5.length() > 0) {
                            this.processLine(var2_5.toString());
                        }
                    } else {
                        while ((var9_38 = var1_1.readLine()) != null) {
                            var2_5.append((String)var9_38);
                            this.processLine(var2_5.toString());
                            var2_5.setLength(0);
                        }
                    }
                    v5 = null;
lbl382:
                    // 1 sources

                    catch (IOException var8_28) {
                        OutputForwarder.LOGGER.log(Level.INFO, "Process finished unexpectedly: " + var8_28.getMessage(), var8_28);
                        v5 = null;
                    }
                    break block153;
lbl386:
                    // 1 sources

                    catch (Throwable var10_45) {
                        v5 = null;
                    }
                }
                var11_52 = v5;
                ** try [egrp 7[TRYBLOCK] [22 : 551->558)] { 
lbl391:
                // 1 sources

                var1_1.close();
                break block154;
lbl393:
                // 1 sources

                catch (IOException var12_59) {
                    OutputForwarder.LOGGER.log(Level.WARNING, var12_59.getMessage(), (Throwable)var12_59);
                }
            }
            if (this.runBeforeFinishHook) {
                for (OutputRecognizer var13_66 : this.recognizers) {
                    for (String var17_94 : var13_66.beforeFinish()) {
                        this.writer.println(var17_94);
                    }
                }
            }
            this.writer.flush();
            this.writer.close();
            for (OutputRecognizer var13_66 : this.recognizers) {
                var13_66.finish();
            }
            return;
        }
        catch (Throwable var6_98) {
            block157: {
                block156: {
                    block155: {
                        var7_20 = null;
                        ** try [egrp 4[TRYBLOCK] [19 : 366->541)] { 
lbl412:
                        // 1 sources

                        ** try [egrp 5[TRYBLOCK] [18 : 366->493)] { 
lbl413:
                        // 1 sources

                        if (Thread.interrupted()) {
                            // empty if block
                        }
                        if (this.stopAction.process == null) {
                            var8_33 = false;
                        } else {
                            ** try [egrp 6[TRYBLOCK] [17 : 388->405)] { 
lbl419:
                            // 1 sources

                            this.stopAction.process.exitValue();
                            var8_33 = false;
                        }
                        break block155;
lbl423:
                        // 1 sources

                        catch (IllegalThreadStateException var9_41) {
                            var8_33 = true;
                        }
                    }
                    if (var8_33) {
                        if (this.str.available() > 0) {
                            var9_41 = var1_1.readLine();
                            var2_5.append((String)var9_41);
                        }
                        if (var2_5.length() > 0) {
                            this.processLine(var2_5.toString());
                        }
                    } else {
                        while ((var9_41 = var1_1.readLine()) != null) {
                            var2_5.append((String)var9_41);
                            this.processLine(var2_5.toString());
                            var2_5.setLength(0);
                        }
                    }
                    v6 = null;
lbl442:
                    // 1 sources

                    catch (IOException var8_34) {
                        OutputForwarder.LOGGER.log(Level.INFO, "Process finished unexpectedly: " + var8_34.getMessage(), var8_34);
                        v6 = null;
                    }
                    break block156;
lbl446:
                    // 1 sources

                    catch (Throwable var10_48) {
                        v6 = null;
                    }
                }
                var11_55 = v6;
                ** try [egrp 7[TRYBLOCK] [22 : 551->558)] { 
lbl451:
                // 1 sources

                var1_1.close();
                break block157;
lbl453:
                // 1 sources

                catch (IOException var12_62) {
                    OutputForwarder.LOGGER.log(Level.WARNING, var12_62.getMessage(), (Throwable)var12_62);
                }
            }
            if (this.runBeforeFinishHook) {
                for (OutputRecognizer var13_69 : this.recognizers) {
                    for (String var17_97 : var13_69.beforeFinish()) {
                        this.writer.println(var17_97);
                    }
                }
            }
            this.writer.flush();
            this.writer.close();
            var12_62 = this.recognizers.iterator();
            while (true) {
                if (!var12_62.hasNext()) {
                    throw var6_98;
                }
                var13_69 = var12_62.next();
                var13_69.finish();
            }
        }
    }

    private class ActionHandler
    implements OutputListener {
        private final Runnable runnable;

        private ActionHandler(Runnable runnable) {
            this.runnable = runnable;
        }

        public void outputLineSelected(OutputEvent outputEvent) {
        }

        public void outputLineAction(OutputEvent outputEvent) {
            this.runnable.run();
        }

        public void outputLineCleared(OutputEvent outputEvent) {
        }
    }
}

