/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.execution;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.RubyExecution;
import org.netbeans.modules.ruby.platform.execution.FileLocator;
import org.netbeans.modules.ruby.platform.execution.OutputRecognizer;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionDescriptor {
    File pwd;
    File cmd;
    boolean addBinPath;
    boolean inputVisible;
    private String displayName;
    Runnable postBuildAction;
    private final RubyPlatform platform;
    private FileLocator fileLocator;
    String script;
    private String scriptPrefix;
    private Map<String, String> additionalEnv;
    private String[] additionalArgs;
    private String initialArgs;
    private String jvmArgs;
    private FileObject fileObject;
    private String classPath;
    boolean showProgress = true;
    boolean showSuspended;
    boolean frontWindow = true;
    boolean debug;
    private boolean fastDebugRequired;
    private boolean appendJdkToPath;
    private String encoding;
    private boolean useInterpreter;
    List<OutputRecognizer> outputRecognizers;
    private boolean rerun = true;
    private int readMaxWaitTime = 50;

    public ExecutionDescriptor(RubyPlatform rubyPlatform) {
        this(rubyPlatform, null, null);
    }

    public ExecutionDescriptor(RubyPlatform rubyPlatform, String string, File file) {
        this(rubyPlatform, string, file, null);
    }

    public ExecutionDescriptor(RubyPlatform rubyPlatform, String string, File file, String string2) {
        HashMap<String, String> hashMap;
        this.platform = rubyPlatform;
        this.displayName = string;
        this.pwd = file;
        this.script = string2;
        this.outputRecognizers = new ArrayList<OutputRecognizer>();
        this.useInterpreter = true;
        assert (file == null || file.isDirectory()) : file + " is a directory";
        if (rubyPlatform.hasRubyGemsInstalled()) {
            hashMap = new HashMap<String, String>();
            GemManager.adjustEnvironment(rubyPlatform, hashMap);
            this.addAdditionalEnv(hashMap);
        }
        if (rubyPlatform.isJRuby()) {
            hashMap = new HashMap();
            String string3 = rubyPlatform.getHome().getAbsolutePath();
            hashMap.put("JRUBY_HOME", string3);
            hashMap.put("JRUBY_BASE", string3);
            hashMap.put("JAVA_HOME", RubyExecution.getJavaHome());
            this.addAdditionalEnv(hashMap);
        }
    }

    public ExecutionDescriptor cmd(File file) {
        this.cmd = file;
        assert (file != null && file.isFile()) : file + " must be a file";
        return this;
    }

    public ExecutionDescriptor postBuild(Runnable runnable) {
        this.postBuildAction = runnable;
        return this;
    }

    public ExecutionDescriptor fileLocator(FileLocator fileLocator) {
        this.fileLocator = fileLocator;
        return this;
    }

    public ExecutionDescriptor fileObject(FileObject fileObject) {
        this.fileObject = fileObject;
        return this;
    }

    public ExecutionDescriptor addStandardRecognizers() {
        this.outputRecognizers.addAll(RubyExecution.getStandardRubyRecognizers());
        return this;
    }

    public ExecutionDescriptor addOutputRecognizer(OutputRecognizer outputRecognizer) {
        this.outputRecognizers.add(outputRecognizer);
        return this;
    }

    public ExecutionDescriptor allowInput() {
        this.inputVisible = true;
        return this;
    }

    public ExecutionDescriptor showProgress(boolean bl) {
        this.showProgress = bl;
        return this;
    }

    public ExecutionDescriptor showSuspended(boolean bl) {
        this.showSuspended = bl;
        return this;
    }

    public ExecutionDescriptor additionalArgs(String ... stringArray) {
        this.additionalArgs = stringArray;
        return this;
    }

    public ExecutionDescriptor initialArgs(String string) {
        this.initialArgs = string;
        return this;
    }

    public ExecutionDescriptor jvmArguments(String string) {
        this.jvmArgs = string;
        return this;
    }

    public ExecutionDescriptor addBinPath(boolean bl) {
        this.addBinPath = bl;
        return this;
    }

    public ExecutionDescriptor frontWindow(boolean bl) {
        this.frontWindow = bl;
        return this;
    }

    public ExecutionDescriptor debug(boolean bl) {
        this.debug = bl;
        return this;
    }

    public ExecutionDescriptor fastDebugRequired(boolean bl) {
        this.fastDebugRequired = bl;
        return this;
    }

    public ExecutionDescriptor appendJdkToPath(boolean bl) {
        this.appendJdkToPath = bl;
        return this;
    }

    public ExecutionDescriptor classPath(String string) {
        this.classPath = string;
        return this;
    }

    String getDisplayName() {
        return this.debug ? this.displayName + " (debug)" : this.displayName;
    }

    public RubyPlatform getPlatform() {
        return this.platform;
    }

    public File getCmd() {
        return this.cmd;
    }

    public String getScript() {
        return this.script;
    }

    public void scriptPrefix(String string) {
        this.scriptPrefix = string;
    }

    public String getScriptPrefix() {
        return this.scriptPrefix;
    }

    public String[] getAdditionalArgs() {
        return this.additionalArgs;
    }

    public String[] getInitialArgs() {
        return this.initialArgs == null ? null : Utilities.parseParameters((String)this.initialArgs);
    }

    public String[] getJVMArguments() {
        return this.jvmArgs == null ? null : Utilities.parseParameters((String)this.jvmArgs);
    }

    public File getPwd() {
        return this.pwd;
    }

    public boolean isFastDebugRequired() {
        return this.fastDebugRequired;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public FileLocator getFileLocator() {
        return this.fileLocator;
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    String getEncoding() {
        return this.encoding;
    }

    public boolean getAppendJdkToPath() {
        return this.appendJdkToPath;
    }

    public void addAdditionalEnv(Map<String, String> map) {
        if (this.additionalEnv == null) {
            this.additionalEnv = new HashMap<String, String>();
        }
        this.additionalEnv.putAll(map);
    }

    public Map<String, String> getAdditionalEnvironment() {
        return this.additionalEnv;
    }

    public boolean useInterpreter() {
        return this.useInterpreter;
    }

    public void useInterpreter(boolean bl) {
        this.useInterpreter = bl;
    }

    public int getReadMaxWaitTime() {
        return this.readMaxWaitTime;
    }

    public void setReadMaxWaitTime(int n) {
        this.readMaxWaitTime = n;
    }

    public boolean isRerun() {
        return this.rerun;
    }

    public void setRerun(boolean bl) {
        this.rerun = bl;
    }
}

