/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.nb.javascript;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.util.Map;
import java.util.WeakHashMap;
import org.mozilla.nb.javascript.Callable;
import org.mozilla.nb.javascript.Context;
import org.mozilla.nb.javascript.Scriptable;

public abstract class SecureCaller {
    private static final byte[] secureCallerImplBytecode = SecureCaller.loadBytecode();
    private static final Map callers = new WeakHashMap();

    public abstract Object call(Callable var1, Context var2, Scriptable var3, Scriptable var4, Object[] var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object callSecurely(final CodeSource codeSource, Callable callable, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        WeakHashMap<ClassLoader, SoftReference<Object>> weakHashMap;
        final Thread thread = Thread.currentThread();
        final ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return thread.getContextClassLoader();
            }
        });
        Object object = callers;
        synchronized (object) {
            weakHashMap = (WeakHashMap<ClassLoader, SoftReference<Object>>)callers.get(codeSource);
            if (weakHashMap == null) {
                weakHashMap = new WeakHashMap<ClassLoader, SoftReference<Object>>();
                callers.put(codeSource, weakHashMap);
            }
        }
        WeakHashMap<ClassLoader, SoftReference<Object>> weakHashMap2 = weakHashMap;
        synchronized (weakHashMap2) {
            SoftReference softReference = (SoftReference)weakHashMap.get(classLoader);
            object = softReference != null ? (SecureCaller)softReference.get() : null;
            if (object == null) {
                try {
                    object = (SecureCaller)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            Class<?> clazz = this.getClass();
                            ClassLoader classLoader2 = classLoader.loadClass(clazz.getName()) != clazz ? clazz.getClassLoader() : classLoader;
                            SecureClassLoaderImpl secureClassLoaderImpl = new SecureClassLoaderImpl(classLoader2);
                            Class clazz2 = secureClassLoaderImpl.defineAndLinkClass(SecureCaller.class.getName() + "Impl", secureCallerImplBytecode, codeSource);
                            return clazz2.newInstance();
                        }
                    });
                    weakHashMap.put(classLoader, new SoftReference<Object>(object));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw new UndeclaredThrowableException(privilegedActionException.getCause());
                }
            }
        }
        return ((SecureCaller)object).call(callable, context, scriptable, scriptable2, objectArray);
    }

    private static byte[] loadBytecode() {
        return (byte[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return SecureCaller.loadBytecodePrivileged();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] loadBytecodePrivileged() {
        URL uRL = SecureCaller.class.getResource("SecureCallerImpl.clazz");
        try {
            InputStream inputStream = uRL.openStream();
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while (true) {
                    int n;
                    if ((n = inputStream.read()) == -1) {
                        byte[] byArray = byteArrayOutputStream.toByteArray();
                        return byArray;
                    }
                    byteArrayOutputStream.write(n);
                }
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new UndeclaredThrowableException(iOException);
        }
    }

    private static class SecureClassLoaderImpl
    extends SecureClassLoader {
        SecureClassLoaderImpl(ClassLoader classLoader) {
            super(classLoader);
        }

        Class defineAndLinkClass(String string, byte[] byArray, CodeSource codeSource) {
            Class<?> clazz = this.defineClass(string, byArray, 0, byArray.length, codeSource);
            this.resolveClass(clazz);
            return clazz;
        }
    }
}

