/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.nb.javascript;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.mozilla.nb.javascript.CompilerEnvirons;
import org.mozilla.nb.javascript.Context;
import org.mozilla.nb.javascript.Decompiler;
import org.mozilla.nb.javascript.ErrorReporter;
import org.mozilla.nb.javascript.FunctionNode;
import org.mozilla.nb.javascript.IRFactory;
import org.mozilla.nb.javascript.Kit;
import org.mozilla.nb.javascript.Node;
import org.mozilla.nb.javascript.ObjArray;
import org.mozilla.nb.javascript.ScriptOrFnNode;
import org.mozilla.nb.javascript.ScriptRuntime;
import org.mozilla.nb.javascript.Token;
import org.mozilla.nb.javascript.TokenStream;

public class Parser {
    private static final String GENERATED_IDENTIFIER = "__UNKNOWN__";
    public static final int CLEAR_TI_MASK = 65535;
    public static final int TI_AFTER_EOL = 65536;
    public static final int TI_CHECK_LABEL = 131072;
    CompilerEnvirons compilerEnv;
    private ErrorReporter errorReporter;
    private String sourceURI;
    boolean calledByCompileFunction;
    private TokenStream ts;
    private int peekedTokenStart;
    private int peekedTokenEnd;
    private int matchedTokenStart;
    private int matchedTokenEnd;
    private int matchedToken;
    private boolean jsonMode;
    private int currentFlaggedToken;
    private int syntaxErrorCount;
    private IRFactory nf;
    private int nestingOfFunction;
    private Decompiler decompiler;
    private String encodedSource;
    ScriptOrFnNode currentScriptOrFn;
    private int nestingOfWith;
    private Hashtable labelSet;
    private ObjArray loopSet;
    private ObjArray loopAndSwitchSet;
    private boolean hasReturnValue;
    private int functionEndFlags;

    public void setJsonMode(boolean bl) {
        this.jsonMode = bl;
    }

    public Parser(CompilerEnvirons compilerEnvirons, ErrorReporter errorReporter) {
        this.compilerEnv = compilerEnvirons;
        this.errorReporter = errorReporter;
    }

    protected Decompiler createDecompiler(CompilerEnvirons compilerEnvirons) {
        return new NoOpDecompiler();
    }

    void addStrictWarning(String string, String string2, Object object) {
        if (this.compilerEnv.isStrictMode()) {
            this.addWarning(string, string2, object);
        }
    }

    void addWarning(String string, String string2, Object object) {
        String string3 = ScriptRuntime.getMessage1(string, string2);
        if (this.compilerEnv.reportWarningAsError()) {
            ++this.syntaxErrorCount;
            this.errorReporter.error(string3, this.sourceURI, this.ts.getLineno(), this.ts.getLine(), this.ts.getOffset(), string, object);
        } else {
            this.errorReporter.warning(string3, this.sourceURI, this.ts.getLineno(), this.ts.getLine(), this.ts.getOffset(), string, object);
        }
    }

    void addError(String string) {
        ++this.syntaxErrorCount;
        String string2 = ScriptRuntime.getMessage0(string);
        this.errorReporter.error(string2, this.sourceURI, this.ts.getLineno(), this.ts.getLine(), this.ts.getOffset(), string, null);
    }

    void addError(String string, String string2, Object object) {
        ++this.syntaxErrorCount;
        String string3 = ScriptRuntime.getMessage1(string, string2);
        this.errorReporter.error(string3, this.sourceURI, this.ts.getLineno(), this.ts.getLine(), this.ts.getOffset(), string, object);
    }

    RuntimeException reportError(String string) {
        this.addError(string);
        throw new ParserException();
    }

    private int peekToken() throws IOException {
        int n = this.currentFlaggedToken;
        if (n == 0) {
            this.peekedTokenStart = this.ts.getBufferOffset();
            n = this.ts.getToken();
            if (n == 1) {
                do {
                    this.peekedTokenStart = this.ts.getBufferOffset();
                } while ((n = this.ts.getToken()) == 1);
                n |= 0x10000;
            }
            this.currentFlaggedToken = n;
            this.peekedTokenStart += this.ts.seenSpaces();
            this.peekedTokenEnd = this.ts.getBufferOffset();
        }
        return n & 0xFFFF;
    }

    private int peekFlaggedToken() throws IOException {
        this.peekToken();
        return this.currentFlaggedToken;
    }

    private void consumeToken() {
        this.matchedToken = this.currentFlaggedToken;
        this.matchedTokenStart = this.peekedTokenStart;
        this.matchedTokenEnd = this.peekedTokenEnd;
        this.currentFlaggedToken = 0;
    }

    private int nextToken() throws IOException {
        int n = this.peekToken();
        this.consumeToken();
        return n;
    }

    private int nextFlaggedToken() throws IOException {
        this.peekToken();
        int n = this.currentFlaggedToken;
        this.consumeToken();
        return n;
    }

    private boolean matchToken(int n) throws IOException {
        int n2 = this.peekToken();
        if (n2 != n) {
            return false;
        }
        this.consumeToken();
        return true;
    }

    private int peekTokenOrEOL() throws IOException {
        int n = this.peekToken();
        if ((this.currentFlaggedToken & 0x10000) != 0) {
            n = 1;
        }
        return n;
    }

    private void setCheckForLabel() {
        if ((this.currentFlaggedToken & 0xFFFF) != 38) {
            throw Kit.codeBug();
        }
        this.currentFlaggedToken |= 0x20000;
    }

    private void mustMatchToken(int n, String string) throws IOException, ParserException {
        if (!this.matchToken(n)) {
            this.reportError(string);
        }
    }

    private void mustHaveXML() {
        if (!this.compilerEnv.isXmlAvailable()) {
            this.reportError("msg.XML.not.available");
        }
    }

    public String getEncodedSource() {
        return this.encodedSource;
    }

    public boolean eof() {
        return this.ts.eof();
    }

    boolean insideFunction() {
        return this.nestingOfFunction != 0;
    }

    private Node enterLoop(Node node) {
        Node node2 = this.nf.createLoopNode(node, this.ts.getLineno());
        int n = this.getStartOffset();
        node2.setSourceBounds(n, n);
        if (this.loopSet == null) {
            this.loopSet = new ObjArray();
            if (this.loopAndSwitchSet == null) {
                this.loopAndSwitchSet = new ObjArray();
            }
        }
        this.loopSet.push(node2);
        this.loopAndSwitchSet.push(node2);
        return node2;
    }

    private void exitLoop() {
        this.loopSet.pop();
        this.loopAndSwitchSet.pop();
    }

    private Node enterSwitch(Node node, int n) {
        Node node2 = this.nf.createSwitch(node, n);
        if (this.loopAndSwitchSet == null) {
            this.loopAndSwitchSet = new ObjArray();
        }
        this.loopAndSwitchSet.push(node2);
        return node2;
    }

    private void exitSwitch() {
        Node node = (Node)this.loopAndSwitchSet.pop();
        this.setSourceOffsets(node, node.getSourceStart());
    }

    public ScriptOrFnNode parse(String string, String string2, int n) {
        this.sourceURI = string2;
        this.ts = new TokenStream(this, null, string, n);
        try {
            this.setJsonMode(false);
            return this.parse();
        }
        catch (IOException iOException) {
            throw new IllegalStateException();
        }
    }

    public ScriptOrFnNode parse(Reader reader, String string, int n) throws IOException {
        this.sourceURI = string;
        this.ts = new TokenStream(this, reader, null, n);
        return this.parse();
    }

    private ScriptOrFnNode parse() throws IOException {
        int n;
        this.decompiler = this.createDecompiler(this.compilerEnv);
        this.nf = new IRFactory(this);
        this.currentScriptOrFn = this.nf.createScript();
        int n2 = this.decompiler.getCurrentOffset();
        int n3 = this.ts.getBufferOffset();
        this.encodedSource = null;
        this.decompiler.addToken(132);
        this.currentFlaggedToken = 0;
        this.syntaxErrorCount = 0;
        int n4 = this.ts.getLineno();
        Node node = this.nf.createLeaf(125);
        try {
            while ((n = this.peekToken()) > 0) {
                Node node2;
                block8: {
                    if (n == 105) {
                        int n5 = this.peekedTokenStart;
                        this.consumeToken();
                        try {
                            node2 = this.function(this.calledByCompileFunction ? 2 : 1);
                            this.setSourceOffsets(node2, n5);
                            break block8;
                        }
                        catch (ParserException parserException) {
                            break;
                        }
                    }
                    node2 = this.statement();
                }
                this.nf.addChildToBack(node, node2);
            }
        }
        catch (StackOverflowError stackOverflowError) {
            String string = ScriptRuntime.getMessage0("msg.too.deep.parser.recursion");
            throw Context.reportRuntimeError(string, this.sourceURI, this.ts.getLineno(), null, 0);
        }
        if (this.syntaxErrorCount != 0) {
            String string = String.valueOf(this.syntaxErrorCount);
            string = ScriptRuntime.getMessage1("msg.got.syntax.errors", string);
            return null;
        }
        this.currentScriptOrFn.setSourceName(this.sourceURI);
        this.currentScriptOrFn.setBaseLineno(n4);
        this.currentScriptOrFn.setEndLineno(this.ts.getLineno());
        n = this.decompiler.getCurrentOffset();
        this.currentScriptOrFn.setEncodedSourceBounds(n2, n);
        int n6 = this.getEndOffset();
        this.currentScriptOrFn.setSourceBounds(n3, n6);
        this.nf.initScript(this.currentScriptOrFn, node);
        if (this.compilerEnv.isGeneratingSource()) {
            this.encodedSource = this.decompiler.getEncodedSource();
        }
        this.decompiler = null;
        return this.currentScriptOrFn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node parseFunctionBody() throws IOException {
        Node node;
        int n;
        block10: {
            ++this.nestingOfFunction;
            n = this.getStartOffset();
            node = this.nf.createBlock(this.ts.getLineno());
            try {
                while (true) {
                    Node node2;
                    int n2 = this.peekToken();
                    switch (n2) {
                        case -1: 
                        case 0: 
                        case 82: {
                            break block10;
                        }
                        case 105: {
                            this.consumeToken();
                            node2 = this.function(1);
                            break;
                        }
                        default: {
                            node2 = this.statement();
                        }
                    }
                    this.nf.addChildToBack(node, node2);
                }
            }
            catch (ParserException parserException) {
            }
            finally {
                --this.nestingOfFunction;
            }
        }
        node.setSourceBounds(n, this.getEndOffset());
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node function(int n) throws IOException, ParserException {
        int n2;
        int n3;
        Node node;
        Object object;
        int n4;
        String string;
        int n5;
        int n6 = n;
        int n7 = this.ts.getLineno();
        int n8 = this.decompiler.markFunctionStart(n);
        int n9 = n5 = this.getStartOffset();
        Node node2 = null;
        Node node3 = null;
        if (this.matchToken(38)) {
            string = this.ts.getString();
            node2 = Node.newString(156, string);
            this.setSourceOffsets(node2, this.getStartOffset());
            this.decompiler.addName(string);
            if (!this.matchToken(83)) {
                if (this.compilerEnv.isAllowMemberExprAsFunctionName()) {
                    Node node4 = this.nf.createName(string);
                    string = "";
                    node3 = this.memberExprTail(false, node4);
                }
                if ((n4 = this.peekToken()) != 83 && GENERATED_IDENTIFIER.equals(string) && this.matchToken(38)) {
                    string = this.ts.getString();
                    node2 = Node.newString(156, string);
                    this.setSourceOffsets(node2, this.getStartOffset());
                }
                this.mustMatchToken(83, "msg.no.paren.parms");
            }
        } else if (this.matchToken(83)) {
            string = "";
        } else {
            string = "";
            if (this.compilerEnv.isAllowMemberExprAsFunctionName()) {
                node3 = this.memberExpr(false);
            }
            this.mustMatchToken(83, "msg.no.paren.parms");
        }
        if (node3 != null) {
            n6 = 2;
        }
        n4 = this.insideFunction();
        FunctionNode functionNode = this.nf.createFunction(string);
        if (node2 != null) {
            functionNode.addChildToFront(node2);
        }
        if (n4 != 0 || this.nestingOfWith > 0) {
            functionNode.itsIgnoreDynamicScope = true;
        }
        int n10 = this.currentScriptOrFn.addFunction(functionNode);
        ScriptOrFnNode scriptOrFnNode = this.currentScriptOrFn;
        this.currentScriptOrFn = functionNode;
        int n11 = this.nestingOfWith;
        this.nestingOfWith = 0;
        Hashtable hashtable = this.labelSet;
        this.labelSet = null;
        ObjArray objArray = this.loopSet;
        this.loopSet = null;
        ObjArray objArray2 = this.loopAndSwitchSet;
        this.loopAndSwitchSet = null;
        boolean bl = this.hasReturnValue;
        int n12 = this.functionEndFlags;
        try {
            this.decompiler.addToken(83);
            if (!this.matchToken(84)) {
                boolean bl2 = true;
                do {
                    if (!bl2) {
                        this.decompiler.addToken(85);
                    }
                    bl2 = false;
                    this.mustMatchToken(38, "msg.no.parm");
                    object = this.ts.getString();
                    Node node5 = Node.newString(155, (String)object);
                    this.setSourceOffsets(node5, this.getStartOffset());
                    functionNode.addChildToBack(node5);
                    if (functionNode.hasParamOrVar((String)object)) {
                        this.addWarning("msg.dup.parms", (String)object, node5);
                    }
                    functionNode.addParam((String)object);
                    this.decompiler.addName((String)object);
                    while (this.peekToken() == 38 && GENERATED_IDENTIFIER.equals(this.ts.getString())) {
                        this.consumeToken();
                    }
                } while (this.matchToken(85));
                this.mustMatchToken(84, "msg.no.paren.after.parms");
            }
            this.decompiler.addToken(84);
            this.mustMatchToken(81, "msg.no.brace.body");
            this.decompiler.addEOL(81);
            node = this.parseFunctionBody();
            this.mustMatchToken(82, "msg.no.brace.after.body");
            if (this.compilerEnv.isStrictMode() && !node.hasConsistentReturnUsage()) {
                String string2 = string.length() > 0 ? "msg.no.return.value" : "msg.anon.no.return.value";
                this.addStrictWarning(string2, string, functionNode);
            }
            this.decompiler.addToken(82);
            n3 = this.decompiler.markFunctionEnd(n8);
            n9 = this.getEndOffset();
            if (n != 2) {
                this.decompiler.addToken(1);
            }
        }
        finally {
            this.hasReturnValue = bl;
            this.functionEndFlags = n12;
            this.loopAndSwitchSet = objArray2;
            this.loopSet = objArray;
            this.labelSet = hashtable;
            this.nestingOfWith = n11;
            this.currentScriptOrFn = scriptOrFnNode;
        }
        functionNode.setEncodedSourceBounds(n8, n3);
        functionNode.setSourceName(this.sourceURI);
        functionNode.setBaseLineno(n7);
        functionNode.setEndLineno(this.ts.getLineno());
        functionNode.setSourceBounds(n5, n9);
        if (string != null && (n2 = this.currentScriptOrFn.getParamOrVarIndex(string)) >= 0 && n2 < this.currentScriptOrFn.getParamCount()) {
            int n13 = 0;
            for (object = functionNode.getFirstChild(); n13 < n2 && object != null && (((Node)object).getType() != 155 || ++n13 != n2); object = ((Node)object).getParentNode()) {
            }
            this.addStrictWarning("msg.var.hides.arg", string, object);
        }
        Node node6 = this.nf.initFunction(functionNode, n10, node, n6);
        if (node3 != null) {
            node6 = this.nf.createAssignment(86, node3, node6);
            if (n != 2) {
                node6 = this.nf.createExprStatementNoReturn(node6, n7);
            }
        }
        node6.setSourceBounds(functionNode.getSourceStart(), functionNode.getSourceEnd());
        return node6;
    }

    private Node statements() throws IOException {
        int n;
        int n2 = this.getStartOffset();
        Node node = this.nf.createBlock(this.ts.getLineno());
        while ((n = this.peekToken()) > 0 && n != 82) {
            this.nf.addChildToBack(node, this.statement());
        }
        this.setSourceOffsets(node, n2);
        return node;
    }

    private Node condition() throws IOException, ParserException {
        this.mustMatchToken(83, "msg.no.paren.cond");
        this.decompiler.addToken(83);
        this.peekToken();
        int n = this.peekedTokenStart;
        Node node = this.expr(false);
        int n2 = this.getEndOffset();
        node.setSourceBounds(n, n2);
        this.mustMatchToken(84, "msg.no.paren.after.cond");
        this.decompiler.addToken(84);
        if (node.getProp(19) == null && (node.getType() == 8 || node.getType() == 34 || node.getType() == 36)) {
            this.addStrictWarning("msg.equal.as.assign", "", node);
        }
        return node;
    }

    private Node matchJumpLabelName() throws IOException, ParserException {
        Node node = null;
        int n = this.peekTokenOrEOL();
        if (n == 38) {
            this.consumeToken();
            String string = this.ts.getString();
            this.decompiler.addName(string);
            if (this.labelSet != null) {
                node = (Node)this.labelSet.get(string);
            }
            if (node == null) {
                this.reportError("msg.undef.label");
            }
        }
        return node;
    }

    private Node statement() throws IOException {
        int n = this.getStartOffset();
        try {
            Node node = this.statementHelper(null);
            if (node != null) {
                if (this.compilerEnv.isStrictMode() && !node.hasSideEffects()) {
                    this.addStrictWarning("msg.no.side.effects", "", node);
                }
                return node;
            }
        }
        catch (ParserException parserException) {
            // empty catch block
        }
        int n2 = this.ts.getLineno();
        block5: while (true) {
            int n3 = this.peekTokenOrEOL();
            this.consumeToken();
            switch (n3) {
                case -1: 
                case 0: 
                case 1: 
                case 78: {
                    break block5;
                }
                default: {
                    continue block5;
                }
            }
            break;
        }
        return this.setSourceOffsets(this.nf.createExprStatement(this.nf.createName("error"), n2), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Node statementHelper(Node var1_1) throws IOException, ParserException {
        var2_2 = null;
        var3_3 = this.peekToken();
        var4_4 = this.peekedTokenStart;
        switch (var3_3) {
            case 108: {
                this.consumeToken();
                this.decompiler.addToken(108);
                var5_5 = this.ts.getLineno();
                var6_14 = this.condition();
                this.decompiler.addEOL(81);
                var7_25 = this.statement();
                var8_34 = null;
                if (this.matchToken(109)) {
                    this.decompiler.addToken(82);
                    this.decompiler.addToken(109);
                    this.decompiler.addEOL(81);
                    var8_34 = this.statement();
                }
                this.decompiler.addEOL(82);
                var2_2 = this.nf.createIf(var6_14, var7_25, var8_34, var5_5);
                var2_2.setSourceBounds(var4_4, this.getEndOffset());
                return var2_2;
            }
            case 110: {
                this.consumeToken();
                this.decompiler.addToken(110);
                var5_6 = this.ts.getLineno();
                this.mustMatchToken(83, "msg.no.paren.switch");
                this.decompiler.addToken(83);
                var2_2 = this.enterSwitch(this.expr(false), var5_6);
                try {
                    this.mustMatchToken(84, "msg.no.paren.after.switch");
                    this.decompiler.addToken(84);
                    this.mustMatchToken(81, "msg.no.brace.switch");
                    this.decompiler.addEOL(81);
                    var6_15 = 0;
                    block49: while (true) {
                        var3_3 = this.nextToken();
                        var8_35 = this.peekedTokenStart;
                        switch (var3_3) {
                            case 82: {
                                break block49;
                            }
                            case 111: {
                                this.decompiler.addToken(111);
                                var7_26 = this.expr(false);
                                this.mustMatchToken(99, "msg.no.colon.case");
                                this.decompiler.addEOL(99);
                                break;
                            }
                            case 112: {
                                if (var6_15 != 0) {
                                    this.reportError("msg.double.switch.default");
                                }
                                this.decompiler.addToken(112);
                                var6_15 = 1;
                                var7_26 = null;
                                this.mustMatchToken(99, "msg.no.colon.case");
                                this.decompiler.addEOL(99);
                                break;
                            }
                            default: {
                                this.reportError("msg.bad.switch");
                                break block49;
                            }
                        }
                        var9_40 = this.nf.createLeaf(125);
                        var10_44 = this.getStartOffset();
                        var2_2.setSourceBounds(var10_44, var10_44);
                        while ((var3_3 = this.peekToken()) != 82 && var3_3 != 111 && var3_3 != 112 && var3_3 != 0) {
                            this.nf.addChildToBack(var9_40, this.statement());
                        }
                        this.nf.addSwitchCase(var2_2, var7_26, var9_40, var8_35);
                    }
                    this.decompiler.addEOL(82);
                    this.nf.closeSwitch(var2_2);
                }
                finally {
                    this.exitSwitch();
                }
                var6_15 = this.matchedTokenEnd;
                var2_2.setSourceBounds(var4_4, var6_15);
                return var2_2;
            }
            case 113: {
                this.consumeToken();
                this.decompiler.addToken(113);
                var5_7 = this.enterLoop(var1_1);
                try {
                    var6_16 = this.condition();
                    this.decompiler.addEOL(81);
                    var7_27 = this.statement();
                    this.decompiler.addEOL(82);
                    var2_2 = this.nf.createWhile(var5_7, var6_16, var7_27);
                    this.setSourceOffsets(var2_2, var4_4);
                }
                finally {
                    this.exitLoop();
                }
                return var2_2;
            }
            case 114: {
                this.consumeToken();
                this.decompiler.addToken(114);
                this.decompiler.addEOL(81);
                var5_8 = this.enterLoop(var1_1);
                try {
                    var6_17 = this.statement();
                    this.decompiler.addToken(82);
                    this.mustMatchToken(113, "msg.no.while.do");
                    this.decompiler.addToken(113);
                    var7_28 = this.condition();
                    var2_2 = this.nf.createDoWhile(var5_8, var6_17, var7_28);
                }
                finally {
                    this.exitLoop();
                }
                this.matchToken(78);
                this.decompiler.addEOL(78);
                this.setSourceOffsets(var2_2, var4_4);
                return var2_2;
            }
            case 115: {
                this.consumeToken();
                var5_9 = false;
                this.decompiler.addToken(115);
                var6_18 = this.enterLoop(var1_1);
                try {
                    var9_41 = null;
                    if (this.matchToken(38)) {
                        this.decompiler.addName(this.ts.getString());
                        if (this.ts.getString().equals("each")) {
                            var5_9 = true;
                        } else {
                            this.reportError("msg.no.paren.for");
                        }
                    }
                    this.mustMatchToken(83, "msg.no.paren.for");
                    this.decompiler.addToken(83);
                    var11_49 = this.getStartOffset();
                    var3_3 = this.peekToken();
                    if (var3_3 == 78) {
                        var7_29 = this.nf.createLeaf(124);
                        var12_52 = this.getStartOffset();
                        var7_29.setSourceBounds(var12_52, var12_52);
                    } else if (var3_3 == 118) {
                        this.consumeToken();
                        var7_29 = this.variables(115);
                        var12_52 = this.getEndOffset();
                        var7_29.setSourceBounds(var11_49, var12_52);
                    } else {
                        var7_29 = this.expr(true);
                    }
                    if (this.matchToken(51)) {
                        this.decompiler.addToken(51);
                        var8_36 = this.expr(false);
                    } else {
                        this.mustMatchToken(78, "msg.no.semi.for");
                        this.decompiler.addToken(78);
                        if (this.peekToken() == 78) {
                            var8_36 = this.nf.createLeaf(124);
                            var12_52 = this.getStartOffset();
                            var8_36.setSourceBounds(var12_52, var12_52);
                        } else {
                            var8_36 = this.expr(false);
                        }
                        this.mustMatchToken(78, "msg.no.semi.for.cond");
                        this.decompiler.addToken(78);
                        if (this.peekToken() == 84) {
                            var9_41 = this.nf.createLeaf(124);
                            var12_52 = this.getStartOffset();
                            var9_41.setSourceBounds(var12_52, var12_52);
                        } else {
                            var9_41 = this.expr(false);
                        }
                    }
                    this.mustMatchToken(84, "msg.no.paren.for.ctrl");
                    this.decompiler.addToken(84);
                    this.decompiler.addEOL(81);
                    var10_45 = this.statement();
                    this.decompiler.addEOL(82);
                    var2_2 = var9_41 == null ? this.nf.createForIn(var6_18, var7_29, var8_36, var10_45, var5_9) : this.nf.createFor(var6_18, var7_29, var8_36, var9_41, var10_45);
                }
                finally {
                    this.exitLoop();
                }
                this.setSourceOffsets(var2_2, var4_4);
                return var2_2;
            }
            case 77: {
                this.consumeToken();
                var4_4 = this.getStartOffset();
                var5_10 = this.ts.getLineno();
                var7_30 = null;
                var8_37 = null;
                this.decompiler.addToken(77);
                this.decompiler.addEOL(81);
                var6_19 = this.statement();
                this.decompiler.addEOL(82);
                var7_30 = this.nf.createLeaf(125);
                var9_42 = false;
                var10_46 = this.peekToken();
                if (var10_46 == 120) {
                    while (this.matchToken(120)) {
                        if (var9_42) {
                            this.reportError("msg.catch.unreachable");
                        }
                        var11_50 = this.getStartOffset();
                        this.decompiler.addToken(120);
                        this.mustMatchToken(83, "msg.no.paren.catch");
                        this.decompiler.addToken(83);
                        this.mustMatchToken(38, "msg.bad.catchcond");
                        var12_53 = this.getStartOffset();
                        var13_56 = this.matchedTokenEnd;
                        var14_58 = this.ts.getString();
                        this.decompiler.addName(var14_58);
                        var15_59 = null;
                        if (this.matchToken(108)) {
                            this.decompiler.addToken(108);
                            var15_59 = this.expr(false);
                        } else {
                            var9_42 = true;
                        }
                        this.mustMatchToken(84, "msg.bad.catchcond");
                        this.decompiler.addToken(84);
                        this.mustMatchToken(81, "msg.no.brace.catchblock");
                        this.decompiler.addEOL(81);
                        var7_30.setSourceBounds(var4_4, this.getEndOffset());
                        if (var15_59 == null) {
                            var15_59 = new Node(124);
                            var15_59.setSourceBounds(var13_56, var13_56);
                        }
                        var16_60 = this.nf.createCatch(var14_58, var15_59, this.statements(), this.ts.getLineno());
                        this.setSourceOffsets(var16_60, var11_50);
                        this.nf.addChildToBack(var7_30, var16_60);
                        var17_61 = var7_30.getLastChild().getFirstChild();
                        var17_61.setSourceBounds(var12_53, var13_56);
                        this.mustMatchToken(82, "msg.no.brace.after.body");
                        this.decompiler.addEOL(82);
                    }
                } else if (var10_46 != 121) {
                    this.mustMatchToken(121, "msg.try.no.catchfinally");
                }
                if (this.matchToken(121)) {
                    var11_50 = this.getStartOffset();
                    this.decompiler.addToken(121);
                    this.decompiler.addEOL(81);
                    var8_37 = this.statement();
                    var12_54 = new Node(121, var8_37);
                    var12_54.setSourceBounds(var11_50, this.getEndOffset());
                    var8_37 = var12_54;
                    this.decompiler.addEOL(82);
                }
                var2_2 = this.nf.createTryCatchFinally(var6_19, var7_30, var8_37, var5_10);
                var2_2.setSourceBounds(var4_4, this.getEndOffset());
                return var2_2;
            }
            case 49: {
                this.consumeToken();
                if (this.peekTokenOrEOL() == 1) {
                    this.reportError("msg.bad.throw.eol");
                }
                var5_11 = this.ts.getLineno();
                this.decompiler.addToken(49);
                var2_2 = this.nf.createThrow(this.expr(false), var5_11);
                var2_2.setSourceBounds(var4_4, this.getEndOffset());
                break;
            }
            case 116: {
                this.consumeToken();
                var5_11 = this.ts.getLineno();
                this.decompiler.addToken(116);
                var6_20 = this.matchJumpLabelName();
                if (var6_20 == null) {
                    if (this.loopAndSwitchSet == null || this.loopAndSwitchSet.size() == 0) {
                        this.reportError("msg.bad.break");
                        return null;
                    }
                    var6_20 = (Node)this.loopAndSwitchSet.peek();
                }
                var2_2 = this.nf.createBreak(var6_20, var5_11);
                this.setSourceOffsets(var2_2, var4_4);
                break;
            }
            case 117: {
                this.consumeToken();
                var5_11 = this.ts.getLineno();
                this.decompiler.addToken(117);
                var7_31 = this.matchJumpLabelName();
                if (var7_31 == null) {
                    if (this.loopSet == null || this.loopSet.size() == 0) {
                        this.reportError("msg.continue.outside");
                        return null;
                    }
                    var6_21 = (Node)this.loopSet.peek();
                } else {
                    var6_21 = this.nf.getLabelLoop(var7_31);
                    if (var6_21 == null) {
                        this.reportError("msg.continue.nonloop");
                        return null;
                    }
                }
                var2_2 = this.nf.createContinue(var6_21, var5_11);
                this.setSourceOffsets(var2_2, var4_4);
                break;
            }
            case 119: {
                this.consumeToken();
                this.decompiler.addToken(119);
                var5_12 = this.ts.getLineno();
                this.mustMatchToken(83, "msg.no.paren.with");
                this.decompiler.addToken(83);
                var6_22 = this.expr(false);
                this.mustMatchToken(84, "msg.no.paren.after.with");
                this.decompiler.addToken(84);
                this.decompiler.addEOL(81);
                ++this.nestingOfWith;
                try {
                    var7_32 = this.statement();
                }
                finally {
                    --this.nestingOfWith;
                }
                this.decompiler.addEOL(82);
                var2_2 = this.nf.createWith(var6_22, var7_32, var5_12);
                this.setSourceOffsets(var2_2, var4_4);
                return var2_2;
            }
            case 118: 
            case 149: {
                this.consumeToken();
                var2_2 = this.variables(var3_3);
                this.setSourceOffsets(var2_2, var4_4);
                break;
            }
            case 4: {
                if (!this.insideFunction()) {
                    this.reportError("msg.bad.return");
                }
                this.consumeToken();
                this.decompiler.addToken(4);
                var5_11 = this.ts.getLineno();
                var3_3 = this.peekTokenOrEOL();
                switch (var3_3) {
                    case -1: 
                    case 0: 
                    case 1: 
                    case 78: 
                    case 82: {
                        var6_23 = null;
                        break;
                    }
                    default: {
                        var6_23 = this.expr(false);
                        this.hasReturnValue = true;
                    }
                }
                var2_2 = this.nf.createReturn(var6_23, var5_11);
                var2_2.setSourceBounds(var4_4, this.getEndOffset());
                if (var6_23 == null) {
                    if (this.functionEndFlags == 4) {
                        this.addStrictWarning("msg.return.inconsistent", "", var2_2);
                    }
                    this.functionEndFlags |= 2;
                    break;
                }
                if (this.functionEndFlags == 2) {
                    this.addStrictWarning("msg.return.inconsistent", "", var2_2);
                }
                this.functionEndFlags |= 4;
                break;
            }
            case 81: {
                this.consumeToken();
                if (var1_1 != null) {
                    this.decompiler.addToken(81);
                }
                var2_2 = this.statements();
                this.mustMatchToken(82, "msg.no.brace.block");
                if (var1_1 != null) {
                    this.decompiler.addEOL(82);
                }
                var2_2.setSourceBounds(var4_4, this.getEndOffset());
                return var2_2;
            }
            case -1: 
            case 78: {
                this.consumeToken();
                var2_2 = this.nf.createLeaf(124);
                var5_13 = this.getStartOffset();
                var2_2.setSourceBounds(var5_13, var5_13);
                return var2_2;
            }
            case 105: {
                this.consumeToken();
                var2_2 = this.function(3);
                this.setSourceOffsets(var2_2, var4_4);
                return var2_2;
            }
            case 112: {
                this.consumeToken();
                this.mustHaveXML();
                this.decompiler.addToken(112);
                var6_24 = this.ts.getLineno();
                if (!this.matchToken(38) || !this.ts.getString().equals("xml")) {
                    this.reportError("msg.bad.namespace");
                }
                this.decompiler.addName(" xml");
                if (!this.matchToken(38) || !this.ts.getString().equals("namespace")) {
                    this.reportError("msg.bad.namespace");
                }
                this.decompiler.addName(" namespace");
                if (!this.matchToken(86)) {
                    this.reportError("msg.bad.namespace");
                }
                this.decompiler.addToken(86);
                var7_33 = this.expr(false);
                var2_2 = this.nf.createDefaultNamespace(var7_33, var6_24);
                this.setSourceOffsets(var2_2, var4_4);
                break;
            }
            case 38: {
                var8_38 = this.ts.getLineno();
                var9_43 = this.ts.getString();
                this.setCheckForLabel();
                var2_2 = this.expr(false);
                if (var2_2.getType() != 126) ** GOTO lbl426
                if (this.peekToken() != 99) {
                    Kit.codeBug();
                }
                this.consumeToken();
                this.decompiler.addName(var9_43);
                this.decompiler.addEOL(99);
                if (this.labelSet == null) {
                    this.labelSet = new Hashtable<K, V>();
                } else if (this.labelSet.containsKey(var9_43)) {
                    this.reportError("msg.dup.label");
                }
                if (var1_1 == null) {
                    var10_47 = true;
                    var1_1 = var2_2;
                } else {
                    var10_47 = false;
                }
                this.labelSet.put(var9_43, var1_1);
                try {
                    var2_2 = this.statementHelper(var1_1);
                }
                finally {
                    this.labelSet.remove(var9_43);
                }
                if (var10_47) {
                    var2_2 = this.nf.createLabeledStatement(var1_1, var2_2);
                }
                this.setSourceOffsets(var2_2, var4_4);
                return var2_2;
lbl426:
                // 1 sources

                var2_2 = this.nf.createExprStatement(var2_2, var8_38);
                this.setSourceOffsets(var2_2, var4_4);
                break;
            }
            default: {
                var8_39 = this.ts.getLineno();
                var2_2 = this.expr(false);
                var2_2 = this.nf.createExprStatement(var2_2, var8_39);
                this.setSourceOffsets(var2_2, var4_4);
                break;
            }
        }
        var5_11 = this.peekFlaggedToken();
        switch (var5_11 & 65535) {
            case 78: {
                this.consumeToken();
                break;
            }
            case -1: 
            case 0: 
            case 82: {
                break;
            }
            default: {
                if ((var5_11 & 65536) != 0) break;
                this.reportError("msg.no.semi.stmt");
            }
        }
        this.decompiler.addEOL(78);
        this.setSourceOffsets(var2_2, var4_4);
        return var2_2;
    }

    private Node variables(int n) throws IOException, ParserException {
        Node node;
        int n2 = this.getStartOffset();
        boolean bl = true;
        if (n == 149) {
            node = this.nf.createVariables(149, this.ts.getLineno());
            this.decompiler.addToken(149);
        } else {
            node = this.nf.createVariables(118, this.ts.getLineno());
            this.decompiler.addToken(118);
        }
        do {
            this.mustMatchToken(38, "msg.bad.var");
            int n3 = this.getStartOffset();
            String string = this.ts.getString();
            if (!bl) {
                this.decompiler.addToken(85);
            }
            bl = false;
            this.decompiler.addName(string);
            Node node2 = this.nf.createName(string);
            if (n == 149) {
                if (!this.currentScriptOrFn.addConst(string)) {
                    if (this.currentScriptOrFn.addVar(string) != -2) {
                        this.addError("msg.var.redecl", string, node2);
                    } else {
                        this.addError("msg.const.redecl", string, node2);
                    }
                }
            } else {
                int n4 = this.currentScriptOrFn.addVar(string);
                if (n4 == -2) {
                    this.addError("msg.const.redecl", string, node2);
                } else if (n4 == -1) {
                    this.addStrictWarning("msg.var.hides.arg", string, node2);
                } else if (n4 == 0) {
                    this.addStrictWarning("msg.var.redecl", string, node2);
                }
            }
            this.setSourceOffsets(node2, n3);
            if (this.matchToken(86)) {
                this.decompiler.addToken(86);
                Node node3 = this.assignExpr(n == 115);
                this.nf.addChildToBack(node2, node3);
            }
            this.nf.addChildToBack(node, node2);
        } while (this.matchToken(85));
        node.setSourceBounds(n2, Math.max(this.getEndOffset(), node.getSourceEnd()));
        return node;
    }

    private Node expr(boolean bl) throws IOException, ParserException {
        int n = this.getStartOffset();
        Node node = this.assignExpr(bl);
        while (this.matchToken(85)) {
            this.decompiler.addToken(85);
            if (this.compilerEnv.isStrictMode() && !node.hasSideEffects()) {
                this.addStrictWarning("msg.no.side.effects", "", node);
            }
            node = this.nf.createBinary(85, node, this.assignExpr(bl));
        }
        this.setSourceOffsets(node, n);
        return node;
    }

    private Node assignExpr(boolean bl) throws IOException, ParserException {
        int n = this.getStartOffset();
        Node node = this.condExpr(bl);
        int n2 = this.peekToken();
        if (n2 == 38 && GENERATED_IDENTIFIER.equals(this.ts.getString())) {
            while ((this.currentFlaggedToken & 0x10000) == 0 && this.peekToken() == 38 && GENERATED_IDENTIFIER.equals(this.ts.getString())) {
                this.consumeToken();
            }
            n2 = this.peekToken();
        }
        if (86 <= n2 && n2 <= 97) {
            this.consumeToken();
            this.decompiler.addToken(n2);
            node = this.nf.createAssignment(n2, node, this.assignExpr(bl));
        }
        this.setSourceOffsets(node, n);
        return node;
    }

    private Node condExpr(boolean bl) throws IOException, ParserException {
        int n = this.getStartOffset();
        Node node = this.orExpr(bl);
        if (this.matchToken(98)) {
            this.decompiler.addToken(98);
            Node node2 = this.assignExpr(false);
            this.mustMatchToken(99, "msg.no.colon.cond");
            this.decompiler.addToken(99);
            Node node3 = this.assignExpr(bl);
            return this.nf.createCondExpr(node, node2, node3);
        }
        this.setSourceOffsets(node, n);
        return node;
    }

    private Node orExpr(boolean bl) throws IOException, ParserException {
        int n = this.getStartOffset();
        Node node = this.andExpr(bl);
        if (this.matchToken(100)) {
            this.decompiler.addToken(100);
            node = this.nf.createBinary(100, node, this.orExpr(bl));
        }
        this.setSourceOffsets(node, n);
        return node;
    }

    private Node andExpr(boolean bl) throws IOException, ParserException {
        int n = this.getStartOffset();
        Node node = this.bitOrExpr(bl);
        if (this.matchToken(101)) {
            this.decompiler.addToken(101);
            node = this.nf.createBinary(101, node, this.andExpr(bl));
        }
        this.setSourceOffsets(node, n);
        return node;
    }

    private Node bitOrExpr(boolean bl) throws IOException, ParserException {
        int n = this.getStartOffset();
        Node node = this.bitXorExpr(bl);
        while (this.matchToken(9)) {
            this.decompiler.addToken(9);
            node = this.nf.createBinary(9, node, this.bitXorExpr(bl));
        }
        this.setSourceOffsets(node, n);
        return node;
    }

    private Node bitXorExpr(boolean bl) throws IOException, ParserException {
        int n = this.getStartOffset();
        Node node = this.bitAndExpr(bl);
        while (this.matchToken(10)) {
            this.decompiler.addToken(10);
            node = this.nf.createBinary(10, node, this.bitAndExpr(bl));
        }
        this.setSourceOffsets(node, n);
        return node;
    }

    private Node bitAndExpr(boolean bl) throws IOException, ParserException {
        int n = this.getStartOffset();
        Node node = this.eqExpr(bl);
        while (this.matchToken(11)) {
            this.decompiler.addToken(11);
            node = this.nf.createBinary(11, node, this.eqExpr(bl));
        }
        this.setSourceOffsets(node, n);
        return node;
    }

    private Node eqExpr(boolean bl) throws IOException, ParserException {
        int n = this.getStartOffset();
        Node node = this.relExpr(bl);
        block9: while (true) {
            int n2 = this.peekToken();
            switch (n2) {
                case 12: 
                case 13: 
                case 45: 
                case 46: {
                    this.consumeToken();
                    int n3 = n2;
                    int n4 = n2;
                    if (this.compilerEnv.getLanguageVersion() == 120) {
                        switch (n2) {
                            case 12: {
                                n4 = 45;
                                break;
                            }
                            case 13: {
                                n4 = 46;
                                break;
                            }
                            case 45: {
                                n3 = 12;
                                break;
                            }
                            case 46: {
                                n3 = 13;
                            }
                        }
                    }
                    this.decompiler.addToken(n3);
                    node = this.nf.createBinary(n4, node, this.relExpr(bl));
                    continue block9;
                }
            }
            break;
        }
        this.setSourceOffsets(node, n);
        return node;
    }

    private Node relExpr(boolean bl) throws IOException, ParserException {
        int n = this.getStartOffset();
        Node node = this.shiftExpr();
        block4: while (true) {
            int n2 = this.peekToken();
            switch (n2) {
                case 51: {
                    if (bl) break block4;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 52: {
                    this.consumeToken();
                    this.decompiler.addToken(n2);
                    node = this.nf.createBinary(n2, node, this.shiftExpr());
                    continue block4;
                }
            }
            break;
        }
        this.setSourceOffsets(node, n);
        return node;
    }

    private Node shiftExpr() throws IOException, ParserException {
        int n = this.getStartOffset();
        Node node = this.addExpr();
        block3: while (true) {
            int n2 = this.peekToken();
            switch (n2) {
                case 18: 
                case 19: 
                case 20: {
                    this.consumeToken();
                    this.decompiler.addToken(n2);
                    node = this.nf.createBinary(n2, node, this.addExpr());
                    continue block3;
                }
            }
            break;
        }
        this.setSourceOffsets(node, n);
        return node;
    }

    private Node addExpr() throws IOException, ParserException {
        int n;
        int n2 = this.getStartOffset();
        Node node = this.mulExpr();
        while ((n = this.peekToken()) == 21 || n == 22) {
            this.consumeToken();
            this.decompiler.addToken(n);
            node = this.nf.createBinary(n, node, this.mulExpr());
        }
        this.setSourceOffsets(node, n2);
        return node;
    }

    private Node mulExpr() throws IOException, ParserException {
        int n = this.getStartOffset();
        Node node = this.unaryExpr();
        block3: while (true) {
            int n2 = this.peekToken();
            switch (n2) {
                case 23: 
                case 24: 
                case 25: {
                    this.consumeToken();
                    this.decompiler.addToken(n2);
                    node = this.nf.createBinary(n2, node, this.unaryExpr());
                    continue block3;
                }
            }
            break;
        }
        this.setSourceOffsets(node, n);
        return node;
    }

    private Node unaryExpr() throws IOException, ParserException {
        int n = this.peekToken();
        int n2 = this.getStartOffset();
        switch (n) {
            case 26: 
            case 27: 
            case 32: 
            case 122: {
                this.consumeToken();
                this.decompiler.addToken(n);
                return this.setSourceOffsets(this.nf.createUnary(n, this.unaryExpr()), n2);
            }
            case 21: {
                this.consumeToken();
                this.decompiler.addToken(28);
                return this.setSourceOffsets(this.nf.createUnary(28, this.unaryExpr()), n2);
            }
            case 22: {
                this.consumeToken();
                this.decompiler.addToken(29);
                return this.setSourceOffsets(this.nf.createUnary(29, this.unaryExpr()), n2);
            }
            case 102: 
            case 103: {
                this.consumeToken();
                this.decompiler.addToken(n);
                return this.setSourceOffsets(this.nf.createIncDec(n, false, this.memberExpr(true)), n2);
            }
            case 31: {
                this.consumeToken();
                this.decompiler.addToken(31);
                return this.setSourceOffsets(this.nf.createUnary(31, this.unaryExpr()), n2);
            }
            case -1: {
                this.consumeToken();
                break;
            }
            case 14: {
                if (this.compilerEnv.isXmlAvailable()) {
                    this.consumeToken();
                    Node node = this.xmlInitializer();
                    return this.setSourceOffsets(this.memberExprTail(true, node), n2);
                }
            }
            default: {
                Node node = this.memberExpr(true);
                n = this.peekTokenOrEOL();
                if (n == 102 || n == 103) {
                    this.consumeToken();
                    this.decompiler.addToken(n);
                    return this.setSourceOffsets(this.nf.createIncDec(n, true, node), n2);
                }
                this.setSourceOffsets(node, n2);
                return node;
            }
        }
        return this.nf.createName("err");
    }

    Node setSourceOffsets(Node node, int n) {
        if (node.getSourceEnd() != 0) {
            return node;
        }
        int n2 = this.matchedTokenEnd;
        node.setSourceBounds(n, n2);
        return node;
    }

    int getStartOffset() {
        return this.matchedTokenStart;
    }

    int getEndOffset() {
        return this.matchedTokenEnd;
    }

    private Node xmlInitializer() throws IOException {
        int n = this.getStartOffset();
        int n2 = this.ts.getFirstXMLToken();
        if (n2 != 141 && n2 != 144) {
            this.reportError("msg.syntax");
            return null;
        }
        Node node = this.nf.createLeaf(166);
        Node node2 = null;
        String string = this.ts.getString();
        node2 = null;
        while (true) {
            switch (n2) {
                case 141: {
                    Node node3;
                    Node node4;
                    string = this.ts.getString();
                    int n3 = this.ts.getBufferOffset();
                    n = n3 - string.length();
                    this.decompiler.addName(string);
                    this.mustMatchToken(81, "msg.syntax");
                    this.decompiler.addToken(81);
                    if (this.peekToken() == 82) {
                        node4 = this.nf.createString("");
                        node4.setSourceBounds(n, n);
                    } else {
                        node4 = this.expr(false);
                    }
                    this.mustMatchToken(82, "msg.syntax");
                    this.decompiler.addToken(82);
                    if (node2 == null) {
                        node2 = this.nf.createString(string);
                        node2.setSourceBounds(n, n3);
                    } else {
                        node3 = this.nf.createString(string);
                        node3.setSourceBounds(n, n3);
                        node2 = this.nf.createBinary(21, node2, node3);
                        node2.setSourceBounds(node2.getSourceStart(), n3);
                    }
                    node4 = this.nf.createUnary(72, node4);
                    node2 = this.nf.createBinary(21, node2, node4);
                    node2.setSourceBounds(node2.getSourceStart(), node4.getSourceEnd());
                    break;
                }
                case 144: {
                    Node node3;
                    string = this.ts.getString();
                    this.decompiler.addName(string);
                    int n3 = this.ts.getBufferOffset();
                    n = n3 - string.length();
                    if (node2 == null) {
                        node2 = this.nf.createString(string);
                        node2.setSourceBounds(n, n3);
                    } else {
                        node3 = this.nf.createString(string);
                        node3.setSourceBounds(n, n3);
                        node2 = this.nf.createBinary(21, node2, node3);
                    }
                    this.nf.addChildToBack(node, node2);
                    node.setSourceBounds(node.getSourceStart(), n3);
                    this.matchedTokenEnd = n3;
                    return node;
                }
                default: {
                    this.reportError("msg.syntax");
                    return null;
                }
            }
            n2 = this.ts.getNextXMLToken();
        }
    }

    private void argumentList(Node node) throws IOException, ParserException {
        int n = this.getStartOffset();
        boolean bl = this.matchToken(84);
        if (!bl) {
            boolean bl2 = true;
            boolean bl3 = false;
            do {
                int n2;
                if (!bl2) {
                    this.decompiler.addToken(85);
                }
                bl2 = false;
                if (bl3 && (n2 = this.peekToken()) == 84) break;
                Node node2 = this.assignExpr(false);
                int n3 = this.peekToken();
                while (n3 == 38 || n3 == 40) {
                    if (n3 == 38 && GENERATED_IDENTIFIER.equals(this.ts.getString())) {
                        bl3 = true;
                        this.nextToken();
                    } else {
                        if (n3 != 40 || this.ts.getString().indexOf(GENERATED_IDENTIFIER) == -1) break;
                        bl3 = true;
                        this.nextToken();
                    }
                    n3 = this.peekToken();
                }
                if ((n3 = this.peekToken()) != 85 && n3 != 84 && node2.getType() == 38 && GENERATED_IDENTIFIER.equals(node2.getString())) {
                    node2 = this.assignExpr(false);
                }
                this.nf.addChildToBack(node, node2);
            } while (this.matchToken(85));
            this.mustMatchToken(84, "msg.no.paren.arg");
        }
        this.setSourceOffsets(node, n);
        this.decompiler.addToken(84);
    }

    private Node memberExpr(boolean bl) throws IOException, ParserException {
        Node node;
        int n = this.peekToken();
        int n2 = this.getStartOffset();
        if (n == 30) {
            this.consumeToken();
            this.decompiler.addToken(30);
            n2 = this.getStartOffset();
            node = this.nf.createCallOrNew(30, this.memberExpr(false));
            node.setSourceBounds(n2, node.getSourceEnd());
            if (this.matchToken(83)) {
                this.decompiler.addToken(83);
                this.argumentList(node);
            }
            if ((n = this.peekToken()) == 81) {
                this.nf.addChildToBack(node, this.primaryExpr());
            }
        } else {
            node = this.primaryExpr();
        }
        this.setSourceOffsets(node, n2);
        return this.memberExprTail(bl, node);
    }

    private Node memberExprTail(boolean bl, Node node) throws IOException, ParserException {
        assert (node.getSourceStart() <= this.getStartOffset()) : node.getSourceStart() + "," + this.getStartOffset();
        int n = node.getSourceStart();
        block11: while (true) {
            int n2 = this.peekToken();
            block0 : switch (n2) {
                case 104: 
                case 139: {
                    String string;
                    this.consumeToken();
                    this.decompiler.addToken(n2);
                    int n3 = 0;
                    if (n2 == 139) {
                        this.mustHaveXML();
                        n3 = 4;
                    }
                    if (!this.compilerEnv.isXmlAvailable()) {
                        this.mustMatchToken(38, "msg.no.name.after.dot");
                        string = this.ts.getString();
                        this.decompiler.addName(string);
                        node = this.nf.createPropertyGet(node, null, string, n3);
                        break;
                    }
                    n2 = this.nextToken();
                    switch (n2) {
                        case 38: {
                            string = this.ts.getString();
                            this.decompiler.addName(string);
                            node = this.propertyName(node, string, n3);
                            this.setSourceOffsets(node.getLastChild(), this.getStartOffset());
                            break block0;
                        }
                        case 23: {
                            this.decompiler.addName("*");
                            node = this.propertyName(node, "*", n3);
                            break block0;
                        }
                        case 143: {
                            this.decompiler.addToken(143);
                            node = this.attributeAccess(node, n3);
                            break block0;
                        }
                    }
                    String string2 = ScriptRuntime.getMessage0("msg.no.name.after.dot");
                    this.errorReporter.error(string2, this.sourceURI, this.ts.getLineno(), this.ts.getLine(), this.getStartOffset(), "msg.no.name.after.dot", null);
                    node = this.propertyName(node, "@", n3);
                    node.getFirstChild().getNext().setType(164);
                    this.setSourceOffsets(node.getLastChild(), this.getStartOffset());
                    break;
                }
                case 142: {
                    this.consumeToken();
                    this.mustHaveXML();
                    this.decompiler.addToken(142);
                    node = this.nf.createDotQuery(node, this.expr(false), this.ts.getLineno());
                    this.mustMatchToken(84, "msg.no.paren");
                    this.decompiler.addToken(84);
                    break;
                }
                case 79: {
                    this.consumeToken();
                    this.decompiler.addToken(79);
                    node = this.nf.createElementGet(node, null, this.expr(false), 0);
                    this.mustMatchToken(80, "msg.no.bracket.index");
                    this.decompiler.addToken(80);
                    break;
                }
                case 83: {
                    if (!bl) break block11;
                    this.consumeToken();
                    this.decompiler.addToken(83);
                    node = this.nf.createCallOrNew(37, node);
                    this.argumentList(node);
                    break;
                }
                default: {
                    break block11;
                }
            }
        }
        node.setSourceBounds(n, this.getEndOffset());
        return node;
    }

    private Node attributeAccess(Node node, int n) throws IOException {
        int n2 = this.getStartOffset();
        n |= 2;
        int n3 = this.nextToken();
        switch (n3) {
            case 38: {
                String string = this.ts.getString();
                this.decompiler.addName(string);
                node = this.propertyName(node, string, n);
                break;
            }
            case 23: {
                this.decompiler.addName("*");
                node = this.propertyName(node, "*", n);
                break;
            }
            case 79: {
                this.decompiler.addToken(79);
                node = this.nf.createElementGet(node, null, this.expr(false), n);
                this.mustMatchToken(80, "msg.no.bracket.index");
                this.decompiler.addToken(80);
                break;
            }
            default: {
                this.reportError("msg.no.name.after.xmlAttr");
                node = this.nf.createPropertyGet(node, null, "?", n);
            }
        }
        this.setSourceOffsets(node, n2);
        return node;
    }

    private Node propertyName(Node node, String string, int n) throws IOException, ParserException {
        int n2;
        int n3 = this.matchedTokenStart;
        if (GENERATED_IDENTIFIER.equals(string) && (n2 = this.peekToken()) == 38) {
            this.nextToken();
            string = this.ts.getString();
        }
        String string2 = null;
        if (this.matchToken(140)) {
            this.decompiler.addToken(140);
            string2 = string;
            int n4 = this.nextToken();
            switch (n4) {
                case 38: {
                    string = this.ts.getString();
                    this.decompiler.addName(string);
                    break;
                }
                case 23: {
                    this.decompiler.addName("*");
                    string = "*";
                    break;
                }
                case 79: {
                    this.decompiler.addToken(79);
                    node = this.nf.createElementGet(node, string2, this.expr(false), n);
                    this.mustMatchToken(80, "msg.no.bracket.index");
                    this.decompiler.addToken(80);
                    this.setSourceOffsets(node, n3);
                    return node;
                }
                default: {
                    this.reportError("msg.no.name.after.coloncolon");
                    string = "?";
                }
            }
        }
        node = this.nf.createPropertyGet(node, string2, string, n);
        this.setSourceOffsets(node, n3);
        return node;
    }

    private Node primaryExpr() throws IOException, ParserException {
        int n = this.nextFlaggedToken();
        int n2 = n & 0xFFFF;
        int n3 = this.matchedTokenStart;
        switch (n2) {
            case 105: {
                Node node = this.function(2);
                if (this.jsonMode) {
                    this.addError("msg.json.error", Token.fullName(n2), node);
                }
                return node;
            }
            case 79: {
                ObjArray objArray = new ObjArray();
                int n4 = 0;
                this.decompiler.addToken(79);
                boolean bl = true;
                Node node = null;
                while (true) {
                    if ((n2 = this.peekToken()) == 85) {
                        this.consumeToken();
                        this.decompiler.addToken(85);
                        if (!bl) {
                            bl = true;
                            continue;
                        }
                        objArray.add(null);
                        ++n4;
                        continue;
                    }
                    if (n2 == 80) break;
                    if (!bl) {
                        this.reportError("msg.no.bracket.arg");
                    }
                    node = this.assignExpr(false);
                    objArray.add(node);
                    bl = false;
                }
                this.consumeToken();
                this.decompiler.addToken(80);
                return this.setSourceOffsets(this.nf.createArrayLiteral(objArray, n4), n3);
            }
            case 81: {
                Object object;
                ObjArray objArray = new ObjArray();
                ArrayList<Node.LabelledNode> arrayList = new ArrayList<Node.LabelledNode>();
                this.decompiler.addToken(81);
                if (!this.matchToken(82)) {
                    boolean bl = true;
                    block25: do {
                        int n5 = this.getStartOffset();
                        if (!bl) {
                            this.decompiler.addToken(85);
                        } else {
                            bl = false;
                        }
                        n2 = this.peekToken();
                        switch (n2) {
                            case 38: {
                                if (this.jsonMode) {
                                    this.addError("msg.json.error", Token.fullName(n2), null);
                                }
                            }
                            case 40: {
                                this.consumeToken();
                                String string = this.ts.getString();
                                if (n2 == 38) {
                                    if (string.equals("get") && this.peekToken() == 38) {
                                        this.decompiler.addToken(147);
                                        this.consumeToken();
                                        string = this.ts.getString();
                                        this.decompiler.addName(string);
                                        object = ScriptRuntime.getIndexObject(string);
                                        if (this.getterSetterProperty(objArray, object, true)) continue block25;
                                        break block25;
                                    }
                                    if (string.equals("set") && this.peekToken() == 38) {
                                        this.decompiler.addToken(148);
                                        this.consumeToken();
                                        string = this.ts.getString();
                                        this.decompiler.addName(string);
                                        object = ScriptRuntime.getIndexObject(string);
                                        if (this.getterSetterProperty(objArray, object, false)) continue block25;
                                        break block25;
                                    }
                                    this.decompiler.addName(string);
                                } else {
                                    this.decompiler.addString(string);
                                }
                                int n6 = this.matchedTokenStart;
                                object = ScriptRuntime.getIndexObject(string);
                                this.plainProperty(objArray, object);
                                if (objArray.size() <= 0) continue block25;
                                Node node = (Node)objArray.get(objArray.size() - 1);
                                Node.LabelledNode labelledNode = new Node.LabelledNode(string, node);
                                labelledNode.setSourceBounds(n6, n6 + string.length());
                                arrayList.add(labelledNode);
                                break;
                            }
                            case 39: {
                                this.consumeToken();
                                int n7 = this.matchedTokenStart;
                                int n6 = this.matchedTokenEnd;
                                double d = this.ts.getNumber();
                                this.decompiler.addNumber(d);
                                object = ScriptRuntime.getIndexObject(d);
                                this.plainProperty(objArray, object);
                                if (objArray.size() <= 0) continue block25;
                                Object object2 = (Node)objArray.get(objArray.size() - 1);
                                String string = Double.toString(d);
                                if (string.endsWith(".0")) {
                                    string = string.substring(0, string.length() - 2);
                                }
                                Node.LabelledNode labelledNode = new Node.LabelledNode(string, (Node)object2);
                                labelledNode.setSourceBounds(n7, n6);
                                arrayList.add(labelledNode);
                                break;
                            }
                            case 82: {
                                if (!this.compilerEnv.isStrictMode()) break block25;
                                Object object2 = ScriptRuntime.getMessage0("msg.trailing.comma");
                                this.errorReporter.warning((String)object2, this.sourceURI, this.ts.getLineno(), this.ts.getLine(), n5, "msg.trailing.comma", n5);
                                break block25;
                            }
                            default: {
                                this.reportError("msg.bad.prop");
                                break block25;
                            }
                        }
                    } while (this.matchToken(85));
                    this.mustMatchToken(82, "msg.no.brace.prop");
                }
                this.decompiler.addToken(82);
                Node node = this.nf.createObjectLiteral(objArray);
                if (node.hasChildren()) {
                    object = node.getFirstChild();
                    Iterator iterator = arrayList.iterator();
                    do {
                        node.addChildBefore((Node)iterator.next(), (Node)object);
                    } while ((object = ((Node)object).getNext()) != null);
                }
                node.setSourceBounds(n3, this.getEndOffset());
                return node;
            }
            case 83: {
                if (this.jsonMode) {
                    this.addError("msg.json.error", Token.fullName(n2), null);
                }
                this.decompiler.addToken(83);
                Node node = this.expr(false);
                node.putProp(19, Boolean.TRUE);
                this.decompiler.addToken(84);
                this.mustMatchToken(84, "msg.no.paren");
                this.setSourceOffsets(node, n3);
                return node;
            }
            case 143: {
                this.mustHaveXML();
                this.decompiler.addToken(143);
                Node node = this.attributeAccess(null, 0);
                this.setSourceOffsets(node, n3);
                return node;
            }
            case 38: {
                String string;
                if (this.jsonMode) {
                    this.addError("msg.json.error", Token.fullName(n2), null);
                }
                if (GENERATED_IDENTIFIER.equals(string = this.ts.getString())) {
                    int n8 = this.peekToken();
                    boolean bl = false;
                    switch (n8) {
                        case 24: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 79: 
                        case 81: 
                        case 83: 
                        case 96: 
                        case 105: 
                        case 143: {
                            bl = true;
                        }
                    }
                    if (bl) {
                        Node node = this.primaryExpr();
                        this.setSourceOffsets(node, n3);
                        return node;
                    }
                }
                if ((n & 0x20000) != 0 && this.peekToken() == 99) {
                    return this.nf.createLabel(this.ts.getLineno());
                }
                this.decompiler.addName(string);
                Node node = this.compilerEnv.isXmlAvailable() ? this.propertyName(null, string, 0) : this.nf.createName(string);
                this.setSourceOffsets(node, n3);
                return node;
            }
            case 39: {
                double d = this.ts.getNumber();
                this.decompiler.addNumber(d);
                return this.setSourceOffsets(this.nf.createNumber(d), n3);
            }
            case 40: {
                String string = this.ts.getString();
                this.decompiler.addString(string);
                return this.setSourceOffsets(this.nf.createString(string), n3);
            }
            case 24: 
            case 96: {
                this.ts.readRegExp(n2);
                String string = this.ts.regExpFlags;
                this.ts.regExpFlags = null;
                String string2 = this.ts.getString();
                this.decompiler.addRegexp(string2, string);
                int n9 = this.currentScriptOrFn.addRegexp(string2, string);
                Node node = this.nf.createRegExp(n9);
                int n10 = this.matchedTokenEnd + string2.length() + string.length() + 1;
                node.setSourceBounds(n3, n10);
                this.matchedTokenEnd = n10;
                return node;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                this.decompiler.addToken(n2);
                return this.setSourceOffsets(this.nf.createLeaf(n2), n3);
            }
            case 123: {
                this.reportError("msg.reserved.id");
                break;
            }
            case -1: {
                break;
            }
            case 0: {
                this.reportError("msg.unexpected.eof");
                break;
            }
            default: {
                this.reportError("msg.syntax");
            }
        }
        return null;
    }

    private void plainProperty(ObjArray objArray, Object object) throws IOException {
        this.mustMatchToken(99, "msg.no.colon.prop");
        this.decompiler.addToken(64);
        objArray.add(object);
        objArray.add(this.assignExpr(false));
    }

    private boolean getterSetterProperty(ObjArray objArray, Object object, boolean bl) throws IOException {
        Node node = this.function(2);
        if (node.getType() != 105) {
            this.reportError("msg.bad.prop");
            return false;
        }
        int n = node.getExistingIntProp(1);
        FunctionNode functionNode = this.currentScriptOrFn.getFunctionNode(n);
        if (functionNode.getFunctionName().length() != 0) {
            this.reportError("msg.bad.prop");
            return false;
        }
        objArray.add(object);
        if (bl) {
            objArray.add(this.nf.createUnary(147, node));
        } else {
            objArray.add(this.nf.createUnary(148, node));
        }
        return true;
    }

    public TokenStream getTokenStream() {
        return this.ts;
    }

    public void setTokenStream(TokenStream tokenStream) {
        this.ts = tokenStream;
    }

    public FunctionNode parseFunction(String string, String string2, int n) {
        this.sourceURI = string2;
        this.ts = new TokenStream(this, null, string, n);
        this.setJsonMode(false);
        this.decompiler = this.createDecompiler(this.compilerEnv);
        this.nf = new IRFactory(this);
        this.currentScriptOrFn = this.nf.createScript();
        this.encodedSource = null;
        this.currentFlaggedToken = 0;
        this.syntaxErrorCount = 0;
        try {
            int n2 = this.peekToken();
            if (n2 <= 0) {
                return null;
            }
            if (n2 == 105) {
                int n3 = this.peekedTokenStart;
                this.consumeToken();
                try {
                    Node node = this.function(this.calledByCompileFunction ? 2 : 1);
                    this.setSourceOffsets(node, n3);
                    return (FunctionNode)node;
                }
                catch (ParserException parserException) {
                    return null;
                }
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException();
        }
        return null;
    }

    public ScriptOrFnNode parseJson(String string, String string2, int n) {
        this.sourceURI = string2;
        this.ts = new TokenStream(this, null, string, n);
        try {
            this.setJsonMode(true);
            return this.parseJson();
        }
        catch (IOException iOException) {
            throw new IllegalStateException();
        }
    }

    private ScriptOrFnNode parseJson() throws IOException {
        int n;
        assert (this.jsonMode);
        this.decompiler = this.createDecompiler(this.compilerEnv);
        this.nf = new IRFactory(this);
        this.currentScriptOrFn = this.nf.createScript();
        int n2 = this.decompiler.getCurrentOffset();
        int n3 = this.ts.getBufferOffset();
        this.encodedSource = null;
        this.decompiler.addToken(132);
        this.currentFlaggedToken = 0;
        this.syntaxErrorCount = 0;
        int n4 = this.ts.getLineno();
        Node node = this.nf.createLeaf(125);
        try {
            Object object;
            this.mustMatchToken(81, "msg.json.expectedlc");
            n = this.getStartOffset();
            ObjArray objArray = new ObjArray();
            ArrayList<Node.LabelledNode> arrayList = new ArrayList<Node.LabelledNode>();
            this.decompiler.addToken(81);
            if (!this.matchToken(82)) {
                boolean bl = true;
                block7: do {
                    if (!bl) {
                        this.decompiler.addToken(85);
                    } else {
                        bl = false;
                    }
                    int n5 = this.peekToken();
                    switch (n5) {
                        case 38: 
                        case 40: {
                            this.consumeToken();
                            String string = this.ts.getString();
                            if (n5 == 38) {
                                if (string.equals("get") && this.peekToken() == 38) {
                                    this.decompiler.addToken(147);
                                    this.consumeToken();
                                    string = this.ts.getString();
                                    this.decompiler.addName(string);
                                    object = ScriptRuntime.getIndexObject(string);
                                    if (this.getterSetterProperty(objArray, object, true)) continue block7;
                                    break block7;
                                }
                                if (string.equals("set") && this.peekToken() == 38) {
                                    this.decompiler.addToken(148);
                                    this.consumeToken();
                                    string = this.ts.getString();
                                    this.decompiler.addName(string);
                                    object = ScriptRuntime.getIndexObject(string);
                                    if (this.getterSetterProperty(objArray, object, false)) continue block7;
                                    break block7;
                                }
                                this.decompiler.addName(string);
                            } else {
                                this.decompiler.addString(string);
                            }
                            int n6 = this.matchedTokenStart;
                            object = ScriptRuntime.getIndexObject(string);
                            this.plainProperty(objArray, object);
                            if (objArray.size() <= 0) continue block7;
                            Node node2 = (Node)objArray.get(objArray.size() - 1);
                            Node.LabelledNode labelledNode = new Node.LabelledNode(string, node2);
                            labelledNode.setSourceBounds(n6, n6 + string.length());
                            arrayList.add(labelledNode);
                            break;
                        }
                        case 39: {
                            this.consumeToken();
                            int n7 = this.matchedTokenStart;
                            int n6 = this.matchedTokenEnd;
                            double d = this.ts.getNumber();
                            this.decompiler.addNumber(d);
                            object = ScriptRuntime.getIndexObject(d);
                            this.plainProperty(objArray, object);
                            if (objArray.size() <= 0) continue block7;
                            Node node3 = (Node)objArray.get(objArray.size() - 1);
                            String string = Double.toString(d);
                            if (string.endsWith(".0")) {
                                string = string.substring(0, string.length() - 2);
                            }
                            Node.LabelledNode labelledNode = new Node.LabelledNode(string, node3);
                            labelledNode.setSourceBounds(n7, n6);
                            arrayList.add(labelledNode);
                            break;
                        }
                        case 82: {
                            break block7;
                        }
                        default: {
                            this.reportError("msg.bad.prop");
                            break block7;
                        }
                    }
                } while (this.matchToken(85));
                this.mustMatchToken(82, "msg.no.brace.prop");
            }
            this.decompiler.addToken(82);
            Node node4 = this.nf.createObjectLiteral(objArray);
            if (node4.hasChildren()) {
                object = node4.getFirstChild();
                Iterator iterator = arrayList.iterator();
                do {
                    node4.addChildBefore((Node)iterator.next(), (Node)object);
                } while ((object = ((Node)object).getNext()) != null);
            }
            node4.setSourceBounds(n, this.getEndOffset());
            node.addChildToBack(node4);
        }
        catch (StackOverflowError stackOverflowError) {
            String string = ScriptRuntime.getMessage0("msg.too.deep.parser.recursion");
            throw Context.reportRuntimeError(string, this.sourceURI, this.ts.getLineno(), null, 0);
        }
        if (this.syntaxErrorCount != 0) {
            String string = String.valueOf(this.syntaxErrorCount);
            string = ScriptRuntime.getMessage1("msg.got.syntax.errors", string);
            return null;
        }
        this.currentScriptOrFn.setSourceName(this.sourceURI);
        this.currentScriptOrFn.setBaseLineno(n4);
        this.currentScriptOrFn.setEndLineno(this.ts.getLineno());
        n = this.decompiler.getCurrentOffset();
        this.currentScriptOrFn.setEncodedSourceBounds(n2, n);
        int n8 = this.getEndOffset();
        this.currentScriptOrFn.setSourceBounds(n3, n8);
        this.nf.initScript(this.currentScriptOrFn, node);
        if (this.compilerEnv.isGeneratingSource()) {
            this.encodedSource = this.decompiler.getEncodedSource();
        }
        this.decompiler = null;
        return this.currentScriptOrFn;
    }

    private class NoOpDecompiler
    extends Decompiler {
        private NoOpDecompiler() {
        }

        String getEncodedSource() {
            return null;
        }

        int getCurrentOffset() {
            return 0;
        }

        int markFunctionStart(int n) {
            return 0;
        }

        int markFunctionEnd(int n) {
            return 0;
        }

        void addToken(int n) {
        }

        void addEOL(int n) {
        }

        void addName(String string) {
        }

        void addString(String string) {
        }

        void addRegexp(String string, String string2) {
        }

        void addNumber(double d) {
        }
    }

    private static class ParserException
    extends RuntimeException {
        static final long serialVersionUID = 5882582646773765630L;

        private ParserException() {
        }
    }
}

