/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.nb.javascript;

import java.io.Serializable;
import org.mozilla.nb.javascript.Context;
import org.mozilla.nb.javascript.IdFunctionCall;
import org.mozilla.nb.javascript.IdFunctionObject;
import org.mozilla.nb.javascript.ScriptRuntime;
import org.mozilla.nb.javascript.Scriptable;
import org.mozilla.nb.javascript.ScriptableObject;

public class NativeWith
implements Scriptable,
IdFunctionCall,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Object FTAG = new Object();
    private static final int Id_constructor = 1;
    protected Scriptable prototype;
    protected Scriptable parent;

    static void init(Scriptable scriptable, boolean bl) {
        NativeWith nativeWith = new NativeWith();
        nativeWith.setParentScope(scriptable);
        nativeWith.setPrototype(ScriptableObject.getObjectPrototype(scriptable));
        IdFunctionObject idFunctionObject = new IdFunctionObject(nativeWith, FTAG, 1, "With", 0, scriptable);
        idFunctionObject.markAsConstructor(nativeWith);
        if (bl) {
            idFunctionObject.sealObject();
        }
        idFunctionObject.exportAsScopeProperty();
    }

    private NativeWith() {
    }

    protected NativeWith(Scriptable scriptable, Scriptable scriptable2) {
        this.parent = scriptable;
        this.prototype = scriptable2;
    }

    public String getClassName() {
        return "With";
    }

    public boolean has(String string, Scriptable scriptable) {
        return this.prototype.has(string, this.prototype);
    }

    public boolean has(int n, Scriptable scriptable) {
        return this.prototype.has(n, this.prototype);
    }

    public Object get(String string, Scriptable scriptable) {
        if (scriptable == this) {
            scriptable = this.prototype;
        }
        return this.prototype.get(string, scriptable);
    }

    public Object get(int n, Scriptable scriptable) {
        if (scriptable == this) {
            scriptable = this.prototype;
        }
        return this.prototype.get(n, scriptable);
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (scriptable == this) {
            scriptable = this.prototype;
        }
        this.prototype.put(string, scriptable, object);
    }

    public void put(int n, Scriptable scriptable, Object object) {
        if (scriptable == this) {
            scriptable = this.prototype;
        }
        this.prototype.put(n, scriptable, object);
    }

    public void delete(String string) {
        this.prototype.delete(string);
    }

    public void delete(int n) {
        this.prototype.delete(n);
    }

    public Scriptable getPrototype() {
        return this.prototype;
    }

    public void setPrototype(Scriptable scriptable) {
        this.prototype = scriptable;
    }

    public Scriptable getParentScope() {
        return this.parent;
    }

    public void setParentScope(Scriptable scriptable) {
        this.parent = scriptable;
    }

    public Object[] getIds() {
        return this.prototype.getIds();
    }

    public Object getDefaultValue(Class clazz) {
        return this.prototype.getDefaultValue(clazz);
    }

    public boolean hasInstance(Scriptable scriptable) {
        return this.prototype.hasInstance(scriptable);
    }

    protected Object updateDotQuery(boolean bl) {
        throw new IllegalStateException();
    }

    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (idFunctionObject.hasTag(FTAG) && idFunctionObject.methodId() == 1) {
            throw Context.reportRuntimeError1("msg.cant.call.indirect", "With");
        }
        throw idFunctionObject.unknown();
    }

    static boolean isWithFunction(Object object) {
        if (object instanceof IdFunctionObject) {
            IdFunctionObject idFunctionObject = (IdFunctionObject)object;
            return idFunctionObject.hasTag(FTAG) && idFunctionObject.methodId() == 1;
        }
        return false;
    }

    static Object newWithSpecial(Context context, Scriptable scriptable, Object[] objectArray) {
        ScriptRuntime.checkDeprecated(context, "With");
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        NativeWith nativeWith = new NativeWith();
        nativeWith.setPrototype(objectArray.length == 0 ? ScriptableObject.getClassPrototype(scriptable, "Object") : ScriptRuntime.toObject(context, scriptable, objectArray[0]));
        nativeWith.setParentScope(scriptable);
        return nativeWith;
    }
}

