/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.nb.javascript;

import org.mozilla.nb.javascript.Callable;
import org.mozilla.nb.javascript.Context;
import org.mozilla.nb.javascript.ContextAction;
import org.mozilla.nb.javascript.DefiningClassLoader;
import org.mozilla.nb.javascript.GeneratedClassLoader;
import org.mozilla.nb.javascript.Kit;
import org.mozilla.nb.javascript.Scriptable;
import org.mozilla.nb.javascript.xml.XMLLib;

public class ContextFactory {
    private static volatile boolean hasCustomGlobal;
    private static ContextFactory global;
    private volatile boolean sealed;
    private final Object listenersLock = new Object();
    private volatile Object listeners;
    private boolean disabledListening;
    private ClassLoader applicationClassLoader;

    public static ContextFactory getGlobal() {
        return global;
    }

    public static boolean hasExplicitGlobal() {
        return hasCustomGlobal;
    }

    public static void initGlobal(ContextFactory contextFactory) {
        if (contextFactory == null) {
            throw new IllegalArgumentException();
        }
        if (hasCustomGlobal) {
            throw new IllegalStateException();
        }
        hasCustomGlobal = true;
        global = contextFactory;
    }

    protected Context makeContext() {
        return new Context();
    }

    protected boolean hasFeature(Context context, int n) {
        switch (n) {
            case 1: {
                int n2 = context.getLanguageVersion();
                return n2 == 100 || n2 == 110 || n2 == 120;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                int n3 = context.getLanguageVersion();
                return n3 == 120;
            }
            case 5: {
                return true;
            }
            case 6: {
                int n4 = context.getLanguageVersion();
                return n4 == 0 || n4 >= 160;
            }
            case 7: {
                return false;
            }
            case 8: {
                return false;
            }
            case 9: {
                return false;
            }
            case 10: {
                return false;
            }
            case 11: {
                return false;
            }
            case 12: {
                return false;
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    private boolean isDom3Present() {
        Class clazz = Kit.classOrNull("org.w3c.dom.Node");
        if (clazz == null) {
            return false;
        }
        try {
            clazz.getMethod("getUserData", String.class);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    protected XMLLib.Factory getE4xImplementationFactory() {
        if (Kit.classOrNull("org.apache.xmlbeans.XmlCursor") != null) {
            return XMLLib.Factory.create("org.mozilla.nb.javascript.xml.impl.xmlbeans.XMLLibImpl");
        }
        if (this.isDom3Present()) {
            return XMLLib.Factory.create("org.mozilla.nb.javascript.xmlimpl.XMLLibImpl");
        }
        return null;
    }

    protected GeneratedClassLoader createClassLoader(ClassLoader classLoader) {
        return new DefiningClassLoader(classLoader);
    }

    public final ClassLoader getApplicationClassLoader() {
        return this.applicationClassLoader;
    }

    public final void initApplicationClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("loader is null");
        }
        if (!Kit.testIfCanLoadRhinoClasses(classLoader)) {
            throw new IllegalArgumentException("Loader can not resolve Rhino classes");
        }
        if (this.applicationClassLoader != null) {
            throw new IllegalStateException("applicationClassLoader can only be set once");
        }
        this.checkNotSealed();
        this.applicationClassLoader = classLoader;
    }

    protected Object doTopCall(Callable callable, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        return callable.call(context, scriptable, scriptable2, objectArray);
    }

    protected void observeInstructionCount(Context context, int n) {
    }

    protected void onContextCreated(Context context) {
        Listener listener;
        Object object = this.listeners;
        int n = 0;
        while ((listener = (Listener)Kit.getListener(object, n)) != null) {
            listener.contextCreated(context);
            ++n;
        }
    }

    protected void onContextReleased(Context context) {
        Listener listener;
        Object object = this.listeners;
        int n = 0;
        while ((listener = (Listener)Kit.getListener(object, n)) != null) {
            listener.contextReleased(context);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(Listener listener) {
        this.checkNotSealed();
        Object object = this.listenersLock;
        synchronized (object) {
            if (this.disabledListening) {
                throw new IllegalStateException();
            }
            this.listeners = Kit.addListener(this.listeners, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeListener(Listener listener) {
        this.checkNotSealed();
        Object object = this.listenersLock;
        synchronized (object) {
            if (this.disabledListening) {
                throw new IllegalStateException();
            }
            this.listeners = Kit.removeListener(this.listeners, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void disableContextListening() {
        this.checkNotSealed();
        Object object = this.listenersLock;
        synchronized (object) {
            this.disabledListening = true;
            this.listeners = null;
        }
    }

    public final boolean isSealed() {
        return this.sealed;
    }

    public final void seal() {
        this.checkNotSealed();
        this.sealed = true;
    }

    protected final void checkNotSealed() {
        if (this.sealed) {
            throw new IllegalStateException();
        }
    }

    public final Object call(ContextAction contextAction) {
        return Context.call(this, contextAction);
    }

    public final Context enter() {
        return this.enter(null);
    }

    public final Context enter(Context context) {
        return Context.enter(context, this);
    }

    public final void exit() {
        Context.exit(this);
    }

    static {
        global = new ContextFactory();
    }

    public static interface Listener {
        public void contextCreated(Context var1);

        public void contextReleased(Context var1);
    }
}

